/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.base.protocol.webdav;

import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.base.logging.BaseLogManager;
import com.sap.caf.mp.base.protocol.http.HttpClientConnection;
import com.sap.caf.mp.base.protocol.http.HttpRequest;
import com.sap.caf.mp.base.protocol.http.HttpResponse;
import com.sap.caf.mp.base.protocol.webdav.PropFindResponse;
import com.sap.caf.mp.base.protocol.webdav.WebDAVConstants;
import com.sap.caf.mp.base.protocol.webdav.WebDAVProperty;
import com.sap.caf.mp.base.util.NamespacePrefixes;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class PropFindRequest {
    public static final int PROPFIND_TYPE_NAMED = 0;
    public static final int PROPFIND_TYPE_ALLPROP = 1;
    private String m_resourceUri;
    private Vector m_requestProperties;
    private String m_webDavPrefix;
    private int m_depth;
    private Hashtable m_nameSpaces;
    private int m_type;

    public PropFindRequest(int type, String resourceUri, int depth, Vector properties) {
        this.m_type = type;
        this.m_webDavPrefix = NamespacePrefixes.addNamespace("DAV:");
        this.m_resourceUri = resourceUri;
        this.m_depth = depth;
        this.m_nameSpaces = new Hashtable();
        this.m_requestProperties = new Vector();
        try {
            this.m_requestProperties.add(WebDAVConstants.constructStandardProperty("creationdate"));
            this.m_requestProperties.add(WebDAVConstants.constructStandardProperty("displayname"));
            this.m_requestProperties.add(WebDAVConstants.constructStandardProperty("getcontentlanguage"));
            this.m_requestProperties.add(WebDAVConstants.constructStandardProperty("getcontentlength"));
            this.m_requestProperties.add(WebDAVConstants.constructStandardProperty("getcontenttype"));
            this.m_requestProperties.add(WebDAVConstants.constructStandardProperty("getlastmodified"));
            this.m_requestProperties.add(WebDAVConstants.constructStandardProperty("resourcetype"));
        }
        catch (Exception ex) {
            BaseLogManager.error(this.getClass(), "ERROR: unable to request standard WebDAV properties");
        }
        if (properties != null) {
            int count = properties.size();
            for (int i = 0; i < count; ++i) {
                WebDAVProperty prop = (WebDAVProperty)properties.get(i);
                String ns = prop.getNameSpace();
                if (!this.m_nameSpaces.containsKey(ns)) {
                    this.m_nameSpaces.put(ns, ns);
                }
                this.m_requestProperties.add(prop);
            }
        }
    }

    private byte[] constructRequestEntityPropname() throws EngineException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\r\n");
        buffer.append("<D:propfind xmlns:D=\"DAV:\"><D:propname/></D:propfind>");
        String entity = buffer.toString();
        try {
            return entity.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new EngineException(e.getMessage(), e);
        }
    }

    private byte[] constructRequestEntityAllprop() throws EngineException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\r\n");
        buffer.append("<D:propfind xmlns:D=\"DAV:\"><D:allprop/></D:propfind>");
        String entity = buffer.toString();
        try {
            return entity.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new EngineException(e.getMessage(), e);
        }
    }

    private byte[] constructRequestEntity() throws EngineException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\r\n<");
        buffer.append(this.m_webDavPrefix);
        buffer.append(":propfind xmlns:");
        buffer.append(this.m_webDavPrefix);
        buffer.append("=\"DAV:\"");
        Enumeration<Object> enumeration = this.m_nameSpaces.elements();
        while (enumeration.hasMoreElements()) {
            String ns = (String)enumeration.nextElement();
            buffer.append(" xmlns:");
            buffer.append(NamespacePrefixes.addNamespace(ns));
            buffer.append("=\"" + ns + "\"");
        }
        buffer.append(">\r\n<");
        buffer.append(this.m_webDavPrefix);
        buffer.append(":prop>\r\n");
        enumeration = this.m_requestProperties.elements();
        while (enumeration.hasMoreElements()) {
            WebDAVProperty prop = (WebDAVProperty)enumeration.nextElement();
            String prefix = NamespacePrefixes.addNamespace(prop.getNameSpace());
            buffer.append("<");
            buffer.append(prefix);
            buffer.append(":");
            buffer.append(prop.getName());
            buffer.append("/>\r\n");
        }
        buffer.append("</");
        buffer.append(this.m_webDavPrefix);
        buffer.append(":prop>\r\n</");
        buffer.append(this.m_webDavPrefix);
        buffer.append(":propfind>\r\n");
        String entity = buffer.toString();
        try {
            return entity.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new EngineException(e.getMessage(), e);
        }
    }

    protected PropFindResponse executeRequest(HttpClientConnection connection) throws InvocationException, EngineException {
        byte[] entity = null;
        if (this.m_type == 0) {
            entity = this.constructRequestEntity();
        } else if (this.m_type == 1) {
            entity = this.constructRequestEntityAllprop();
        } else {
            throw new InvocationException("Invalid request type.");
        }
        HttpRequest request = connection.constructHttpRequest("PROPFIND", this.m_resourceUri, 1);
        request.setRequestBody(entity);
        request.setRequestHeader(35, "text/xml; charset=\"utf-8\"");
        if (this.m_depth == -1) {
            request.setRequestHeader("Depth", "infinite");
        } else {
            request.setRequestHeader("Depth", "" + this.m_depth);
        }
        HttpResponse response = connection.executeRequest(request);
        switch (response.getResonseCode()) {
            case 207: {
                return new PropFindResponse(response);
            }
            case 403: {
                throw new InvocationException("You are not authorized to access this resource. ");
            }
            case 404: {
                throw new InvocationException("The resource with this resource id does not exist.");
            }
        }
        throw new EngineException("The server returned the resonse: " + response.getResonseCode() + " " + response.getResponseText());
    }
}

