/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.base.protocol.http;

import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.base.protocol.http.HttpClient;
import com.sap.caf.mp.base.protocol.http.HttpHeader;
import com.sap.caf.mp.base.protocol.http.HttpRequest;
import com.sap.caf.mp.base.protocol.http.content.IResponseContent;
import com.sap.caf.mp.base.protocol.http.content.ResponseMemory;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class HttpResponse {
    public static final int HTTP_RESPONSE_CONTINUE = 100;
    public static final int HTTP_RESPONSE_SWITCHING_PROTOCOLS = 101;
    public static final int HTTP_RESPONSE_OK = 200;
    public static final int HTTP_RESPONSE_CREATED = 201;
    public static final int HTTP_RESPONSE_ACCEPTED = 202;
    public static final int HTTP_RESPONSE_NON_AUTHORITATIVE_INFORMATION = 203;
    public static final int HTTP_RESPONSE_NO_CONTENT = 204;
    public static final int HTTP_RESPONSE_RESET_CONTENT = 205;
    public static final int HTTP_RESPONSE_PARTIAL_CONTENT = 206;
    public static final int HTTP_RESPONSE_MULTIPLE_CHOICES = 300;
    public static final int HTTP_RESPONSE_MOVED_PERMANENTLY = 301;
    public static final int HTTP_RESPONSE_FOUND = 302;
    public static final int HTTP_RESPONSE_SEE_OTHER = 303;
    public static final int HTTP_RESPONSE_NOT_MODIFIED = 304;
    public static final int HTTP_RESPONSE_USE_PROXY = 305;
    public static final int HTTP_RESPONSE_TEMPORARY_REDIRECT = 306;
    public static final int HTTP_RESPONSE_BAD_REQUEST = 400;
    public static final int HTTP_RESPONSE_UNAUTHORIZED = 401;
    public static final int HTTP_RESPONSE_PAYMENT_REQUIRED = 402;
    public static final int HTTP_RESPONSE_FORBIDDEN = 403;
    public static final int HTTP_RESPONSE_NOT_FOUND = 404;
    public static final int HTTP_RESPONSE_METHOD_NOT_ALLOWED = 405;
    public static final int HTTP_RESPONSE_NOT_ACCEPTABLE = 406;
    public static final int HTTP_RESPONSE_PROXY_AUTHENTICATION_REQUIRED = 407;
    public static final int HTTP_RESPONSE_REQUEST_TIMEOUT = 408;
    public static final int HTTP_RESPONSE_CONFLICT = 409;
    public static final int HTTP_RESPONSE_GONE = 410;
    public static final int HTTP_RESPONSE_LENGTH_REQUIRED = 411;
    public static final int HTTP_RESPONSE_PRECONDITION_FAILED = 412;
    public static final int HTTP_RESPONSE_REQUEST_ENTITY_TOO_LARGE = 413;
    public static final int HTTP_RESPONSE_REQUEST_URI_TOO_LONG = 414;
    public static final int HTTP_RESPONSE_UNSUPPORTED_MEDIA_TYPE = 415;
    public static final int HTTP_RESPONSE_REQUEST_RANGE_NOT_SATISFIABLE = 416;
    public static final int HTTP_RESPONSE_EXPECTATION_FAILED = 417;
    public static final int HTTP_RESPONSE_INTERNAL_SERVER_ERROR = 500;
    public static final int HTTP_RESPONSE_NOT_IMPLEMENTED = 501;
    public static final int HTTP_RESPONSE_BAD_GATEWAY = 502;
    public static final int HTTP_RESPONSE_SERVICE_UNAVAILABLE = 503;
    public static final int HTTP_RESPONSE_GATEWAY_TIMEOUT = 504;
    public static final int HTTP_RESPONSE_HTTP_VERSION_NOT_SUPPORTED = 505;
    public static final int HEADER_GENERIC_CACHE_CONTROL = 0;
    public static final int HEADER_GENERIC_CONNECTION = 1;
    public static final int HEADER_GENERIC_DATE = 2;
    public static final int HEADER_GENERIC_PRAGMA = 3;
    public static final int HEADER_GENERIC_TRAILER = 4;
    public static final int HEADER_GENERIC_TRANSFER_ENCODING = 5;
    public static final int HEADER_GENERIC_UPGRADE = 6;
    public static final int HEADER_GENERIC_VIA = 7;
    public static final int HEADER_GENERIC_WARNING = 8;
    public static final int HEADER_RESPONSE_ACCEPT_RANGES = 9;
    public static final int HEADER_RESPONSE_AGE = 10;
    public static final int HEADER_RESPONSE_ETAG = 11;
    public static final int HEADER_RESPONSE_LOCATION = 12;
    public static final int HEADER_RESPONSE_PROXY_AUTHENTICATE = 13;
    public static final int HEADER_RESPONSE_RETRY_AFTER = 14;
    public static final int HEADER_RESPONSE_SERVER = 15;
    public static final int HEADER_RESPONSE_VARY = 16;
    public static final int HEADER_RESPONSE_WWW_AUTHENTICATE = 17;
    public static final int HEADER_RESPONSE_ALLOW = 18;
    public static final int HEADER_RESPONSE_CONTENT_ENCODING = 19;
    public static final int HEADER_RESPONSE_CONTENT_LANGUAGE = 20;
    public static final int HEADER_RESPONSE_CONTENT_LENGTH = 21;
    public static final int HEADER_RESPONSE_CONTENT_LOCATION = 22;
    public static final int HEADER_RESPONSE_CONTENT_MD5 = 23;
    public static final int HEADER_RESPONSE_CONTENT_RANGE = 24;
    public static final int HEADER_RESPONSE_CONTENT_TYPE = 25;
    public static final int HEADER_RESPONSE_EXPIRES = 26;
    public static final int HEADER_RESPONSE_LAST_MODIFIED = 27;
    private static final String[] PROTOCOL_VERSION_STRINGS;
    private static final String[] RESPONSE_HEADER_FIELDS;
    private static Hashtable m_protocolVersion;
    private static Hashtable m_responseHeaderFields;
    private boolean m_foundCr = false;
    private boolean m_beginOfLine = false;
    private StringBuffer m_headerData = new StringBuffer();
    private IResponseContent m_content;
    private Hashtable m_responseHeaders;
    private int m_responseProtocol;
    private int m_returnCode;
    private String m_responseText;
    private boolean m_requiresClose = false;
    private long m_contentLength;

    public static String normalizeResponseHeaderField(String fieldName) {
        Integer idx = (Integer)m_responseHeaderFields.get(fieldName.toLowerCase());
        if (idx == null) {
            return fieldName;
        }
        return RESPONSE_HEADER_FIELDS[idx];
    }

    protected HttpResponse(HttpRequest request, InputStream stream) throws IOException, EngineException {
        HttpHeader connClose;
        this.readLines(stream);
        if (HttpClient.isTraceEnabled()) {
            HttpClient.traceEvent("HttpResponse::ctor(): response headers", this.m_headerData.toString());
        }
        this.m_responseHeaders = new Hashtable();
        this.parseResponseHeader();
        HttpHeader lengthStr = (HttpHeader)this.m_responseHeaders.get(RESPONSE_HEADER_FIELDS[21]);
        if (lengthStr != null) {
            this.m_contentLength = Long.parseLong(lengthStr.getHeaderValue());
        } else {
            this.m_requiresClose = true;
            this.m_contentLength = -1L;
        }
        if (!this.m_requiresClose && (connClose = (HttpHeader)this.m_responseHeaders.get(RESPONSE_HEADER_FIELDS[1])) != null) {
            this.m_requiresClose = true;
        }
        if (!this.m_requiresClose && this.m_responseProtocol == 0) {
            this.m_requiresClose = true;
        }
        this.m_content = this.m_contentLength != 0L && this.containsEntity(request) ? new ResponseMemory(stream, (int)this.m_contentLength) : null;
    }

    private void parseResponseHeader() throws EngineException {
        StringTokenizer tokenizer = new StringTokenizer(this.m_headerData.toString(), "\r\n", false);
        boolean seenResponseLine = false;
        while (tokenizer.hasMoreTokens()) {
            int pos;
            String token = tokenizer.nextToken();
            if (token.length() == 0) continue;
            if (seenResponseLine) {
                pos = token.indexOf(":");
                if (pos <= 0) continue;
                String headerName = token.substring(0, pos);
                String headerValue = token.charAt(pos + 1) == ' ' ? token.substring(pos + 2) : token.substring(pos);
                this.m_responseHeaders.put(HttpResponse.normalizeResponseHeaderField(headerName), new HttpHeader(headerName, headerValue));
                continue;
            }
            pos = token.indexOf(" ");
            if (pos == -1) {
                throw new EngineException("Invalid http response: " + token);
            }
            String protocolVersion = token.substring(0, pos);
            Integer versionNum = (Integer)m_protocolVersion.get(protocolVersion);
            if (versionNum == null) {
                throw new EngineException("Unsupported protocol version: " + protocolVersion);
            }
            this.m_responseProtocol = versionNum;
            while (token.charAt(pos) == ' ') {
                ++pos;
            }
            String code = token.substring(pos, pos + 3);
            try {
                this.m_returnCode = Integer.parseInt(code);
            }
            catch (NumberFormatException ex) {
                throw new EngineException("Invalid http response: " + token, ex);
            }
            this.m_responseText = token.substring(pos += 3).trim();
            seenResponseLine = true;
        }
    }

    private boolean containsEntity(HttpRequest request) {
        switch (this.m_returnCode) {
            case 100: {
                return false;
            }
            case 101: {
                return false;
            }
            case 200: {
                return request.getRequestMethod() != 3;
            }
            case 204: {
                return false;
            }
            case 205: {
                return false;
            }
            case 300: {
                return request.getRequestMethod() != 3;
            }
            case 304: {
                return false;
            }
        }
        return true;
    }

    private void readLines(InputStream inp) throws IOException {
        block6: while (true) {
            int b = inp.read();
            switch (b) {
                case -1: {
                    throw new EOFException("Unexpected end of stream while reading headers.");
                }
                case 13: {
                    this.m_foundCr = true;
                    continue block6;
                }
                case 10: {
                    if (this.m_beginOfLine) break block6;
                    this.m_headerData.append('\n');
                    this.m_beginOfLine = true;
                    this.m_foundCr = false;
                    continue block6;
                }
                case 9: 
                case 32: {
                    if (this.m_beginOfLine) {
                        this.m_headerData.setCharAt(this.m_headerData.length() - 1, ' ');
                        this.m_beginOfLine = false;
                        continue block6;
                    }
                }
                default: {
                    if (this.m_foundCr) {
                        this.m_headerData.append('\r');
                        this.m_foundCr = false;
                    }
                    this.m_headerData.append((char)(b & 0xFF));
                    this.m_beginOfLine = false;
                    continue block6;
                }
            }
            break;
        }
    }

    public int getResonseCode() {
        return this.m_returnCode;
    }

    public String getResponseText() {
        return this.m_responseText;
    }

    public int getResponseProtocolVersion() {
        return this.m_responseProtocol;
    }

    public HttpHeader getResponseHeader(String headerName) {
        String name = HttpResponse.normalizeResponseHeaderField(headerName);
        return (HttpHeader)this.m_responseHeaders.get(name);
    }

    public HttpHeader getResponseHeader(int header) throws InvocationException {
        try {
            String name = RESPONSE_HEADER_FIELDS[header];
            return (HttpHeader)this.m_responseHeaders.get(name);
        }
        catch (Exception ex) {
            throw new InvocationException("Invalid http response header identifier.", ex);
        }
    }

    public long getContentLength() {
        return this.m_contentLength;
    }

    public boolean isContentAvailable() {
        return this.m_content != null;
    }

    public IResponseContent getResponseContent() {
        return this.m_content;
    }

    public boolean isCloseRequired() {
        return this.m_requiresClose;
    }

    static {
        int i;
        PROTOCOL_VERSION_STRINGS = new String[]{"HTTP/1.0", "HTTP/1.1"};
        RESPONSE_HEADER_FIELDS = new String[]{"Cache-Control", "Connection", "Date", "Pragma", "Trailer", "Transfer-Encoding", "Upgrade", "Via", "Warning", "Accept-Range", "Age", "ETag", "Location", "Proxy-Authenticate", "Retry-After", "Server", "Vary", "WWW-Authenticate", "Allow", "Content-Encoding", "Content-Language", "Content-Length", "Content-Location", "Content-MD5", "Content-Range", "Content-Type", "Expires", "Last-Modified"};
        m_protocolVersion = new Hashtable();
        for (i = 0; i < PROTOCOL_VERSION_STRINGS.length; ++i) {
            m_protocolVersion.put(PROTOCOL_VERSION_STRINGS[i], new Integer(i));
        }
        m_responseHeaderFields = new Hashtable();
        for (i = 0; i < RESPONSE_HEADER_FIELDS.length; ++i) {
            String header = RESPONSE_HEADER_FIELDS[i];
            m_responseHeaderFields.put(header.toLowerCase(), new Integer(i));
        }
    }
}

