/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.base.protocol.http;

import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.base.protocol.http.HttpClientConnection;
import com.sap.caf.mp.base.protocol.http.HttpHeader;
import java.util.Enumeration;
import java.util.Hashtable;

public class HttpRequest {
    public static final int REQUEST_METHOD_GET = 0;
    public static final int REQUEST_METHOD_OPTIONS = 1;
    public static final int REQUEST_METHOD_PUT = 2;
    public static final int REQUEST_METHOD_HEAD = 3;
    public static final int REQUEST_METHOD_POST = 4;
    public static final int REQUEST_METHOD_DELETE = 5;
    public static final int REQUEST_METHOD_CONNECT = 6;
    public static final int REQUEST_METHOD_TRACE = 7;
    public static final int REQUEST_METHOD_CUSTOM = 8;
    public static final int HEADER_GENERIC_CACHE_CONTROL = 0;
    public static final int HEADER_GENERIC_CONNECTION = 1;
    public static final int HEADER_GENERIC_DATE = 2;
    public static final int HEADER_GENERIC_PRAGMA = 3;
    public static final int HEADER_GENERIC_TRAILER = 4;
    public static final int HEADER_GENERIC_TRANSFER_ENCODING = 5;
    public static final int HEADER_GENERIC_UPGRADE = 6;
    public static final int HEADER_GENERIC_VIA = 7;
    public static final int HEADER_GENERIC_WARNING = 8;
    public static final int HEADER_REQUEST_ACCEPT = 9;
    public static final int HEADER_REQUEST_ACCEPT_CHARSET = 10;
    public static final int HEADER_REQUEST_ACCEPT_ENCODING = 11;
    public static final int HEADER_REQUEST_ACCEPT_LANGUAGE = 12;
    public static final int HEADER_REQUEST_AUTHORIZATION = 13;
    public static final int HEADER_REQUEST_EXPECT = 14;
    public static final int HEADER_REQUEST_FROM = 15;
    public static final int HEADER_REQUEST_HOST = 16;
    public static final int HEADER_REQUEST_IF_MATCH = 17;
    public static final int HEADER_REQUEST_IF_MODIFIED_SINCE = 18;
    public static final int HEADER_REQUEST_IF_NONE_MATCH = 19;
    public static final int HEADER_REQUEST_IF_RANGE = 20;
    public static final int HEADER_REQUEST_IF_UNMODIFIED_SINCE = 21;
    public static final int HEADER_REQUEST_MAX_FORWARDS = 22;
    public static final int HEADER_REQUEST_PROXY_AUTHORIZATION = 23;
    public static final int HEADER_REQUEST_RANGE = 24;
    public static final int HEADER_REQUEST_REFERER = 25;
    public static final int HEADER_REQUEST_TE = 26;
    public static final int HEADER_REQUEST_USER_AGENT = 27;
    public static final int HEADER_ENTITY_ALLOW = 28;
    public static final int HEADER_ENTITY_CONTENT_ENCODING = 29;
    public static final int HEADER_ENTITY_CONTENT_LANGUAGE = 30;
    public static final int HEADER_ENTITY_CONTENT_LENGTH = 31;
    public static final int HEADER_ENTITY_CONTENT_LOCATION = 32;
    public static final int HEADER_ENTITY_CONTENT_MD5 = 33;
    public static final int HEADER_ENTITY_CONTENT_RANGE = 34;
    public static final int HEADER_ENTITY_CONTENT_TYPE = 35;
    public static final int HEADER_ENTITY_EXPIRES = 36;
    public static final int HEADER_ENTITY_LAST_MODIFIED = 37;
    public static final int HEADER_CUSTOM = 38;
    private static final String[] REQUEST_METHOD_STRINGS = new String[]{"GET", "OPTIONS", "PUT", "HEAD", "POST", "DELETE", "CONNECT", "TRACE"};
    private static final String[] REQUEST_HEADER_FIELDS = new String[]{"Cache-Control", "Connection", "Date", "Pragma", "Trailer", "Transfer-Encoding", "Upgrade", "Via", "Warning", "Accept", "Accept-Charset", "Accept-Encoding", "Accept-Language", "Authorization", "Expect", "From", "Host", "If-Match", "If-Modified-Since", "If-None-Match", "If-Range", "If-Unmodified-Since", "Max-Forwards", "Proxy-Authorization", "Range", "Referer", "TE", "User-Agent", "Allow", "Content-Encoding", "Content-Language", "Content-Length", "Content-Location", "Content-MD5", "Content-Range", "Content-Type", "Expires", "Last-Modified"};
    private static final String CRLF = "\r\n";
    private static final String HEADER_SEPARATOR = ": ";
    private static final String[] PROTOCOL_VERSION_STRINGS = new String[]{"HTTP/1.0", "HTTP/1.1"};
    private static Hashtable m_requestHeaderTable = new Hashtable();
    private static Hashtable m_responseHeaderTable;
    private int m_requestMethod;
    private String m_customMethod;
    private int m_protocolVersion;
    private Hashtable m_headers;
    private String m_requestUri;
    private HttpClientConnection m_connection;
    private byte[] m_requestBody;

    protected HttpRequest(String requestMethod, String requestUri, HttpClientConnection conn, int protocolVersion) throws InvocationException {
        this(8, requestUri, conn, protocolVersion);
        this.m_customMethod = requestMethod;
    }

    protected HttpRequest(int requestMethod, String requestUri, HttpClientConnection conn, int protocolVersion) throws InvocationException {
        if (requestMethod < 0 || requestMethod > REQUEST_METHOD_STRINGS.length) {
            throw new InvocationException("Invalid request method.");
        }
        if (protocolVersion < 0 || protocolVersion > PROTOCOL_VERSION_STRINGS.length - 1) {
            throw new InvocationException("Invalid request protocol.");
        }
        this.m_requestMethod = requestMethod;
        this.m_customMethod = null;
        this.m_requestBody = null;
        this.m_requestUri = requestUri;
        this.m_connection = conn;
        this.m_protocolVersion = protocolVersion;
        this.m_headers = new Hashtable();
        this.setRequestHeader(16, this.m_connection.m_hostName + ":" + this.m_connection.m_port);
        this.setRequestHeader(27, "com.sap.xapps.kn/1.0");
    }

    public int getRequestMethod() {
        return this.m_requestMethod;
    }

    public String getRequestHost() {
        return this.m_connection.m_hostName;
    }

    public int getRequestPort() {
        return this.m_connection.m_port;
    }

    public String getRequestUri() {
        return this.m_requestUri;
    }

    protected void constructRequestLine(StringBuffer buffer) {
        if (this.m_requestMethod == 8) {
            buffer.append(this.m_customMethod);
        } else {
            buffer.append(REQUEST_METHOD_STRINGS[this.m_requestMethod]);
        }
        buffer.append(" ");
        if (this.m_connection.m_useProxy && !this.m_connection.m_useTunneling) {
            if (this.m_connection.m_protocol == 0) {
                buffer.append("http://");
            } else {
                buffer.append("https://");
            }
            buffer.append(this.m_connection.m_hostName);
            buffer.append(":");
            buffer.append(this.m_connection.m_port);
        }
        buffer.append(this.m_requestUri);
        buffer.append(" ");
        buffer.append(PROTOCOL_VERSION_STRINGS[this.m_protocolVersion]);
        buffer.append(CRLF);
    }

    protected void constructMessageHeader(StringBuffer buffer) {
        Enumeration enumeration = this.m_headers.elements();
        while (enumeration.hasMoreElements()) {
            HttpHeader header = (HttpHeader)enumeration.nextElement();
            buffer.append(header.getHeaderName());
            buffer.append(HEADER_SEPARATOR);
            buffer.append(header.getHeaderValue());
            buffer.append(CRLF);
        }
        if (this.m_requestBody != null) {
            buffer.append(REQUEST_HEADER_FIELDS[31]);
            buffer.append(HEADER_SEPARATOR);
            buffer.append(this.m_requestBody.length);
            buffer.append(CRLF);
        }
        buffer.append(CRLF);
    }

    public void setRequestHeader(String headerName, String headerValue) throws InvocationException {
        String name = headerName.toLowerCase();
        Integer idx = (Integer)m_requestHeaderTable.get(name);
        if (idx != null) {
            headerName = REQUEST_HEADER_FIELDS[idx];
            if (idx == 31) {
                throw new InvocationException("Content-Length must not be set manually.");
            }
        }
        HttpHeader header = new HttpHeader(headerName, headerValue);
        this.m_headers.put(headerName, header);
    }

    public void setRequestHeader(int header, String headerValue) throws InvocationException {
        if (header > REQUEST_HEADER_FIELDS.length - 1) {
            throw new InvocationException("Header name unknown.");
        }
        if (header == 31) {
            throw new InvocationException("Content-Length must not be set manually.");
        }
        String name = REQUEST_HEADER_FIELDS[header];
        HttpHeader headerObj = new HttpHeader(name, headerValue);
        this.m_headers.put(name, headerObj);
    }

    public void setRequestBody(byte[] body) {
        this.m_requestBody = body;
    }

    public boolean isRequestBodyPresent() {
        return this.m_requestBody != null;
    }

    public byte[] getRequestBody() {
        return this.m_requestBody;
    }

    static {
        for (int i = 0; i < REQUEST_HEADER_FIELDS.length; ++i) {
            String header = REQUEST_HEADER_FIELDS[i];
            m_requestHeaderTable.put(header.toLowerCase(), new Integer(i));
        }
    }
}

