/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.base.portalclient;

import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.util.ByteArray;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class PortalCommand
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Vector m_params;
    private String m_targetServiceName;
    private String m_methodName;
    private Class[] m_classes;
    private Object[] m_objects;
    private boolean m_created;

    public PortalCommand(String targetService, String methodName) {
        this.m_targetServiceName = targetService;
        this.m_methodName = methodName;
        this.m_params = new Vector();
        this.m_classes = null;
        this.m_objects = null;
        this.m_created = false;
    }

    public String getTargetServiceName() {
        return this.m_targetServiceName;
    }

    public String getMethodName() {
        return this.m_methodName;
    }

    public void addParameter(Object obj) {
        this.m_created = false;
        this.m_params.add(obj);
    }

    private synchronized void createArrays() {
        if (this.m_created) {
            return;
        }
        int size = this.m_params.size();
        this.m_classes = new Class[size + 1];
        this.m_objects = new Object[size + 1];
        Enumeration enumeration = this.m_params.elements();
        int idx = 1;
        while (enumeration.hasMoreElements()) {
            Object param = enumeration.nextElement();
            this.m_classes[idx] = param.getClass();
            this.m_objects[idx] = param;
            ++idx;
        }
    }

    public Class[] getParameterClasses() {
        this.createArrays();
        return this.m_classes;
    }

    public Object[] getParameters() {
        this.createArrays();
        return this.m_objects;
    }

    public byte[] serialize() throws EngineException {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream(stream);
            os.writeObject(this);
            return stream.toByteArray();
        }
        catch (Exception ex) {
            throw new EngineException("Unable to serialize the portal command object: " + ex.getMessage(), ex);
        }
    }

    public static PortalCommand createInstance(byte[] stream) throws EngineException {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(stream);
            ObjectInputStream ois = new ObjectInputStream(is);
            return (PortalCommand)ois.readObject();
        }
        catch (Exception ex) {
            throw new EngineException("Unable to deserialize the portal command object: " + ex.getMessage(), ex);
        }
    }

    public static PortalCommand createInstance(InputStream stream) throws EngineException {
        byte[] data = null;
        try {
            data = new ByteArray(stream).toByteArray(false);
        }
        catch (Exception ex) {
            throw new EngineException("Unable to deserialize the portal command object: " + ex.getMessage(), ex);
        }
        if (data == null) {
            return null;
        }
        return PortalCommand.createInstance(data);
    }
}

