/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.base.mimetype;

import com.sap.caf.mp.base.logging.BaseLogManager;
import com.sap.caf.mp.base.mimetype.BasicMimetype;
import com.sap.caf.mp.base.mimetype.IMimetype;
import com.sap.caf.mp.base.mimetype.IMimetypeMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class BasicMimetypeMap
implements IMimetypeMap {
    private static final String STANDARD_FILE_NAME = "mimetypes.txt";
    private Hashtable m_mimetypes = new Hashtable();
    private BasicMimetype m_defaultMimetype = new BasicMimetype("application", null);

    private void addMimetype(String line) {
        if (line.startsWith("//")) {
            return;
        }
        if (line.startsWith("#")) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(line, " ", false);
        BaseLogManager.info(this.getClass(), "Adding mime type info: " + line);
        String mimeType = null;
        Vector<String> extensions = new Vector<String>();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (mimeType == null) {
                mimeType = token;
                continue;
            }
            extensions.add(token.toLowerCase());
        }
        if (mimeType != null && extensions.size() > 0) {
            BasicMimetype bmt = new BasicMimetype(mimeType, extensions);
            Enumeration enumeration = extensions.elements();
            while (enumeration.hasMoreElements()) {
                String extension = (String)enumeration.nextElement();
                this.m_mimetypes.put(extension, bmt);
            }
        }
    }

    private void addStandardMimetypes() {
        this.addMimetype("text/plain asc txt text c h java cpp f90 m ini g");
        this.addMimetype("text/html htm html");
        this.addMimetype("text/xml xml");
        this.addMimetype("text/richtext rtf");
        this.addMimetype("text/thtml tht thtm thtml");
        this.addMimetype("text/asp asp");
        this.addMimetype("text/css css");
        this.addMimetype("text/javascript js ");
        this.addMimetype("image/gif gif");
        this.addMimetype("image/jpeg jpg jpe jpeg");
        this.addMimetype("image/bmp bmp");
        this.addMimetype("image/ief ief");
        this.addMimetype("image/png png");
        this.addMimetype("image/tiff tif tiff");
        this.addMimetype("application/x-zip-compressed zip");
        this.addMimetype("application/msword doc dot");
        this.addMimetype("application/mshelp chm");
        this.addMimetype("application/vnd.ms-excel xls");
        this.addMimetype("application/vnd.ms-powerpoint ppa pot pps ppz ppt");
        this.addMimetype("application/vnd.ms-project mpp mpx");
    }

    private void addAdditionalMimetypes() {
        String javaHome = System.getProperty("java.home");
        if (javaHome == null) {
            return;
        }
        File folder = new File(javaHome);
        folder = new File(folder, "lib");
        File file = new File(folder = new File(folder, "ext"), STANDARD_FILE_NAME);
        if (!file.exists()) {
            return;
        }
        try {
            FileInputStream fis = new FileInputStream(file);
            InputStreamReader isr = new InputStreamReader(fis);
            BufferedReader reader = new BufferedReader(isr);
            String line = reader.readLine();
            while (line != null) {
                this.addMimetype(line);
                line = reader.readLine();
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    public BasicMimetypeMap() {
        this.addStandardMimetypes();
        this.addAdditionalMimetypes();
    }

    public IMimetype getMimetype(String filename) {
        int pos = filename.lastIndexOf(".");
        String extension = null;
        if (pos > 0) {
            extension = filename.substring(pos + 1);
        }
        if (extension == null) {
            return this.m_defaultMimetype;
        }
        BasicMimetype mimeType = (BasicMimetype)this.m_mimetypes.get(extension);
        if (mimeType == null) {
            return this.m_defaultMimetype;
        }
        return mimeType;
    }

    public IMimetype getMimetype(File file) {
        return this.getMimetype(file.getName());
    }
}

