/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.base.exception;

import com.sap.exception.BaseException;
import java.text.MessageFormat;

public class KnBaseException
extends BaseException {
    private static final long serialVersionUID = 1L;
    private String m_message;
    private Exception m_nestedException;

    protected KnBaseException() {
        this.m_message = ((Object)((Object)this)).getClass().getName();
        this.m_nestedException = null;
    }

    protected KnBaseException(String msg) {
        this.m_message = msg;
        this.m_nestedException = null;
    }

    protected KnBaseException(Exception ex) {
        this.m_message = ex.getMessage() == null ? ex.getClass().toString() : ex.getMessage();
        this.m_nestedException = ex;
    }

    protected KnBaseException(String msg, Exception nestedException) {
        this.m_message = msg;
        this.m_nestedException = nestedException;
    }

    public String toString() {
        if (this.m_nestedException == null) {
            return this.m_message;
        }
        return this.m_message + ", " + this.m_nestedException;
    }

    public Exception getNestedException() {
        return this.m_nestedException;
    }

    public String getLocalizedMessage() {
        if (this.m_message == null && this.m_nestedException == null) {
            return ((Object)((Object)this)).getClass().getName();
        }
        if (this.m_message == null) {
            return this.m_nestedException.getLocalizedMessage();
        }
        if (this.m_nestedException == null) {
            return this.m_message;
        }
        return MessageFormat.format("{0} (Nested exception: {1}).", this.m_message, this.extractLocalizedMessage(this.m_nestedException));
    }

    public String getMessage() {
        if (this.m_message == null && this.m_nestedException == null) {
            return ((Object)((Object)this)).getClass().getName();
        }
        if (this.m_message == null) {
            return this.extractMessage(this.m_nestedException);
        }
        if (this.m_nestedException == null) {
            return this.m_message;
        }
        return MessageFormat.format("{0} (Nested exception: {1}).", this.m_message, this.extractMessage(this.m_nestedException));
    }

    private String extractMessage(Exception ex) {
        String text = ex.getMessage();
        if (text == null) {
            return ex.getClass().getName();
        }
        return text;
    }

    private String extractLocalizedMessage(Exception ex) {
        String text = ex.getLocalizedMessage();
        if (text == null) {
            return ex.getClass().getName();
        }
        return text;
    }
}

