/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.base.device;

import com.sap.caf.mp.base.device.DeviceTypeDefinitionTitle;
import java.util.Enumeration;
import java.util.Hashtable;

public class DeviceTypeDefinition {
    private String m_name;
    private String m_fallbackLanguage;
    private String m_masterLanguage;
    private Hashtable m_titles;
    private Hashtable m_userAgents;
    private boolean m_default;

    protected DeviceTypeDefinition(String name, String fallbackLanguage, boolean def) {
        this.m_name = name;
        this.m_masterLanguage = null;
        this.m_fallbackLanguage = fallbackLanguage.toLowerCase();
        this.m_titles = new Hashtable();
        this.m_userAgents = new Hashtable();
        this.m_default = def;
    }

    protected void addUserAgent(String userAgent) {
        this.m_userAgents.put(userAgent, userAgent);
    }

    protected void setUserAgents(Hashtable userAgents) {
        this.m_userAgents = userAgents;
    }

    protected void setMasterLanguage(String language) {
        this.m_masterLanguage = language.toLowerCase();
    }

    protected void addTitle(String language, String text) {
        language = language.toLowerCase();
        DeviceTypeDefinitionTitle title = new DeviceTypeDefinitionTitle(language, text);
        this.m_titles.put(language, title);
    }

    protected void setTitles(Hashtable titles) {
        this.m_titles = titles;
    }

    public String getName() {
        return this.m_name;
    }

    public Enumeration getUserAgents() {
        return this.m_userAgents.elements();
    }

    public DeviceTypeDefinitionTitle resolveTitle(String language) {
        if (this.m_titles.containsKey(language = language.toLowerCase())) {
            return (DeviceTypeDefinitionTitle)this.m_titles.get(language);
        }
        if (this.m_titles.containsKey(this.m_fallbackLanguage)) {
            return (DeviceTypeDefinitionTitle)this.m_titles.get(this.m_fallbackLanguage);
        }
        return (DeviceTypeDefinitionTitle)this.m_titles.get(this.m_masterLanguage);
    }

    public Enumeration getTitles() {
        return this.m_titles.elements();
    }

    public boolean isDefault() {
        return this.m_default;
    }

    public String getMasterLanguage() {
        return this.m_masterLanguage;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("DeviceTypeDefinition masterLanguage=");
        result.append(this.m_masterLanguage);
        result.append(" default=");
        result.append(this.m_default);
        result.append("\r\n  UserAgents");
        Enumeration agents = this.m_userAgents.elements();
        while (agents.hasMoreElements()) {
            String agent = (String)agents.nextElement();
            result.append("\r\n    " + agent);
        }
        result.append("\r\n  Titles");
        Enumeration titles = this.m_titles.elements();
        while (titles.hasMoreElements()) {
            DeviceTypeDefinitionTitle title = (DeviceTypeDefinitionTitle)titles.nextElement();
            result.append("\r\n    " + title.toString());
        }
        return result.toString();
    }
}

