/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.base.db;

import com.sap.caf.mp.base.db.ICNConnectionPool;
import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.exception.InvocationException;
import java.sql.Connection;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.sql.DataSource;

public class ConnectionPoolJ2EE
implements ICNConnectionPool {
    public static final String DBPOOL_NAME = "DBPOOL_NAME";
    private String m_dbpoolName;
    private DataSource m_dataSource;

    public void initialize(Properties props) throws InvocationException, EngineException {
        this.m_dbpoolName = props.getProperty(DBPOOL_NAME);
        if (this.m_dbpoolName == null) {
            throw new InvocationException("Unable to initialize connection pool: J2EE database pool name missing.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws EngineException {
        InitialContext ctxt = null;
        try {
            ctxt = new InitialContext();
        }
        catch (Exception ex) {
            throw new EngineException("Unable to acquire initial context: " + ex.getMessage(), ex);
        }
        ConnectionPoolJ2EE ex = this;
        synchronized (ex) {
            if (this.m_dataSource == null) {
                try {
                    this.m_dataSource = (DataSource)ctxt.lookup(this.m_dbpoolName);
                }
                catch (Exception ex2) {
                    throw new EngineException("Unable to access data source for pool with this name.", ex2);
                }
            }
        }
        try {
            return this.m_dataSource.getConnection();
        }
        catch (Exception ex2) {
            throw new EngineException("Unable to open connection for this data source.", ex2);
        }
    }

    public void ReturnConnection(Connection conn, boolean invalid) {
    }
}

