/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.base.caching;

import com.sap.caf.mp.base.caching.ICacheEntryValidator;
import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.base.logging.BaseLogManager;
import com.sap.caf.mp.base.resource.BaseResourceHandler;
import java.lang.ref.SoftReference;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;

public class MemoryCache {
    private static final long THREAD_SLEEP_TIME = 100L;
    private int m_invalidationCycle;
    private ICacheEntryValidator m_validator;
    private boolean m_shutdownRequested;
    private Hashtable m_cacheEntries;
    private ValidationThread m_validationThread;

    public MemoryCache(int invalidationCycle, Locale locale) throws InvocationException, EngineException {
        this.m_invalidationCycle = invalidationCycle;
        if (this.m_invalidationCycle < 0) {
            throw new InvocationException(BaseResourceHandler.getString("MemoryCache.ERROR_NO_NEGATIVE_VALUES", locale));
        }
        this.m_invalidationCycle = invalidationCycle;
        this.m_validator = null;
        this.m_cacheEntries = new Hashtable();
        this.m_shutdownRequested = false;
        if (this.m_invalidationCycle != 0) {
            this.m_validationThread = new ValidationThread();
            this.m_validationThread.start();
        }
    }

    public MemoryCache(int invalidationCycle, ICacheEntryValidator validator, Locale locale) throws InvocationException, EngineException {
        this.m_invalidationCycle = invalidationCycle;
        if (this.m_invalidationCycle < 0) {
            throw new InvocationException(BaseResourceHandler.getString("MemoryCache.ERROR_NO_NEGATIVE_VALUES", locale));
        }
        if (this.m_invalidationCycle == 0) {
            throw new InvocationException(BaseResourceHandler.getString("MemoryCache.ERROR_NO_ZERO_VALUE", locale));
        }
        this.m_validator = validator;
        this.m_cacheEntries = new Hashtable();
        this.m_shutdownRequested = false;
        this.m_validationThread = new ValidationThread();
        this.m_validationThread.start();
    }

    private void checkActive() throws InvocationException {
        if (this.m_shutdownRequested) {
            throw new InvocationException("The cache has been shut down.");
        }
    }

    public void shutdown() {
        this.m_shutdownRequested = true;
        this.clear();
    }

    public boolean isShutdown() {
        return this.m_shutdownRequested;
    }

    public void clear() {
        this.m_cacheEntries.clear();
    }

    public void addEntry(String entryId, Object entry) throws InvocationException {
        this.checkActive();
        CacheEntry newEntry = new CacheEntry(entryId, entry);
        this.m_cacheEntries.put(entryId, newEntry);
    }

    public Object getEntry(String entryId) throws InvocationException {
        this.checkActive();
        CacheEntry entry = (CacheEntry)this.m_cacheEntries.get(entryId);
        if (entry != null) {
            return entry.getEntry();
        }
        return null;
    }

    public Object removeEntry(String entryId) throws InvocationException {
        this.checkActive();
        Object entry = this.getEntry(entryId);
        this.m_cacheEntries.remove(entryId);
        return entry;
    }

    private class ValidationThread
    extends Thread {
        private ValidationThread() {
        }

        public void run() {
            BaseLogManager.info(this.getClass(), "Cache validator was started.");
            while (!MemoryCache.this.isShutdown()) {
                try {
                    Enumeration enumeration = MemoryCache.this.m_cacheEntries.elements();
                    while (enumeration.hasMoreElements()) {
                        CacheEntry cacheEntry = (CacheEntry)enumeration.nextElement();
                        long lastTime = cacheEntry.getLastCheckTime();
                        if (lastTime + (long)MemoryCache.this.m_invalidationCycle >= System.currentTimeMillis()) continue;
                        if (MemoryCache.this.m_validator != null) {
                            String entryId = cacheEntry.getEntryId();
                            Object entry = cacheEntry.getEntry();
                            if (entry != null && MemoryCache.this.m_validator.validateEntry(entryId, entry)) {
                                cacheEntry.touch();
                                continue;
                            }
                            MemoryCache.this.removeEntry(entryId);
                            continue;
                        }
                        MemoryCache.this.removeEntry(cacheEntry.getEntryId());
                    }
                    Thread.sleep(100L);
                }
                catch (Exception ex) {
                    BaseLogManager.error(this.getClass(), ex.getMessage());
                }
            }
            BaseLogManager.info(this.getClass(), "Cache validator was stopped.");
        }
    }

    private class CacheEntry {
        private String m_entryId;
        private SoftReference m_entry;
        private long m_lastcheckTime;

        public CacheEntry(String entryid, Object entry) {
            this.m_entryId = entryid;
            this.m_entry = new SoftReference<Object>(entry);
            this.m_lastcheckTime = System.currentTimeMillis();
        }

        public String getEntryId() {
            return this.m_entryId;
        }

        public Object getEntry() {
            return this.m_entry.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getLastCheckTime() {
            CacheEntry cacheEntry = this;
            synchronized (cacheEntry) {
                return this.m_lastcheckTime;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void touch() {
            CacheEntry cacheEntry = this;
            synchronized (cacheEntry) {
                this.m_lastcheckTime = System.currentTimeMillis();
            }
        }
    }
}

