/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.security.util;

import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.BusinessEntityInterface;
import com.sap.caf.metamodel.DataObject;
import com.sap.caf.rt.bol.IDependentObject;
import com.sap.caf.rt.exception.CAFCreateException;
import com.sap.caf.rt.exception.CAFPermissionException;
import com.sap.caf.rt.exception.DataAccessException;
import com.sap.caf.rt.exception.ServiceException;
import com.sap.caf.rt.metamodel.MetaModel;
import com.sap.caf.rt.security.acl.impl.CAFPermissionLocal;
import com.sap.caf.rt.security.acl.impl.CAFPermissionLocalHome;
import com.sap.caf.rt.security.acl.impl.businessrule.BusinessRuleLocal;
import com.sap.caf.rt.security.acl.impl.businessrule.BusinessRuleLocalHome;
import com.sap.caf.rt.security.acl.impl.businessrule.BusinessRuleVo;
import com.sap.caf.rt.security.acl.impl.condition.ConditionLocal;
import com.sap.caf.rt.security.acl.impl.condition.ConditionLocalHome;
import com.sap.caf.rt.security.acl.impl.condition.ConditionVo;
import com.sap.caf.rt.security.acl.impl.objectattribute.ObjectAttributeLocal;
import com.sap.caf.rt.security.acl.impl.objectattribute.ObjectAttributeLocalHome;
import com.sap.caf.rt.security.acl.impl.objectattribute.ObjectAttributeVo;
import com.sap.caf.rt.security.acl.impl.objecttype.ObjectTypeLocal;
import com.sap.caf.rt.security.acl.impl.objecttype.ObjectTypeLocalHome;
import com.sap.caf.rt.security.util.CAFBusinessConditionBean;
import com.sap.caf.rt.security.util.CAFBusinessRuleBean;
import com.sap.caf.rt.security.util.CAFBusinessRuleList;
import com.sap.caf.rt.security.util.CAFPermissionCache;
import com.sap.caf.rt.srv.util.EJBHomeFactory;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.logging.Location;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.ejb.CreateException;
import javax.ejb.EJBLocalHome;
import javax.naming.NamingException;

public class CAFPermissionUtil {
    private static final String APPLICATION = (class$com$sap$caf$rt$security$util$CAFPermissionUtil == null ? (class$com$sap$caf$rt$security$util$CAFPermissionUtil = CAFPermissionUtil.class$("com.sap.caf.rt.security.util.CAFPermissionUtil")) : class$com$sap$caf$rt$security$util$CAFPermissionUtil).getName();
    private static final Location LOGGER = Location.getLocation((String)APPLICATION);
    private static final String JARMREQPREFIX = "CAF:RT:security:";
    private static final String JARMREQUEST = "CAF:RT:security:" + APPLICATION;
    private static final String BUSINESSRULE_JNDI = "/localejbs/sap.com/caf.runtime/BusinessRule";
    private static final String OBJECTATTRIBUTE_JNDI = "/localejbs/sap.com/caf.runtime/ObjectAttribute";
    private static final String CONDITION_JNDI = "/localejbs/sap.com/caf.runtime/Condition";
    private static final String CAFPERMISSION_JNDI = "/localejbs/sap.com/caf.runtime/CAFPermissionBean";
    private static final String OBJECTTYPE_JNDI = "/localejbs/sap.com/caf.runtime/ObjectType";
    private static MetaModel m_mmr = null;
    static /* synthetic */ Class class$com$sap$caf$rt$security$util$CAFPermissionUtil;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Map;

    public static BusinessRuleLocal getBusinessRuleLocal() throws CAFCreateException {
        String method = "getBusinessRuleLocal()";
        try {
            EJBHomeFactory ejbFactory = EJBHomeFactory.getInstance();
            BusinessRuleLocalHome businessRuleLocalHome = (BusinessRuleLocalHome)ejbFactory.getLocalHome(BUSINESSRULE_JNDI);
            BusinessRuleLocal businessRuleLocal = businessRuleLocalHome.create();
            return businessRuleLocal;
        }
        catch (NamingException e) {
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"getBusinessRuleLocal()", (String)e.getMessage(), (Throwable)e);
            throw new CAFCreateException(e.getMessage());
        }
        catch (CreateException e) {
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"getBusinessRuleLocal()", (String)e.getMessage(), (Throwable)e);
            throw new CAFCreateException(e.getMessage());
        }
    }

    public static ObjectTypeLocal getObjectTypeLocal() throws CAFCreateException {
        String method = "getObjectTypeLocal()";
        try {
            EJBHomeFactory ejbFactory = EJBHomeFactory.getInstance();
            ObjectTypeLocalHome objectTypeLocalHome = (ObjectTypeLocalHome)ejbFactory.getLocalHome(OBJECTTYPE_JNDI);
            ObjectTypeLocal objectTypeLocal = objectTypeLocalHome.create();
            return objectTypeLocal;
        }
        catch (NamingException e) {
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"getObjectTypeLocal()", (String)e.getMessage(), (Throwable)e);
            throw new CAFCreateException(e.getMessage());
        }
        catch (CreateException e) {
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"getObjectTypeLocal()", (String)e.getMessage(), (Throwable)e);
            throw new CAFCreateException(e.getMessage());
        }
    }

    public static ObjectAttributeLocal getObjectAttributeLocal() throws CAFCreateException {
        String method = "getObjectAttributeLocal()";
        try {
            EJBHomeFactory ejbFactory = EJBHomeFactory.getInstance();
            ObjectAttributeLocalHome objectAttributeLocalHome = (ObjectAttributeLocalHome)ejbFactory.getLocalHome(OBJECTATTRIBUTE_JNDI);
            ObjectAttributeLocal objectAttributeLocal = objectAttributeLocalHome.create();
            return objectAttributeLocal;
        }
        catch (NamingException e) {
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"getObjectAttributeLocal()", (String)e.getMessage(), (Throwable)e);
            throw new CAFCreateException(e.getMessage());
        }
        catch (CreateException e) {
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"getObjectAttributeLocal()", (String)e.getMessage(), (Throwable)e);
            throw new CAFCreateException(e.getMessage());
        }
    }

    public static ConditionLocal getConditionLocal() throws CAFCreateException {
        String method = "getConditionLocal()";
        try {
            EJBHomeFactory ejbFactory = EJBHomeFactory.getInstance();
            ConditionLocalHome conditionLocalHome = (ConditionLocalHome)ejbFactory.getLocalHome(CONDITION_JNDI);
            ConditionLocal conditionLocal = conditionLocalHome.create();
            return conditionLocal;
        }
        catch (NamingException e) {
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"getConditionLocal()", (String)e.getMessage(), (Throwable)e);
            throw new CAFCreateException(e.getMessage());
        }
        catch (CreateException e) {
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"getConditionLocal()", (String)e.getMessage(), (Throwable)e);
            throw new CAFCreateException(e.getMessage());
        }
    }

    public static boolean remoteCheckAclPermission(Object obj, String userId, String permissionName, String objectType) throws CAFPermissionException, CAFCreateException {
        String method = "remoteCheckAclPermission";
        try {
            EJBHomeFactory ejbFactory = EJBHomeFactory.getInstance();
            CAFPermissionLocalHome permissionLocalHome = (CAFPermissionLocalHome)ejbFactory.getLocalHome(CAFPERMISSION_JNDI);
            CAFPermissionLocal permissionLocal = permissionLocalHome.create();
            return permissionLocal.checkAclPermission(obj, userId, permissionName, objectType);
        }
        catch (NamingException e) {
            CAFPublicLogger.traceThrowableT((int)300, (Location)LOGGER, (String)"remoteCheckAclPermission", (String)e.getMessage(), (Throwable)e);
            throw new CAFCreateException(e.getMessage());
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowableT((int)300, (Location)LOGGER, (String)"remoteCheckAclPermission", (String)e.getMessage(), (Throwable)e);
            throw new CAFPermissionException((Throwable)e);
        }
    }

    public static ArrayList fetchAttributeSet(String objectTypeID) throws ServiceException {
        String method = "fetchAttributeSet(String)";
        CAFPublicLogger.entering(null, (String)JARMREQUEST, (String)"fetchAttributeSet(String)", (Location)LOGGER, (int)1);
        try {
            ObjectAttributeLocal objectAttributeLocal = CAFPermissionUtil.getObjectAttributeLocal();
            Collection objectAttributes = objectAttributeLocal.findByObjectTypeID(objectTypeID);
            ArrayList<String> result = new ArrayList<String>();
            Iterator it = objectAttributes.iterator();
            while (it.hasNext()) {
                ObjectAttributeVo objectAttributeVo = (ObjectAttributeVo)it.next();
                result.add(objectAttributeVo.getObjectAttributeName());
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        catch (Exception _e) {
            throw new ServiceException(_e.getLocalizedMessage());
        }
        finally {
            CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"fetchAttributeSet(String)", (Location)LOGGER, (int)1);
        }
    }

    public static ArrayList fetchBusinessRules(String objectType) throws ServiceException {
        String method = "fetchBusinessRules(String)";
        CAFPublicLogger.entering(null, (String)JARMREQUEST, (String)"fetchBusinessRules(String)", (Location)LOGGER, (int)1);
        CAFBusinessRuleList cafBusinessRuleList = null;
        try {
            BusinessRuleLocal businessRuleLocal = CAFPermissionUtil.getBusinessRuleLocal();
            ConditionLocal conditionLocal = CAFPermissionUtil.getConditionLocal();
            Collection businessRules = businessRuleLocal.findByObjectType(objectType);
            if (businessRules == null) {
                ArrayList arrayList = new ArrayList();
                return arrayList;
            }
            ArrayList businessRulesCopy = new ArrayList(businessRules);
            BusinessRuleVo businessRuleVoCopy = (BusinessRuleVo)businessRulesCopy.iterator().next();
            String objectTypeID = businessRuleVoCopy.getObjectTypeID();
            ArrayList attrList = (ArrayList)CAFPermissionCache.getAttributeSetFromCache(objectTypeID);
            cafBusinessRuleList = new CAFBusinessRuleList(businessRules.size(), attrList);
            Iterator it = businessRules.iterator();
            while (it.hasNext()) {
                BusinessRuleVo businessRuleVo = (BusinessRuleVo)it.next();
                Collection conditions = conditionLocal.findByBusinessRule(businessRuleVo.getKey());
                CAFBusinessRuleBean cafBusinessRuleBean = new CAFBusinessRuleBean(businessRuleVo.getKey());
                Iterator iter = conditions.iterator();
                while (iter.hasNext()) {
                    ConditionVo conditionVo = (ConditionVo)iter.next();
                    StringTokenizer valueToken = new StringTokenizer(conditionVo.getAttributeValue(), "_", false);
                    String lowValue = valueToken.nextToken();
                    String highValue = valueToken.nextToken();
                    String operator = valueToken.nextToken();
                    CAFBusinessConditionBean cafBusinessConditionBean = new CAFBusinessConditionBean(conditionVo.getKey(), conditionVo.getAttributeName(), lowValue, highValue, operator, cafBusinessRuleList.getAttributeIndex(conditionVo.getAttributeName()));
                    cafBusinessRuleBean.addCondition(cafBusinessConditionBean);
                }
                cafBusinessRuleList.add(cafBusinessRuleBean);
            }
        }
        catch (Exception e) {
            throw new ServiceException(e.getLocalizedMessage());
        }
        finally {
            CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"fetchBusinessRules(String)", (Location)LOGGER, (int)1);
        }
        return cafBusinessRuleList;
    }

    public static IDependentObject getDependentObject(String objectID, String objectType) throws ServiceException {
        String method = "getDependentObject(String, String)";
        try {
            EJBHomeFactory ejbFactory = EJBHomeFactory.getInstance();
            String jndiName = "/localejbs/" + objectType + "Service";
            EJBLocalHome objectLocalHome = ejbFactory.getLocalHome(jndiName);
            Method createLocal = objectLocalHome.getClass().getMethod("create", new Class[0]);
            Object bean = createLocal.invoke((Object)objectLocalHome, new Object[0]);
            Method methodRead = bean.getClass().getMethod("read", class$java$lang$String == null ? (class$java$lang$String = CAFPermissionUtil.class$("java.lang.String")) : class$java$lang$String);
            Object ejbRef = methodRead.invoke(bean, objectID);
            return (IDependentObject)ejbRef;
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"getDependentObject(String, String)", (String)e.getMessage(), (Throwable)e);
            throw new ServiceException(e.getMessage());
        }
    }

    public static Collection getDependentObjects(String objectType, Map mapNameToFilter) throws ServiceException {
        String method = "getDependentObjects(String, Map)";
        try {
            EJBHomeFactory ejbFactory = EJBHomeFactory.getInstance();
            String jndiName = "/localejbs/" + objectType + "Service";
            EJBLocalHome objectLocalHome = ejbFactory.getLocalHome(jndiName);
            Method createLocal = objectLocalHome.getClass().getMethod("create", new Class[0]);
            Object bean = createLocal.invoke((Object)objectLocalHome, new Object[0]);
            Method methodRead = bean.getClass().getMethod("findByMultipleParameters", class$java$util$Map == null ? (class$java$util$Map = CAFPermissionUtil.class$("java.util.Map")) : class$java$util$Map, Boolean.TYPE, class$java$lang$String == null ? (class$java$lang$String = CAFPermissionUtil.class$("java.lang.String")) : class$java$lang$String);
            Object ejbRef = methodRead.invoke(bean, mapNameToFilter, Boolean.FALSE, "getDependentObjects");
            return (Collection)ejbRef;
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"getDependentObjects(String, Map)", (String)e.getMessage(), (Throwable)e);
            throw new ServiceException(e.getMessage());
        }
    }

    private static synchronized MetaModel getMetaModel() throws ServiceException {
        String method = "getMetaModel()";
        if (m_mmr == null) {
            try {
                m_mmr = new MetaModel();
            }
            catch (DataAccessException e) {
                CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)method, (String)e.getMessage(), (Throwable)e);
                throw new ServiceException(e.getMessage());
            }
        }
        return m_mmr;
    }

    public static synchronized BusinessEntityInterface getBusinessEntityInterfaceByObjectName(String objectName) throws DataAccessException, ServiceException {
        return CAFPermissionUtil.getMetaModel().getBusinessEntityInterfaceByObjectName(objectName);
    }

    public static synchronized BusinessEntityInterface getBusinessEntityInterfaceByGUID(String guid) throws DataAccessException, ServiceException {
        return CAFPermissionUtil.getMetaModel().getBusinessEntityInterfaceByGUID(guid);
    }

    public static synchronized DataObject getDataObjectByGUID(String guid) throws DataAccessException, ServiceException {
        return CAFPermissionUtil.getMetaModel().getDataObjectByGUID(guid);
    }

    public static synchronized DataObject getDataObject(String qualifiedName) throws DataAccessException, ServiceException {
        return CAFPermissionUtil.getMetaModel().getDataObject(qualifiedName);
    }

    public static synchronized Map getAttributes(String qualifiedName) throws DataAccessException, ServiceException {
        return CAFPermissionUtil.getMetaModel().getAttributes(qualifiedName);
    }

    public static synchronized Attribute getAttribute(String guid) throws DataAccessException, ServiceException {
        return CAFPermissionUtil.getMetaModel().getAttribute(guid);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

