/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.security.util;

import com.sap.caf.rt.exception.CAFPermissionException;
import com.sap.caf.rt.security.util.CAFPermissionUtil;
import com.sap.ip.basecomps.cache.Attributes;
import com.sap.ip.basecomps.cache.CacheAccess;
import com.sap.ip.basecomps.cache.CacheException;
import com.sap.ip.basecomps.cache.CacheNotAvailableException;
import com.sap.ip.basecomps.cache.ObjectExistsException;
import java.util.ArrayList;
import java.util.Properties;

public class CAFPermissionCache {
    private static CacheAccess mCacheParamAccess;
    private static CacheAccess mCacheRuleAccess;
    private static CacheAccess mCachePermissionAccess;
    private static final String CAF_ACL_PARAMETER_GROUP = "CAF_ACL_PARAM_GROUP";
    private static final String CAF_ACL_BUSINESSRULE_GROUP = "CAF_ACL_RULE_GROUP";
    private static final String CAF_ACL_PERMISSION_GROUP = "CAF_ACL_PERM_GROUP";
    private static final String CAF_PARAM_CACHEID = "CAF_ACL_PARAM_GROUP";
    private static final String CAF_RULE_CACHE_ID = "CAF_ACL_RULE_GROUP";
    private static final String CAF_PERMISSION_CACHEID = "CAF_ACL_PERM_GROUP";
    private static final String CAF_ACL_LIFETIME = "lifetime";
    private static final String LT_UNLIMITED = "-1";
    private static final String WT_SIGNLETON = "1";
    private static final String LT_PERMISSION = "900000";
    private static final String CAF_ACL_WEIGHT = "weight";
    private static final String ACCESS_GRANDED = "accessGranded";
    private static final String ACCESS_DENIED = "accessDenied";

    public static Object getAttributeSetFromCache(String objectTypeID) throws CAFPermissionException {
        CacheAccess ma = CAFPermissionCache.getCacheAccess(CAFPermissionCache.getCacheParamAccess(), "CAF_ACL_PARAM_GROUP", "CAF_ACL_PARAM_GROUP", LT_UNLIMITED);
        Object cObj = null;
        try {
            cObj = ma.get((Object)objectTypeID);
        }
        catch (Exception _ex) {
            throw new CAFPermissionException("AUTH_CACHE_READ", new Object[]{"AttributeSet", objectTypeID});
        }
        if (cObj == null) {
            try {
                ArrayList al = CAFPermissionUtil.fetchAttributeSet(objectTypeID);
                ma.put((Object)objectTypeID, (Object)al);
                cObj = al;
            }
            catch (Exception _ex) {
                throw new CAFPermissionException("AUTH_CACHE_READ", new Object[]{"AttributeSet", objectTypeID});
            }
        }
        return cObj;
    }

    public static Object getBusinessRuleFromCache(String objectType) throws CAFPermissionException {
        CacheAccess ma = CAFPermissionCache.getCacheAccess(CAFPermissionCache.getCacheRuleAccess(), "CAF_ACL_RULE_GROUP", "CAF_ACL_RULE_GROUP", LT_UNLIMITED);
        Object cObj = null;
        try {
            cObj = ma.get((Object)objectType);
        }
        catch (Exception _ex) {
            throw new CAFPermissionException("AUTH_CACHE_READ", new Object[]{"BusinessRule", objectType});
        }
        try {
            if (cObj == null) {
                cObj = CAFPermissionUtil.fetchBusinessRules(objectType);
                ma.put((Object)objectType, cObj);
            }
        }
        catch (Exception _ex) {
            try {
                ma.delete((Object)objectType);
            }
            catch (Exception e) {
                new CAFPermissionException((Throwable)e);
            }
            throw new CAFPermissionException("AUTH_NO_BUSINESSRULE", new Object[]{objectType});
        }
        return cObj;
    }

    public static void cacheAllowedAccess(String accessCacheKey) throws CAFPermissionException {
        CAFPermissionCache.cacheAllowedAccess(accessCacheKey, true);
    }

    public static void cacheAllowedAccess(String accessCacheKey, boolean allowed) throws CAFPermissionException {
        CacheAccess cacheAccess = CAFPermissionCache.getCacheAccess(CAFPermissionCache.getCachePermissionAccess(), "CAF_ACL_PERM_GROUP", "CAF_ACL_PERM_GROUP", LT_PERMISSION);
        try {
            cacheAccess.put((Object)accessCacheKey, (Object)(allowed ? ACCESS_GRANDED : ACCESS_DENIED));
        }
        catch (Exception _ex) {
            throw new CAFPermissionException((Throwable)_ex);
        }
    }

    public static Boolean getAllowed(String accessCacheKey) throws CAFPermissionException {
        CacheAccess cacheAccess = CAFPermissionCache.getCacheAccess(CAFPermissionCache.getCachePermissionAccess(), "CAF_ACL_PERM_GROUP", "CAF_ACL_PERM_GROUP", LT_PERMISSION);
        try {
            String val = (String)cacheAccess.get((Object)accessCacheKey);
            return val == null ? null : (ACCESS_GRANDED.equals(val) ? Boolean.TRUE : Boolean.FALSE);
        }
        catch (Exception ex) {
            throw new CAFPermissionException((Throwable)ex);
        }
    }

    public static boolean isAllowed(String accessCacheKey) throws CAFPermissionException {
        Boolean res = CAFPermissionCache.getAllowed(accessCacheKey);
        return res == null ? false : res;
    }

    public static void invalidCache() throws CAFPermissionException {
        if (CAFPermissionCache.getCacheParamAccess() != null) {
            CAFPermissionCache.invalidParamCache();
        }
        if (CAFPermissionCache.getCacheRuleAccess() != null) {
            CAFPermissionCache.invalidRuleCache();
        }
        if (CAFPermissionCache.getCachePermissionAccess() != null) {
            CAFPermissionCache.invalidPermissionCache();
        }
    }

    public static void invalidParamCache() throws CAFPermissionException {
        try {
            if (CAFPermissionCache.getCacheParamAccess() != null) {
                CacheAccess.destroyRegion((String)"CAF_ACL_PARAM_GROUP");
                CAFPermissionCache.setCacheParamAccess(null);
            }
        }
        catch (CacheException e) {
            new CAFPermissionException((Throwable)e);
        }
    }

    public static void invalidRuleCache() throws CAFPermissionException {
        try {
            if (CAFPermissionCache.getCacheRuleAccess() != null) {
                CacheAccess.destroyRegion((String)"CAF_ACL_RULE_GROUP");
                CAFPermissionCache.setCacheRuleAccess(null);
            }
        }
        catch (CacheException _e) {
            throw new CAFPermissionException((Throwable)_e);
        }
    }

    public static void invalidPermissionCache() throws CAFPermissionException {
        CAFPermissionCache.getCacheAccess(CAFPermissionCache.getCachePermissionAccess(), "CAF_ACL_PERM_GROUP", "CAF_ACL_PERM_GROUP", LT_UNLIMITED);
        try {
            if (CAFPermissionCache.getCachePermissionAccess() != null) {
                CacheAccess.destroyRegion((String)"CAF_ACL_PERM_GROUP");
                CAFPermissionCache.setCachePermissionAccess(null);
            }
        }
        catch (CacheException _e) {
            throw new CAFPermissionException((Throwable)_e);
        }
    }

    private static CacheAccess getCacheParamAccess() {
        return mCacheParamAccess;
    }

    private static void setCacheParamAccess(CacheAccess mCacheAccess) {
        mCacheParamAccess = mCacheAccess;
    }

    private static CacheAccess getCacheRuleAccess() {
        return mCacheRuleAccess;
    }

    private static void setCacheRuleAccess(CacheAccess mCacheAccess) {
        mCacheRuleAccess = mCacheAccess;
    }

    private static CacheAccess getCachePermissionAccess() {
        return mCachePermissionAccess;
    }

    private static void setCachePermissionAccess(CacheAccess cacheAccess) {
        mCachePermissionAccess = cacheAccess;
    }

    private static CacheAccess getCacheAccess(CacheAccess mCacheAccess, String cacheId, String domainName, String lifeTime) throws CAFPermissionException {
        if (mCacheAccess == null) {
            Properties props = new Properties();
            props.put("consistency-domain.domain.name", domainName);
            props.put(CAF_ACL_LIFETIME, lifeTime);
            props.put(CAF_ACL_WEIGHT, WT_SIGNLETON);
            Attributes mDefaultAttributes = new Attributes(props);
            try {
                CacheAccess.defineRegion((String)cacheId, (Attributes)mDefaultAttributes);
                mCacheAccess = CacheAccess.getAccess((String)cacheId);
            }
            catch (CacheNotAvailableException cnaex) {
                throw new CAFPermissionException("AUTH_CACHE_CREATE", new Object[]{cacheId, cnaex.getMessage()});
            }
            catch (ObjectExistsException oee) {
                try {
                    mCacheAccess = CacheAccess.getAccess((String)cacheId);
                }
                catch (Exception ex) {
                    throw new CAFPermissionException("AUTH_CACHE_ACCESS", new Object[]{cacheId});
                }
            }
            catch (Exception ex) {
                throw new CAFPermissionException("AUTH_CACHE_ACCESS", new Object[]{cacheId});
            }
            if ("CAF_ACL_PARAM_GROUP".equals(cacheId)) {
                CAFPermissionCache.setCacheParamAccess(mCacheAccess);
            }
            if ("CAF_ACL_RULE_GROUP".equals(cacheId)) {
                CAFPermissionCache.setCacheRuleAccess(mCacheAccess);
            }
            if ("CAF_ACL_PERM_GROUP".equals(cacheId)) {
                CAFPermissionCache.setCachePermissionAccess(mCacheAccess);
            }
        }
        return mCacheAccess;
    }
}

