/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.security.util;

import com.sap.caf.rt.security.util.CAFBusinessConditionBean;
import com.sap.caf.rt.security.util.CAFBusinessRuleBean;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class CAFBusinessRuleList
extends ArrayList {
    private static final Class[] NO_ARGUMENTS = new Class[0];
    private static final Object[] NO_PARAMETERS = new Class[0];
    private static final String KEY_METHOD = "getKey";
    private static final Comparator CONDITIONS_OBJECT_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            CAFBusinessConditionBean co1 = (CAFBusinessConditionBean)o1;
            CAFBusinessConditionBean co2 = (CAFBusinessConditionBean)o2;
            return co1.getattributeName().compareTo(co2.getattributeName());
        }
    };
    private List m_attributeList;
    private Method[] m_getMethodList;
    private Method keyMethod;

    public CAFBusinessRuleList(int rulesSize, List attributeList) {
        super(rulesSize);
        this.setAttributes(attributeList);
        this.m_getMethodList = new Method[attributeList.size()];
    }

    public Object getProperty(Object object, String attributeName) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Method getMethod(Object object, int attributeIndex) throws NoSuchMethodException {
        Method method = this.m_getMethodList[attributeIndex];
        if (method == null || !method.getDeclaringClass().isInstance(object)) {
            CAFBusinessRuleList cAFBusinessRuleList = this;
            synchronized (cAFBusinessRuleList) {
                String attrName = (String)this.m_attributeList.get(attributeIndex);
                String methodName = "get" + attrName.substring(0, 1).toUpperCase() + attrName.substring(1);
                this.m_getMethodList[attributeIndex] = method = object.getClass().getMethod(methodName, NO_ARGUMENTS);
            }
        }
        return method;
    }

    private void setAttributes(List attributeList) {
        this.m_attributeList = attributeList;
    }

    public int getAttributeIndex(String attribute) {
        int size = this.m_attributeList.size();
        for (int i = 0; i < size; ++i) {
            if (!attribute.equals(this.m_attributeList.get(i))) continue;
            return i;
        }
        return -1;
    }

    public Object[] getEmptyAttributeCache() {
        return new Object[this.m_attributeList.size()];
    }

    public boolean objectFulfillBusinessRuleCondition(Object object, int businessRuleIndex, Object[] attrCache) throws Exception {
        CAFBusinessRuleBean businessRule = this.getBusinessRule(businessRuleIndex);
        List conditionList = businessRule.getConditions();
        Collections.sort(conditionList, CONDITIONS_OBJECT_COMPARATOR);
        String previousAttributeName = "";
        boolean resultOperationOR = true;
        boolean resultOperationAND = true;
        int size = conditionList.size();
        for (int i = 0; i < size; ++i) {
            String currentAttributeName;
            CAFBusinessConditionBean condition = (CAFBusinessConditionBean)conditionList.get(i);
            int attrIndex = condition.getAttributeIndex();
            Object attrValue = attrCache[attrIndex];
            if (object != null && attrValue == null) {
                Method method = this.getMethod(object, attrIndex);
                attrCache[attrIndex] = attrValue = method.invoke(object, NO_PARAMETERS);
            }
            if (!previousAttributeName.equals(currentAttributeName = condition.getattributeName())) {
                boolean bl = resultOperationAND = resultOperationAND && resultOperationOR;
                if (!resultOperationAND) {
                    return false;
                }
                resultOperationOR = false;
            }
            if (attrValue instanceof Collection) {
                boolean resultForCollectionAttributeAND = true;
                Iterator iter = ((Collection)attrValue).iterator();
                while (iter.hasNext()) {
                    resultForCollectionAttributeAND = resultForCollectionAttributeAND && condition.valueFulfillCondition(iter.next());
                }
                resultOperationOR = resultOperationOR || resultForCollectionAttributeAND;
            } else {
                resultOperationOR = resultOperationOR || condition.valueFulfillCondition(attrValue);
            }
            previousAttributeName = currentAttributeName;
        }
        resultOperationAND = resultOperationAND && resultOperationOR;
        return resultOperationAND;
    }

    public CAFBusinessRuleBean getBusinessRule(int index) {
        return (CAFBusinessRuleBean)this.get(index);
    }
}

