/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.security.acl.impl.permission;

import com.sap.caf.rt.bol.IBusinessObject;
import com.sap.caf.rt.bol.IDependentObject;
import com.sap.caf.rt.exception.ServiceException;
import com.sap.caf.rt.security.acl.impl.CAFPermission;
import com.sap.caf.rt.security.acl.impl.SecurityServiceBase;
import com.sap.caf.rt.security.acl.impl.permission.PermissionVo;
import com.sap.caf.rt.security.util.CAFPermissionCache;
import com.sap.caf.rt.security.util.CAFPermissionName;
import com.sap.caf.rt.security.util.CAFPermissionUtil;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.security.api.IPrincipal;
import com.sap.security.api.IPrincipalFactory;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.ejb.SessionBean;

public class PermissionBean
extends SecurityServiceBase
implements SessionBean {
    private static final String APPLICATION = (class$com$sap$caf$rt$security$acl$impl$permission$PermissionBean == null ? (class$com$sap$caf$rt$security$acl$impl$permission$PermissionBean = PermissionBean.class$("com.sap.caf.rt.security.acl.impl.permission.PermissionBean")) : class$com$sap$caf$rt$security$acl$impl$permission$PermissionBean).getName();
    private static final Location LOGGER = Location.getLocation((String)APPLICATION);
    private static final String JARMREQPREFIX = "CAF:RT:security:";
    private static final String JARMREQUEST = "CAF:RT:security:" + APPLICATION;
    private static final int PERMISSIONNAME_COUNT = 8;
    static /* synthetic */ Class class$com$sap$caf$rt$security$acl$impl$permission$PermissionBean;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void create(String businessRuleID, String principalID, String permissionName) throws ServiceException {
        String method = "create(String, String, String)";
        CAFPublicLogger.entering(null, (String)JARMREQUEST, (String)"create(String, String, String)", (Location)LOGGER, (int)1);
        String loginUserID = this.getCurrentUserID();
        try {
            try {
                IPrincipal iPrincipal = UMFactory.getPrincipalFactory().getPrincipal(principalID);
                CAFPermission.createPermission(loginUserID, businessRuleID, permissionName, iPrincipal);
            }
            catch (UMException e) {
                CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"create(String, String, String)", (String)e.getMessage(), (Throwable)e);
                throw new ServiceException((Throwable)e);
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                CAFPermissionCache.invalidRuleCache();
                CAFPermissionCache.invalidPermissionCache();
            }
            catch (Exception pex) {
                CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"create(String, String, String)", (String)pex.getMessage(), (Throwable)pex);
                throw new ServiceException("AUTH_RESET_CACHE");
            }
            CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"create(String, String, String)", (Location)LOGGER, (int)1);
            throw throwable;
        }
        try {}
        catch (Exception pex) {
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"create(String, String, String)", (String)pex.getMessage(), (Throwable)pex);
            throw new ServiceException("AUTH_RESET_CACHE");
        }
        CAFPermissionCache.invalidRuleCache();
        CAFPermissionCache.invalidPermissionCache();
        CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"create(String, String, String)", (Location)LOGGER, (int)1);
    }

    public boolean isPermissionExist(String businessRuleID, String principalID, String permissionName) throws ServiceException {
        String method = "isPermissionExist(String, String, String)";
        CAFPublicLogger.entering(null, (String)JARMREQUEST, (String)"isPermissionExist(String, String, String)", (Location)LOGGER, (int)1);
        boolean result = false;
        try {
            String loginUserID = this.getCurrentUserID();
            IPrincipalFactory principalFactory = UMFactory.getPrincipalFactory();
            IPrincipal iPrincipal = principalFactory.getPrincipal(principalID);
            ArrayList permissions = CAFPermission.retrievePermission(loginUserID, businessRuleID, permissionName, iPrincipal);
            result = !permissions.isEmpty();
        }
        catch (UMException e) {
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"isPermissionExist(String, String, String)", (String)e.getMessage(), (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"isPermissionExist(String, String, String)", (Location)LOGGER, (int)1);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void update(String businessRuleID, String permissionName, String nameBackUp, String principalID) throws ServiceException {
        String method = "update(String, String, String, String)";
        CAFPublicLogger.entering(null, (String)JARMREQUEST, (String)"update(String, String, String, String)", (Location)LOGGER, (int)1);
        String loginUserID = this.getCurrentUserID();
        try {
            try {
                IPrincipal iPrincipal = UMFactory.getPrincipalFactory().getPrincipal(principalID);
                CAFPermission.modifyPermission(loginUserID, businessRuleID, nameBackUp, permissionName, iPrincipal);
            }
            catch (UMException e) {
                CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"update(String, String, String, String)", (String)e.getMessage(), (Throwable)e);
                throw new ServiceException((Throwable)e);
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                CAFPermissionCache.invalidRuleCache();
                CAFPermissionCache.invalidPermissionCache();
            }
            catch (Exception pex) {
                CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"update(String, String, String, String)", (String)pex.getMessage(), (Throwable)pex);
                throw new ServiceException("AUTH_RESET_CACHE");
            }
            CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"update(String, String, String, String)", (Location)LOGGER, (int)1);
            throw throwable;
        }
        try {}
        catch (Exception pex) {
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"update(String, String, String, String)", (String)pex.getMessage(), (Throwable)pex);
            throw new ServiceException("AUTH_RESET_CACHE");
        }
        CAFPermissionCache.invalidRuleCache();
        CAFPermissionCache.invalidPermissionCache();
        CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"update(String, String, String, String)", (Location)LOGGER, (int)1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void delete(String businessRuleID, String principalID, String permissionName) throws ServiceException {
        String method = "delete(String, String, String)";
        CAFPublicLogger.entering(null, (String)JARMREQUEST, (String)"delete(String, String, String)", (Location)LOGGER, (int)1);
        try {
            try {
                String loginUserID = this.getCurrentUserID();
                IPrincipal principal = UMFactory.getPrincipalFactory().getPrincipal(principalID);
                CAFPermission.removePermission(loginUserID, businessRuleID, permissionName, principal);
            }
            catch (UMException e) {
                CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"delete(String, String, String)", (String)e.getMessage(), (Throwable)e);
                throw new ServiceException((Throwable)e);
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                CAFPermissionCache.invalidRuleCache();
                CAFPermissionCache.invalidPermissionCache();
            }
            catch (Exception pex) {
                CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"delete(String, String, String)", (String)pex.getMessage(), (Throwable)pex);
                throw new ServiceException("AUTH_RESET_CACHE");
            }
            CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"delete(String, String, String)", (Location)LOGGER, (int)1);
            throw throwable;
        }
        try {}
        catch (Exception pex) {
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"delete(String, String, String)", (String)pex.getMessage(), (Throwable)pex);
            throw new ServiceException("AUTH_RESET_CACHE");
        }
        CAFPermissionCache.invalidRuleCache();
        CAFPermissionCache.invalidPermissionCache();
        CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"delete(String, String, String)", (Location)LOGGER, (int)1);
    }

    public Collection findByObjectID(String objectID) throws ServiceException {
        String method = "findByObjectID(String)";
        CAFPublicLogger.entering(null, (String)JARMREQUEST, (String)"findByObjectID(String)", (Location)LOGGER, (int)1);
        ArrayList<PermissionVo> result = new ArrayList<PermissionVo>();
        try {
            if (CAFPermission.getACL(objectID) == null) {
                ArrayList<PermissionVo> arrayList = result;
                return arrayList;
            }
            String currentUserID = this.getCurrentUserID();
            ArrayList permissions = CAFPermission.retrievePermission(currentUserID, objectID, null, (IPrincipal)null);
            IPrincipalFactory principalFactory = UMFactory.getPrincipalFactory();
            Iterator iter = permissions.iterator();
            while (iter.hasNext()) {
                HashMap permissionMap = (HashMap)iter.next();
                Iterator permissionMapIter = permissionMap.keySet().iterator();
                while (permissionMapIter.hasNext()) {
                    IPrincipal principal = (IPrincipal)permissionMapIter.next();
                    String permissionName = (String)permissionMap.get(principal);
                    String principalType = principalFactory.getPrincipalType(principal.getUniqueID());
                    PermissionVo permissionVo = new PermissionVo();
                    permissionVo.setBusinessRuleID(objectID);
                    permissionVo.setPermissionName(permissionName);
                    permissionVo.setPrincipalType(principalType);
                    permissionVo.setPrincipalName(principal.getDisplayName());
                    permissionVo.setPrincipalID(principal.getUniqueID());
                    permissionVo.setNameBackUp(permissionName);
                    result.add(permissionVo);
                }
            }
            ArrayList<PermissionVo> arrayList = result;
            return arrayList;
        }
        catch (UMException e) {
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"findByObjectID(String)", (String)e.getMessage(), (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"findByObjectID(String)", (Location)LOGGER, (int)1);
        }
    }

    public Collection checkPermission(String principalID, String objectID, String objectType) throws ServiceException {
        String method = "checkPermission(String, String, String)";
        CAFPublicLogger.entering(null, (String)JARMREQUEST, (String)"checkPermission(String, String, String)", (Location)LOGGER, (int)1);
        ArrayList<PermissionVo> result = new ArrayList<PermissionVo>();
        try {
            IPrincipalFactory principalFactory = UMFactory.getPrincipalFactory();
            IPrincipal principal = principalFactory.getPrincipal(principalID);
            String principalType = principalFactory.getPrincipalType(principalID);
            IDependentObject depObj = CAFPermissionUtil.getDependentObject(objectID, objectType);
            Collection permissionList = CAFPermission.getAllowedPermission(principalID, depObj, objectType);
            Iterator iter = permissionList.iterator();
            while (iter.hasNext()) {
                String permissionName = (String)iter.next();
                PermissionVo permissionVo = new PermissionVo();
                permissionVo.setBusinessRuleID(objectID);
                permissionVo.setPermissionName(permissionName);
                permissionVo.setPrincipalType(principalType);
                permissionVo.setPrincipalName(principal.getDisplayName());
                permissionVo.setPrincipalID(principalID);
                permissionVo.setNameBackUp(permissionName);
                result.add(permissionVo);
            }
            ArrayList<PermissionVo> arrayList = result;
            return arrayList;
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"checkPermission(String, String, String)", (String)e.getMessage(), (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"checkPermission(String, String, String)", (Location)LOGGER, (int)1);
        }
    }

    public Collection findByObjectType(String principalID, String objectType) throws ServiceException {
        String method = "findByObjectType(String, String)";
        CAFPublicLogger.entering(null, (String)JARMREQUEST, (String)"findByObjectType(String, String)", (Location)LOGGER, (int)1);
        HashMap inputSet = new HashMap();
        ArrayList<PermissionVo> result = new ArrayList<PermissionVo>();
        try {
            Collection objects = CAFPermissionUtil.getDependentObjects(objectType, inputSet);
            IPrincipalFactory factory = UMFactory.getPrincipalFactory();
            IPrincipal principal = factory.getPrincipal(principalID);
            String principalType = factory.getPrincipalType(principalID);
            ArrayList<String> permissionNames = new ArrayList<String>(8);
            Iterator namesIterator = CAFPermissionName.getAllNames();
            while (namesIterator.hasNext()) {
                String name = ((CAFPermissionName)namesIterator.next()).getName();
                if (name.equals("create")) continue;
                permissionNames.add(name);
            }
            Iterator objIterator = objects.iterator();
            while (objIterator.hasNext()) {
                Object object = objIterator.next();
                String objectID = ((IBusinessObject)object).getKey();
                Iterator permNamesIterator = permissionNames.iterator();
                while (permNamesIterator.hasNext()) {
                    String permissionName = (String)permNamesIterator.next();
                    if (!CAFPermission.checkAclPermission(object, principal, permissionName, objectType, null, true)) continue;
                    PermissionVo permissionVo = new PermissionVo();
                    permissionVo.setBusinessRuleID(objectID);
                    permissionVo.setPermissionName(permissionName);
                    permissionVo.setPrincipalType(principalType);
                    permissionVo.setPrincipalName(principal.getDisplayName());
                    permissionVo.setPrincipalID(principalID);
                    permissionVo.setNameBackUp(permissionName);
                    result.add(permissionVo);
                }
            }
            ArrayList<PermissionVo> arrayList = result;
            return arrayList;
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"findByObjectType(String, String)", (String)e.getMessage(), (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"findByObjectType(String, String)", (Location)LOGGER, (int)1);
        }
    }

    public Collection findByPrincipalBusinessRules(String businessRuleID, String principalID, String objectType) throws ServiceException {
        String method = "findByPrincipalBusinessRules(String, String, String)";
        CAFPublicLogger.entering(null, (String)JARMREQUEST, (String)"findByPrincipalBusinessRules(String, String, String)", (Location)LOGGER, (int)1);
        HashMap inputSet = new HashMap();
        ArrayList<PermissionVo> result = new ArrayList<PermissionVo>();
        try {
            Collection objects = CAFPermissionUtil.getDependentObjects(objectType, inputSet);
            IPrincipalFactory factory = UMFactory.getPrincipalFactory();
            IPrincipal principal = factory.getPrincipal(principalID);
            String principalType = factory.getPrincipalType(principalID);
            ArrayList<String> permissionNames = new ArrayList<String>(8);
            Iterator namesIterator = CAFPermissionName.getAllNames();
            while (namesIterator.hasNext()) {
                String name = ((CAFPermissionName)namesIterator.next()).getName();
                if (name.equals("create")) continue;
                permissionNames.add(name);
            }
            Iterator objIterator = objects.iterator();
            while (objIterator.hasNext()) {
                Object object = objIterator.next();
                String objectID = ((IBusinessObject)object).getKey();
                Iterator permNamesIterator = permissionNames.iterator();
                while (permNamesIterator.hasNext()) {
                    String permissionName = (String)permNamesIterator.next();
                    if (!CAFPermission.checkAclPermission(object, principal, permissionName, objectType, businessRuleID, false)) continue;
                    PermissionVo permissionVo = new PermissionVo();
                    permissionVo.setBusinessRuleID(objectID);
                    permissionVo.setPermissionName(permissionName);
                    permissionVo.setPrincipalType(principalType);
                    permissionVo.setPrincipalName(principal.getDisplayName());
                    permissionVo.setPrincipalID(principalID);
                    permissionVo.setNameBackUp(permissionName);
                    result.add(permissionVo);
                }
            }
            ArrayList<PermissionVo> arrayList = result;
            return arrayList;
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"findByPrincipalBusinessRules(String, String, String)", (String)e.getMessage(), (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"findByPrincipalBusinessRules(String, String, String)", (Location)LOGGER, (int)1);
        }
    }

    public Collection findByBusinessRuleID(String currentUserID, String businessRuleID) throws ServiceException {
        String method = "findByBusinessRuleID(String, String)";
        CAFPublicLogger.entering(null, (String)JARMREQUEST, (String)"findByBusinessRuleID(String, String)", (Location)LOGGER, (int)1);
        ArrayList<PermissionVo> result = new ArrayList<PermissionVo>();
        try {
            ArrayList permissions = CAFPermission.retrievePermission(currentUserID, businessRuleID, null, (IPrincipal)null);
            IPrincipalFactory principalFactory = UMFactory.getPrincipalFactory();
            Iterator iter = permissions.iterator();
            while (iter.hasNext()) {
                HashMap permissionMap = (HashMap)iter.next();
                Iterator permissionMapIter = permissionMap.keySet().iterator();
                while (permissionMapIter.hasNext()) {
                    PermissionVo permissionVo = new PermissionVo();
                    permissionVo.setBusinessRuleID(businessRuleID);
                    IPrincipal principal = (IPrincipal)permissionMapIter.next();
                    String principalID = principal.getUniqueID();
                    String permissionName = (String)permissionMap.get(principal);
                    permissionVo.setKey(businessRuleID + "|" + principalID + "|" + permissionName);
                    permissionVo.setPrincipalID(principalID);
                    permissionVo.setPrincipalName(principal.getDisplayName());
                    permissionVo.setPrincipalType(principalFactory.getPrincipalType(principalID));
                    permissionVo.setPermissionName(permissionName);
                    permissionVo.setNameBackUp(permissionName);
                    result.add(permissionVo);
                }
            }
            ArrayList<PermissionVo> arrayList = result;
            return arrayList;
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"findByBusinessRuleID(String, String)", (String)e.getMessage(), (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"findByBusinessRuleID(String, String)", (Location)LOGGER, (int)1);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

