/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.security.acl.impl.objectattribute;

import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.DataObject;
import com.sap.caf.rt.exception.ServiceException;
import com.sap.caf.rt.security.acl.impl.SecurityServiceBase;
import com.sap.caf.rt.security.acl.impl.objectattribute.ObjectAttributeVo;
import com.sap.caf.rt.security.util.CAFPermissionUtil;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.ejb.SessionBean;

public class ObjectAttributeBean
extends SecurityServiceBase
implements SessionBean {
    private static final String APPLICATION = (class$com$sap$caf$rt$security$acl$impl$objectattribute$ObjectAttributeBean == null ? (class$com$sap$caf$rt$security$acl$impl$objectattribute$ObjectAttributeBean = ObjectAttributeBean.class$("com.sap.caf.rt.security.acl.impl.objectattribute.ObjectAttributeBean")) : class$com$sap$caf$rt$security$acl$impl$objectattribute$ObjectAttributeBean).getName();
    private static final Location LOGGER = Location.getLocation((String)APPLICATION);
    private static final String JARMREQPREFIX = "CAF:RT:security:";
    private static final String JARMREQUEST = "CAF:RT:security:" + APPLICATION;
    static /* synthetic */ Class class$com$sap$caf$rt$security$acl$impl$objectattribute$ObjectAttributeBean;

    public ObjectAttributeVo findByPrimaryKey(String objectAttributeID) throws ServiceException {
        String method = "findByPrimaryKey(String)";
        CAFPublicLogger.entering(null, (String)JARMREQUEST, (String)"findByPrimaryKey(String)", (Location)LOGGER, (int)1);
        ObjectAttributeVo objectAttributeVo = null;
        try {
            Attribute attribute = CAFPermissionUtil.getAttribute(objectAttributeID);
            String attributeId = attribute.getObjectId();
            String attributeName = attribute.getObjectName();
            objectAttributeVo = new ObjectAttributeVo();
            objectAttributeVo.setKey(attributeId);
            objectAttributeVo.setObjectAttributeName(attributeName);
        }
        catch (Exception e) {
            this.getSessionContext().setRollbackOnly();
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"findByPrimaryKey(String)", (String)e.getMessage(), (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"findByPrimaryKey(String)", (Location)LOGGER, (int)1);
        }
        return objectAttributeVo;
    }

    public Collection findByObjectTypeID(String objectTypeID) throws ServiceException {
        String method = "findByObjectTypeID(String)";
        CAFPublicLogger.entering(null, (String)JARMREQUEST, (String)"findByObjectTypeID(String)", (Location)LOGGER, (int)1);
        ArrayList<ObjectAttributeVo> result = new ArrayList<ObjectAttributeVo>();
        try {
            DataObject dataObject = CAFPermissionUtil.getDataObjectByGUID(objectTypeID);
            List attributes = dataObject.getAttributes();
            Iterator it = attributes.iterator();
            while (it.hasNext()) {
                Attribute attribute = (Attribute)it.next();
                String attributeId = attribute.getObjectId();
                String attributeName = attribute.getObjectName();
                ObjectAttributeVo objectAttributeVo = new ObjectAttributeVo();
                objectAttributeVo.setKey(attributeId);
                objectAttributeVo.setObjectAttributeName(attributeName);
                objectAttributeVo.setObjectTypeID(objectTypeID);
                result.add(objectAttributeVo);
            }
        }
        catch (Exception e) {
            this.getSessionContext().setRollbackOnly();
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"findByObjectTypeID(String)", (String)e.getMessage(), (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"findByObjectTypeID(String)", (Location)LOGGER, (int)1);
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

