/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.security.acl.impl.businessrule;

import com.sap.caf.rt.bol.IDependentObject;
import com.sap.caf.rt.bol.pk.PrimaryKeyFactory;
import com.sap.caf.rt.exception.ServiceException;
import com.sap.caf.rt.security.acl.impl.CAFPermission;
import com.sap.caf.rt.security.acl.impl.SecurityServiceBase;
import com.sap.caf.rt.security.acl.impl.businessrule.BusinessRuleVo;
import com.sap.caf.rt.security.acl.impl.condition.ConditionLocal;
import com.sap.caf.rt.security.acl.impl.condition.ConditionVo;
import com.sap.caf.rt.security.acl.impl.objectattribute.ObjectAttributeLocal;
import com.sap.caf.rt.security.acl.impl.objectattribute.ObjectAttributeVo;
import com.sap.caf.rt.security.acl.impl.objecttype.ObjectTypeLocal;
import com.sap.caf.rt.security.util.CAFBusinessRuleList;
import com.sap.caf.rt.security.util.CAFPermissionCache;
import com.sap.caf.rt.security.util.CAFPermissionUtil;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.security.api.IPrincipal;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.ejb.SessionBean;

public class BusinessRuleBean
extends SecurityServiceBase
implements SessionBean {
    private static final String APPLICATION = (class$com$sap$caf$rt$security$acl$impl$businessrule$BusinessRuleBean == null ? (class$com$sap$caf$rt$security$acl$impl$businessrule$BusinessRuleBean = BusinessRuleBean.class$("com.sap.caf.rt.security.acl.impl.businessrule.BusinessRuleBean")) : class$com$sap$caf$rt$security$acl$impl$businessrule$BusinessRuleBean).getName();
    private static final Location LOGGER = Location.getLocation((String)APPLICATION);
    private static final String JARMREQPREFIX = "CAF:RT:security:";
    private static final String JARMREQUEST = "CAF:RT:security:" + APPLICATION;
    static /* synthetic */ Class class$com$sap$caf$rt$security$acl$impl$businessrule$BusinessRuleBean;
    static /* synthetic */ Class class$com$sap$caf$rt$security$acl$impl$businessrule$BusinessRuleVo;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String create(String objectTypeID, String ruleName, HashMap conditions) throws ServiceException {
        this.checkUpdatePermission();
        String method = "create(String, String, HashMap)";
        CAFPublicLogger.entering(null, (String)JARMREQUEST, (String)"create(String, String, HashMap)", (Location)LOGGER, (int)1);
        String businessRuleID = null;
        ObjectTypeLocal objectTypeLocal = null;
        try {
            try {
                businessRuleID = PrimaryKeyFactory.getInstance().getPrimaryKey();
                String ruleIdForAcl = this.buildRuleIdForAcl(objectTypeID, conditions);
                objectTypeLocal = CAFPermissionUtil.getObjectTypeLocal();
                String objectType = objectTypeLocal.findByPrimaryKey(objectTypeID).getObjectType();
                BusinessRuleVo businessRuleVo = new BusinessRuleVo(businessRuleID, ruleIdForAcl, objectTypeID, objectType, ruleName);
                this.getJDODataAccessService().create((IDependentObject)businessRuleVo);
                CAFPermission.createOwnerPermission(this.getCurrentUserID(), businessRuleID);
                CAFPermission.removeOwnerPermission(this.getCurrentUserID(), businessRuleID);
                CAFPermission.createPermission(this.getCurrentUserID(), businessRuleID, "fullcontrol", this.getCurrentUserID());
            }
            catch (Exception e) {
                this.getSessionContext().setRollbackOnly();
                CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"create(String, String, HashMap)", (String)e.getMessage(), (Throwable)e);
                throw new ServiceException((Throwable)e);
            }
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            try {
                CAFPermissionCache.invalidParamCache();
                CAFPermissionCache.invalidRuleCache();
                CAFPermissionCache.invalidPermissionCache();
            }
            catch (Exception pex) {
                CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"create(String, String, HashMap)", (String)pex.getMessage(), (Throwable)pex);
                throw new ServiceException("AUTH_RESET_CACHE");
            }
            this.release(objectTypeLocal);
            CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"create(String, String, HashMap)", (Location)LOGGER, (int)1);
            throw throwable;
        }
        try {}
        catch (Exception pex) {
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"create(String, String, HashMap)", (String)pex.getMessage(), (Throwable)pex);
            throw new ServiceException("AUTH_RESET_CACHE");
        }
        CAFPermissionCache.invalidParamCache();
        CAFPermissionCache.invalidRuleCache();
        CAFPermissionCache.invalidPermissionCache();
        this.release(objectTypeLocal);
        CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"create(String, String, HashMap)", (Location)LOGGER, (int)1);
        return businessRuleID;
    }

    public void update(String businessRuleID, String businessRuleName) throws ServiceException {
        this.checkUpdatePermission();
        String method = "update(String, String)";
        CAFPublicLogger.entering(null, (String)JARMREQUEST, (String)"update(String, String)", (Location)LOGGER, (int)1);
        BusinessRuleVo businessRuleVo = null;
        try {
            businessRuleVo = this.findByPrimaryKey(businessRuleID);
            businessRuleVo.setBusinessRuleName(businessRuleName);
            this.getJDODataAccessService().store((IDependentObject)businessRuleVo);
        }
        catch (Exception e) {
            this.getSessionContext().setRollbackOnly();
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"update(String, String)", (String)e.getMessage(), (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"update(String, String)", (Location)LOGGER, (int)1);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void delete(String businessRuleID) throws ServiceException {
        this.checkUpdatePermission();
        String method = "delete(String)";
        CAFPublicLogger.entering(null, (String)JARMREQUEST, (String)"delete(String)", (Location)LOGGER, (int)1);
        BusinessRuleVo businessRuleVo = null;
        ConditionVo conditionVo = null;
        ConditionLocal conditionLocal = null;
        try {
            try {
                businessRuleVo = this.findByPrimaryKey(businessRuleID);
                conditionLocal = CAFPermissionUtil.getConditionLocal();
                Collection conditions = conditionLocal.findByBusinessRule(businessRuleVo.getKey());
                Iterator it = conditions.iterator();
                while (it.hasNext()) {
                    conditionVo = (ConditionVo)it.next();
                    conditionLocal.delete(conditionVo.getKey());
                }
                this.getJDODataAccessService().remove((IDependentObject)businessRuleVo);
                CAFPermission.removePermission(this.getCurrentUserID(), businessRuleID, null, (IPrincipal)null);
            }
            catch (Exception e) {
                this.getSessionContext().setRollbackOnly();
                CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"delete(String)", (String)e.getMessage(), (Throwable)e);
                throw new ServiceException((Throwable)e);
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                CAFPermissionCache.invalidParamCache();
                CAFPermissionCache.invalidRuleCache();
                CAFPermissionCache.invalidPermissionCache();
            }
            catch (Exception pex) {
                CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"delete(String)", (String)pex.getMessage(), (Throwable)pex);
                throw new ServiceException("AUTH_RESET_CACHE");
            }
            this.release(conditionLocal);
            CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"delete(String)", (Location)LOGGER, (int)1);
            throw throwable;
        }
        try {}
        catch (Exception pex) {
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"delete(String)", (String)pex.getMessage(), (Throwable)pex);
            throw new ServiceException("AUTH_RESET_CACHE");
        }
        CAFPermissionCache.invalidParamCache();
        CAFPermissionCache.invalidRuleCache();
        CAFPermissionCache.invalidPermissionCache();
        this.release(conditionLocal);
        CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"delete(String)", (Location)LOGGER, (int)1);
    }

    public BusinessRuleVo findByPrimaryKey(String businessRuleID) throws ServiceException {
        BusinessRuleVo businessRuleVo = null;
        String method = "findByPrimaryKey(String)";
        CAFPublicLogger.entering(null, (String)JARMREQUEST, (String)"findByPrimaryKey(String)", (Location)LOGGER, (int)1);
        try {
            String param = "String key";
            String filter = "this.key == key";
            HashMap<String, String> hm = new HashMap<String, String>();
            hm.put("key", businessRuleID);
            Collection resultSet = this.getJDODataAccessService().query(class$com$sap$caf$rt$security$acl$impl$businessrule$BusinessRuleVo == null ? (class$com$sap$caf$rt$security$acl$impl$businessrule$BusinessRuleVo = BusinessRuleBean.class$("com.sap.caf.rt.security.acl.impl.businessrule.BusinessRuleVo")) : class$com$sap$caf$rt$security$acl$impl$businessrule$BusinessRuleVo, filter, param, hm, null);
            businessRuleVo = (BusinessRuleVo)resultSet.iterator().next();
        }
        catch (Exception e) {
            this.getSessionContext().setRollbackOnly();
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"findByPrimaryKey(String)", (String)e.getMessage(), (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"findByPrimaryKey(String)", (Location)LOGGER, (int)1);
        }
        return businessRuleVo;
    }

    private String buildRuleIdForAcl(String objectTypeID, HashMap conditions) throws ServiceException {
        String method = "buildRuleIdForAcl(String, HashMap)";
        CAFPublicLogger.entering(null, (String)JARMREQUEST, (String)"buildRuleIdForAcl(String, HashMap)", (Location)LOGGER, (int)1);
        String ruleIdForAcl = null;
        StringBuffer buf = new StringBuffer();
        Object obj = null;
        String attributeName = null;
        Object[] attributes = null;
        try {
            ObjectAttributeLocal objectAttributeLocal = CAFPermissionUtil.getObjectAttributeLocal();
            attributes = objectAttributeLocal.findByObjectTypeID(objectTypeID).toArray();
        }
        catch (Exception e) {
            this.getSessionContext().setRollbackOnly();
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"buildRuleIdForAcl(String, HashMap)", (String)e.getMessage(), (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        for (int i = 0; i < attributes.length; ++i) {
            if (attributes[i] != null && attributes[i] instanceof ObjectAttributeVo) {
                attributeName = ((ObjectAttributeVo)attributes[i]).getObjectAttributeName();
                obj = conditions.get(attributeName);
            }
            if (obj != null && i > 0) {
                buf.append(":");
            }
            if (obj == null) continue;
            buf.append((Object)obj);
        }
        if (buf.length() > 0) {
            ruleIdForAcl = buf.toString();
        }
        CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"buildRuleIdForAcl(String, HashMap)", (Location)LOGGER, (int)1);
        return ruleIdForAcl;
    }

    public Collection findByObjectTypeID(String objectTypeID) throws ServiceException {
        Collection resultSet = new ArrayList(1);
        String method = "findByObjectTypeID(String)";
        CAFPublicLogger.entering(null, (String)JARMREQUEST, (String)"findByObjectTypeID(String)", (Location)LOGGER, (int)1);
        String param = "String objectTypeID";
        String filter = "this.objectTypeID == objectTypeID";
        HashMap<String, String> hm = new HashMap<String, String>();
        hm.put("objectTypeID", objectTypeID);
        try {
            resultSet = this.getJDODataAccessService().query(class$com$sap$caf$rt$security$acl$impl$businessrule$BusinessRuleVo == null ? (class$com$sap$caf$rt$security$acl$impl$businessrule$BusinessRuleVo = BusinessRuleBean.class$("com.sap.caf.rt.security.acl.impl.businessrule.BusinessRuleVo")) : class$com$sap$caf$rt$security$acl$impl$businessrule$BusinessRuleVo, filter, param, hm, null);
        }
        catch (Exception e) {
            this.getSessionContext().setRollbackOnly();
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"findByObjectTypeID(String)", (String)e.getMessage(), (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"findByObjectTypeID(String)", (Location)LOGGER, (int)1);
        }
        return resultSet;
    }

    public Collection findByObjectType(String objectType) throws ServiceException {
        Collection resultSet = new ArrayList(1);
        String method = "findByObjectType(String)";
        CAFPublicLogger.entering(null, (String)JARMREQUEST, (String)"findByObjectType(String)", (Location)LOGGER, (int)1);
        String param = "String objectType";
        String filter = "this.objectType == objectType";
        HashMap<String, String> hm = new HashMap<String, String>();
        hm.put("objectType", objectType);
        try {
            resultSet = this.getJDODataAccessService().query(class$com$sap$caf$rt$security$acl$impl$businessrule$BusinessRuleVo == null ? (class$com$sap$caf$rt$security$acl$impl$businessrule$BusinessRuleVo = BusinessRuleBean.class$("com.sap.caf.rt.security.acl.impl.businessrule.BusinessRuleVo")) : class$com$sap$caf$rt$security$acl$impl$businessrule$BusinessRuleVo, filter, param, hm, null);
        }
        catch (Exception e) {
            this.getSessionContext().setRollbackOnly();
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"findByObjectType(String)", (String)e.getMessage(), (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"findByObjectType(String)", (Location)LOGGER, (int)1);
        }
        return resultSet;
    }

    public Collection findByObjectID(String objectID, String objectTypeID) throws ServiceException {
        ArrayList<BusinessRuleVo> result = new ArrayList<BusinessRuleVo>();
        String method = "findByObjectID(String, String)";
        CAFPublicLogger.entering(null, (String)JARMREQUEST, (String)"findByObjectID(String, String)", (Location)LOGGER, (int)1);
        try {
            IDependentObject businessObject = CAFPermissionUtil.getDependentObject(objectID, objectTypeID);
            if (businessObject != null) {
                Collection rules = this.retrieveBusinessRulesByObject(businessObject, objectTypeID);
                Iterator iter = rules.iterator();
                while (iter.hasNext()) {
                    BusinessRuleVo businessRuleVo = (BusinessRuleVo)iter.next();
                    businessRuleVo.setObjectType(objectTypeID);
                    result.add(businessRuleVo);
                }
            }
        }
        catch (Exception e) {
            this.getSessionContext().setRollbackOnly();
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"findByObjectID(String, String)", (String)e.getMessage(), (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"findByObjectID(String, String)", (Location)LOGGER, (int)1);
        }
        return result;
    }

    private Collection retrieveBusinessRulesByObject(IDependentObject object, String objectTypeID) throws ServiceException {
        Collection resultSet = null;
        String method = "retrieveBusinessRulesByObject(IDependentObject, String)";
        CAFPublicLogger.entering(null, (String)JARMREQUEST, (String)"retrieveBusinessRulesByObject(IDependentObject, String)", (Location)LOGGER, (int)1);
        if (object == null) {
            ServiceException serviceException = new ServiceException("AUTH_NO_RULE");
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"retrieveBusinessRulesByObject(IDependentObject, String)", (String)serviceException.getMessage(), (Throwable)serviceException);
            throw serviceException;
        }
        try {
            CAFBusinessRuleList ruleList = (CAFBusinessRuleList)CAFPermissionCache.getBusinessRuleFromCache(objectTypeID);
            if (ruleList == null) {
                List list = Collections.EMPTY_LIST;
                return list;
            }
            int rulesCount = ruleList.size();
            Object[] attrCache = ruleList.getEmptyAttributeCache();
            HashSet<String> ids = new HashSet<String>(rulesCount);
            for (int i = 0; i < rulesCount; ++i) {
                if (!ruleList.objectFulfillBusinessRuleCondition(object, i, attrCache)) continue;
                ids.add(ruleList.getBusinessRule(i).getRuleID());
            }
            resultSet = this.retrieveRules(ids);
        }
        catch (Exception e) {
            this.getSessionContext().setRollbackOnly();
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"retrieveBusinessRulesByObject(IDependentObject, String)", (String)e.getMessage(), (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"retrieveBusinessRulesByObject(IDependentObject, String)", (Location)LOGGER, (int)1);
        }
        return resultSet;
    }

    private Collection retrieveRules(Collection ids) throws ServiceException {
        String method = "retrieveRules(Collection)";
        CAFPublicLogger.entering(null, (String)JARMREQUEST, (String)"retrieveRules(Collection)", (Location)LOGGER, (int)1);
        Collection resultSet = null;
        try {
            if (ids == null || ids.isEmpty()) {
                List list = Collections.EMPTY_LIST;
                return list;
            }
            StringBuffer params = new StringBuffer();
            StringBuffer filter = new StringBuffer();
            HashMap<String, String> hm = new HashMap<String, String>();
            int index = 0;
            Iterator iter = ids.iterator();
            while (iter.hasNext()) {
                String id = (String)iter.next();
                String parameter = "ruleID" + index;
                if (index > 0) {
                    params.append(",");
                    filter.append(" || ");
                }
                params.append("String ").append(parameter);
                filter.append("this.key==").append(parameter);
                hm.put(parameter, id);
                ++index;
            }
            resultSet = this.getJDODataAccessService().query(class$com$sap$caf$rt$security$acl$impl$businessrule$BusinessRuleVo == null ? (class$com$sap$caf$rt$security$acl$impl$businessrule$BusinessRuleVo = BusinessRuleBean.class$("com.sap.caf.rt.security.acl.impl.businessrule.BusinessRuleVo")) : class$com$sap$caf$rt$security$acl$impl$businessrule$BusinessRuleVo, filter.toString(), params.toString(), hm, null);
        }
        catch (Exception e) {
            this.getSessionContext().setRollbackOnly();
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"retrieveRules(Collection)", (String)e.getMessage(), (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"retrieveRules(Collection)", (Location)LOGGER, (int)1);
        }
        return resultSet;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

