/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.security.acl.impl;

import com.sap.caf.rt.bol.da.jdo.JDODataAccessService;
import com.sap.caf.rt.exception.ServiceException;
import com.sap.caf.rt.security.acl.impl.businessrule.BusinessRuleLocalHome;
import com.sap.caf.rt.security.acl.impl.condition.ConditionLocalHome;
import com.sap.caf.rt.security.acl.impl.objectattribute.ObjectAttributeLocalHome;
import com.sap.caf.rt.security.acl.impl.objecttype.ObjectTypeLocalHome;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.security.api.IRole;
import com.sap.security.api.IUser;
import com.sap.security.api.IUserFactory;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.tc.logging.Location;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EJBLocalObject;
import javax.ejb.RemoveException;
import javax.ejb.SessionContext;

public class SecurityServiceBase {
    private static final String APPLICATION_INNER = (class$com$sap$caf$rt$security$acl$impl$SecurityServiceBase == null ? (class$com$sap$caf$rt$security$acl$impl$SecurityServiceBase = SecurityServiceBase.class$("com.sap.caf.rt.security.acl.impl.SecurityServiceBase")) : class$com$sap$caf$rt$security$acl$impl$SecurityServiceBase).getName();
    private static final Location LOGGER_INNER = Location.getLocation((String)APPLICATION_INNER);
    private static final String JARMREQPREFIX_INNER = "CAF:RT:security:";
    private static final String JARMREQUEST_INNER = "CAF:RT:security:" + APPLICATION_INNER;
    private ObjectTypeLocalHome objectTypeLocalHome;
    private ObjectAttributeLocalHome objectAttributeLocalHome;
    private BusinessRuleLocalHome businessRuleLocalHome;
    private ConditionLocalHome conditionLocalHome;
    private SessionContext m_sessionContext;
    private JDODataAccessService m_service;
    private IRole m_adminRole;
    private IUserFactory m_userFactory;
    static /* synthetic */ Class class$com$sap$caf$rt$security$acl$impl$SecurityServiceBase;

    public void ejbRemove() {
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public void ejbCreate() throws CreateException {
        String method = "ejbCreate()";
        CAFPublicLogger.entering(null, (String)JARMREQUEST_INNER, (String)"ejbCreate()", (Location)LOGGER_INNER, (int)1);
        try {
            this.m_adminRole = UMFactory.getRoleFactory().getRoleByUniqueName("CAFAdmin");
            this.m_userFactory = UMFactory.getUserFactory();
        }
        catch (UMException e) {
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER_INNER, (String)"ejbCreate()", (String)e.getMessage(), (Throwable)e);
            throw new CreateException(e.getMessage());
        }
        finally {
            CAFPublicLogger.exiting(null, (String)JARMREQUEST_INNER, (String)"ejbCreate()", (Location)LOGGER_INNER, (int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSessionContext(SessionContext context) {
        this.m_sessionContext = context;
        String method = "setSessionContext(SessionContext)";
        CAFPublicLogger.entering(null, (String)JARMREQUEST_INNER, (String)"setSessionContext(SessionContext)", (Location)LOGGER_INNER, (int)1);
        try {
            this.m_service = (JDODataAccessService)JDODataAccessService.getInstance();
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER_INNER, (String)"setSessionContext(SessionContext)", (String)e.getMessage(), (Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)JARMREQUEST_INNER, (String)"setSessionContext(SessionContext)", (Location)LOGGER_INNER, (int)1);
        }
    }

    protected SessionContext getSessionContext() {
        return this.m_sessionContext;
    }

    protected JDODataAccessService getJDODataAccessService() {
        return this.m_service;
    }

    protected void checkUpdatePermission() throws ServiceException {
        String method = "checkUpdatePermission()";
        CAFPublicLogger.entering(null, (String)JARMREQUEST_INNER, (String)"checkUpdatePermission()", (Location)LOGGER_INNER, (int)1);
        String caller = this.m_sessionContext.getCallerPrincipal().getName();
        try {
            IUser user = this.m_userFactory.getUserByLogonID(caller);
            if (!this.m_adminRole.isUserMember(user.getUniqueID(), true)) {
                throw new ServiceException("AUTH_NO_ACCESS", (Object[])new String[]{caller});
            }
        }
        catch (UMException e) {
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER_INNER, (String)"checkUpdatePermission()", (String)e.getMessage(), (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)JARMREQUEST_INNER, (String)"checkUpdatePermission()", (Location)LOGGER_INNER, (int)1);
        }
    }

    protected String getCurrentUserID() throws ServiceException {
        String method = "getCurrentUserID()";
        String loginUserID = null;
        try {
            String callerName = this.getSessionContext().getCallerPrincipal().getName();
            if (callerName != null) {
                IUser user = UMFactory.getUserFactory().getUserByLogonID(callerName);
                loginUserID = user.getUniqueID();
            }
        }
        catch (UMException e) {
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER_INNER, (String)"getCurrentUserID()", (String)e.getMessage(), (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        return loginUserID;
    }

    protected void release(EJBLocalObject object) {
        String method = "release(EJBLocalObject)";
        if (object != null) {
            try {
                object.remove();
            }
            catch (EJBException e) {
                CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER_INNER, (String)"release(EJBLocalObject)", (String)e.getMessage(), (Throwable)e);
            }
            catch (RemoveException e) {
                CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER_INNER, (String)"release(EJBLocalObject)", (String)e.getMessage(), (Throwable)e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

