/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.security.acl.impl;

import com.sap.caf.rt.bol.IDependentObject;
import com.sap.caf.rt.bol.context.CAFProperties;
import com.sap.caf.rt.exception.CAFPermissionException;
import com.sap.caf.rt.security.srv.ServicePermission;
import com.sap.caf.rt.security.util.CAFBusinessRuleList;
import com.sap.caf.rt.security.util.CAFPermissionCache;
import com.sap.caf.rt.security.util.CAFPermissionName;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.security.api.IPrincipal;
import com.sap.security.api.IPrincipalFactory;
import com.sap.security.api.IRole;
import com.sap.security.api.IRoleFactory;
import com.sap.security.api.IUser;
import com.sap.security.api.IUserFactory;
import com.sap.security.api.NoSuchRoleException;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.security.api.acl.IAcl;
import com.sap.security.api.acl.IAclEntry;
import com.sap.security.api.acl.IAclManager;
import com.sap.tc.logging.Location;
import java.lang.reflect.Method;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class CAFPermission {
    protected static final String ADMIN_ROLE = "CAFAdmin";
    private static final String APPLICATION_ID = "CAF";
    private static final String ACL_CUSTOMIZED_CLASS = "CAF_AUTHORITY_EXIT";
    private static final String CHECK_PERMISSION_METHOD = "checkAclPermission";
    private static final String STANDARD_CHECK_REQUIRED_METHOD = "isStandardAclCheckRequired";
    private static final String APPLICATION = (class$com$sap$caf$rt$security$acl$impl$CAFPermission == null ? (class$com$sap$caf$rt$security$acl$impl$CAFPermission = CAFPermission.class$("com.sap.caf.rt.security.acl.impl.CAFPermission")) : class$com$sap$caf$rt$security$acl$impl$CAFPermission).getName();
    private static final Location LOGGER = Location.getLocation((String)APPLICATION);
    private static final String JARMREQPREFIX = "CAF:RT:security:";
    private static final String JARMREQUEST = "CAF:RT:security:" + APPLICATION;
    private static IAclManager s_aclManager;
    private static IUserFactory s_userFactory;
    private static IPrincipalFactory s_principalFactory;
    private static String s_AclCustomizedClass;
    private static boolean s_StandardCheckPermissionRequired;
    private static Class s_CutomizedPermissionClass;
    private static IRole s_adminRole;
    static /* synthetic */ Class class$com$sap$caf$rt$security$acl$impl$CAFPermission;
    static /* synthetic */ Class class$java$lang$Object;

    public static boolean checkAclPermission(Object object, String principalID, String permissionName, String objectType) throws CAFPermissionException {
        String method = "checkAclPermission(Object, String, String, String)";
        CAFPublicLogger.entering(null, (String)JARMREQUEST, (String)"checkAclPermission(Object, String, String, String)", (Location)LOGGER, (int)1);
        IPrincipal principal = null;
        try {
            principal = CAFPermission.getPrincipal(principalID);
        }
        catch (UMException e) {
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"checkAclPermission(Object, String, String, String)", (String)"AUTH_PERMISSION_ERROR", (Object[])new Object[]{"checkAclPermission(Object, String, String, String)", e.getMessage()}, (Throwable)e);
            throw new CAFPermissionException("AUTH_PERMISSION_ERROR", new Object[]{"checkAclPermission(Object, String, String, String)", e.getMessage()});
        }
        return CAFPermission.checkAclPermission(object, principal, permissionName, objectType, null, false);
    }

    public static boolean checkAclPermission(Object object, IPrincipal principal, String permissionName, String objectType, String boRuleID, boolean checkAclPermissions) throws CAFPermissionException {
        block24: {
            String method = "checkAclPermission(Object, String, String,  String, String, boolean)";
            CAFPublicLogger.entering(null, (String)JARMREQUEST, (String)"checkAclPermission(Object, String, String,  String, String, boolean)", (Location)LOGGER, (int)0);
            try {
                String key;
                String principalID = principal.getUniqueID();
                if (s_AclCustomizedClass != null && s_AclCustomizedClass.equals("-1")) {
                    s_CutomizedPermissionClass = CAFPermission.getAclCustomerizedClass();
                }
                boolean bCustomerizedPermission = false;
                try {
                    String principalType = UMFactory.getPrincipalFactory().getPrincipalType(principalID);
                    if (s_CutomizedPermissionClass != null && principalType.equals("IUser")) {
                        bCustomerizedPermission = CAFPermission.checkCustomerizedAclPermission(s_CutomizedPermissionClass, object, principalID, permissionName, objectType);
                    }
                }
                catch (UMException e) {
                    CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"checkAclPermission(Object, String, String,  String, String, boolean)", (String)e.getMessage(), (Throwable)e);
                }
                if (bCustomerizedPermission && !s_StandardCheckPermissionRequired) {
                    boolean e = true;
                    return e;
                }
                if (boRuleID == null && object != null && CAFPermission.hasAclPermission(principal, (key = ((IDependentObject)object).getKey()) != null ? key : "", permissionName)) {
                    boolean bl = true;
                    return bl;
                }
                if (checkAclPermissions) break block24;
                CAFBusinessRuleList ruleList = (CAFBusinessRuleList)CAFPermissionCache.getBusinessRuleFromCache(objectType);
                if (ruleList == null || ruleList.isEmpty()) {
                    boolean bl = false;
                    return bl;
                }
                Object[] attrCache = ruleList.getEmptyAttributeCache();
                int rulesCount = ruleList.size();
                for (int i = 0; i < rulesCount; ++i) {
                    boolean isObjectFulfillBusinessRuleCondition = false;
                    isObjectFulfillBusinessRuleCondition = "create".equals(permissionName) && object == null ? true : ruleList.objectFulfillBusinessRuleCondition(object, i, attrCache);
                    if (!isObjectFulfillBusinessRuleCondition) continue;
                    String ruleID = ruleList.getBusinessRule(i).getRuleID();
                    if (boRuleID != null && !boRuleID.equals(ruleID)) continue;
                    String accessCacheKey = ruleID + principalID + permissionName;
                    Boolean cachedResult = CAFPermissionCache.getAllowed(accessCacheKey);
                    if (cachedResult == null) {
                        boolean result = CAFPermission.hasAclPermission(principal, ruleID, permissionName);
                        CAFPermissionCache.cacheAllowedAccess(accessCacheKey, result);
                        if (!result) continue;
                        boolean bl = true;
                        return bl;
                    }
                    if (!cachedResult.booleanValue()) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            catch (ClassCastException ce) {
                try {
                    CAFPermission.resetCache();
                }
                catch (Exception pex) {
                    CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"checkAclPermission(Object, String, String,  String, String, boolean)", (String)pex.getMessage(), (Throwable)pex);
                }
            }
            catch (CAFPermissionException e) {
                throw e;
            }
            catch (Exception e) {
                CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"checkAclPermission(Object, String, String,  String, String, boolean)", (String)e.getMessage(), (Throwable)e);
                Object[] param = new Object[]{"checkAclPermission(Object, String, String,  String, String, boolean)", e.getMessage()};
                CAFPermissionException pe = new CAFPermissionException("AUTH_PERMISSION_ERROR", param);
                throw pe;
            }
            finally {
                CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"checkAclPermission(Object, String, String,  String, String, boolean)", (Location)LOGGER, (int)0);
            }
        }
        return false;
    }

    public static boolean checkServicePermission(String usr, ServicePermission sp) throws CAFPermissionException {
        String method = "checkServicePermission(String, ServicePermission)";
        CAFPublicLogger.entering(null, (String)JARMREQUEST, (String)"checkServicePermission(String, ServicePermission)", (Location)LOGGER, (int)1);
        try {
            IUser iusr = CAFPermission.getUser(usr);
            boolean bl = iusr.hasPermission((Permission)sp);
            return bl;
        }
        catch (UMException e) {
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"checkServicePermission(String, ServicePermission)", (String)e.getMessage(), (Throwable)e);
            throw new CAFPermissionException("AUTH_PERMISSION_ERROR", new Object[]{"checkServicePermission(String, ServicePermission)", e.getMessage()});
        }
        finally {
            CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"checkServicePermission(String, ServicePermission)", (Location)LOGGER, (int)1);
        }
    }

    public static void resetCache() throws CAFPermissionException {
        String method = "resetCache()";
        CAFPublicLogger.entering(null, (String)JARMREQUEST, (String)"resetCache()", (Location)LOGGER, (int)1);
        CAFPermissionCache.invalidCache();
        CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"resetCache()", (Location)LOGGER, (int)1);
    }

    public static void createOwnerPermission(String userId, String objectId) throws CAFPermissionException {
        String method = "createOwnerPermission(String, String)";
        CAFPublicLogger.entering(null, (String)JARMREQUEST, (String)"createOwnerPermission(String, String)", (Location)LOGGER, (int)1);
        try {
            IUser iusr = CAFPermission.getUser(userId);
            IAclManager aclManager = CAFPermission.getAclManagerInstance();
            try {
                if (aclManager.getAcl(objectId) != null) {
                    throw new CAFPermissionException("Owner has existed for object Id = " + objectId, (Object[])new String[0]);
                }
            }
            catch (UMException e) {
                CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"createOwnerPermission(String, String)", (String)e.getMessage(), (Throwable)e);
            }
            IAcl iAcl = aclManager.createAcl((IPrincipal)iusr, objectId);
            IRoleFactory rf = UMFactory.getRoleFactory();
            try {
                IRole ir = rf.getRoleByUniqueName(ADMIN_ROLE);
                iAcl.addOwner((IPrincipal)iusr, (IPrincipal)ir);
            }
            catch (NoSuchRoleException e) {
                CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"createOwnerPermission(String, String)", (String)e.getMessage(), (Throwable)e);
                throw new CAFPermissionException("AUTH_PERMISSION_ERROR", new Object[]{ADMIN_ROLE});
            }
        }
        catch (UMException e) {
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"createOwnerPermission(String, String)", (String)e.getMessage(), (Throwable)e);
            throw new CAFPermissionException("AUTH_PERMISSION_ERROR", new Object[]{"createOwnerPermission(String, String)", e.getMessage()});
        }
        CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"createOwnerPermission(String, String)", (Location)LOGGER, (int)1);
    }

    public static void removeOwnerPermission(String userID, String objectID) throws CAFPermissionException {
        String method = "removeOwnerPermission(String, String)";
        CAFPublicLogger.entering(null, (String)JARMREQUEST, (String)"removeOwnerPermission(String, String)", (Location)LOGGER, (int)1);
        try {
            IUser iusr = CAFPermission.getUser(userID);
            IAcl acl = CAFPermission.getACL(objectID, true);
            if (CAFPermission.checkAuthorizePermission(iusr, acl)) {
                acl.removeOwner((IPrincipal)iusr, (IPrincipal)iusr);
            }
        }
        catch (UMException e) {
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"removeOwnerPermission(String, String)", (String)e.getMessage(), (Throwable)e);
            throw new CAFPermissionException("AUTH_PERMISSION_ERROR", new Object[]{"removeOwnerPermission(String, String)", e.getMessage()});
        }
        CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"removeOwnerPermission(String, String)", (Location)LOGGER, (int)1);
    }

    public static void createPermission(String loginUserID, String objectID, String permissionName, IPrincipal iPrincipal) throws CAFPermissionException {
        String method = "createPermission(String, String, String, IPrincipal)";
        CAFPublicLogger.entering(null, (String)JARMREQUEST, (String)"createPermission(String, String, String, IPrincipal)", (Location)LOGGER, (int)1);
        try {
            IUser iusr = CAFPermission.getUser(loginUserID);
            IAcl acl = CAFPermission.getACL(objectID, true);
            if (CAFPermission.checkAuthorizePermission(iusr, acl)) {
                acl.createAclEntry((IPrincipal)iusr, iPrincipal, permissionName, false);
            }
        }
        catch (UMException e) {
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"createPermission(String, String, String, IPrincipal)", (String)e.getMessage(), (Throwable)e);
            throw new CAFPermissionException("AUTH_PERMISSION_ERROR", new Object[]{"createPermission(String, String, String, IPrincipal)", e.getMessage()});
        }
        CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"createPermission(String, String, String, IPrincipal)", (Location)LOGGER, (int)1);
    }

    public static void createPermission(String loginUserID, String objectID, String permissionName, String assignedUserID) throws CAFPermissionException {
        String method = "createPermission(String, String, String, String)";
        CAFPublicLogger.entering(null, (String)JARMREQUEST, (String)"createPermission(String, String, String, String)", (Location)LOGGER, (int)1);
        try {
            IUser assignedUsr = CAFPermission.getUser(assignedUserID);
            CAFPermission.createPermission(loginUserID, objectID, permissionName, (IPrincipal)assignedUsr);
        }
        catch (UMException e) {
            Object[] param = new Object[]{"createPermission(String, String, String, String)", e.getMessage()};
            CAFPermissionException pe = new CAFPermissionException("AUTH_PERMISSION_ERROR", param);
            throw pe;
        }
        finally {
            CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"createPermission(String, String, String, String)", (Location)LOGGER, (int)1);
        }
    }

    public static void createPermissionAll(String loginUserID, String objectID, List principalList) throws CAFPermissionException {
        String method = "createPermissionAll(String, String, List)";
        CAFPublicLogger.entering(null, (String)JARMREQUEST, (String)"createPermissionAll(String, String, List)", (Location)LOGGER, (int)1);
        int size = principalList.size();
        for (int i = 0; i < size; ++i) {
            HashMap hm = (HashMap)principalList.get(i);
            Iterator iter = hm.keySet().iterator();
            while (iter.hasNext()) {
                IPrincipal ipr = (IPrincipal)iter.next();
                String permissionName = (String)hm.get(ipr);
                CAFPermission.createPermission(loginUserID, objectID, permissionName, ipr);
            }
        }
        CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"createPermissionAll(String, String, List)", (Location)LOGGER, (int)1);
    }

    public static void modifyPermission(String loginUserID, String objectID, String oldPermissionName, String newPermissionName, IPrincipal iPrincipal) throws CAFPermissionException {
        String method = "modifyPermission(String, String, String, String, IPrincipal)";
        CAFPublicLogger.entering(null, (String)JARMREQUEST, (String)"modifyPermission(String, String, String, String, IPrincipal)", (Location)LOGGER, (int)1);
        try {
            IUser iusr = CAFPermission.getUser(loginUserID);
            IAcl acl = CAFPermission.getACL(objectID, true);
            List ar1 = acl.getAclEntries(iPrincipal);
            CAFPermission.modifyACEntries(acl, (IPrincipal)iusr, iPrincipal, ar1, oldPermissionName, newPermissionName);
        }
        catch (UMException e) {
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"modifyPermission(String, String, String, String, IPrincipal)", (String)e.getMessage(), (Throwable)e);
            Object[] param = new Object[]{"modifyPermission(String, String, String, String, IPrincipal)", e.getMessage()};
            throw new CAFPermissionException("AUTH_PERMISSION_ERROR", param);
        }
        CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"modifyPermission(String, String, String, String, IPrincipal)", (Location)LOGGER, (int)1);
    }

    public static void modifyPermission(String loginUserID, String objectID, String oldPermissionName, String newPermissionName, String assignedUserID) throws CAFPermissionException {
        String method = "modifyPermission(String, String, String, String, String)";
        CAFPublicLogger.entering(null, (String)JARMREQUEST, (String)"modifyPermission(String, String, String, String, String)", (Location)LOGGER, (int)1);
        try {
            IUser assignedUser = CAFPermission.getUser(assignedUserID);
            CAFPermission.modifyPermission(loginUserID, objectID, oldPermissionName, newPermissionName, (IPrincipal)assignedUser);
        }
        catch (UMException e) {
            Object[] param = new Object[]{"modifyPermission(String, String, String, String, String)", e.getMessage()};
            CAFPermissionException pe = new CAFPermissionException("AUTH_PERMISSION_ERROR", param);
            throw pe;
        }
        finally {
            CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"modifyPermission(String, String, String, String, String)", (Location)LOGGER, (int)1);
        }
    }

    public static void removePermission(String loginUserID, String objectID, String permissionName, IPrincipal iPrincipal) throws CAFPermissionException {
        String method = "removePermission(String, String, String, IPrincipal)";
        CAFPublicLogger.entering(null, (String)JARMREQUEST, (String)"removePermission(String, String, String, IPrincipal)", (Location)LOGGER, (int)1);
        try {
            IUser iusr = CAFPermission.getUser(loginUserID);
            IAcl iAcl = CAFPermission.getACL(objectID, true);
            List ar1 = iPrincipal == null ? iAcl.getAclEntries() : iAcl.getAclEntries(iPrincipal);
            CAFPermission.removeACEntries(iAcl, (IPrincipal)iusr, ar1, permissionName);
        }
        catch (UMException e) {
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"removePermission(String, String, String, IPrincipal)", (String)e.getMessage(), (Throwable)e);
            throw new CAFPermissionException("AUTH_PERMISSION_ERROR", new Object[]{"removePermission(String, String, String, IPrincipal)", e.getMessage()});
        }
        CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"removePermission(String, String, String, IPrincipal)", (Location)LOGGER, (int)1);
    }

    public static void removePermission(String loginUserID, String objectID, String permissionName, String assignedUserID) throws CAFPermissionException {
        String method = "removePermission(String, String, String, String)";
        CAFPublicLogger.entering(null, (String)JARMREQUEST, (String)"removePermission(String, String, String, String)", (Location)LOGGER, (int)1);
        try {
            IUser assignedUser = null;
            if (assignedUserID != null && assignedUserID.length() != 0) {
                assignedUser = CAFPermission.getUser(assignedUserID);
            }
            CAFPermission.removePermission(loginUserID, objectID, permissionName, assignedUser);
        }
        catch (UMException e) {
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"removePermission(String, String, String, String)", (String)e.getMessage(), (Throwable)e);
            throw new CAFPermissionException("AUTH_PERMISSION_ERROR", new Object[]{"removePermission(String, String, String, String)", e.getMessage()});
        }
        CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"removePermission(String, String, String, String)", (Location)LOGGER, (int)1);
    }

    public static ArrayList retrievePermission(String loginUserID, String objectID, String permissionName, IPrincipal iPrincipal) throws CAFPermissionException {
        String method = "retrievePermission(String, String, String , IPrincipal)";
        CAFPublicLogger.entering(null, (String)JARMREQUEST, (String)"retrievePermission(String, String, String , IPrincipal)", (Location)LOGGER, (int)1);
        try {
            IUser iusr = CAFPermission.getUser(loginUserID);
            List ar1 = new ArrayList();
            IAcl acl = CAFPermission.getACL(objectID, true);
            if (CAFPermission.hasAuthorizePermission(iusr, acl)) {
                ar1 = iPrincipal == null ? acl.getAclEntries() : acl.getAclEntries(iPrincipal);
            }
            ArrayList arrayList = CAFPermission.retrieveACEntries(ar1, permissionName);
            return arrayList;
        }
        catch (UMException e) {
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"retrievePermission(String, String, String , IPrincipal)", (String)e.getMessage(), (Throwable)e);
            throw new CAFPermissionException("AUTH_PERMISSION_ERROR", new Object[]{"retrievePermission(String, String, String , IPrincipal)", e.getMessage()});
        }
        finally {
            CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"retrievePermission(String, String, String , IPrincipal)", (Location)LOGGER, (int)1);
        }
    }

    public static ArrayList retrievePermission(String loginUserID, String objectID, String permissionName, String assignedUserID) throws CAFPermissionException {
        String method = "retrievePermission(String, String, String, String)";
        CAFPublicLogger.entering(null, (String)JARMREQUEST, (String)"retrievePermission(String, String, String, String)", (Location)LOGGER, (int)1);
        try {
            IUser assignedUser = null;
            if (assignedUserID != null && assignedUserID.length() != 0) {
                assignedUser = CAFPermission.getUser(assignedUserID);
            }
            ArrayList arrayList = CAFPermission.retrievePermission(loginUserID, objectID, permissionName, assignedUser);
            return arrayList;
        }
        catch (UMException e) {
            Object[] param = new Object[]{"retrievePermission(String, String, String, String)", e.getMessage()};
            CAFPermissionException pe = new CAFPermissionException("AUTH_PERMISSION_ERROR", param);
            throw pe;
        }
        finally {
            CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"retrievePermission(String, String, String, String)", (Location)LOGGER, (int)1);
        }
    }

    public static synchronized void createDefaultPermissionHierarchy() throws CAFPermissionException {
        String method = "createDefaultPermissionHierarchy()";
        CAFPublicLogger.entering(null, (String)JARMREQUEST, (String)"createDefaultPermissionHierarchy()", (Location)LOGGER, (int)1);
        try {
            IAclManager aclManager = CAFPermission.getAclManagerInstance();
            List permissions = aclManager.getAllPermissions();
            if (!permissions.contains("read")) {
                aclManager.addPermission("fullcontrol", null);
                aclManager.addPermission("owner", null);
                aclManager.addPermission("create", null);
                aclManager.addPermission("update", null);
                aclManager.addPermission("delete", null);
                aclManager.addPermission("read", null);
                aclManager.addPermission("write", null);
                aclManager.addPermission("remove", null);
                aclManager.addPermissionMember("owner", "create");
                aclManager.addPermissionMember("owner", "update");
                aclManager.addPermissionMember("owner", "delete");
                aclManager.addPermissionMember("update", "read");
                aclManager.addPermissionMember("update", "write");
                aclManager.addPermissionMember("delete", "read");
                aclManager.addPermissionMember("delete", "remove");
            }
        }
        catch (UMException e) {
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"createDefaultPermissionHierarchy()", (String)e.getMessage(), (Throwable)e);
            throw new CAFPermissionException("AUTH_PERMISSION_ERROR", new Object[]{"createDefaultPermissionHierarchy()", e.getMessage()});
        }
        CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"createDefaultPermissionHierarchy()", (Location)LOGGER, (int)1);
    }

    private static void removeACEntries(IAcl iAcl, IPrincipal loggedInUser, List ar, String permissionName) throws UMException {
        int size = ar.size();
        boolean removeAll = permissionName == null || permissionName.length() == 0;
        for (int i = 0; i < size; ++i) {
            IAclEntry entry = (IAclEntry)ar.get(i);
            if (!removeAll && !entry.getPermission().equals(permissionName)) continue;
            iAcl.removeAclEntry(loggedInUser, entry);
        }
    }

    private static ArrayList retrieveACEntries(List ar, String permissionName) throws CAFPermissionException {
        ArrayList resultList = new ArrayList();
        int size = ar.size();
        for (int i = 0; i < size; ++i) {
            IAclEntry ace = (IAclEntry)ar.get(i);
            if (permissionName != null && permissionName.length() != 0 && !ace.getPermission().equals(permissionName)) continue;
            HashMap<IPrincipal, String> hm = new HashMap<IPrincipal, String>();
            hm.put(ace.getPrincipal(), ace.getPermission());
            resultList.add(hm);
        }
        return resultList;
    }

    private static void modifyACEntries(IAcl iAcl, IPrincipal ipr, IPrincipal iPrincipal, List ar, String oldPermissionName, String newPermissionName) throws UMException {
        int size = ar.size();
        for (int i = 0; i < size; ++i) {
            IAclEntry ace = (IAclEntry)ar.get(i);
            if (!ace.getPermission().equals(oldPermissionName)) continue;
            iAcl.removeAclEntry(ipr, ace);
            iAcl.createAclEntry(ipr, iPrincipal, newPermissionName, false);
        }
    }

    private static synchronized IAclManager getAclManagerInstance() {
        if (s_aclManager == null) {
            s_aclManager = UMFactory.getAclManager((String)APPLICATION_ID);
        }
        return s_aclManager;
    }

    private static synchronized IUser getUser(String userID) throws UMException {
        String method = "getUser (String)";
        IUser usr = null;
        if (s_userFactory == null) {
            s_userFactory = UMFactory.getUserFactory();
        }
        if (!userID.startsWith("USER.")) {
            try {
                usr = s_userFactory.getUserByUniqueName(userID);
                if (usr != null) {
                    return usr;
                }
            }
            catch (UMException e) {
                CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)method, (String)e.getMessage(), (Throwable)e);
            }
        }
        try {
            usr = s_userFactory.getUser(userID);
        }
        catch (UMException e) {
            usr = s_userFactory.getUserByUniqueName(userID);
        }
        return usr;
    }

    private static synchronized IPrincipal getPrincipal(String principalId) throws UMException {
        String method = "getPrincipal (String)";
        IUser prcl = null;
        if (s_userFactory == null) {
            s_userFactory = UMFactory.getUserFactory();
        }
        if (s_principalFactory == null) {
            s_principalFactory = UMFactory.getPrincipalFactory();
        }
        if (!principalId.startsWith("USER.")) {
            try {
                prcl = s_userFactory.getUserByUniqueName(principalId);
                if (prcl != null) {
                    return prcl;
                }
            }
            catch (UMException e) {
                CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)method, (String)e.getMessage(), (Throwable)e);
            }
        }
        try {
            prcl = s_principalFactory.getPrincipal(principalId);
        }
        catch (UMException _e) {
            prcl = s_userFactory.getUserByUniqueName(principalId);
        }
        return prcl;
    }

    private static synchronized Class getAclCustomerizedClass() {
        Class<?> lClass = null;
        if (s_AclCustomizedClass.equals("-1")) {
            CAFProperties cPro = new CAFProperties();
            try {
                cPro.loadApplicationProperties();
                s_AclCustomizedClass = (String)cPro.get((Object)ACL_CUSTOMIZED_CLASS);
            }
            catch (Exception e) {
                s_AclCustomizedClass = null;
            }
        }
        if (s_AclCustomizedClass == null || s_AclCustomizedClass.length() == 0) {
            return null;
        }
        try {
            lClass = Class.forName(s_AclCustomizedClass);
            if (lClass != null) {
                s_StandardCheckPermissionRequired = CAFPermission.isStandardCheckPermissionRequired(lClass);
            }
        }
        catch (ClassNotFoundException _e) {
            lClass = null;
        }
        catch (CAFPermissionException _e) {
            lClass = null;
        }
        return lClass;
    }

    private static boolean hasAclPermission(IPrincipal principal, String objectID, String permissionName) throws CAFPermissionException {
        boolean isAllowed;
        try {
            IAclManager aclManager = CAFPermission.getAclManagerInstance();
            IAcl iAcl = aclManager.getAcl(objectID);
            if (iAcl == null) {
                return false;
            }
            isAllowed = iAcl.isAllowed(principal, permissionName);
        }
        catch (Exception e) {
            throw new CAFPermissionException("AUTH_ACL_ACCESS", new Object[]{objectID, principal, permissionName}, (Throwable)e);
        }
        return isAllowed;
    }

    private static boolean checkCustomerizedAclPermission(Class cClass, Object obj, String userID, String permissionName, String objectType) throws CAFPermissionException {
        boolean bPermission;
        try {
            Class[] parameterDataType = new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = CAFPermission.class$("java.lang.Object")) : class$java$lang$Object, userID.getClass(), permissionName.getClass(), objectType.getClass()};
            Object[] parameterValueObject = new Object[]{obj, userID, permissionName, objectType};
            Method method = cClass.getMethod(CHECK_PERMISSION_METHOD, parameterDataType);
            bPermission = (Boolean)method.invoke(cClass.newInstance(), parameterValueObject);
        }
        catch (Exception _e) {
            throw new CAFPermissionException((Throwable)_e);
        }
        return bPermission;
    }

    private static boolean isStandardCheckPermissionRequired(Class cClass) throws CAFPermissionException {
        boolean bRequired;
        try {
            Object[] nullObject = new Object[]{};
            Method method = cClass.getMethod(STANDARD_CHECK_REQUIRED_METHOD, new Class[0]);
            bRequired = (Boolean)method.invoke(cClass.newInstance(), nullObject);
        }
        catch (Exception _e) {
            throw new CAFPermissionException((Throwable)_e);
        }
        return bRequired;
    }

    public static IAcl getACL(String objectID) throws UMException, CAFPermissionException {
        IAclManager aclManager = CAFPermission.getAclManagerInstance();
        IAcl acl = aclManager.getAcl(objectID);
        return acl;
    }

    private static IAcl getACL(String objectID, boolean mustExist) throws UMException, CAFPermissionException {
        IAclManager aclManager = CAFPermission.getAclManagerInstance();
        IAcl acl = aclManager.getAcl(objectID);
        if (acl == null && mustExist) {
            throw new CAFPermissionException("AUTH_NO_ACL", new Object[]{objectID});
        }
        return acl;
    }

    public static Collection getAllowedPermission(String principalID, Object object, String objectType) throws CAFPermissionException {
        String method = "getAllowedPermission(String, Object, String)";
        CAFPublicLogger.entering(null, (String)JARMREQUEST, (String)"getAllowedPermission(String, Object, String)", (Location)LOGGER, (int)1);
        try {
            Iterator iter = CAFPermissionName.getAllNames();
            ArrayList<String> result = new ArrayList<String>();
            while (iter.hasNext()) {
                CAFPermissionName permission = (CAFPermissionName)iter.next();
                String name = permission.getName();
                if (!CAFPermission.checkAclPermission(object, principalID, name, objectType)) continue;
                result.add(name);
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        catch (Exception e) {
            throw new CAFPermissionException((Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"getAllowedPermission(String, Object, String)", (Location)LOGGER, (int)1);
        }
    }

    private static boolean checkAuthorizePermission(IUser user, IAcl acl) throws CAFPermissionException {
        if (!CAFPermission.hasAuthorizePermission(user, acl)) {
            throw new CAFPermissionException("AUTH_NO_ACL_MODIFY_ACCESS", new Object[]{user.getDisplayName()});
        }
        return true;
    }

    private static boolean hasAuthorizePermission(IUser user, IAcl acl) throws CAFPermissionException {
        String method = "hasAuthorizePermission(IUser, IAcl)";
        CAFPublicLogger.entering(null, (String)JARMREQUEST, (String)"hasAuthorizePermission(IUser, IAcl)", (Location)LOGGER, (int)1);
        if (user == null || acl == null) {
            return false;
        }
        try {
            if (acl.isAllowed((IPrincipal)user, "owner")) {
                boolean bl = true;
                return bl;
            }
            if (s_adminRole == null) {
                try {
                    s_adminRole = UMFactory.getRoleFactory().getRoleByUniqueName(ADMIN_ROLE);
                }
                catch (UMException e) {
                    CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"hasAuthorizePermission(IUser, IAcl)", (String)e.getMessage(), (Throwable)e);
                    throw new CAFPermissionException("AUTH_NO_ROLE", new Object[]{ADMIN_ROLE});
                }
            }
            boolean e = s_adminRole.isUserMember(user.getUniqueID(), true);
            return e;
        }
        catch (UMException e) {
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"hasAuthorizePermission(IUser, IAcl)", (String)e.getMessage(), (Throwable)e);
            Object[] param = new Object[]{"hasAuthorizePermission(IUser, IAcl)", e.getMessage()};
            throw new CAFPermissionException("AUTH_PERMISSION_ERROR", param);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"hasAuthorizePermission(IUser, IAcl)", (Location)LOGGER, (int)1);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        s_AclCustomizedClass = "-1";
        s_StandardCheckPermissionRequired = false;
        s_CutomizedPermissionClass = null;
        try {
            CAFPermission.createDefaultPermissionHierarchy();
        }
        catch (Exception e) {
            String method = "Static block";
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)method, (String)"AUTH_PERMISSION_ERROR", (Object[])new Object[]{method, e.getMessage()}, (Throwable)e);
        }
    }
}

