/*
 * Decompiled with CFR 0.152.
 */
package antlr.preprocessor;

import antlr.ANTLRException;
import antlr.TokenStreamException;
import antlr.Tool;
import antlr.collections.impl.IndexedVector;
import antlr.preprocessor.Grammar;
import antlr.preprocessor.GrammarFile;
import antlr.preprocessor.Option;
import antlr.preprocessor.Preprocessor;
import antlr.preprocessor.PreprocessorLexer;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.Enumeration;
import java.util.Hashtable;

public class Hierarchy {
    protected static Grammar LexerRoot = new Grammar("Lexer", null, null);
    protected static Grammar ParserRoot = new Grammar("Parser", null, null);
    protected static Grammar TreeParserRoot = new Grammar("TreeParser", null, null);
    protected Hashtable symbols = new Hashtable(10);
    protected Hashtable files = new Hashtable(10);

    public Hierarchy() {
        LexerRoot.setPredefined(true);
        ParserRoot.setPredefined(true);
        TreeParserRoot.setPredefined(true);
        this.symbols.put(LexerRoot.getName(), LexerRoot);
        this.symbols.put(ParserRoot.getName(), ParserRoot);
        this.symbols.put(TreeParserRoot.getName(), TreeParserRoot);
    }

    public void addGrammar(Grammar gr) {
        gr.setHierarchy(this);
        this.symbols.put(gr.getName(), gr);
        GrammarFile f = this.getFile(gr.getFileName());
        f.addGrammar(gr);
    }

    public void addGrammarFile(GrammarFile gf) {
        this.files.put(gf.getName(), gf);
    }

    public void expandGrammarsInFile(String fileName) {
        GrammarFile f = this.getFile(fileName);
        Enumeration e = f.getGrammars().elements();
        while (e.hasMoreElements()) {
            Grammar g = (Grammar)e.nextElement();
            g.expandInPlace();
        }
    }

    public Grammar findRoot(Grammar g) {
        if (g.getSuperGrammarName() == null) {
            return g;
        }
        Grammar sg = g.getSuperGrammar();
        if (sg == null) {
            return g;
        }
        return this.findRoot(sg);
    }

    public GrammarFile getFile(String fileName) {
        return (GrammarFile)this.files.get(fileName);
    }

    public Grammar getGrammar(String gr) {
        return (Grammar)this.symbols.get(gr);
    }

    public static String optionsToString(IndexedVector options) {
        String s = "options {" + System.getProperty("line.separator");
        Enumeration e = options.elements();
        while (e.hasMoreElements()) {
            s = s + (Option)e.nextElement() + System.getProperty("line.separator");
        }
        s = s + "}" + System.getProperty("line.separator") + System.getProperty("line.separator");
        return s;
    }

    public void readGrammarFile(String file) throws FileNotFoundException {
        FileReader grStream = new FileReader(file);
        this.addGrammarFile(new GrammarFile(file));
        PreprocessorLexer ppLexer = new PreprocessorLexer(grStream);
        ppLexer.setFilename(file);
        Preprocessor pp = new Preprocessor(ppLexer);
        pp.setFilename(file);
        try {
            pp.grammarFile(this, file);
        }
        catch (TokenStreamException io) {
            Tool.toolError("Token stream error reading grammar(s):" + io);
        }
        catch (ANTLRException se) {
            Tool.toolError("error reading grammar(s):" + se);
        }
    }

    public boolean verifyThatHierarchyIsComplete() {
        boolean complete = true;
        Enumeration e = this.symbols.elements();
        while (e.hasMoreElements()) {
            Grammar superG;
            Grammar c = (Grammar)e.nextElement();
            if (c.getSuperGrammarName() == null || (superG = c.getSuperGrammar()) != null) continue;
            Tool.toolError("grammar " + c.getSuperGrammarName() + " not defined");
            complete = false;
            this.symbols.remove(c.getName());
        }
        if (!complete) {
            return false;
        }
        Enumeration e2 = this.symbols.elements();
        while (e2.hasMoreElements()) {
            Grammar c = (Grammar)e2.nextElement();
            if (c.getSuperGrammarName() == null) continue;
            c.setType(this.findRoot(c).getName());
        }
        return true;
    }
}

