/*
 * Decompiled with CFR 0.152.
 */
package antlr.debug;

import antlr.CharStreamException;
import antlr.InputBuffer;
import antlr.debug.InputBufferEventSupport;
import antlr.debug.InputBufferListener;
import java.io.InputStream;
import java.io.Reader;
import java.util.Vector;

public class DebuggingInputBuffer
extends InputBuffer {
    private InputBuffer buffer;
    private InputBufferEventSupport inputBufferEventSupport;
    private boolean debugMode = true;

    public DebuggingInputBuffer(InputBuffer buffer) {
        this.buffer = buffer;
        this.inputBufferEventSupport = new InputBufferEventSupport(this);
    }

    public void resetInput(Reader in) {
        this.reset();
        this.buffer.resetInput(in);
        this.inputBufferEventSupport = new InputBufferEventSupport(this);
    }

    public void resetInput(InputStream in) {
        this.reset();
        this.buffer.resetInput(in);
        this.inputBufferEventSupport = new InputBufferEventSupport(this);
    }

    public void addInputBufferListener(InputBufferListener l) {
        this.inputBufferEventSupport.addInputBufferListener(l);
    }

    public void consume() {
        char la = ' ';
        try {
            la = this.buffer.LA(1);
        }
        catch (CharStreamException charStreamException) {
            // empty catch block
        }
        this.buffer.consume();
        if (this.debugMode) {
            this.inputBufferEventSupport.fireConsume(la);
        }
    }

    public void fill(int a) throws CharStreamException {
        this.buffer.fill(a);
    }

    public Vector getInputBufferListeners() {
        return this.inputBufferEventSupport.getInputBufferListeners();
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public boolean isMarked() {
        return this.buffer.isMarked();
    }

    public char LA(int i) throws CharStreamException {
        char la = this.buffer.LA(i);
        if (this.debugMode) {
            this.inputBufferEventSupport.fireLA(la, i);
        }
        return la;
    }

    public int mark() {
        int m = this.buffer.mark();
        this.inputBufferEventSupport.fireMark(m);
        return m;
    }

    public void removeInputBufferListener(InputBufferListener l) {
        if (this.inputBufferEventSupport != null) {
            this.inputBufferEventSupport.removeInputBufferListener(l);
        }
    }

    public void rewind(int mark) {
        this.buffer.rewind(mark);
        this.inputBufferEventSupport.fireRewind(mark);
    }

    public void setDebugMode(boolean value) {
        this.debugMode = value;
    }
}

