/*
 * Decompiled with CFR 0.152.
 */
package antlr;

import antlr.TokenManager;
import antlr.TokenSymbol;
import antlr.Tool;
import antlr.collections.impl.Vector;
import java.util.Enumeration;
import java.util.Hashtable;

class SimpleTokenManager
implements TokenManager,
Cloneable {
    protected int maxToken = 4;
    protected Vector vocabulary;
    private Hashtable table;
    protected Tool tool;
    protected String name;
    protected boolean readOnly = false;

    SimpleTokenManager(String name_, Tool tool_) {
        this.tool = tool_;
        this.name = name_;
        this.vocabulary = new Vector(1);
        this.table = new Hashtable();
        TokenSymbol ts = new TokenSymbol("EOF");
        ts.setTokenType(1);
        this.define(ts);
        this.vocabulary.ensureCapacity(3);
        this.vocabulary.setElementAt("NULL_TREE_LOOKAHEAD", 3);
    }

    public Object clone() {
        SimpleTokenManager tm;
        try {
            tm = (SimpleTokenManager)super.clone();
            tm.vocabulary = (Vector)this.vocabulary.clone();
            tm.table = (Hashtable)this.table.clone();
            tm.maxToken = this.maxToken;
            tm.tool = this.tool;
            tm.name = this.name;
        }
        catch (CloneNotSupportedException e) {
            Tool.panic("cannot clone token manager");
            return null;
        }
        return tm;
    }

    public void define(TokenSymbol ts) {
        this.vocabulary.ensureCapacity(ts.getTokenType());
        this.vocabulary.setElementAt(ts.getId(), ts.getTokenType());
        this.mapToTokenSymbol(ts.getId(), ts);
    }

    public String getName() {
        return this.name;
    }

    public String getTokenStringAt(int idx) {
        return (String)this.vocabulary.elementAt(idx);
    }

    public TokenSymbol getTokenSymbol(String sym) {
        return (TokenSymbol)this.table.get(sym);
    }

    public TokenSymbol getTokenSymbolAt(int idx) {
        return this.getTokenSymbol(this.getTokenStringAt(idx));
    }

    public Enumeration getTokenSymbolElements() {
        return this.table.elements();
    }

    public Enumeration getTokenSymbolKeys() {
        return this.table.keys();
    }

    public Vector getVocabulary() {
        return this.vocabulary;
    }

    public boolean isReadOnly() {
        return false;
    }

    public void mapToTokenSymbol(String name, TokenSymbol sym) {
        this.table.put(name, sym);
    }

    public int maxTokenType() {
        return this.maxToken - 1;
    }

    public int nextTokenType() {
        return this.maxToken++;
    }

    public void setName(String name_) {
        this.name = name_;
    }

    public void setReadOnly(boolean ro) {
        this.readOnly = ro;
    }

    public boolean tokenDefined(String symbol) {
        return this.table.containsKey(symbol);
    }
}

