/*
 * Decompiled with CFR 0.152.
 */
package antlr;

import antlr.CharFormatter;
import antlr.collections.impl.BitSet;

class SatherCharFormatter
implements CharFormatter {
    SatherCharFormatter() {
    }

    public String escapeChar(int c, boolean forCharLiteral) {
        switch (c) {
            case 10: {
                return "\\n";
            }
            case 9: {
                return "\\t";
            }
            case 13: {
                return "\\r";
            }
            case 92: {
                return "\\\\";
            }
            case 39: {
                return forCharLiteral ? "\\'" : "'";
            }
            case 34: {
                return forCharLiteral ? "\"" : "\\\"";
            }
        }
        if (c < 32 || c > 126) {
            if (c > 255) {
                System.out.println("warning: Sather does not support 16-bit characters (..yet).");
                return "\\u" + Integer.toString(c, 16);
            }
            return "\\" + Integer.toString(c, 8);
        }
        return String.valueOf((char)c);
    }

    public String escapeString(String s) {
        String retval = new String();
        int i = 0;
        while (i < s.length()) {
            retval = retval + this.escapeChar(s.charAt(i), false);
            ++i;
        }
        return retval;
    }

    public String literalChar(int c) {
        return "'" + this.escapeChar(c, true) + "'";
    }

    public String literalString(String s) {
        return "\"" + this.escapeString(s) + "\"";
    }

    public String BitSet2BoolList(BitSet bs, String separator) {
        String result = new String();
        int bs_size = bs.size();
        int i = 0;
        while (i < bs_size) {
            result = bs.member(i) ? result + "true" : result + "false";
            if (i < bs_size - 1) {
                result = result + separator;
            }
            ++i;
        }
        return result;
    }

    public String BitSet2IntList(BitSet bs, String separator) {
        String result = new String();
        boolean first = true;
        int i = 0;
        while (i < bs.size()) {
            if (bs.member(i)) {
                if (!first) {
                    result = result + separator;
                } else {
                    first = false;
                }
                result = result + i;
            }
            ++i;
        }
        return result;
    }
}

