/*
 * Decompiled with CFR 0.152.
 */
package antlr;

import antlr.ActionElement;
import antlr.ActionTransInfo;
import antlr.Alternative;
import antlr.AlternativeBlock;
import antlr.AlternativeElement;
import antlr.BlockEndElement;
import antlr.CharLiteralElement;
import antlr.CharRangeElement;
import antlr.CodeGenerator;
import antlr.ExceptionHandler;
import antlr.ExceptionSpec;
import antlr.Grammar;
import antlr.GrammarAtom;
import antlr.GrammarSymbol;
import antlr.JavaBlockFinishingInfo;
import antlr.JavaCharFormatter;
import antlr.LexerGrammar;
import antlr.Lookahead;
import antlr.MakeGrammar;
import antlr.OneOrMoreBlock;
import antlr.ParserGrammar;
import antlr.RuleBlock;
import antlr.RuleRefElement;
import antlr.RuleSymbol;
import antlr.StringLiteralElement;
import antlr.StringLiteralSymbol;
import antlr.SynPredBlock;
import antlr.Token;
import antlr.TokenManager;
import antlr.TokenRangeElement;
import antlr.TokenRefElement;
import antlr.TokenSymbol;
import antlr.Tool;
import antlr.TreeElement;
import antlr.TreeWalkerGrammar;
import antlr.WildcardElement;
import antlr.ZeroOrMoreBlock;
import antlr.collections.impl.BitSet;
import antlr.collections.impl.Vector;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class JavaCodeGenerator
extends CodeGenerator {
    protected int syntacticPredLevel = 0;
    protected boolean genAST = false;
    protected boolean saveText = false;
    String labeledElementType;
    String labeledElementASTType;
    String labeledElementInit;
    String commonExtraArgs;
    String commonExtraParams;
    String commonLocalVars;
    String lt1Value;
    String exceptionThrown;
    String throwNoViable;
    RuleBlock currentRule;
    String currentASTResult;
    Hashtable treeVariableMap = new Hashtable();
    int astVarNumber = 1;
    protected static final String NONUNIQUE = new String();
    public static final int caseSizeThreshold = 127;
    private Vector semPreds;

    public JavaCodeGenerator() {
        this.charFormatter = new JavaCharFormatter();
    }

    protected int addSemPred(String predicate) {
        this.semPreds.appendElement(predicate);
        return this.semPreds.size() - 1;
    }

    public void exitIfError() {
        if (this.tool.hasError) {
            System.out.println("Exiting due to errors.");
            System.exit(1);
        }
    }

    public void gen() {
        try {
            Enumeration grammarIter = this.behavior.grammars.elements();
            while (grammarIter.hasMoreElements()) {
                Grammar g = (Grammar)grammarIter.nextElement();
                g.setGrammarAnalyzer(this.analyzer);
                g.setCodeGenerator(this);
                this.analyzer.setGrammar(g);
                this.setupGrammarParameters(g);
                g.generate();
                this.exitIfError();
            }
            Enumeration tmIter = this.behavior.tokenManagers.elements();
            while (tmIter.hasMoreElements()) {
                TokenManager tm = (TokenManager)tmIter.nextElement();
                if (!tm.isReadOnly()) {
                    this.genTokenTypes(tm);
                    this.genTokenInterchange(tm);
                }
                this.exitIfError();
            }
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    public void gen(ActionElement action) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genAction(" + action + ")");
        }
        if (action.isSemPred) {
            this.genSemPred(action.actionText, action.line);
        } else {
            if (this.grammar.hasSyntacticPredicate) {
                this.println("if ( inputState.guessing==0 ) {");
                ++this.tabs;
            }
            ActionTransInfo tInfo = new ActionTransInfo();
            String actionStr = this.processActionForTreeSpecifiers(action.actionText, action.getLine(), this.currentRule, tInfo);
            if (tInfo.refRuleRoot != null) {
                this.println(tInfo.refRuleRoot + " = (" + this.labeledElementASTType + ")currentAST.root;");
            }
            this.printAction(actionStr);
            if (tInfo.assignToRoot) {
                this.println("currentAST.root = " + tInfo.refRuleRoot + ";");
                this.println("currentAST.child = " + tInfo.refRuleRoot + "!=null &&" + tInfo.refRuleRoot + ".getFirstChild()!=null ?");
                ++this.tabs;
                this.println(tInfo.refRuleRoot + ".getFirstChild() : " + tInfo.refRuleRoot + ";");
                --this.tabs;
                this.println("currentAST.advanceChildToEnd();");
            }
            if (this.grammar.hasSyntacticPredicate) {
                --this.tabs;
                this.println("}");
            }
        }
    }

    public void gen(AlternativeBlock blk) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("gen(" + blk + ")");
        }
        this.println("{");
        this.genBlockPreamble(blk);
        String saveCurrentASTResult = this.currentASTResult;
        if (blk.getLabel() != null) {
            this.currentASTResult = blk.getLabel();
        }
        boolean ok = this.grammar.theLLkAnalyzer.deterministic(blk);
        JavaBlockFinishingInfo howToFinish = this.genCommonBlock(blk, true);
        this.genBlockFinish(howToFinish, this.throwNoViable);
        this.println("}");
        this.currentASTResult = saveCurrentASTResult;
    }

    public void gen(BlockEndElement end) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genRuleEnd(" + end + ")");
        }
    }

    public void gen(CharLiteralElement atom) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genChar(" + atom + ")");
        }
        if (atom.getLabel() != null) {
            this.println(atom.getLabel() + " = " + this.lt1Value + ";");
        }
        boolean oldsaveText = this.saveText;
        this.saveText = this.saveText && atom.getAutoGenType() == 1;
        this.genMatch(atom);
        this.saveText = oldsaveText;
    }

    public void gen(CharRangeElement r) {
        if (r.getLabel() != null && this.syntacticPredLevel == 0) {
            this.println(r.getLabel() + " = " + this.lt1Value + ";");
        }
        this.println("matchRange(" + r.beginText + "," + r.endText + ");");
    }

    public void gen(LexerGrammar g) throws IOException {
        GrammarSymbol sym;
        Enumeration ids;
        String suffix;
        if (g.debuggingOutput) {
            this.semPreds = new Vector();
        }
        this.setGrammar(g);
        if (!(this.grammar instanceof LexerGrammar)) {
            Tool.panic("Internal error generating lexer");
        }
        this.setupOutput(this.grammar.getClassName());
        this.genAST = false;
        this.saveText = true;
        this.tabs = 0;
        this.genHeader();
        this.println(this.behavior.getHeaderAction(""));
        this.println("import java.io.InputStream;");
        this.println("import antlr.TokenStreamException;");
        this.println("import antlr.TokenStreamIOException;");
        this.println("import antlr.TokenStreamRecognitionException;");
        this.println("import antlr.CharStreamException;");
        this.println("import antlr.CharStreamIOException;");
        this.println("import antlr.ANTLRException;");
        this.println("import java.io.Reader;");
        this.println("import java.util.Hashtable;");
        this.println("import antlr." + this.grammar.getSuperClass() + ";");
        this.println("import antlr.InputBuffer;");
        this.println("import antlr.ByteBuffer;");
        this.println("import antlr.CharBuffer;");
        this.println("import antlr.Token;");
        this.println("import antlr.CommonToken;");
        this.println("import antlr.RecognitionException;");
        this.println("import antlr.NoViableAltForCharException;");
        this.println("import antlr.MismatchedCharException;");
        this.println("import antlr.TokenStream;");
        this.println("import antlr.ANTLRHashString;");
        this.println("import antlr.LexerSharedInputState;");
        this.println("import antlr.collections.impl.BitSet;");
        this.println("import antlr.SemanticException;");
        this.println(this.grammar.preambleAction.getText());
        String sup = null;
        sup = this.grammar.superClass != null ? this.grammar.superClass : "antlr." + this.grammar.getSuperClass();
        if (this.grammar.comment != null) {
            this._println(this.grammar.comment);
        }
        this.print("public class " + this.grammar.getClassName() + " extends " + sup);
        this.println(" implements " + this.grammar.tokenManager.getName() + CodeGenerator.TokenTypesFileSuffix + ", TokenStream");
        Token tsuffix = (Token)this.grammar.options.get("classHeaderSuffix");
        if (tsuffix != null && (suffix = Tool.stripFrontBack(tsuffix.getText(), "\"", "\"")) != null) {
            this.print(", " + suffix);
        }
        this.println(" {");
        this.print(this.processActionForTreeSpecifiers(this.grammar.classMemberAction.getText(), 0, this.currentRule, null));
        this.println("public " + this.grammar.getClassName() + "(InputStream in) {");
        ++this.tabs;
        this.println("this(new ByteBuffer(in));");
        --this.tabs;
        this.println("}");
        this.println("public " + this.grammar.getClassName() + "(Reader in) {");
        ++this.tabs;
        this.println("this(new CharBuffer(in));");
        --this.tabs;
        this.println("}");
        this.println("public " + this.grammar.getClassName() + "(InputBuffer ib) {");
        ++this.tabs;
        if (this.grammar.debuggingOutput) {
            this.println("this(new LexerSharedInputState(new antlr.debug.DebuggingInputBuffer(ib)));");
        } else {
            this.println("this(new LexerSharedInputState(ib));");
        }
        --this.tabs;
        this.println("}");
        this.println("public " + this.grammar.getClassName() + "(LexerSharedInputState state) {");
        ++this.tabs;
        this.println("super(state);");
        if (this.grammar.debuggingOutput) {
            this.println("  ruleNames  = _ruleNames;");
            this.println("  semPredNames = _semPredNames;");
            this.println("  setupDebugging();");
        }
        this.println("literals = new Hashtable();");
        Enumeration keys = this.grammar.tokenManager.getTokenSymbolKeys();
        while (keys.hasMoreElements()) {
            TokenSymbol sym2;
            String key = (String)keys.nextElement();
            if (key.charAt(0) != '\"' || !((sym2 = this.grammar.tokenManager.getTokenSymbol(key)) instanceof StringLiteralSymbol)) continue;
            StringLiteralSymbol s = (StringLiteralSymbol)sym2;
            this.println("literals.put(new ANTLRHashString(" + s.getId() + ", this), new Integer(" + s.getTokenType() + "));");
        }
        --this.tabs;
        this.println("caseSensitiveLiterals = " + g.caseSensitiveLiterals + ";");
        this.println("setCaseSensitive(" + g.caseSensitive + ");");
        this.println("}");
        if (this.grammar.debuggingOutput) {
            this.println("private static final String _ruleNames[] = {");
            ids = this.grammar.rules.elements();
            boolean ruleNum = false;
            while (ids.hasMoreElements()) {
                sym = (GrammarSymbol)ids.nextElement();
                if (!(sym instanceof RuleSymbol)) continue;
                this.println("  \"" + ((RuleSymbol)sym).getId() + "\",");
            }
            this.println("};");
        }
        this.genNextToken();
        ids = this.grammar.rules.elements();
        int ruleNum = 0;
        while (ids.hasMoreElements()) {
            sym = (RuleSymbol)ids.nextElement();
            if (!sym.getId().equals("mnextToken")) {
                this.genRule((RuleSymbol)sym, false, ruleNum++);
            }
            this.exitIfError();
        }
        if (this.grammar.debuggingOutput) {
            this.genSemPredMap();
        }
        this.genBitsets(this.bitsetsUsed, ((LexerGrammar)this.grammar).charVocabulary.size());
        this.println("");
        this.println("}");
        this.currentOutput.close();
        this.currentOutput = null;
    }

    public void gen(OneOrMoreBlock blk) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("gen+(" + blk + ")");
        }
        this.println("{");
        this.genBlockPreamble(blk);
        String cnt = blk.getLabel() != null ? "_cnt_" + blk.getLabel() : "_cnt" + blk.ID;
        this.println("int " + cnt + "=0;");
        String label = blk.getLabel() != null ? blk.getLabel() : "_loop" + blk.ID;
        this.println(label + ":");
        this.println("do {");
        ++this.tabs;
        String saveCurrentASTResult = this.currentASTResult;
        if (blk.getLabel() != null) {
            this.currentASTResult = blk.getLabel();
        }
        boolean ok = this.grammar.theLLkAnalyzer.deterministic(blk);
        boolean generateNonGreedyExitPath = false;
        int nonGreedyExitDepth = this.grammar.maxk;
        if (!blk.greedy && blk.exitLookaheadDepth <= this.grammar.maxk && blk.exitCache[blk.exitLookaheadDepth].containsEpsilon()) {
            generateNonGreedyExitPath = true;
            nonGreedyExitDepth = blk.exitLookaheadDepth;
        } else if (!blk.greedy && blk.exitLookaheadDepth == Integer.MAX_VALUE) {
            generateNonGreedyExitPath = true;
        }
        if (generateNonGreedyExitPath) {
            if (this.DEBUG_CODE_GENERATOR) {
                System.out.println("nongreedy (...)+ loop; exit depth is " + blk.exitLookaheadDepth);
            }
            String predictExit = this.getLookaheadTestExpression(blk.exitCache, nonGreedyExitDepth);
            this.println("// nongreedy exit test");
            this.println("if ( " + cnt + ">=1 && " + predictExit + ") break " + label + ";");
        }
        JavaBlockFinishingInfo howToFinish = this.genCommonBlock(blk, false);
        this.genBlockFinish(howToFinish, "if ( " + cnt + ">=1 ) { break " + label + "; } else {" + this.throwNoViable + "}");
        this.println(cnt + "++;");
        --this.tabs;
        this.println("} while (true);");
        this.println("}");
        this.currentASTResult = saveCurrentASTResult;
    }

    public void gen(ParserGrammar g) throws IOException {
        GrammarSymbol sym;
        int ruleNum;
        Enumeration ids;
        String suffix;
        if (g.debuggingOutput) {
            this.semPreds = new Vector();
        }
        this.setGrammar(g);
        if (!(this.grammar instanceof ParserGrammar)) {
            Tool.panic("Internal error generating parser");
        }
        this.setupOutput(this.grammar.getClassName());
        this.genAST = this.grammar.buildAST;
        this.tabs = 0;
        this.genHeader();
        this.println(this.behavior.getHeaderAction(""));
        this.println("import antlr.TokenBuffer;");
        this.println("import antlr.TokenStreamException;");
        this.println("import antlr.TokenStreamIOException;");
        this.println("import antlr.ANTLRException;");
        this.println("import antlr." + this.grammar.getSuperClass() + ";");
        this.println("import antlr.Token;");
        this.println("import antlr.TokenStream;");
        this.println("import antlr.RecognitionException;");
        this.println("import antlr.NoViableAltException;");
        this.println("import antlr.MismatchedTokenException;");
        this.println("import antlr.SemanticException;");
        this.println("import antlr.ParserSharedInputState;");
        this.println("import antlr.collections.impl.BitSet;");
        this.println("import antlr.collections.AST;");
        this.println("import antlr.ASTPair;");
        this.println("import antlr.collections.impl.ASTArray;");
        this.println(this.grammar.preambleAction.getText());
        String sup = null;
        sup = this.grammar.superClass != null ? this.grammar.superClass : "antlr." + this.grammar.getSuperClass();
        if (this.grammar.comment != null) {
            this._println(this.grammar.comment);
        }
        this.println("public class " + this.grammar.getClassName() + " extends " + sup);
        this.println("       implements " + this.grammar.tokenManager.getName() + CodeGenerator.TokenTypesFileSuffix);
        Token tsuffix = (Token)this.grammar.options.get("classHeaderSuffix");
        if (tsuffix != null && (suffix = Tool.stripFrontBack(tsuffix.getText(), "\"", "\"")) != null) {
            this.print(", " + suffix);
        }
        this.println(" {");
        if (this.grammar.debuggingOutput) {
            this.println("private static final String _ruleNames[] = {");
            ids = this.grammar.rules.elements();
            ruleNum = 0;
            while (ids.hasMoreElements()) {
                sym = (GrammarSymbol)ids.nextElement();
                if (!(sym instanceof RuleSymbol)) continue;
                this.println("  \"" + ((RuleSymbol)sym).getId() + "\",");
            }
            this.println("};");
        }
        this.print(this.processActionForTreeSpecifiers(this.grammar.classMemberAction.getText(), 0, this.currentRule, null));
        this.println("");
        this.println("protected " + this.grammar.getClassName() + "(TokenBuffer tokenBuf, int k) {");
        this.println("  super(tokenBuf,k);");
        this.println("  tokenNames = _tokenNames;");
        if (this.grammar.debuggingOutput) {
            this.println("  ruleNames  = _ruleNames;");
            this.println("  semPredNames = _semPredNames;");
            this.println("  setupDebugging(tokenBuf);");
        }
        this.println("}");
        this.println("");
        this.println("public " + this.grammar.getClassName() + "(TokenBuffer tokenBuf) {");
        this.println("  this(tokenBuf," + this.grammar.maxk + ");");
        this.println("}");
        this.println("");
        this.println("protected " + this.grammar.getClassName() + "(TokenStream lexer, int k) {");
        this.println("  super(lexer,k);");
        this.println("  tokenNames = _tokenNames;");
        if (this.grammar.debuggingOutput) {
            this.println("  ruleNames  = _ruleNames;");
            this.println("  semPredNames = _semPredNames;");
            this.println("  setupDebugging(lexer);");
        }
        this.println("}");
        this.println("");
        this.println("public " + this.grammar.getClassName() + "(TokenStream lexer) {");
        this.println("  this(lexer," + this.grammar.maxk + ");");
        this.println("}");
        this.println("");
        this.println("public " + this.grammar.getClassName() + "(ParserSharedInputState state) {");
        this.println("  super(state," + this.grammar.maxk + ");");
        this.println("  tokenNames = _tokenNames;");
        this.println("}");
        this.println("");
        ids = this.grammar.rules.elements();
        ruleNum = 0;
        while (ids.hasMoreElements()) {
            sym = (GrammarSymbol)ids.nextElement();
            if (sym instanceof RuleSymbol) {
                RuleSymbol rs = (RuleSymbol)sym;
                this.genRule(rs, rs.references.size() == 0, ruleNum++);
            }
            this.exitIfError();
        }
        this.genTokenStrings();
        this.genBitsets(this.bitsetsUsed, this.grammar.tokenManager.maxTokenType());
        if (this.grammar.debuggingOutput) {
            this.genSemPredMap();
        }
        this.println("");
        this.println("}");
        this.currentOutput.close();
        this.currentOutput = null;
    }

    public void gen(RuleRefElement rr) {
        RuleSymbol rs;
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genRR(" + rr + ")");
        }
        if ((rs = (RuleSymbol)this.grammar.getSymbol(rr.targetRule)) == null || !rs.isDefined()) {
            this.tool.error("Rule '" + rr.targetRule + "' is not defined", this.grammar.getFilename(), rr.getLine());
            return;
        }
        if (!(rs instanceof RuleSymbol)) {
            this.tool.error("'" + rr.targetRule + "' does not name a grammar rule", this.grammar.getFilename(), rr.getLine());
            return;
        }
        this.genErrorTryForElement(rr);
        if (this.grammar instanceof TreeWalkerGrammar && rr.getLabel() != null && this.syntacticPredLevel == 0) {
            this.println(rr.getLabel() + " = _t==ASTNULL ? null : " + this.lt1Value + ";");
        }
        if (this.grammar instanceof LexerGrammar && (!this.saveText || rr.getAutoGenType() == 3)) {
            this.println("_saveIndex=text.length();");
        }
        this.printTabs();
        if (rr.idAssign != null) {
            if (rs.block.returnAction == null) {
                Tool.warning("Rule '" + rr.targetRule + "' has no return type", this.grammar.getFilename(), rr.getLine());
            }
            this._print(rr.idAssign + "=");
        } else if (!(this.grammar instanceof LexerGrammar) && this.syntacticPredLevel == 0 && rs.block.returnAction != null) {
            Tool.warning("Rule '" + rr.targetRule + "' returns a value", this.grammar.getFilename(), rr.getLine());
        }
        this.GenRuleInvocation(rr);
        if (this.grammar instanceof LexerGrammar && (!this.saveText || rr.getAutoGenType() == 3)) {
            this.println("text.setLength(_saveIndex);");
        }
        if (this.syntacticPredLevel == 0) {
            boolean doNoGuessTest;
            boolean bl = doNoGuessTest = this.grammar.hasSyntacticPredicate && (this.grammar.buildAST && rr.getLabel() != null || this.genAST && rr.getAutoGenType() == 1);
            if (doNoGuessTest) {
                this.println("if (inputState.guessing==0) {");
                ++this.tabs;
            }
            if (this.grammar.buildAST && rr.getLabel() != null) {
                this.println(rr.getLabel() + "_AST = (" + this.labeledElementASTType + ")returnAST;");
            }
            if (this.genAST) {
                switch (rr.getAutoGenType()) {
                    case 1: {
                        this.println("astFactory.addASTChild(currentAST, returnAST);");
                        break;
                    }
                    case 2: {
                        this.tool.error("Internal: encountered ^ after rule reference");
                        break;
                    }
                }
            }
            if (this.grammar instanceof LexerGrammar && rr.getLabel() != null) {
                this.println(rr.getLabel() + "=_returnToken;");
            }
            if (doNoGuessTest) {
                --this.tabs;
                this.println("}");
            }
        }
        this.genErrorCatchForElement(rr);
    }

    public void gen(StringLiteralElement atom) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genString(" + atom + ")");
        }
        if (atom.getLabel() != null && this.syntacticPredLevel == 0) {
            this.println(atom.getLabel() + " = " + this.lt1Value + ";");
        }
        this.genElementAST(atom);
        boolean oldsaveText = this.saveText;
        this.saveText = this.saveText && atom.getAutoGenType() == 1;
        this.genMatch(atom);
        this.saveText = oldsaveText;
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("_t = _t.getNextSibling();");
        }
    }

    public void gen(TokenRangeElement r) {
        this.genErrorTryForElement(r);
        if (r.getLabel() != null && this.syntacticPredLevel == 0) {
            this.println(r.getLabel() + " = " + this.lt1Value + ";");
        }
        this.genElementAST(r);
        this.println("matchRange(" + r.beginText + "," + r.endText + ");");
        this.genErrorCatchForElement(r);
    }

    public void gen(TokenRefElement atom) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genTokenRef(" + atom + ")");
        }
        if (this.grammar instanceof LexerGrammar) {
            Tool.panic("Token reference found in lexer");
        }
        this.genErrorTryForElement(atom);
        if (atom.getLabel() != null && this.syntacticPredLevel == 0) {
            this.println(atom.getLabel() + " = " + this.lt1Value + ";");
        }
        this.genElementAST(atom);
        this.genMatch(atom);
        this.genErrorCatchForElement(atom);
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("_t = _t.getNextSibling();");
        }
    }

    public void gen(TreeElement t) {
        this.println("AST __t" + t.ID + " = _t;");
        if (t.root.getLabel() != null) {
            this.println(t.root.getLabel() + " = _t==ASTNULL ? null :(" + this.labeledElementASTType + ")_t;");
        }
        this.genElementAST(t.root);
        if (this.grammar.buildAST) {
            this.println("ASTPair __currentAST" + t.ID + " = currentAST.copy();");
            this.println("currentAST.root = currentAST.child;");
            this.println("currentAST.child = null;");
        }
        this.genMatch(t.root);
        this.println("_t = _t.getFirstChild();");
        int i = 0;
        while (i < t.getAlternatives().size()) {
            Alternative a = t.getAlternativeAt(i);
            AlternativeElement e = a.head;
            while (e != null) {
                e.generate();
                e = e.next;
            }
            ++i;
        }
        if (this.grammar.buildAST) {
            this.println("currentAST = __currentAST" + t.ID + ";");
        }
        this.println("_t = __t" + t.ID + ";");
        this.println("_t = _t.getNextSibling();");
    }

    public void gen(TreeWalkerGrammar g) throws IOException {
        String suffix;
        this.setGrammar(g);
        if (!(this.grammar instanceof TreeWalkerGrammar)) {
            Tool.panic("Internal error generating tree-walker");
        }
        this.setupOutput(this.grammar.getClassName());
        this.genAST = this.grammar.buildAST;
        this.tabs = 0;
        this.genHeader();
        this.println(this.behavior.getHeaderAction(""));
        this.println("import antlr." + this.grammar.getSuperClass() + ";");
        this.println("import antlr.Token;");
        this.println("import antlr.collections.AST;");
        this.println("import antlr.RecognitionException;");
        this.println("import antlr.ANTLRException;");
        this.println("import antlr.NoViableAltException;");
        this.println("import antlr.MismatchedTokenException;");
        this.println("import antlr.SemanticException;");
        this.println("import antlr.collections.impl.BitSet;");
        this.println("import antlr.ASTPair;");
        this.println("import antlr.collections.impl.ASTArray;");
        this.println(this.grammar.preambleAction.getText());
        String sup = null;
        sup = this.grammar.superClass != null ? this.grammar.superClass : "antlr." + this.grammar.getSuperClass();
        this.println("");
        if (this.grammar.comment != null) {
            this._println(this.grammar.comment);
        }
        this.println("public class " + this.grammar.getClassName() + " extends " + sup);
        this.println("       implements " + this.grammar.tokenManager.getName() + CodeGenerator.TokenTypesFileSuffix);
        Token tsuffix = (Token)this.grammar.options.get("classHeaderSuffix");
        if (tsuffix != null && (suffix = Tool.stripFrontBack(tsuffix.getText(), "\"", "\"")) != null) {
            this.print(", " + suffix);
        }
        this.println(" {");
        this.print(this.processActionForTreeSpecifiers(this.grammar.classMemberAction.getText(), 0, this.currentRule, null));
        this.println("public " + this.grammar.getClassName() + "() {");
        ++this.tabs;
        this.println("tokenNames = _tokenNames;");
        --this.tabs;
        this.println("}");
        this.println("");
        Enumeration ids = this.grammar.rules.elements();
        int ruleNum = 0;
        String ruleNameInits = "";
        while (ids.hasMoreElements()) {
            GrammarSymbol sym = (GrammarSymbol)ids.nextElement();
            if (sym instanceof RuleSymbol) {
                RuleSymbol rs = (RuleSymbol)sym;
                this.genRule(rs, rs.references.size() == 0, ruleNum++);
            }
            this.exitIfError();
        }
        this.genTokenStrings();
        this.genBitsets(this.bitsetsUsed, this.grammar.tokenManager.maxTokenType());
        this.println("}");
        this.println("");
        this.currentOutput.close();
        this.currentOutput = null;
    }

    public void gen(WildcardElement wc) {
        if (wc.getLabel() != null && this.syntacticPredLevel == 0) {
            this.println(wc.getLabel() + " = " + this.lt1Value + ";");
        }
        this.genElementAST(wc);
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("if ( _t==null ) throw new MismatchedTokenException();");
        } else if (this.grammar instanceof LexerGrammar) {
            if (this.grammar instanceof LexerGrammar && (!this.saveText || wc.getAutoGenType() == 3)) {
                this.println("_saveIndex=text.length();");
            }
            this.println("matchNot(EOF_CHAR);");
            if (this.grammar instanceof LexerGrammar && (!this.saveText || wc.getAutoGenType() == 3)) {
                this.println("text.setLength(_saveIndex);");
            }
        } else {
            this.println("matchNot(" + this.getValueString(1) + ");");
        }
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("_t = _t.getNextSibling();");
        }
    }

    public void gen(ZeroOrMoreBlock blk) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("gen*(" + blk + ")");
        }
        this.println("{");
        this.genBlockPreamble(blk);
        String label = blk.getLabel() != null ? blk.getLabel() : "_loop" + blk.ID;
        this.println(label + ":");
        this.println("do {");
        ++this.tabs;
        String saveCurrentASTResult = this.currentASTResult;
        if (blk.getLabel() != null) {
            this.currentASTResult = blk.getLabel();
        }
        boolean ok = this.grammar.theLLkAnalyzer.deterministic(blk);
        boolean generateNonGreedyExitPath = false;
        int nonGreedyExitDepth = this.grammar.maxk;
        if (!blk.greedy && blk.exitLookaheadDepth <= this.grammar.maxk && blk.exitCache[blk.exitLookaheadDepth].containsEpsilon()) {
            generateNonGreedyExitPath = true;
            nonGreedyExitDepth = blk.exitLookaheadDepth;
        } else if (!blk.greedy && blk.exitLookaheadDepth == Integer.MAX_VALUE) {
            generateNonGreedyExitPath = true;
        }
        if (generateNonGreedyExitPath) {
            if (this.DEBUG_CODE_GENERATOR) {
                System.out.println("nongreedy (...)* loop; exit depth is " + blk.exitLookaheadDepth);
            }
            String predictExit = this.getLookaheadTestExpression(blk.exitCache, nonGreedyExitDepth);
            this.println("// nongreedy exit test");
            this.println("if (" + predictExit + ") break " + label + ";");
        }
        JavaBlockFinishingInfo howToFinish = this.genCommonBlock(blk, false);
        this.genBlockFinish(howToFinish, "break " + label + ";");
        --this.tabs;
        this.println("} while (true);");
        this.println("}");
        this.currentASTResult = saveCurrentASTResult;
    }

    protected void genAlt(Alternative alt, AlternativeBlock blk) {
        boolean savegenAST = this.genAST;
        this.genAST = this.genAST && alt.getAutoGen();
        boolean oldsaveTest = this.saveText;
        this.saveText = this.saveText && alt.getAutoGen();
        Hashtable saveMap = this.treeVariableMap;
        this.treeVariableMap = new Hashtable();
        if (alt.exceptionSpec != null) {
            this.println("try {      // for error handling");
            ++this.tabs;
        }
        AlternativeElement elem = alt.head;
        while (!(elem instanceof BlockEndElement)) {
            elem.generate();
            elem = elem.next;
        }
        if (this.genAST) {
            if (blk instanceof RuleBlock) {
                RuleBlock rblk = (RuleBlock)blk;
                this.println(rblk.getRuleName() + "_AST = (" + this.labeledElementASTType + ")currentAST.root;");
            } else if (blk.getLabel() != null) {
                // empty if block
            }
        }
        if (alt.exceptionSpec != null) {
            --this.tabs;
            this.println("}");
            this.genErrorHandler(alt.exceptionSpec);
        }
        this.genAST = savegenAST;
        this.saveText = oldsaveTest;
        this.treeVariableMap = saveMap;
    }

    protected void genBitsets(Vector bitsetList, int maxVocabulary) {
        this.println("");
        int i = 0;
        while (i < bitsetList.size()) {
            BitSet p = (BitSet)bitsetList.elementAt(i);
            p.growToInclude(maxVocabulary);
            this.println("private static final long " + this.getBitsetName(i) + "_data_" + "[] = { " + p.toStringOfWords() + " };");
            this.println("public static final BitSet " + this.getBitsetName(i) + " = new BitSet(" + this.getBitsetName(i) + "_data_" + ");");
            ++i;
        }
    }

    private void genBlockFinish(JavaBlockFinishingInfo howToFinish, String noViableAction) {
        if (howToFinish.needAnErrorClause && (howToFinish.generatedAnIf || howToFinish.generatedSwitch)) {
            if (howToFinish.generatedAnIf) {
                this.println("else {");
            } else {
                this.println("{");
            }
            ++this.tabs;
            this.println(noViableAction);
            --this.tabs;
            this.println("}");
        }
        if (howToFinish.postscript != null) {
            this.println(howToFinish.postscript);
        }
    }

    protected void genBlockPreamble(AlternativeBlock blk) {
        if (blk instanceof RuleBlock) {
            RuleBlock rblk = (RuleBlock)blk;
            if (rblk.labeledElements != null) {
                int i = 0;
                while (i < rblk.labeledElements.size()) {
                    AlternativeElement a = (AlternativeElement)rblk.labeledElements.elementAt(i);
                    if (a instanceof RuleRefElement || a instanceof AlternativeBlock && !(a instanceof RuleBlock) && !(a instanceof SynPredBlock)) {
                        if (!(a instanceof RuleRefElement) && ((AlternativeBlock)a).not && this.analyzer.subruleCanBeInverted((AlternativeBlock)a, this.grammar instanceof LexerGrammar)) {
                            this.println(this.labeledElementType + " " + a.getLabel() + " = " + this.labeledElementInit + ";");
                            if (this.grammar.buildAST) {
                                this.println(this.labeledElementASTType + " " + a.getLabel() + "_AST = null;");
                            }
                        } else {
                            if (this.grammar.buildAST) {
                                this.println(this.labeledElementASTType + " " + a.getLabel() + "_AST = null;");
                            }
                            if (this.grammar instanceof LexerGrammar) {
                                this.println("Token " + a.getLabel() + "=null;");
                            }
                            if (this.grammar instanceof TreeWalkerGrammar) {
                                this.println(this.labeledElementType + " " + a.getLabel() + " = " + this.labeledElementInit + ";");
                            }
                        }
                    } else {
                        this.println(this.labeledElementType + " " + a.getLabel() + " = " + this.labeledElementInit + ";");
                        if (this.grammar.buildAST) {
                            if (a instanceof GrammarAtom && ((GrammarAtom)a).getASTNodeType() != null) {
                                GrammarAtom ga = (GrammarAtom)a;
                                this.println(ga.getASTNodeType() + " " + a.getLabel() + "_AST = null;");
                            } else {
                                this.println(this.labeledElementASTType + " " + a.getLabel() + "_AST = null;");
                            }
                        }
                    }
                    ++i;
                }
            }
        }
        if (blk.initAction != null) {
            this.printAction(this.processActionForTreeSpecifiers(blk.initAction, 0, this.currentRule, null));
        }
    }

    protected void genCases(BitSet p) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genCases(" + p + ")");
        }
        int[] elems = p.toArray();
        int wrap = this.grammar instanceof LexerGrammar ? 4 : 1;
        int j = 1;
        boolean startOfLine = true;
        int i = 0;
        while (i < elems.length) {
            if (j == 1) {
                this.print("");
            } else {
                this._print("  ");
            }
            this._print("case " + this.getValueString(elems[i]) + ":");
            if (j == wrap) {
                this._println("");
                startOfLine = true;
                j = 1;
            } else {
                ++j;
                startOfLine = false;
            }
            ++i;
        }
        if (!startOfLine) {
            this._println("");
        }
    }

    public JavaBlockFinishingInfo genCommonBlock(AlternativeBlock blk, boolean noTestForSingle) {
        int startDepth;
        int nIF = 0;
        boolean createdLL1Switch = false;
        int closingBracesOfIFSequence = 0;
        JavaBlockFinishingInfo finishingInfo = new JavaBlockFinishingInfo();
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genCommonBlock(" + blk + ")");
        }
        boolean savegenAST = this.genAST;
        this.genAST = this.genAST && blk.getAutoGen();
        boolean oldsaveTest = this.saveText;
        boolean bl = this.saveText = this.saveText && blk.getAutoGen();
        if (blk.not && this.analyzer.subruleCanBeInverted(blk, this.grammar instanceof LexerGrammar)) {
            if (this.DEBUG_CODE_GENERATOR) {
                System.out.println("special case: ~(subrule)");
            }
            Lookahead p = this.analyzer.look(1, blk);
            if (blk.getLabel() != null && this.syntacticPredLevel == 0) {
                this.println(blk.getLabel() + " = " + this.lt1Value + ";");
            }
            this.genElementAST(blk);
            String astArgs = "";
            if (this.grammar instanceof TreeWalkerGrammar) {
                astArgs = "_t,";
            }
            this.println("match(" + astArgs + this.getBitsetName(this.markBitsetForGen(p.fset)) + ");");
            if (this.grammar instanceof TreeWalkerGrammar) {
                this.println("_t = _t.getNextSibling();");
            }
            return finishingInfo;
        }
        if (blk.getAlternatives().size() == 1) {
            Alternative alt = blk.getAlternativeAt(0);
            if (alt.synPred != null) {
                Tool.warning("Syntactic predicate superfluous for single alternative", this.grammar.getFilename(), blk.getAlternativeAt((int)0).synPred.getLine());
            }
            if (noTestForSingle) {
                if (alt.semPred != null) {
                    this.genSemPred(alt.semPred, blk.line);
                }
                this.genAlt(alt, blk);
                return finishingInfo;
            }
        }
        int nLL1 = 0;
        int i = 0;
        while (i < blk.getAlternatives().size()) {
            Alternative a = blk.getAlternativeAt(i);
            if (JavaCodeGenerator.suitableForCaseExpression(a)) {
                ++nLL1;
            }
            ++i;
        }
        if (nLL1 >= this.makeSwitchThreshold) {
            String testExpr = this.lookaheadString(1);
            createdLL1Switch = true;
            if (this.grammar instanceof TreeWalkerGrammar) {
                this.println("if (_t==null) _t=ASTNULL;");
            }
            this.println("switch ( " + testExpr + ") {");
            int i2 = 0;
            while (i2 < blk.alternatives.size()) {
                Alternative alt = blk.getAlternativeAt(i2);
                if (JavaCodeGenerator.suitableForCaseExpression(alt)) {
                    Lookahead p = alt.cache[1];
                    if (p.fset.degree() == 0 && !p.containsEpsilon()) {
                        Tool.warning("Alternate omitted due to empty prediction set", this.grammar.getFilename(), alt.head.getLine());
                    } else {
                        this.genCases(p.fset);
                        this.println("{");
                        ++this.tabs;
                        this.genAlt(alt, blk);
                        this.println("break;");
                        --this.tabs;
                        this.println("}");
                    }
                }
                ++i2;
            }
            this.println("default:");
            ++this.tabs;
        }
        int altDepth = startDepth = this.grammar instanceof LexerGrammar ? this.grammar.maxk : 0;
        while (altDepth >= 0) {
            if (this.DEBUG_CODE_GENERATOR) {
                System.out.println("checking depth " + altDepth);
            }
            int i3 = 0;
            while (i3 < blk.alternatives.size()) {
                block46: {
                    String e;
                    boolean unpredicted;
                    Alternative alt;
                    block49: {
                        block47: {
                            int effectiveDepth;
                            block48: {
                                block45: {
                                    alt = blk.getAlternativeAt(i3);
                                    if (this.DEBUG_CODE_GENERATOR) {
                                        System.out.println("genAlt: " + i3);
                                    }
                                    if (!createdLL1Switch || !JavaCodeGenerator.suitableForCaseExpression(alt)) break block45;
                                    if (this.DEBUG_CODE_GENERATOR) {
                                        System.out.println("ignoring alt because it was in the switch");
                                    }
                                    break block46;
                                }
                                unpredicted = false;
                                if (!(this.grammar instanceof LexerGrammar)) break block47;
                                effectiveDepth = alt.lookaheadDepth;
                                if (effectiveDepth == Integer.MAX_VALUE) {
                                    effectiveDepth = this.grammar.maxk;
                                }
                                while (effectiveDepth >= 1 && alt.cache[effectiveDepth].containsEpsilon()) {
                                    --effectiveDepth;
                                }
                                if (effectiveDepth == altDepth) break block48;
                                if (this.DEBUG_CODE_GENERATOR) {
                                    System.out.println("ignoring alt because effectiveDepth!=altDepth;" + effectiveDepth + "!=" + altDepth);
                                }
                                break block46;
                            }
                            unpredicted = this.lookaheadIsEmpty(alt, effectiveDepth);
                            e = this.getLookaheadTestExpression(alt, effectiveDepth);
                            break block49;
                        }
                        unpredicted = this.lookaheadIsEmpty(alt, this.grammar.maxk);
                        e = this.getLookaheadTestExpression(alt, this.grammar.maxk);
                    }
                    if (alt.cache[1].fset.degree() > 127 && alt.semPred == null && alt.synPred == null) {
                        if (nIF == 0) {
                            this.println("if " + e + " {");
                        } else {
                            this.println("else if " + e + " {");
                        }
                    } else if (unpredicted && alt.semPred == null && alt.synPred == null) {
                        if (nIF == 0) {
                            this.println("{");
                        } else {
                            this.println("else {");
                        }
                        finishingInfo.needAnErrorClause = false;
                    } else {
                        if (alt.semPred != null) {
                            ActionTransInfo tInfo = new ActionTransInfo();
                            String actionStr = this.processActionForTreeSpecifiers(alt.semPred, blk.line, this.currentRule, tInfo);
                            e = (this.grammar instanceof ParserGrammar || this.grammar instanceof LexerGrammar) && this.grammar.debuggingOutput ? "(" + e + "&& fireSemanticPredicateEvaluated(antlr.debug.SemanticPredicateEvent.PREDICTING," + this.addSemPred(this.charFormatter.escapeString(actionStr)) + "," + actionStr + "))" : "(" + e + "&&(" + actionStr + "))";
                        }
                        if (nIF > 0) {
                            if (alt.synPred != null) {
                                this.println("else {");
                                ++this.tabs;
                                this.genSynPred(alt.synPred, e);
                                ++closingBracesOfIFSequence;
                            } else {
                                this.println("else if " + e + " {");
                            }
                        } else if (alt.synPred != null) {
                            this.genSynPred(alt.synPred, e);
                        } else {
                            if (this.grammar instanceof TreeWalkerGrammar) {
                                this.println("if (_t==null) _t=ASTNULL;");
                            }
                            this.println("if " + e + " {");
                        }
                    }
                    ++nIF;
                    ++this.tabs;
                    this.genAlt(alt, blk);
                    --this.tabs;
                    this.println("}");
                }
                ++i3;
            }
            --altDepth;
        }
        String ps = "";
        int i4 = 1;
        while (i4 <= closingBracesOfIFSequence) {
            ps = ps + "}";
            ++i4;
        }
        this.genAST = savegenAST;
        this.saveText = oldsaveTest;
        if (createdLL1Switch) {
            --this.tabs;
            finishingInfo.postscript = ps + "}";
            finishingInfo.generatedSwitch = true;
            finishingInfo.generatedAnIf = nIF > 0;
        } else {
            finishingInfo.postscript = ps;
            finishingInfo.generatedSwitch = false;
            finishingInfo.generatedAnIf = nIF > 0;
        }
        return finishingInfo;
    }

    private static boolean suitableForCaseExpression(Alternative a) {
        return a.lookaheadDepth == 1 && a.semPred == null && !a.cache[1].containsEpsilon() && a.cache[1].fset.degree() <= 127;
    }

    private void genElementAST(AlternativeElement el) {
        if (this.grammar instanceof TreeWalkerGrammar && !this.grammar.buildAST) {
            if (el.getLabel() == null) {
                String elementRef = this.lt1Value;
                String astName = "tmp" + this.astVarNumber + "_AST";
                ++this.astVarNumber;
                this.mapTreeVariable(el, astName);
                this.println(this.labeledElementASTType + " " + astName + "_in = " + elementRef + ";");
            }
            return;
        }
        if (this.grammar.buildAST && this.syntacticPredLevel == 0) {
            String astName;
            String elementRef;
            boolean doNoGuessTest;
            boolean bl = doNoGuessTest = this.grammar.hasSyntacticPredicate && (el.getLabel() != null || el.getAutoGenType() != 3);
            if (el.getLabel() != null) {
                elementRef = el.getLabel();
                astName = el.getLabel() + "_AST";
            } else {
                elementRef = this.lt1Value;
                astName = "tmp" + this.astVarNumber + "_AST";
                ++this.astVarNumber;
                if (el instanceof GrammarAtom) {
                    GrammarAtom ga = (GrammarAtom)el;
                    if (ga.getASTNodeType() != null) {
                        this.println(ga.getASTNodeType() + " " + astName + " = null;");
                    } else {
                        this.println(this.labeledElementASTType + " " + astName + " = null;");
                    }
                } else {
                    this.println(this.labeledElementASTType + " " + astName + " = null;");
                }
                this.mapTreeVariable(el, astName);
                if (this.grammar instanceof TreeWalkerGrammar) {
                    this.println(this.labeledElementASTType + " " + astName + "_in = null;");
                }
            }
            if (doNoGuessTest) {
                this.println("if (inputState.guessing==0) {");
                ++this.tabs;
            }
            if (el.getLabel() != null) {
                if (el instanceof GrammarAtom) {
                    this.println(astName + " = " + this.getASTCreateString((GrammarAtom)el, elementRef) + ";");
                } else {
                    this.println(astName + " = " + this.getASTCreateString(elementRef) + ";");
                }
            } else {
                elementRef = this.lt1Value;
                if (el instanceof GrammarAtom) {
                    this.println(astName + " = " + this.getASTCreateString((GrammarAtom)el, elementRef) + ";");
                } else {
                    this.println(astName + " = " + this.getASTCreateString(elementRef) + ";");
                }
                if (this.grammar instanceof TreeWalkerGrammar) {
                    this.println(astName + "_in = " + elementRef + ";");
                }
            }
            if (this.genAST) {
                switch (el.getAutoGenType()) {
                    case 1: {
                        this.println("astFactory.addASTChild(currentAST, " + astName + ");");
                        break;
                    }
                    case 2: {
                        this.println("astFactory.makeASTRoot(currentAST, " + astName + ");");
                        break;
                    }
                }
            }
            if (doNoGuessTest) {
                --this.tabs;
                this.println("}");
            }
        }
    }

    private void genErrorCatchForElement(AlternativeElement el) {
        ExceptionSpec ex;
        RuleSymbol rs;
        if (el.getLabel() == null) {
            return;
        }
        String r = el.enclosingRuleName;
        if (this.grammar instanceof LexerGrammar) {
            r = CodeGenerator.lexerRuleName(el.enclosingRuleName);
        }
        if ((rs = (RuleSymbol)this.grammar.getSymbol(r)) == null) {
            Tool.panic("Enclosing rule not found!");
        }
        if ((ex = rs.block.findExceptionSpec(el.getLabel())) != null) {
            --this.tabs;
            this.println("}");
            this.genErrorHandler(ex);
        }
    }

    private void genErrorHandler(ExceptionSpec ex) {
        int i = 0;
        while (i < ex.handlers.size()) {
            ExceptionHandler handler = (ExceptionHandler)ex.handlers.elementAt(i);
            this.println("catch (" + handler.exceptionTypeAndName.getText() + ") {");
            ++this.tabs;
            if (this.grammar.hasSyntacticPredicate) {
                this.println("if (inputState.guessing==0) {");
                ++this.tabs;
            }
            this.printAction(this.processActionForTreeSpecifiers(handler.action.getText(), 0, this.currentRule, null));
            if (this.grammar.hasSyntacticPredicate) {
                --this.tabs;
                this.println("} else {");
                ++this.tabs;
                this.println("throw " + this.extractIdOfAction(handler.exceptionTypeAndName) + ";");
                --this.tabs;
                this.println("}");
            }
            --this.tabs;
            this.println("}");
            ++i;
        }
    }

    private void genErrorTryForElement(AlternativeElement el) {
        ExceptionSpec ex;
        RuleSymbol rs;
        if (el.getLabel() == null) {
            return;
        }
        String r = el.enclosingRuleName;
        if (this.grammar instanceof LexerGrammar) {
            r = CodeGenerator.lexerRuleName(el.enclosingRuleName);
        }
        if ((rs = (RuleSymbol)this.grammar.getSymbol(r)) == null) {
            Tool.panic("Enclosing rule not found!");
        }
        if ((ex = rs.block.findExceptionSpec(el.getLabel())) != null) {
            this.println("try { // for error handling");
            ++this.tabs;
        }
    }

    protected void genHeader() {
        this.println("// $ANTLR 2.7.1: \"" + Tool.fileMinusPath(this.tool.grammarFile) + "\"" + " -> " + "\"" + this.grammar.getClassName() + ".java\"$");
    }

    private void genLiteralsTest() {
        this.println("_ttype = testLiteralsTable(_ttype);");
    }

    private void genLiteralsTestForPartialToken() {
        this.println("_ttype = testLiteralsTable(new String(text.getBuffer(),_begin,text.length()-_begin),_ttype);");
    }

    protected void genMatch(BitSet b) {
    }

    protected void genMatch(GrammarAtom atom) {
        if (atom instanceof StringLiteralElement) {
            if (this.grammar instanceof LexerGrammar) {
                this.genMatchUsingAtomText(atom);
            } else {
                this.genMatchUsingAtomTokenType(atom);
            }
        } else if (atom instanceof CharLiteralElement) {
            if (this.grammar instanceof LexerGrammar) {
                this.genMatchUsingAtomText(atom);
            } else {
                this.tool.error("cannot ref character literals in grammar: " + atom);
            }
        } else if (atom instanceof TokenRefElement) {
            this.genMatchUsingAtomText(atom);
        }
    }

    protected void genMatchUsingAtomText(GrammarAtom atom) {
        String astArgs = "";
        if (this.grammar instanceof TreeWalkerGrammar) {
            astArgs = "_t,";
        }
        if (this.grammar instanceof LexerGrammar && (!this.saveText || atom.getAutoGenType() == 3)) {
            this.println("_saveIndex=text.length();");
        }
        this.print(atom.not ? "matchNot(" : "match(");
        this._print(astArgs);
        if (atom.atomText.equals("EOF")) {
            this._print("Token.EOF_TYPE");
        } else {
            this._print(atom.atomText);
        }
        this._println(");");
        if (this.grammar instanceof LexerGrammar && (!this.saveText || atom.getAutoGenType() == 3)) {
            this.println("text.setLength(_saveIndex);");
        }
    }

    protected void genMatchUsingAtomTokenType(GrammarAtom atom) {
        String astArgs = "";
        if (this.grammar instanceof TreeWalkerGrammar) {
            astArgs = "_t,";
        }
        Object mangledName = null;
        String s = astArgs + this.getValueString(atom.getType());
        this.println((atom.not ? "matchNot(" : "match(") + s + ");");
    }

    public void genNextToken() {
        boolean hasPublicRules = false;
        int i = 0;
        while (i < this.grammar.rules.size()) {
            RuleSymbol rs = (RuleSymbol)this.grammar.rules.elementAt(i);
            if (rs.isDefined() && rs.access.equals("public")) {
                hasPublicRules = true;
                break;
            }
            ++i;
        }
        if (!hasPublicRules) {
            this.println("");
            this.println("public Token nextToken() throws TokenStreamException {");
            this.println("\ttry {uponEOF();}");
            this.println("\tcatch(CharStreamIOException csioe) {");
            this.println("\t\tthrow new TokenStreamIOException(csioe.io);");
            this.println("\t}");
            this.println("\tcatch(CharStreamException cse) {");
            this.println("\t\tthrow new TokenStreamException(cse.getMessage());");
            this.println("\t}");
            this.println("\treturn new CommonToken(Token.EOF_TYPE, \"\");");
            this.println("}");
            this.println("");
            return;
        }
        RuleBlock nextTokenBlk = MakeGrammar.createNextTokenRule(this.grammar, this.grammar.rules, "nextToken");
        RuleSymbol nextTokenRs = new RuleSymbol("mnextToken");
        nextTokenRs.setDefined();
        nextTokenRs.setBlock(nextTokenBlk);
        nextTokenRs.access = "private";
        this.grammar.define(nextTokenRs);
        boolean ok = this.grammar.theLLkAnalyzer.deterministic(nextTokenBlk);
        String filterRule = null;
        if (((LexerGrammar)this.grammar).filterMode) {
            filterRule = ((LexerGrammar)this.grammar).filterRule;
        }
        this.println("");
        this.println("public Token nextToken() throws TokenStreamException {");
        ++this.tabs;
        this.println("Token theRetToken=null;");
        this._println("tryAgain:");
        this.println("for (;;) {");
        ++this.tabs;
        this.println("Token _token = null;");
        this.println("int _ttype = Token.INVALID_TYPE;");
        if (((LexerGrammar)this.grammar).filterMode) {
            this.println("setCommitToPath(false);");
            if (filterRule != null) {
                if (!this.grammar.isDefined(CodeGenerator.lexerRuleName(filterRule))) {
                    this.grammar.tool.error("Filter rule " + filterRule + " does not exist in this lexer");
                } else {
                    RuleSymbol rs = (RuleSymbol)this.grammar.getSymbol(CodeGenerator.lexerRuleName(filterRule));
                    if (!rs.isDefined()) {
                        this.grammar.tool.error("Filter rule " + filterRule + " does not exist in this lexer");
                    } else if (rs.access.equals("public")) {
                        this.grammar.tool.error("Filter rule " + filterRule + " must be protected");
                    }
                }
                this.println("int _m;");
                this.println("_m = mark();");
            }
        }
        this.println("resetText();");
        this.println("try {   // for char stream error handling");
        ++this.tabs;
        this.println("try {   // for lexical error handling");
        ++this.tabs;
        int i2 = 0;
        while (i2 < nextTokenBlk.getAlternatives().size()) {
            Alternative a = nextTokenBlk.getAlternativeAt(i2);
            if (a.cache[1].containsEpsilon()) {
                Tool.warning("found optional path in nextToken()");
            }
            ++i2;
        }
        String newline = System.getProperty("line.separator");
        JavaBlockFinishingInfo howToFinish = this.genCommonBlock(nextTokenBlk, false);
        String errFinish = "if (LA(1)==EOF_CHAR) {uponEOF(); _returnToken = makeToken(Token.EOF_TYPE);}";
        errFinish = errFinish + newline + "\t\t\t\t";
        errFinish = ((LexerGrammar)this.grammar).filterMode ? (filterRule == null ? errFinish + "else {consume(); continue tryAgain;}" : errFinish + "else {" + newline + "\t\t\t\t\tcommit();" + newline + "\t\t\t\t\ttry {m" + filterRule + "(false);}" + newline + "\t\t\t\t\tcatch(RecognitionException e) {" + newline + "\t\t\t\t\t\t// catastrophic failure" + newline + "\t\t\t\t\t\treportError(e);" + newline + "\t\t\t\t\t\tconsume();" + newline + "\t\t\t\t\t}" + newline + "\t\t\t\t\tcontinue tryAgain;" + newline + "\t\t\t\t}") : errFinish + "else {" + this.throwNoViable + "}";
        this.genBlockFinish(howToFinish, errFinish);
        if (((LexerGrammar)this.grammar).filterMode && filterRule != null) {
            this.println("commit();");
        }
        this.println("if ( _returnToken==null ) continue tryAgain; // found SKIP token");
        this.println("_ttype = _returnToken.getType();");
        if (((LexerGrammar)this.grammar).getTestLiterals()) {
            this.genLiteralsTest();
        }
        this.println("_returnToken.setType(_ttype);");
        this.println("return _returnToken;");
        --this.tabs;
        this.println("}");
        this.println("catch (RecognitionException e) {");
        ++this.tabs;
        if (((LexerGrammar)this.grammar).filterMode) {
            if (filterRule == null) {
                this.println("if ( !getCommitToPath() ) {consume(); continue tryAgain;}");
            } else {
                this.println("if ( !getCommitToPath() ) {");
                ++this.tabs;
                this.println("rewind(_m);");
                this.println("resetText();");
                this.println("try {m" + filterRule + "(false);}");
                this.println("catch(RecognitionException ee) {");
                this.println("\t// horrendous failure: error in filter rule");
                this.println("\treportError(ee);");
                this.println("\tconsume();");
                this.println("}");
                this.println("continue tryAgain;");
                --this.tabs;
                this.println("}");
            }
        }
        if (nextTokenBlk.getDefaultErrorHandler()) {
            this.println("reportError(e);");
            this.println("consume();");
        } else {
            this.println("throw new TokenStreamRecognitionException(e);");
        }
        --this.tabs;
        this.println("}");
        --this.tabs;
        this.println("}");
        this.println("catch (CharStreamException cse) {");
        this.println("\tif ( cse instanceof CharStreamIOException ) {");
        this.println("\t\tthrow new TokenStreamIOException(((CharStreamIOException)cse).io);");
        this.println("\t}");
        this.println("\telse {");
        this.println("\t\tthrow new TokenStreamException(cse.getMessage());");
        this.println("\t}");
        this.println("}");
        --this.tabs;
        this.println("}");
        --this.tabs;
        this.println("}");
        this.println("");
    }

    public void genRule(RuleSymbol s, boolean startSymbol, int ruleNum) {
        RuleBlock rblk;
        this.tabs = 1;
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("genRule(" + s.getId() + ")");
        }
        if (!s.isDefined()) {
            this.tool.error("undefined rule: " + s.getId());
            return;
        }
        this.currentRule = rblk = s.getBlock();
        this.currentASTResult = s.getId();
        boolean savegenAST = this.genAST;
        this.genAST = this.genAST && rblk.getAutoGen();
        this.saveText = rblk.getAutoGen();
        if (s.comment != null) {
            this._println(s.comment);
        }
        this.print(s.access + " final ");
        if (rblk.returnAction != null) {
            this._print(this.extractTypeOfAction(rblk.returnAction, rblk.getLine()) + " ");
        } else {
            this._print("void ");
        }
        this._print(s.getId() + "(");
        this._print(this.commonExtraParams);
        if (this.commonExtraParams.length() != 0 && rblk.argAction != null) {
            this._print(",");
        }
        if (rblk.argAction != null) {
            this._println("");
            ++this.tabs;
            this.println(rblk.argAction);
            --this.tabs;
            this.print(")");
        } else {
            this._print(")");
        }
        this._print(" throws " + this.exceptionThrown);
        if (this.grammar instanceof ParserGrammar) {
            this._print(", TokenStreamException");
        } else if (this.grammar instanceof LexerGrammar) {
            this._print(", CharStreamException, TokenStreamException");
        }
        if (rblk.throwsSpec != null) {
            if (this.grammar instanceof LexerGrammar) {
                this.tool.error("user-defined throws spec not allowed (yet) for lexer rule " + rblk.ruleName);
            } else {
                this._print(", " + rblk.throwsSpec);
            }
        }
        this._println(" {");
        ++this.tabs;
        if (rblk.returnAction != null) {
            this.println(rblk.returnAction + ";");
        }
        this.println(this.commonLocalVars);
        if (this.grammar.traceRules) {
            if (this.grammar instanceof TreeWalkerGrammar) {
                this.println("traceIn(\"" + s.getId() + "\",_t);");
            } else {
                this.println("traceIn(\"" + s.getId() + "\");");
            }
        }
        if (this.grammar instanceof LexerGrammar) {
            if (s.getId().equals("mEOF")) {
                this.println("_ttype = Token.EOF_TYPE;");
            } else {
                this.println("_ttype = " + s.getId().substring(1) + ";");
            }
            this.println("int _saveIndex;");
        }
        if (this.grammar.debuggingOutput) {
            if (this.grammar instanceof ParserGrammar) {
                this.println("fireEnterRule(" + ruleNum + ",0);");
            } else if (this.grammar instanceof LexerGrammar) {
                this.println("fireEnterRule(" + ruleNum + ",_ttype);");
            }
        }
        if (this.grammar.debuggingOutput || this.grammar.traceRules) {
            this.println("try { // debugging");
            ++this.tabs;
        }
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println(this.labeledElementASTType + " " + s.getId() + "_AST_in = (" + this.labeledElementASTType + ")_t;");
        }
        if (this.grammar.buildAST) {
            this.println("returnAST = null;");
            this.println("ASTPair currentAST = new ASTPair();");
            this.println(this.labeledElementASTType + " " + s.getId() + "_AST = null;");
        }
        this.genBlockPreamble(rblk);
        this.println("");
        ExceptionSpec unlabeledUserSpec = rblk.findExceptionSpec("");
        if (unlabeledUserSpec != null || rblk.getDefaultErrorHandler()) {
            this.println("try {      // for error handling");
            ++this.tabs;
        }
        if (rblk.alternatives.size() == 1) {
            Alternative alt = rblk.getAlternativeAt(0);
            String pred = alt.semPred;
            if (pred != null) {
                this.genSemPred(pred, this.currentRule.line);
            }
            if (alt.synPred != null) {
                Tool.warning("Syntactic predicate ignored for single alternative", this.grammar.getFilename(), alt.synPred.getLine());
            }
            this.genAlt(alt, rblk);
        } else {
            boolean ok = this.grammar.theLLkAnalyzer.deterministic(rblk);
            JavaBlockFinishingInfo howToFinish = this.genCommonBlock(rblk, false);
            this.genBlockFinish(howToFinish, this.throwNoViable);
        }
        if (unlabeledUserSpec != null || rblk.getDefaultErrorHandler()) {
            --this.tabs;
            this.println("}");
        }
        if (unlabeledUserSpec != null) {
            this.genErrorHandler(unlabeledUserSpec);
        } else if (rblk.getDefaultErrorHandler()) {
            this.println("catch (" + this.exceptionThrown + " ex) {");
            ++this.tabs;
            if (this.grammar.hasSyntacticPredicate) {
                this.println("if (inputState.guessing==0) {");
                ++this.tabs;
            }
            this.println("reportError(ex);");
            if (!(this.grammar instanceof TreeWalkerGrammar)) {
                Lookahead follow = this.grammar.theLLkAnalyzer.FOLLOW(1, rblk.endNode);
                String followSetName = this.getBitsetName(this.markBitsetForGen(follow.fset));
                this.println("consume();");
                this.println("consumeUntil(" + followSetName + ");");
            } else {
                this.println("if (_t!=null) {_t = _t.getNextSibling();}");
            }
            if (this.grammar.hasSyntacticPredicate) {
                --this.tabs;
                this.println("} else {");
                this.println("  throw ex;");
                this.println("}");
            }
            --this.tabs;
            this.println("}");
        }
        if (this.grammar.buildAST) {
            this.println("returnAST = " + s.getId() + "_AST;");
        }
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("_retTree = _t;");
        }
        if (rblk.getTestLiterals()) {
            if (s.access.equals("protected")) {
                this.genLiteralsTestForPartialToken();
            } else {
                this.genLiteralsTest();
            }
        }
        if (this.grammar instanceof LexerGrammar) {
            this.println("if ( _createToken && _token==null && _ttype!=Token.SKIP ) {");
            this.println("\t_token = makeToken(_ttype);");
            this.println("\t_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));");
            this.println("}");
            this.println("_returnToken = _token;");
        }
        if (rblk.returnAction != null) {
            this.println("return " + this.extractIdOfAction(rblk.returnAction, rblk.getLine()) + ";");
        }
        if (this.grammar.debuggingOutput || this.grammar.traceRules) {
            --this.tabs;
            this.println("} finally { // debugging");
            ++this.tabs;
            if (this.grammar.debuggingOutput) {
                if (this.grammar instanceof ParserGrammar) {
                    this.println("fireExitRule(" + ruleNum + ",0);");
                } else if (this.grammar instanceof LexerGrammar) {
                    this.println("fireExitRule(" + ruleNum + ",_ttype);");
                }
            }
            if (this.grammar.traceRules) {
                if (this.grammar instanceof TreeWalkerGrammar) {
                    this.println("traceOut(\"" + s.getId() + "\",_t);");
                } else {
                    this.println("traceOut(\"" + s.getId() + "\");");
                }
            }
            --this.tabs;
            this.println("}");
        }
        --this.tabs;
        this.println("}");
        this.println("");
        this.genAST = savegenAST;
    }

    private void GenRuleInvocation(RuleRefElement rr) {
        this._print(rr.targetRule + "(");
        if (this.grammar instanceof LexerGrammar) {
            if (rr.getLabel() != null) {
                this._print("true");
            } else {
                this._print("false");
            }
            if (this.commonExtraArgs.length() != 0 || rr.args != null) {
                this._print(",");
            }
        }
        this._print(this.commonExtraArgs);
        if (this.commonExtraArgs.length() != 0 && rr.args != null) {
            this._print(",");
        }
        RuleSymbol rs = (RuleSymbol)this.grammar.getSymbol(rr.targetRule);
        if (rr.args != null) {
            ActionTransInfo tInfo = new ActionTransInfo();
            String args = this.processActionForTreeSpecifiers(rr.args, 0, this.currentRule, tInfo);
            if (tInfo.assignToRoot || tInfo.refRuleRoot != null) {
                this.tool.error("Arguments of rule reference '" + rr.targetRule + "' cannot set or ref #" + this.currentRule.getRuleName() + " on line " + rr.getLine());
            }
            this._print(args);
            if (rs.block.argAction == null) {
                Tool.warning("Rule '" + rr.targetRule + "' accepts no arguments", this.grammar.getFilename(), rr.getLine());
            }
        } else if (rs.block.argAction != null) {
            Tool.warning("Missing parameters on reference to rule " + rr.targetRule, this.grammar.getFilename(), rr.getLine());
        }
        this._println(");");
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("_t = _retTree;");
        }
    }

    protected void genSemPred(String pred, int line) {
        ActionTransInfo tInfo = new ActionTransInfo();
        pred = this.processActionForTreeSpecifiers(pred, line, this.currentRule, tInfo);
        String escapedPred = this.charFormatter.escapeString(pred);
        if (this.grammar.debuggingOutput && (this.grammar instanceof ParserGrammar || this.grammar instanceof LexerGrammar)) {
            pred = "fireSemanticPredicateEvaluated(antlr.debug.SemanticPredicateEvent.VALIDATING," + this.addSemPred(escapedPred) + "," + pred + ")";
        }
        this.println("if (!(" + pred + "))");
        this.println("  throw new SemanticException(\"" + escapedPred + "\");");
    }

    protected void genSemPredMap() {
        Enumeration e = this.semPreds.elements();
        this.println("private String _semPredNames[] = {");
        while (e.hasMoreElements()) {
            this.println("\"" + e.nextElement() + "\",");
        }
        this.println("};");
    }

    protected void genSynPred(SynPredBlock blk, String lookaheadExpr) {
        if (this.DEBUG_CODE_GENERATOR) {
            System.out.println("gen=>(" + blk + ")");
        }
        this.println("boolean synPredMatched" + blk.ID + " = false;");
        this.println("if (" + lookaheadExpr + ") {");
        ++this.tabs;
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("AST __t" + blk.ID + " = _t;");
        } else {
            this.println("int _m" + blk.ID + " = mark();");
        }
        this.println("synPredMatched" + blk.ID + " = true;");
        this.println("inputState.guessing++;");
        if (this.grammar.debuggingOutput && (this.grammar instanceof ParserGrammar || this.grammar instanceof LexerGrammar)) {
            this.println("fireSyntacticPredicateStarted();");
        }
        ++this.syntacticPredLevel;
        this.println("try {");
        ++this.tabs;
        this.gen(blk);
        --this.tabs;
        this.println("}");
        this.println("catch (" + this.exceptionThrown + " pe) {");
        ++this.tabs;
        this.println("synPredMatched" + blk.ID + " = false;");
        --this.tabs;
        this.println("}");
        if (this.grammar instanceof TreeWalkerGrammar) {
            this.println("_t = __t" + blk.ID + ";");
        } else {
            this.println("rewind(_m" + blk.ID + ");");
        }
        this.println("inputState.guessing--;");
        if (this.grammar.debuggingOutput && (this.grammar instanceof ParserGrammar || this.grammar instanceof LexerGrammar)) {
            this.println("if (synPredMatched" + blk.ID + ")");
            this.println("  fireSyntacticPredicateSucceeded();");
            this.println("else");
            this.println("  fireSyntacticPredicateFailed();");
        }
        --this.syntacticPredLevel;
        --this.tabs;
        this.println("}");
        this.println("if ( synPredMatched" + blk.ID + " ) {");
    }

    public void genTokenStrings() {
        this.println("");
        this.println("public static final String[] _tokenNames = {");
        ++this.tabs;
        Vector v = this.grammar.tokenManager.getVocabulary();
        int i = 0;
        while (i < v.size()) {
            TokenSymbol ts;
            String s = (String)v.elementAt(i);
            if (s == null) {
                s = "<" + String.valueOf(i) + ">";
            }
            if (!s.startsWith("\"") && !s.startsWith("<") && (ts = this.grammar.tokenManager.getTokenSymbol(s)) != null && ts.getParaphrase() != null) {
                s = Tool.stripFrontBack(ts.getParaphrase(), "\"", "\"");
            }
            this.print(this.charFormatter.literalString(s));
            if (i != v.size() - 1) {
                this._print(",");
            }
            this._println("");
            ++i;
        }
        --this.tabs;
        this.println("};");
    }

    protected void genTokenTypes(TokenManager tm) throws IOException {
        this.setupOutput(tm.getName() + CodeGenerator.TokenTypesFileSuffix);
        this.tabs = 0;
        this.genHeader();
        this.println(this.behavior.getHeaderAction(""));
        this.println("public interface " + tm.getName() + CodeGenerator.TokenTypesFileSuffix + " {");
        ++this.tabs;
        Vector v = tm.getVocabulary();
        this.println("int EOF = 1;");
        this.println("int NULL_TREE_LOOKAHEAD = 3;");
        int i = 4;
        while (i < v.size()) {
            String s = (String)v.elementAt(i);
            if (s != null) {
                if (s.startsWith("\"")) {
                    StringLiteralSymbol sl = (StringLiteralSymbol)tm.getTokenSymbol(s);
                    if (sl == null) {
                        Tool.panic("String literal " + s + " not in symbol table");
                    } else if (sl.label != null) {
                        this.println("int " + sl.label + " = " + i + ";");
                    } else {
                        String mangledName = this.mangleLiteral(s);
                        if (mangledName != null) {
                            this.println("int " + mangledName + " = " + i + ";");
                            sl.label = mangledName;
                        } else {
                            this.println("// " + s + " = " + i);
                        }
                    }
                } else if (!s.startsWith("<")) {
                    this.println("int " + s + " = " + i + ";");
                }
            }
            ++i;
        }
        --this.tabs;
        this.println("}");
        this.currentOutput.close();
        this.currentOutput = null;
        this.exitIfError();
    }

    public String getASTCreateString(Vector v) {
        if (v.size() == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        buf.append("(" + this.labeledElementASTType + ")astFactory.make( (new ASTArray(" + v.size() + "))");
        int i = 0;
        while (i < v.size()) {
            buf.append(".add(" + v.elementAt(i) + ")");
            ++i;
        }
        buf.append(")");
        return buf.toString();
    }

    public String getASTCreateString(GrammarAtom atom, String str) {
        if (atom != null && atom.getASTNodeType() != null) {
            return "new " + atom.getASTNodeType() + "(" + str + ")";
        }
        return "(" + this.labeledElementASTType + ")astFactory.create(" + str + ")";
    }

    public String getASTCreateString(String str) {
        return "(" + this.labeledElementASTType + ")astFactory.create(" + str + ")";
    }

    protected String getLookaheadTestExpression(Lookahead[] look, int k) {
        StringBuffer e = new StringBuffer(100);
        boolean first = true;
        e.append("(");
        int i = 1;
        while (i <= k) {
            BitSet p = look[i].fset;
            if (!first) {
                e.append(") && (");
            }
            first = false;
            if (look[i].containsEpsilon()) {
                e.append("true");
            } else {
                e.append(this.getLookaheadTestTerm(i, p));
            }
            ++i;
        }
        e.append(")");
        return e.toString();
    }

    protected String getLookaheadTestExpression(Alternative alt, int maxDepth) {
        int depth = alt.lookaheadDepth;
        if (depth == Integer.MAX_VALUE) {
            depth = this.grammar.maxk;
        }
        if (maxDepth == 0) {
            return "true";
        }
        return "(" + this.getLookaheadTestExpression(alt.cache, depth) + ")";
    }

    protected String getLookaheadTestTerm(int k, BitSet p) {
        String ts = this.lookaheadString(k);
        int[] elems = p.toArray();
        if (CodeGenerator.elementsAreRange(elems)) {
            return this.getRangeExpression(k, elems);
        }
        int degree = p.degree();
        if (degree == 0) {
            return "true";
        }
        if (degree >= this.bitsetTestThreshold) {
            int bitsetIdx = this.markBitsetForGen(p);
            return this.getBitsetName(bitsetIdx) + ".member(" + ts + ")";
        }
        StringBuffer e = new StringBuffer();
        int i = 0;
        while (i < elems.length) {
            String cs = this.getValueString(elems[i]);
            if (i > 0) {
                e.append("||");
            }
            e.append(ts);
            e.append("==");
            e.append(cs);
            ++i;
        }
        return e.toString();
    }

    public String getRangeExpression(int k, int[] elems) {
        if (!CodeGenerator.elementsAreRange(elems)) {
            Tool.panic("getRangeExpression called with non-range");
        }
        int begin = elems[0];
        int end = elems[elems.length - 1];
        return "(" + this.lookaheadString(k) + " >= " + this.getValueString(begin) + " && " + this.lookaheadString(k) + " <= " + this.getValueString(end) + ")";
    }

    private String getValueString(int value) {
        String cs;
        if (this.grammar instanceof LexerGrammar) {
            cs = this.charFormatter.literalChar(value);
        } else {
            TokenSymbol ts = this.grammar.tokenManager.getTokenSymbolAt(value);
            if (ts == null) {
                return "" + value;
            }
            String tId = ts.getId();
            if (ts instanceof StringLiteralSymbol) {
                StringLiteralSymbol sl = (StringLiteralSymbol)ts;
                String label = sl.getLabel();
                if (label != null) {
                    cs = label;
                } else {
                    cs = this.mangleLiteral(tId);
                    if (cs == null) {
                        cs = String.valueOf(value);
                    }
                }
            } else {
                cs = tId;
            }
        }
        return cs;
    }

    protected boolean lookaheadIsEmpty(Alternative alt, int maxDepth) {
        int depth = alt.lookaheadDepth;
        if (depth == Integer.MAX_VALUE) {
            depth = this.grammar.maxk;
        }
        int i = 1;
        while (i <= depth && i <= maxDepth) {
            BitSet p = alt.cache[i].fset;
            if (p.degree() != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private String lookaheadString(int k) {
        if (this.grammar instanceof TreeWalkerGrammar) {
            return "_t.getType()";
        }
        return "LA(" + k + ")";
    }

    private String mangleLiteral(String s) {
        String mangled = Tool.literalsPrefix;
        int i = 1;
        while (i < s.length() - 1) {
            if (!Character.isLetter(s.charAt(i)) && s.charAt(i) != '_') {
                return null;
            }
            mangled = mangled + s.charAt(i);
            ++i;
        }
        if (Tool.upperCaseMangledLiterals) {
            mangled = mangled.toUpperCase();
        }
        return mangled;
    }

    public String mapTreeId(String idParam, ActionTransInfo transInfo) {
        if (this.currentRule == null) {
            return idParam;
        }
        boolean in_var = false;
        String id = idParam;
        if (this.grammar instanceof TreeWalkerGrammar) {
            if (!this.grammar.buildAST) {
                in_var = true;
            } else if (id.length() > 3 && id.lastIndexOf("_in") == id.length() - 3) {
                id = id.substring(0, id.length() - 3);
                in_var = true;
            }
        }
        int i = 0;
        while (i < this.currentRule.labeledElements.size()) {
            AlternativeElement elt = (AlternativeElement)this.currentRule.labeledElements.elementAt(i);
            if (elt.getLabel().equals(id)) {
                return in_var ? id : id + "_AST";
            }
            ++i;
        }
        String s = (String)this.treeVariableMap.get(id);
        if (s != null) {
            if (s == NONUNIQUE) {
                return null;
            }
            if (s.equals(this.currentRule.getRuleName())) {
                return null;
            }
            return in_var ? s + "_in" : s;
        }
        if (id.equals(this.currentRule.getRuleName())) {
            String r;
            String string = r = in_var ? id + "_AST_in" : id + "_AST";
            if (transInfo != null && !in_var) {
                transInfo.refRuleRoot = r;
            }
            return r;
        }
        return id;
    }

    private void mapTreeVariable(AlternativeElement e, String name) {
        if (e instanceof TreeElement) {
            this.mapTreeVariable(((TreeElement)e).root, name);
            return;
        }
        String elName = null;
        if (e.getLabel() == null) {
            if (e instanceof TokenRefElement) {
                elName = ((TokenRefElement)e).atomText;
            } else if (e instanceof RuleRefElement) {
                elName = ((RuleRefElement)e).targetRule;
            }
        }
        if (elName != null) {
            if (this.treeVariableMap.get(elName) != null) {
                this.treeVariableMap.remove(elName);
                this.treeVariableMap.put(elName, NONUNIQUE);
            } else {
                this.treeVariableMap.put(elName, name);
            }
        }
    }

    private void setupGrammarParameters(Grammar g) {
        if (g instanceof ParserGrammar) {
            String suffix;
            Token tsuffix;
            this.labeledElementASTType = "AST";
            if (g.hasOption("ASTLabelType") && (tsuffix = g.getOption("ASTLabelType")) != null && (suffix = Tool.stripFrontBack(tsuffix.getText(), "\"", "\"")) != null) {
                this.labeledElementASTType = suffix;
            }
            this.labeledElementType = "Token ";
            this.labeledElementInit = "null";
            this.commonExtraArgs = "";
            this.commonExtraParams = "";
            this.commonLocalVars = "";
            this.lt1Value = "LT(1)";
            this.exceptionThrown = "RecognitionException";
            this.throwNoViable = "throw new NoViableAltException(LT(1), getFilename());";
        } else if (g instanceof LexerGrammar) {
            this.labeledElementType = "char ";
            this.labeledElementInit = "'\\0'";
            this.commonExtraArgs = "";
            this.commonExtraParams = "boolean _createToken";
            this.commonLocalVars = "int _ttype; Token _token=null; int _begin=text.length();";
            this.lt1Value = "LA(1)";
            this.exceptionThrown = "RecognitionException";
            this.throwNoViable = "throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine());";
        } else if (g instanceof TreeWalkerGrammar) {
            String suffix;
            Token tsuffix;
            this.labeledElementASTType = "AST";
            this.labeledElementType = "AST";
            if (g.hasOption("ASTLabelType") && (tsuffix = g.getOption("ASTLabelType")) != null && (suffix = Tool.stripFrontBack(tsuffix.getText(), "\"", "\"")) != null) {
                this.labeledElementASTType = suffix;
                this.labeledElementType = suffix;
            }
            if (!g.hasOption("ASTLabelType")) {
                g.setOption("ASTLabelType", new Token(6, "AST"));
            }
            this.labeledElementInit = "null";
            this.commonExtraArgs = "_t";
            this.commonExtraParams = "AST _t";
            this.commonLocalVars = "";
            this.lt1Value = "(" + this.labeledElementASTType + ")_t";
            this.exceptionThrown = "RecognitionException";
            this.throwNoViable = "throw new NoViableAltException(_t);";
        } else {
            Tool.panic("Unknown grammar type");
        }
    }

    public void setupOutput(String className) throws IOException {
        this.currentOutput = Tool.openOutputFile(className + ".java");
    }
}

