/*
 * Decompiled with CFR 0.152.
 */
package antlr;

import antlr.ActionElement;
import antlr.ActionTransInfo;
import antlr.Alternative;
import antlr.AlternativeBlock;
import antlr.AlternativeElement;
import antlr.BlockEndElement;
import antlr.CharLiteralElement;
import antlr.CharRangeElement;
import antlr.CodeGenerator;
import antlr.Grammar;
import antlr.GrammarAtom;
import antlr.GrammarSymbol;
import antlr.JavaCharFormatter;
import antlr.LexerGrammar;
import antlr.Lookahead;
import antlr.MakeGrammar;
import antlr.OneOrMoreBlock;
import antlr.ParserGrammar;
import antlr.RuleBlock;
import antlr.RuleRefElement;
import antlr.RuleSymbol;
import antlr.StringLiteralElement;
import antlr.SynPredBlock;
import antlr.TokenManager;
import antlr.TokenRangeElement;
import antlr.TokenRefElement;
import antlr.Tool;
import antlr.TreeElement;
import antlr.TreeWalkerGrammar;
import antlr.WildcardElement;
import antlr.ZeroOrMoreBlock;
import antlr.collections.impl.Vector;
import java.io.IOException;
import java.util.Enumeration;

public class HTMLCodeGenerator
extends CodeGenerator {
    protected int syntacticPredLevel = 0;
    protected boolean doingLexRules = false;
    protected boolean firstElementInAlt;
    protected AlternativeElement prevAltElem = null;

    public HTMLCodeGenerator() {
        this.charFormatter = new JavaCharFormatter();
    }

    public void gen() {
        try {
            Enumeration grammarIter = this.behavior.grammars.elements();
            while (grammarIter.hasMoreElements()) {
                Grammar g = (Grammar)grammarIter.nextElement();
                g.setCodeGenerator(this);
                g.generate();
                if (!this.tool.hasError) continue;
                System.out.println("Exiting due to errors.");
                System.exit(1);
            }
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    public void gen(ActionElement action) {
    }

    public void gen(AlternativeBlock blk) {
        this.genGenericBlock(blk, "");
    }

    public void gen(BlockEndElement end) {
    }

    public void gen(CharLiteralElement atom) {
        if (atom.not) {
            this._print("~");
        }
        this._print(atom.atomText + " ");
    }

    public void gen(CharRangeElement r) {
        this.print(r.beginText + ".." + r.endText + " ");
    }

    public void gen(LexerGrammar g) throws IOException {
        this.setGrammar(g);
        System.out.println("Generating " + this.grammar.getClassName() + CodeGenerator.TokenTypesFileExt);
        this.currentOutput = Tool.openOutputFile(this.grammar.getClassName() + CodeGenerator.TokenTypesFileExt);
        this.tabs = 0;
        this.doingLexRules = true;
        this.genHeader();
        this.println("");
        if (this.grammar.comment != null) {
            this._println(this.grammar.comment);
        }
        this.println("class " + this.grammar.getClassName() + " extends " + this.grammar.getSuperClass() + " {");
        this.genNextToken();
        Enumeration ids = this.grammar.rules.elements();
        while (ids.hasMoreElements()) {
            RuleSymbol rs = (RuleSymbol)ids.nextElement();
            if (rs.id.equals("mnextToken")) continue;
            this.genRule(rs);
        }
        this.currentOutput.close();
        this.currentOutput = null;
        this.doingLexRules = false;
    }

    public void gen(OneOrMoreBlock blk) {
        this.genGenericBlock(blk, "+");
    }

    public void gen(ParserGrammar g) throws IOException {
        this.setGrammar(g);
        System.out.println("Generating " + this.grammar.getClassName() + ".html");
        this.currentOutput = Tool.openOutputFile(this.grammar.getClassName() + ".html");
        this.tabs = 0;
        this.genHeader();
        this.println("");
        if (this.grammar.comment != null) {
            this._println(this.grammar.comment);
        }
        this.println("class " + this.grammar.getClassName() + " extends " + this.grammar.getSuperClass());
        Enumeration rules = this.grammar.rules.elements();
        while (rules.hasMoreElements()) {
            this.println("");
            GrammarSymbol sym = (GrammarSymbol)rules.nextElement();
            if (!(sym instanceof RuleSymbol)) continue;
            this.genRule((RuleSymbol)sym);
        }
        --this.tabs;
        this.println("");
        this.genTail();
        this.currentOutput.close();
        this.currentOutput = null;
    }

    public void gen(RuleRefElement rr) {
        RuleSymbol rs = (RuleSymbol)this.grammar.getSymbol(rr.targetRule);
        this._print("<a href=" + this.grammar.getClassName() + ".html#" + rr.targetRule + ">");
        this._print(rr.targetRule);
        this._print("</a>");
        if (rr.args != null) {
            this._print("[" + rr.args + "]");
        }
        this._print(" ");
    }

    public void gen(StringLiteralElement atom) {
        if (atom.not) {
            this._print("~");
        }
        this._print(atom.atomText);
        this._print(" ");
    }

    public void gen(TokenRangeElement r) {
        this.print(r.beginText + ".." + r.endText + " ");
    }

    public void gen(TokenRefElement atom) {
        if (atom.not) {
            this._print("~");
        }
        this._print(atom.atomText);
        this._print(" ");
    }

    public void gen(TreeElement t) {
        this.print(t + " ");
    }

    public void gen(TreeWalkerGrammar g) throws IOException {
        this.setGrammar(g);
        System.out.println("Generating " + this.grammar.getClassName() + ".txt");
        this.currentOutput = Tool.openOutputFile(this.grammar.getClassName() + ".txt");
        this.tabs = 0;
        this.genHeader();
        this.println("");
        this.println("*** Tree-walker Preamble Action.");
        this.println("This action will appear before the declaration of your tree-walker class:");
        ++this.tabs;
        this.println(this.grammar.preambleAction.getText());
        --this.tabs;
        this.println("*** End of tree-walker Preamble Action");
        this.println("");
        if (this.grammar.comment != null) {
            this._println(this.grammar.comment);
        }
        this.println("class " + this.grammar.getClassName() + " extends " + this.grammar.getSuperClass() + "{");
        this.println("");
        this.println("*** User-defined tree-walker class members:");
        this.println("These are the member declarations that you defined for your class:");
        ++this.tabs;
        this.printAction(this.grammar.classMemberAction.getText());
        --this.tabs;
        this.println("*** End of user-defined tree-walker class members");
        this.println("");
        this.println("*** tree-walker rules:");
        ++this.tabs;
        Enumeration rules = this.grammar.rules.elements();
        while (rules.hasMoreElements()) {
            this.println("");
            GrammarSymbol sym = (GrammarSymbol)rules.nextElement();
            if (!(sym instanceof RuleSymbol)) continue;
            this.genRule((RuleSymbol)sym);
        }
        --this.tabs;
        this.println("");
        this.println("*** End of tree-walker rules");
        this.println("");
        this.println("*** End of tree-walker");
        this.currentOutput.close();
        this.currentOutput = null;
    }

    public void gen(WildcardElement wc) {
        this._print(". ");
    }

    public void gen(ZeroOrMoreBlock blk) {
        this.genGenericBlock(blk, "*");
    }

    protected void genAlt(Alternative alt) {
        if (alt.getTreeSpecifier() != null) {
            this._print(alt.getTreeSpecifier().getText());
        }
        this.prevAltElem = null;
        AlternativeElement elem = alt.head;
        while (!(elem instanceof BlockEndElement)) {
            elem.generate();
            this.firstElementInAlt = false;
            this.prevAltElem = elem;
            elem = elem.next;
        }
    }

    protected void genBlockPreamble(AlternativeBlock blk) {
        if (blk.initAction != null) {
            this.printAction("{" + blk.initAction + "}");
        }
    }

    public void genCommonBlock(AlternativeBlock blk) {
        int i = 0;
        while (i < blk.alternatives.size()) {
            Alternative alt = blk.getAlternativeAt(i);
            AlternativeElement elem = alt.head;
            if (i > 0 && blk.alternatives.size() > 1) {
                this._println("");
                this.print("|\t");
            }
            boolean save = this.firstElementInAlt;
            this.firstElementInAlt = true;
            ++this.tabs;
            if (alt.semPred != null) {
                this.println("{" + alt.semPred + "}?");
            }
            if (alt.synPred != null) {
                this.genSynPred(alt.synPred);
            }
            this.genAlt(alt);
            --this.tabs;
            this.firstElementInAlt = save;
            ++i;
        }
    }

    public void genFollowSetForRuleBlock(RuleBlock blk) {
        Lookahead follow = this.grammar.theLLkAnalyzer.FOLLOW(1, blk.endNode);
        this.printSet(this.grammar.maxk, 1, follow);
    }

    protected void genGenericBlock(AlternativeBlock blk, String blkOp) {
        if (blk.alternatives.size() > 1) {
            if (!this.firstElementInAlt) {
                if (this.prevAltElem == null || !(this.prevAltElem instanceof AlternativeBlock) || ((AlternativeBlock)this.prevAltElem).alternatives.size() == 1) {
                    this._println("");
                    this.print("(\t");
                } else {
                    this._print("(\t");
                }
            } else {
                this._print("(\t");
            }
        } else {
            this._print("( ");
        }
        this.genBlockPreamble(blk);
        this.genCommonBlock(blk);
        if (blk.alternatives.size() > 1) {
            this._println("");
            this.print(")" + blkOp + " ");
            if (!(blk.next instanceof BlockEndElement)) {
                this._println("");
                this.print("");
            }
        } else {
            this._print(")" + blkOp + " ");
        }
    }

    protected void genHeader() {
        this.println("<HTML>");
        this.println("<HEAD>");
        this.println("<TITLE>Grammar " + this.tool.grammarFile + "</TITLE>");
        this.println("</HEAD>");
        this.println("<BODY>");
        this.println("<table border=1 cellpadding=5>");
        this.println("<tr>");
        this.println("<td>");
        this.println("<font size=+2>Grammar " + this.grammar.getClassName() + "</font><br>");
        this.println("<a href=http://www.ANTLR.org>ANTLR</a>-generated HTML file from " + this.tool.grammarFile);
        this.println("<p>");
        this.println("Terence Parr, <a href=http://www.magelang.com>MageLang Institute</a>");
        this.println("<br>ANTLR Version 2.7.1; 1989-1999");
        this.println("</td>");
        this.println("</tr>");
        this.println("</table>");
        this.println("<PRE>");
        ++this.tabs;
        this.printAction(this.behavior.getHeaderAction(""));
        --this.tabs;
    }

    protected void genLookaheadSetForAlt(Alternative alt) {
        if (this.doingLexRules && alt.cache[1].containsEpsilon()) {
            this.println("MATCHES ALL");
            return;
        }
        int depth = alt.lookaheadDepth;
        if (depth == Integer.MAX_VALUE) {
            depth = this.grammar.maxk;
        }
        int i = 1;
        while (i <= depth) {
            Lookahead lookahead = alt.cache[i];
            this.printSet(depth, i, lookahead);
            ++i;
        }
    }

    public void genLookaheadSetForBlock(AlternativeBlock blk) {
        int depth = 0;
        int i = 0;
        while (i < blk.alternatives.size()) {
            Alternative alt = blk.getAlternativeAt(i);
            if (alt.lookaheadDepth == Integer.MAX_VALUE) {
                depth = this.grammar.maxk;
                break;
            }
            if (depth < alt.lookaheadDepth) {
                depth = alt.lookaheadDepth;
            }
            ++i;
        }
        int i2 = 1;
        while (i2 <= depth) {
            Lookahead lookahead = this.grammar.theLLkAnalyzer.look(i2, blk);
            this.printSet(depth, i2, lookahead);
            ++i2;
        }
    }

    public void genNextToken() {
        this.println("");
        this.println("/** Lexer nextToken rule:");
        this.println(" *  The lexer nextToken rule is synthesized from all of the user-defined");
        this.println(" *  lexer rules.  It logically consists of one big alternative block with");
        this.println(" *  each user-defined rule being an alternative.");
        this.println(" */");
        RuleBlock blk = MakeGrammar.createNextTokenRule(this.grammar, this.grammar.rules, "nextToken");
        RuleSymbol nextTokenRs = new RuleSymbol("mnextToken");
        nextTokenRs.setDefined();
        nextTokenRs.setBlock(blk);
        nextTokenRs.access = "private";
        this.grammar.define(nextTokenRs);
        this.genCommonBlock(blk);
    }

    public void genRule(RuleSymbol s) {
        if (s == null || !s.isDefined()) {
            return;
        }
        this.println("");
        if (s.comment != null) {
            this._println(s.comment);
        }
        if (s.access.length() != 0 && !s.access.equals("public")) {
            this._print(s.access + " ");
        }
        this._print("<a name=" + s.getId() + ">");
        this._print(s.getId());
        this._print("</a>");
        RuleBlock rblk = s.getBlock();
        if (rblk.returnAction != null) {
            this._print("[" + rblk.returnAction + "]");
        }
        if (rblk.argAction != null) {
            this._print(" returns [" + rblk.argAction + "]");
        }
        this._println("");
        ++this.tabs;
        this.print(":\t");
        this.genCommonBlock(rblk);
        this._println("");
        this.println(";");
        --this.tabs;
    }

    protected void genSynPred(SynPredBlock blk) {
        ++this.syntacticPredLevel;
        this.genGenericBlock(blk, " =>");
        --this.syntacticPredLevel;
    }

    public void genTail() {
        this.println("</PRE>");
        this.println("</BODY>");
        this.println("</HTML>");
    }

    protected void genTokenTypes(TokenManager tm) throws IOException {
        System.out.println("Generating " + tm.getName() + CodeGenerator.TokenTypesFileSuffix + CodeGenerator.TokenTypesFileExt);
        this.currentOutput = Tool.openOutputFile(tm.getName() + CodeGenerator.TokenTypesFileSuffix + CodeGenerator.TokenTypesFileExt);
        this.tabs = 0;
        this.genHeader();
        this.println("");
        this.println("*** Tokens used by the parser");
        this.println("This is a list of the token numeric values and the corresponding");
        this.println("token identifiers.  Some tokens are literals, and because of that");
        this.println("they have no identifiers.  Literals are double-quoted.");
        ++this.tabs;
        Vector v = tm.getVocabulary();
        int i = 4;
        while (i < v.size()) {
            String s = (String)v.elementAt(i);
            if (s != null) {
                this.println(s + " = " + i);
            }
            ++i;
        }
        --this.tabs;
        this.println("*** End of tokens used by the parser");
        this.currentOutput.close();
        this.currentOutput = null;
    }

    public String getASTCreateString(Vector v) {
        return null;
    }

    public String getASTCreateString(GrammarAtom atom, String str) {
        return null;
    }

    public String mapTreeId(String id, ActionTransInfo tInfo) {
        return id;
    }

    public void printSet(int depth, int k, Lookahead lookahead) {
        int numCols = 5;
        int[] elems = lookahead.fset.toArray();
        if (depth != 1) {
            this.print("k==" + k + ": {");
        } else {
            this.print("{ ");
        }
        if (elems.length > numCols) {
            this._println("");
            ++this.tabs;
            this.print("");
        }
        int column = 0;
        int i = 0;
        while (i < elems.length) {
            if (++column > numCols) {
                this._println("");
                this.print("");
                column = 0;
            }
            if (this.doingLexRules) {
                this._print(this.charFormatter.literalChar(elems[i]));
            } else {
                this._print((String)this.grammar.tokenManager.getVocabulary().elementAt(elems[i]));
            }
            if (i != elems.length - 1) {
                this._print(", ");
            }
            ++i;
        }
        if (elems.length > numCols) {
            this._println("");
            --this.tabs;
            this.print("");
        }
        this._println(" }");
    }
}

