/*
 * Decompiled with CFR 0.152.
 */
package antlr;

import antlr.ActionElement;
import antlr.ActionTransInfo;
import antlr.Alternative;
import antlr.AlternativeBlock;
import antlr.AlternativeElement;
import antlr.BlockEndElement;
import antlr.CharLiteralElement;
import antlr.CharRangeElement;
import antlr.CodeGenerator;
import antlr.ExceptionHandler;
import antlr.ExceptionSpec;
import antlr.Grammar;
import antlr.GrammarAtom;
import antlr.GrammarSymbol;
import antlr.JavaCharFormatter;
import antlr.LexerGrammar;
import antlr.Lookahead;
import antlr.MakeGrammar;
import antlr.OneOrMoreBlock;
import antlr.ParserGrammar;
import antlr.RuleBlock;
import antlr.RuleRefElement;
import antlr.RuleSymbol;
import antlr.StringLiteralElement;
import antlr.StringLiteralSymbol;
import antlr.SynPredBlock;
import antlr.TokenManager;
import antlr.TokenRangeElement;
import antlr.TokenRefElement;
import antlr.Tool;
import antlr.TreeElement;
import antlr.TreeWalkerGrammar;
import antlr.WildcardElement;
import antlr.ZeroOrMoreBlock;
import antlr.collections.impl.Vector;
import java.io.IOException;
import java.util.Enumeration;

public class DiagnosticCodeGenerator
extends CodeGenerator {
    protected int syntacticPredLevel = 0;
    protected boolean doingLexRules = false;

    public DiagnosticCodeGenerator() {
        this.charFormatter = new JavaCharFormatter();
    }

    public void gen() {
        try {
            Enumeration grammarIter = this.behavior.grammars.elements();
            while (grammarIter.hasMoreElements()) {
                Grammar g = (Grammar)grammarIter.nextElement();
                g.setGrammarAnalyzer(this.analyzer);
                g.setCodeGenerator(this);
                this.analyzer.setGrammar(g);
                g.generate();
                if (!this.tool.hasError) continue;
                System.out.println("Exiting due to errors.");
                System.exit(1);
            }
            Enumeration tmIter = this.behavior.tokenManagers.elements();
            while (tmIter.hasMoreElements()) {
                TokenManager tm = (TokenManager)tmIter.nextElement();
                if (tm.isReadOnly()) continue;
                this.genTokenTypes(tm);
            }
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    public void gen(ActionElement action) {
        if (!action.isSemPred) {
            this.print("ACTION: ");
            this._printAction(action.actionText);
        }
    }

    public void gen(AlternativeBlock blk) {
        this.println("Start of alternative block.");
        ++this.tabs;
        this.genBlockPreamble(blk);
        boolean ok = this.grammar.theLLkAnalyzer.deterministic(blk);
        if (!ok) {
            this.println("Warning: This alternative block is non-deterministic");
        }
        this.genCommonBlock(blk);
        --this.tabs;
    }

    public void gen(BlockEndElement end) {
    }

    public void gen(CharLiteralElement atom) {
        this.print("Match character ");
        if (atom.not) {
            this._print("NOT ");
        }
        this._print(atom.atomText);
        if (atom.label != null) {
            this._print(", label=" + atom.label);
        }
        this._println("");
    }

    public void gen(CharRangeElement r) {
        this.print("Match character range: " + r.beginText + ".." + r.endText);
        if (r.label != null) {
            this._print(", label = " + r.label);
        }
        this._println("");
    }

    public void gen(LexerGrammar g) throws IOException {
        this.setGrammar(g);
        System.out.println("Generating " + this.grammar.getClassName() + CodeGenerator.TokenTypesFileExt);
        this.currentOutput = Tool.openOutputFile(this.grammar.getClassName() + CodeGenerator.TokenTypesFileExt);
        this.tabs = 0;
        this.doingLexRules = true;
        this.genHeader();
        this.println("");
        this.println("*** Lexer Preamble Action.");
        this.println("This action will appear before the declaration of your lexer class:");
        ++this.tabs;
        this.println(this.grammar.preambleAction.getText());
        --this.tabs;
        this.println("*** End of Lexer Preamble Action");
        this.println("");
        this.println("*** Your lexer class is called '" + this.grammar.getClassName() + "' and is a subclass of '" + this.grammar.getSuperClass() + "'.");
        this.println("");
        this.println("*** User-defined lexer  class members:");
        this.println("These are the member declarations that you defined for your class:");
        ++this.tabs;
        this.printAction(this.grammar.classMemberAction.getText());
        --this.tabs;
        this.println("*** End of user-defined lexer class members");
        this.println("");
        this.println("*** String literals used in the parser");
        this.println("The following string literals were used in the parser.");
        this.println("An actual code generator would arrange to place these literals");
        this.println("into a table in the generated lexer, so that actions in the");
        this.println("generated lexer could match token text against the literals.");
        this.println("String literals used in the lexer are not listed here, as they");
        this.println("are incorporated into the mainstream lexer processing.");
        ++this.tabs;
        Enumeration ids = this.grammar.getSymbols();
        while (ids.hasMoreElements()) {
            GrammarSymbol sym = (GrammarSymbol)ids.nextElement();
            if (!(sym instanceof StringLiteralSymbol)) continue;
            StringLiteralSymbol s = (StringLiteralSymbol)sym;
            this.println(s.getId() + " = " + s.getTokenType());
        }
        --this.tabs;
        this.println("*** End of string literals used by the parser");
        this.genNextToken();
        this.println("");
        this.println("*** User-defined Lexer rules:");
        ++this.tabs;
        ids = this.grammar.rules.elements();
        while (ids.hasMoreElements()) {
            RuleSymbol rs = (RuleSymbol)ids.nextElement();
            if (rs.id.equals("mnextToken")) continue;
            this.genRule(rs);
        }
        --this.tabs;
        this.println("");
        this.println("*** End User-defined Lexer rules:");
        this.currentOutput.close();
        this.currentOutput = null;
        this.doingLexRules = false;
    }

    public void gen(OneOrMoreBlock blk) {
        this.println("Start ONE-OR-MORE (...)+ block:");
        ++this.tabs;
        this.genBlockPreamble(blk);
        boolean ok = this.grammar.theLLkAnalyzer.deterministic(blk);
        if (!ok) {
            this.println("Warning: This one-or-more block is non-deterministic");
        }
        this.genCommonBlock(blk);
        --this.tabs;
        this.println("End ONE-OR-MORE block.");
    }

    public void gen(ParserGrammar g) throws IOException {
        this.setGrammar(g);
        System.out.println("Generating " + this.grammar.getClassName() + CodeGenerator.TokenTypesFileExt);
        this.currentOutput = Tool.openOutputFile(this.grammar.getClassName() + CodeGenerator.TokenTypesFileExt);
        this.tabs = 0;
        this.genHeader();
        this.println("");
        this.println("*** Parser Preamble Action.");
        this.println("This action will appear before the declaration of your parser class:");
        ++this.tabs;
        this.println(this.grammar.preambleAction.getText());
        --this.tabs;
        this.println("*** End of Parser Preamble Action");
        this.println("");
        this.println("*** Your parser class is called '" + this.grammar.getClassName() + "' and is a subclass of '" + this.grammar.getSuperClass() + "'.");
        this.println("");
        this.println("*** User-defined parser class members:");
        this.println("These are the member declarations that you defined for your class:");
        ++this.tabs;
        this.printAction(this.grammar.classMemberAction.getText());
        --this.tabs;
        this.println("*** End of user-defined parser class members");
        this.println("");
        this.println("*** Parser rules:");
        ++this.tabs;
        Enumeration rules = this.grammar.rules.elements();
        while (rules.hasMoreElements()) {
            this.println("");
            GrammarSymbol sym = (GrammarSymbol)rules.nextElement();
            if (!(sym instanceof RuleSymbol)) continue;
            this.genRule((RuleSymbol)sym);
        }
        --this.tabs;
        this.println("");
        this.println("*** End of parser rules");
        this.println("");
        this.println("*** End of parser");
        this.currentOutput.close();
        this.currentOutput = null;
    }

    public void gen(RuleRefElement rr) {
        RuleSymbol rs = (RuleSymbol)this.grammar.getSymbol(rr.targetRule);
        this.print("Rule Reference: " + rr.targetRule);
        if (rr.idAssign != null) {
            this._print(", assigned to '" + rr.idAssign + "'");
        }
        if (rr.args != null) {
            this._print(", arguments = " + rr.args);
        }
        this._println("");
        if (rs == null || !rs.isDefined()) {
            this.println("Rule '" + rr.targetRule + "' is referenced, but that rule is not defined.");
            this.println("\tPerhaps the rule is misspelled, or you forgot to define it.");
            return;
        }
        if (!(rs instanceof RuleSymbol)) {
            this.println("Rule '" + rr.targetRule + "' is referenced, but that is not a grammar rule.");
            return;
        }
        if (rr.idAssign != null) {
            if (rs.block.returnAction == null) {
                this.println("Error: You assigned from Rule '" + rr.targetRule + "', but that rule has no return type.");
            }
        } else if (!(this.grammar instanceof LexerGrammar) && this.syntacticPredLevel == 0 && rs.block.returnAction != null) {
            this.println("Warning: Rule '" + rr.targetRule + "' returns a value");
        }
        if (rr.args != null && rs.block.argAction == null) {
            this.println("Error: Rule '" + rr.targetRule + "' accepts no arguments.");
        }
    }

    public void gen(StringLiteralElement atom) {
        this.print("Match string literal ");
        this._print(atom.atomText);
        if (atom.label != null) {
            this._print(", label=" + atom.label);
        }
        this._println("");
    }

    public void gen(TokenRangeElement r) {
        this.print("Match token range: " + r.beginText + ".." + r.endText);
        if (r.label != null) {
            this._print(", label = " + r.label);
        }
        this._println("");
    }

    public void gen(TokenRefElement atom) {
        this.print("Match token ");
        if (atom.not) {
            this._print("NOT ");
        }
        this._print(atom.atomText);
        if (atom.label != null) {
            this._print(", label=" + atom.label);
        }
        this._println("");
    }

    public void gen(TreeElement t) {
        this.print("Tree reference: " + t);
    }

    public void gen(TreeWalkerGrammar g) throws IOException {
        this.setGrammar(g);
        System.out.println("Generating " + this.grammar.getClassName() + CodeGenerator.TokenTypesFileExt);
        this.currentOutput = Tool.openOutputFile(this.grammar.getClassName() + CodeGenerator.TokenTypesFileExt);
        this.tabs = 0;
        this.genHeader();
        this.println("");
        this.println("*** Tree-walker Preamble Action.");
        this.println("This action will appear before the declaration of your tree-walker class:");
        ++this.tabs;
        this.println(this.grammar.preambleAction.getText());
        --this.tabs;
        this.println("*** End of tree-walker Preamble Action");
        this.println("");
        this.println("*** Your tree-walker class is called '" + this.grammar.getClassName() + "' and is a subclass of '" + this.grammar.getSuperClass() + "'.");
        this.println("");
        this.println("*** User-defined tree-walker class members:");
        this.println("These are the member declarations that you defined for your class:");
        ++this.tabs;
        this.printAction(this.grammar.classMemberAction.getText());
        --this.tabs;
        this.println("*** End of user-defined tree-walker class members");
        this.println("");
        this.println("*** tree-walker rules:");
        ++this.tabs;
        Enumeration rules = this.grammar.rules.elements();
        while (rules.hasMoreElements()) {
            this.println("");
            GrammarSymbol sym = (GrammarSymbol)rules.nextElement();
            if (!(sym instanceof RuleSymbol)) continue;
            this.genRule((RuleSymbol)sym);
        }
        --this.tabs;
        this.println("");
        this.println("*** End of tree-walker rules");
        this.println("");
        this.println("*** End of tree-walker");
        this.currentOutput.close();
        this.currentOutput = null;
    }

    public void gen(WildcardElement wc) {
        this.print("Match wildcard");
        if (wc.getLabel() != null) {
            this._print(", label = " + wc.getLabel());
        }
        this._println("");
    }

    public void gen(ZeroOrMoreBlock blk) {
        this.println("Start ZERO-OR-MORE (...)+ block:");
        ++this.tabs;
        this.genBlockPreamble(blk);
        boolean ok = this.grammar.theLLkAnalyzer.deterministic(blk);
        if (!ok) {
            this.println("Warning: This zero-or-more block is non-deterministic");
        }
        this.genCommonBlock(blk);
        --this.tabs;
        this.println("End ZERO-OR-MORE block.");
    }

    protected void genAlt(Alternative alt) {
        AlternativeElement elem = alt.head;
        while (!(elem instanceof BlockEndElement)) {
            elem.generate();
            elem = elem.next;
        }
        if (alt.getTreeSpecifier() != null) {
            this.println("AST will be built as: " + alt.getTreeSpecifier().getText());
        }
    }

    protected void genBlockPreamble(AlternativeBlock blk) {
        if (blk.initAction != null) {
            this.printAction("Init action: " + blk.initAction);
        }
    }

    public void genCommonBlock(AlternativeBlock blk) {
        boolean singleAlt = blk.alternatives.size() == 1;
        this.println("Start of an alternative block.");
        ++this.tabs;
        this.println("The lookahead set for this block is:");
        ++this.tabs;
        this.genLookaheadSetForBlock(blk);
        --this.tabs;
        if (singleAlt) {
            this.println("This block has a single alternative");
            if (blk.getAlternativeAt((int)0).synPred != null) {
                this.println("Warning: you specified a syntactic predicate for this alternative,");
                this.println("and it is the only alternative of a block and will be ignored.");
            }
        } else {
            this.println("This block has multiple alternatives:");
            ++this.tabs;
        }
        int i = 0;
        while (i < blk.alternatives.size()) {
            Alternative alt = blk.getAlternativeAt(i);
            AlternativeElement elem = alt.head;
            this.println("");
            if (i != 0) {
                this.print("Otherwise, ");
            } else {
                this.print("");
            }
            this._println("Alternate(" + (i + 1) + ") will be taken IF:");
            this.println("The lookahead set: ");
            ++this.tabs;
            this.genLookaheadSetForAlt(alt);
            --this.tabs;
            if (alt.semPred != null || alt.synPred != null) {
                this.print("is matched, AND ");
            } else {
                this.println("is matched.");
            }
            if (alt.semPred != null) {
                this._println("the semantic predicate:");
                ++this.tabs;
                this.println(alt.semPred);
                if (alt.synPred != null) {
                    this.print("is true, AND ");
                } else {
                    this.println("is true.");
                }
            }
            if (alt.synPred != null) {
                this._println("the syntactic predicate:");
                ++this.tabs;
                this.genSynPred(alt.synPred);
                --this.tabs;
                this.println("is matched.");
            }
            this.genAlt(alt);
            ++i;
        }
        this.println("");
        this.println("OTHERWISE, a NoViableAlt exception will be thrown");
        this.println("");
        if (!singleAlt) {
            --this.tabs;
            this.println("End of alternatives");
        }
        --this.tabs;
        this.println("End of alternative block.");
    }

    public void genFollowSetForRuleBlock(RuleBlock blk) {
        Lookahead follow = this.grammar.theLLkAnalyzer.FOLLOW(1, blk.endNode);
        this.printSet(this.grammar.maxk, 1, follow);
    }

    protected void genHeader() {
        this.println("ANTLR-generated file resulting from grammar " + this.tool.grammarFile);
        this.println("Diagnostic output");
        this.println("");
        this.println("Terence Parr, MageLang Institute");
        this.println("with John Lilley, Empathy Software");
        this.println("ANTLR Version 2.7.1; 1996,1997");
        this.println("");
        this.println("*** Header Action.");
        this.println("This action will appear at the top of all generated files.");
        ++this.tabs;
        this.printAction(this.behavior.getHeaderAction(""));
        --this.tabs;
        this.println("*** End of Header Action");
        this.println("");
    }

    protected void genLookaheadSetForAlt(Alternative alt) {
        if (this.doingLexRules && alt.cache[1].containsEpsilon()) {
            this.println("MATCHES ALL");
            return;
        }
        int depth = alt.lookaheadDepth;
        if (depth == Integer.MAX_VALUE) {
            depth = this.grammar.maxk;
        }
        int i = 1;
        while (i <= depth) {
            Lookahead lookahead = alt.cache[i];
            this.printSet(depth, i, lookahead);
            ++i;
        }
    }

    public void genLookaheadSetForBlock(AlternativeBlock blk) {
        int depth = 0;
        int i = 0;
        while (i < blk.alternatives.size()) {
            Alternative alt = blk.getAlternativeAt(i);
            if (alt.lookaheadDepth == Integer.MAX_VALUE) {
                depth = this.grammar.maxk;
                break;
            }
            if (depth < alt.lookaheadDepth) {
                depth = alt.lookaheadDepth;
            }
            ++i;
        }
        int i2 = 1;
        while (i2 <= depth) {
            Lookahead lookahead = this.grammar.theLLkAnalyzer.look(i2, blk);
            this.printSet(depth, i2, lookahead);
            ++i2;
        }
    }

    public void genNextToken() {
        this.println("");
        this.println("*** Lexer nextToken rule:");
        this.println("The lexer nextToken rule is synthesized from all of the user-defined");
        this.println("lexer rules.  It logically consists of one big alternative block with");
        this.println("each user-defined rule being an alternative.");
        this.println("");
        RuleBlock blk = MakeGrammar.createNextTokenRule(this.grammar, this.grammar.rules, "nextToken");
        RuleSymbol nextTokenRs = new RuleSymbol("mnextToken");
        nextTokenRs.setDefined();
        nextTokenRs.setBlock(blk);
        nextTokenRs.access = "private";
        this.grammar.define(nextTokenRs);
        if (!this.grammar.theLLkAnalyzer.deterministic(blk)) {
            this.println("The grammar analyzer has determined that the synthesized");
            this.println("nextToken rule is non-deterministic (i.e., it has ambiguities)");
            this.println("This means that there is some overlap of the character");
            this.println("lookahead for two or more of your lexer rules.");
        }
        this.genCommonBlock(blk);
        this.println("*** End of nextToken lexer rule.");
    }

    public void genRule(RuleSymbol s) {
        this.println("");
        String ruleType = this.doingLexRules ? "Lexer" : "Parser";
        this.println("*** " + ruleType + " Rule: " + s.getId());
        if (!s.isDefined()) {
            this.println("This rule is undefined.");
            this.println("This means that the rule was referenced somewhere in the grammar,");
            this.println("but a definition for the rule was not encountered.");
            this.println("It is also possible that syntax errors during the parse of");
            this.println("your grammar file prevented correct processing of the rule.");
            this.println("*** End " + ruleType + " Rule: " + s.getId());
            return;
        }
        ++this.tabs;
        if (s.access.length() != 0) {
            this.println("Access: " + s.access);
        }
        RuleBlock rblk = s.getBlock();
        if (rblk.returnAction != null) {
            this.println("Return value(s): " + rblk.returnAction);
            if (this.doingLexRules) {
                this.println("Error: you specified return value(s) for a lexical rule.");
                this.println("\tLexical rules have an implicit return type of 'int'.");
            }
        } else if (this.doingLexRules) {
            this.println("Return value: lexical rule returns an implicit token type");
        } else {
            this.println("Return value: none");
        }
        if (rblk.argAction != null) {
            this.println("Arguments: " + rblk.argAction);
        }
        this.genBlockPreamble(rblk);
        boolean ok = this.grammar.theLLkAnalyzer.deterministic(rblk);
        if (!ok) {
            this.println("Error: This rule is non-deterministic");
        }
        this.genCommonBlock(rblk);
        ExceptionSpec unlabeledUserSpec = rblk.findExceptionSpec("");
        if (unlabeledUserSpec != null) {
            this.println("You specified error-handler(s) for this rule:");
            ++this.tabs;
            int i = 0;
            while (i < unlabeledUserSpec.handlers.size()) {
                if (i != 0) {
                    this.println("");
                }
                ExceptionHandler handler = (ExceptionHandler)unlabeledUserSpec.handlers.elementAt(i);
                this.println("Error-handler(" + (i + 1) + ") catches [" + handler.exceptionTypeAndName.getText() + "] and executes:");
                this.printAction(handler.action.getText());
                ++i;
            }
            --this.tabs;
            this.println("End error-handlers.");
        } else if (!this.doingLexRules) {
            this.println("Default error-handling will be generated, which catches all");
            this.println("parser exceptions and consumes tokens until the follow-set is seen.");
        }
        if (!this.doingLexRules) {
            this.println("The follow set for this rule is:");
            ++this.tabs;
            this.genFollowSetForRuleBlock(rblk);
            --this.tabs;
        }
        --this.tabs;
        this.println("*** End " + ruleType + " Rule: " + s.getId());
    }

    protected void genSynPred(SynPredBlock blk) {
        ++this.syntacticPredLevel;
        this.gen(blk);
        --this.syntacticPredLevel;
    }

    protected void genTokenTypes(TokenManager tm) throws IOException {
        System.out.println("Generating " + tm.getName() + CodeGenerator.TokenTypesFileSuffix + CodeGenerator.TokenTypesFileExt);
        this.currentOutput = Tool.openOutputFile(tm.getName() + CodeGenerator.TokenTypesFileSuffix + CodeGenerator.TokenTypesFileExt);
        this.tabs = 0;
        this.genHeader();
        this.println("");
        this.println("*** Tokens used by the parser");
        this.println("This is a list of the token numeric values and the corresponding");
        this.println("token identifiers.  Some tokens are literals, and because of that");
        this.println("they have no identifiers.  Literals are double-quoted.");
        ++this.tabs;
        Vector v = tm.getVocabulary();
        int i = 4;
        while (i < v.size()) {
            String s = (String)v.elementAt(i);
            if (s != null) {
                this.println(s + " = " + i);
            }
            ++i;
        }
        --this.tabs;
        this.println("*** End of tokens used by the parser");
        this.currentOutput.close();
        this.currentOutput = null;
    }

    public String getASTCreateString(Vector v) {
        return "***Create an AST from a vector here***" + System.getProperty("line.separator");
    }

    public String getASTCreateString(GrammarAtom atom, String str) {
        return "[" + str + "]";
    }

    public String mapTreeId(String id, ActionTransInfo tInfo) {
        return id;
    }

    public void printSet(int depth, int k, Lookahead lookahead) {
        int numCols = 5;
        int[] elems = lookahead.fset.toArray();
        if (depth != 1) {
            this.print("k==" + k + ": {");
        } else {
            this.print("{ ");
        }
        if (elems.length > numCols) {
            this._println("");
            ++this.tabs;
            this.print("");
        }
        int column = 0;
        int i = 0;
        while (i < elems.length) {
            if (++column > numCols) {
                this._println("");
                this.print("");
                column = 0;
            }
            if (this.doingLexRules) {
                this._print(this.charFormatter.literalChar(elems[i]));
            } else {
                this._print((String)this.grammar.tokenManager.getVocabulary().elementAt(elems[i]));
            }
            if (i != elems.length - 1) {
                this._print(", ");
            }
            ++i;
        }
        if (elems.length > numCols) {
            this._println("");
            --this.tabs;
            this.print("");
        }
        this._println(" }");
    }
}

