/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlparser;

import com.sap.sql.tree.ArithmeticExpression;
import com.sap.sql.tree.BetweenPredicate;
import com.sap.sql.tree.BigDecimalLiteral;
import com.sap.sql.tree.BooleanAnd;
import com.sap.sql.tree.BooleanNot;
import com.sap.sql.tree.BooleanOr;
import com.sap.sql.tree.ColumnReference;
import com.sap.sql.tree.ComparisonPredicate;
import com.sap.sql.tree.ConcatenationExpression;
import com.sap.sql.tree.CountAll;
import com.sap.sql.tree.DefaultValue;
import com.sap.sql.tree.DeleteStatement;
import com.sap.sql.tree.DerivedTable;
import com.sap.sql.tree.ExistsPredicate;
import com.sap.sql.tree.FloatLiteral;
import com.sap.sql.tree.HostVariable;
import com.sap.sql.tree.InListPredicate;
import com.sap.sql.tree.InSubqueryPredicate;
import com.sap.sql.tree.InsertStatement;
import com.sap.sql.tree.IntegerLiteral;
import com.sap.sql.tree.JoinedTable;
import com.sap.sql.tree.LikePredicate;
import com.sap.sql.tree.NonJoinQuery;
import com.sap.sql.tree.NullPredicate;
import com.sap.sql.tree.NullValue;
import com.sap.sql.tree.QuantifiedComparisonPredicate;
import com.sap.sql.tree.Query;
import com.sap.sql.tree.QuerySpecification;
import com.sap.sql.tree.RowValue;
import com.sap.sql.tree.RowValueElement;
import com.sap.sql.tree.RowValueElementList;
import com.sap.sql.tree.SQLVisitor;
import com.sap.sql.tree.SearchCondition;
import com.sap.sql.tree.SelectForUpdateStatement;
import com.sap.sql.tree.SelectStatement;
import com.sap.sql.tree.SelectSublist;
import com.sap.sql.tree.SetClause;
import com.sap.sql.tree.SetFunction;
import com.sap.sql.tree.SortSpecification;
import com.sap.sql.tree.StringLiteral;
import com.sap.sql.tree.TableReference;
import com.sap.sql.tree.TableValue;
import com.sap.sql.tree.UpdateStatement;
import com.sap.sql.tree.ValueExpression;
import java.util.Stack;

public class NormalizeVisitor
extends SQLVisitor {
    private Stack stack = new Stack();
    private StringBuffer top = null;

    private static void toDelimitedIdentifier(String name, StringBuffer strBuf) {
        strBuf.append('\"');
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            strBuf.append(c);
            if (c == '\"') {
                strBuf.append('\"');
            }
            ++i;
        }
        strBuf.append('\"');
    }

    private StringBuffer listToString(Object[] arr, String sep) {
        int n;
        int cnt = this.stack.size();
        if (arr == null || (n = arr.length) == 0) {
            return null;
        }
        if (n > cnt) {
            throw new IllegalArgumentException("array out of bound in listToString");
        }
        int i = cnt - n;
        StringBuffer buffer = (StringBuffer)this.stack.get(i);
        ++i;
        while (i < cnt) {
            buffer.append(sep);
            buffer.append(this.stack.get(i));
            ++i;
        }
        this.stack.setSize(cnt - n);
        this.top = this.stack.size() > 0 ? (StringBuffer)this.stack.lastElement() : null;
        return buffer;
    }

    private void appendListToBuffer(Object[] arr, String sep, StringBuffer buffer) {
        int n;
        int cnt = this.stack.size();
        if (arr == null || (n = arr.length) == 0) {
            return;
        }
        if (n > cnt) {
            throw new IllegalArgumentException("array out of bound in listToString");
        }
        int i = cnt - n;
        buffer.append(this.stack.get(i));
        ++i;
        while (i < cnt) {
            buffer.append(sep);
            buffer.append(this.stack.get(i));
            ++i;
        }
        this.stack.setSize(cnt - n);
        this.top = this.stack.size() > 0 ? (StringBuffer)this.stack.lastElement() : null;
    }

    private void push(StringBuffer buffer) {
        this.top = buffer;
        this.stack.push(buffer);
    }

    private void push(String string) {
        this.push(new StringBuffer(string));
    }

    private StringBuffer pop() {
        StringBuffer p = (StringBuffer)this.stack.pop();
        this.top = this.stack.size() > 0 ? (StringBuffer)this.stack.lastElement() : null;
        return p;
    }

    private String printComparisonOperator(int op) {
        switch (op) {
            case 1: {
                return "=";
            }
            case 2: {
                return "<>";
            }
            case 3: {
                return "<";
            }
            case 4: {
                return "<=";
            }
            case 5: {
                return ">";
            }
            case 6: {
                return ">=";
            }
        }
        return null;
    }

    private boolean isPlusOrMinus(ValueExpression x) {
        return x instanceof ArithmeticExpression && (((ArithmeticExpression)x).getOperator() == 2 || ((ArithmeticExpression)x).getOperator() == 1);
    }

    public void visitArithmeticExpression(ArithmeticExpression x) {
        ValueExpression left = x.getLeftOperand();
        ValueExpression right = x.getRightOperand();
        if (left != null) {
            StringBuffer rhs = this.pop();
            if (right instanceof ArithmeticExpression) {
                rhs.insert(0, '(');
                rhs.append(')');
            }
            if (left instanceof ArithmeticExpression) {
                this.top.insert(0, '(');
                this.top.append(')');
            }
            switch (x.getOperator()) {
                case 1: {
                    this.top.append(" + ");
                    break;
                }
                case 2: {
                    this.top.append(" - ");
                    break;
                }
                case 3: {
                    this.top.append(" * ");
                    break;
                }
                case 4: {
                    this.top.append(" / ");
                }
            }
            this.top.append((Object)rhs);
        } else if (x.getOperator() == 2) {
            if (right instanceof ArithmeticExpression) {
                this.top.insert(0, " - (");
                this.top.append(')');
            } else {
                this.top.insert(0, " - ");
            }
        }
    }

    public void visitBetweenPredicate(BetweenPredicate x) {
        StringBuffer high = this.pop();
        StringBuffer low = this.pop();
        if (x.isNotBetween()) {
            this.top.append(" NOT BETWEEN ");
        } else {
            this.top.append(" BETWEEN ");
        }
        this.top.append((Object)low);
        this.top.append(" AND ");
        this.top.append((Object)high);
    }

    public void visitBigDecimalLiteral(BigDecimalLiteral x) {
        this.push(x.toString());
    }

    public void visitBooleanAnd(BooleanAnd x) {
        StringBuffer buffer;
        SearchCondition[] operands = x.getOperands();
        int cnt = this.stack.size();
        int n = operands.length;
        int j = 1;
        int i = cnt - n;
        if (operands[0] instanceof BooleanOr) {
            buffer = (StringBuffer)this.stack.get(i);
            buffer.insert(0, '(');
            buffer.append(')');
        } else {
            buffer = (StringBuffer)this.stack.get(i);
        }
        ++i;
        while (i < cnt) {
            buffer.append(" AND ");
            if (operands[j] instanceof BooleanOr) {
                buffer.append('(');
                buffer.append((Object)((StringBuffer)this.stack.get(i)));
                buffer.append(')');
            } else {
                buffer.append(this.stack.get(i));
            }
            ++i;
            ++j;
        }
        this.stack.setSize(cnt - n + 1);
        this.top = this.stack.size() > 0 ? (StringBuffer)this.stack.lastElement() : null;
    }

    public void visitBooleanNot(BooleanNot x) {
        if (x.getOperand() instanceof BooleanAnd || x.getOperand() instanceof BooleanOr) {
            this.top.insert(0, "NOT (");
            this.top.append(')');
        } else {
            this.top.insert(0, "NOT ");
        }
    }

    public void visitBooleanOr(BooleanOr x) {
        this.push(this.listToString(x.getOperands(), " OR "));
    }

    public void visitColumnReference(ColumnReference x) {
        this.push(x.toString());
    }

    public void visitComparisonPredicate(ComparisonPredicate x) {
        StringBuffer right = this.pop();
        if (x.getLeftOperand() instanceof Query) {
            this.top.insert(0, '(');
            this.top.append(')');
        }
        this.top.append(' ');
        this.top.append(this.printComparisonOperator(x.getOperator()));
        this.top.append(' ');
        if (x.getRightOperand() instanceof Query) {
            this.top.append('(');
            this.top.append((Object)right);
            this.top.append(')');
        } else {
            this.top.append((Object)right);
        }
    }

    public void visitConcatenationExpression(ConcatenationExpression x) {
        this.push(this.listToString(x.getOperands(), " || "));
    }

    public void visitCountAll(CountAll x) {
        this.push("COUNT(*)");
    }

    public void visitDefaultValue(DefaultValue x) {
        this.push("DEFAULT");
    }

    public void visitDeleteStatement(DeleteStatement x) {
        StringBuffer where = null;
        StringBuffer buffer = new StringBuffer("DELETE FROM ");
        if (x.getWhereClause() != null) {
            where = this.pop();
        }
        buffer.append((Object)this.pop());
        if (where != null) {
            buffer.append(" WHERE ");
            buffer.append((Object)where);
        }
        this.push(buffer);
    }

    public void visitDerivedTable(DerivedTable x) {
        this.top.insert(0, '(');
        this.top.append(" ) ");
        NormalizeVisitor.toDelimitedIdentifier(x.getCorrelationName(), this.top);
        String[] columnNames = x.getColumnNames();
        if (columnNames != null && columnNames.length > 0) {
            this.top.append(" (");
            this.top.append(columnNames[0]);
            int col_i = 1;
            while (col_i < columnNames.length) {
                this.top.append(",");
                NormalizeVisitor.toDelimitedIdentifier(columnNames[col_i], this.top);
                ++col_i;
            }
            this.top.append(")");
        }
    }

    public void visitExistsPredicate(ExistsPredicate x) {
        this.top.insert(0, "EXISTS (");
        this.top.append(')');
    }

    public void visitFloatLiteral(FloatLiteral x) {
        this.push(x.toString());
    }

    public void visitHostVariable(HostVariable x) {
        this.push("?");
    }

    public void visitInListPredicate(InListPredicate x) {
        StringBuffer buffer = this.pop();
        buffer.append(')');
        int cnt = x.getValueList().length;
        --cnt;
        while (cnt >= 1) {
            buffer.insert(0, ',');
            buffer.insert(0, (Object)this.pop());
            --cnt;
        }
        if (x.isNotIn()) {
            buffer.insert(0, " NOT IN (");
        } else {
            buffer.insert(0, " IN (");
        }
        buffer.insert(0, (Object)this.pop());
        this.push(buffer);
    }

    public void visitInsertStatement(InsertStatement x) {
        StringBuffer source = this.pop();
        StringBuffer columns = this.listToString(x.getColumnList(), ",");
        this.top.insert(0, "INSERT INTO ");
        this.top.append(' ');
        if (columns != null) {
            this.top.append('(');
            this.top.append((Object)columns);
            this.top.append(") ");
        }
        this.top.append((Object)source);
    }

    public void visitInSubqueryPredicate(InSubqueryPredicate x) {
        StringBuffer query = this.pop();
        if (x.isNotIn()) {
            this.top.append(" NOT IN (");
        } else {
            this.top.append(" IN (");
        }
        this.top.append((Object)query);
        this.top.append(')');
    }

    public void visitIntegerLiteral(IntegerLiteral x) {
        this.push(x.toString());
    }

    public void visitJoinedTable(JoinedTable x) {
        String op;
        String[] columns = x.getNamedColumns();
        StringBuffer on = x.getJoinCondition() != null ? this.pop() : null;
        StringBuffer right = this.pop();
        if (x.getRightOperand() instanceof JoinedTable || x.getRightOperand() instanceof NonJoinQuery) {
            right.insert(0, '(');
            right.append(')');
        }
        StringBuffer left = this.pop();
        if (x.getLeftOperand() instanceof NonJoinQuery) {
            left.insert(0, '(');
            left.append(')');
        }
        switch (x.getJoinType()) {
            case 1: {
                op = " CROSS JOIN ";
                break;
            }
            case 2: {
                op = " UNION JOIN ";
                break;
            }
            case 3: {
                op = " INNER JOIN ";
                break;
            }
            case 4: {
                op = " NATURAL INNER JOIN ";
                break;
            }
            case 5: {
                op = " LEFT OUTER JOIN ";
                break;
            }
            case 6: {
                op = " NATURAL LEFT OUTER JOIN ";
                break;
            }
            case 7: {
                op = " RIGHT OUTER JOIN ";
                break;
            }
            case 8: {
                op = " NATURAL RIGHT OUTER JOIN ";
                break;
            }
            case 9: {
                op = " FULL OUTER JOIN ";
                break;
            }
            case 10: {
                op = " NATURAL FULL OUTER JOIN ";
                break;
            }
            default: {
                throw new IllegalStateException("should not be reached");
            }
        }
        StringBuffer buffer = left;
        buffer.append(op);
        buffer.append((Object)right);
        if (on != null) {
            buffer.append(" ON ");
            buffer.append((Object)on);
        } else if (columns != null && columns.length > 0) {
            buffer.append(" USING (");
            NormalizeVisitor.toDelimitedIdentifier(columns[0], buffer);
            int i = 1;
            while (i < columns.length) {
                buffer.append(',');
                NormalizeVisitor.toDelimitedIdentifier(columns[i], buffer);
                ++i;
            }
            buffer.append(')');
        }
        this.push(buffer);
    }

    public void visitLikePredicate(LikePredicate x) {
        StringBuffer escape = x.getEscapeValue() == null ? null : this.pop();
        StringBuffer pattern = this.pop();
        if (x.isNotLike()) {
            this.top.append(" NOT LIKE ");
        } else {
            this.top.append(" LIKE ");
        }
        this.top.append((Object)pattern);
        if (escape != null) {
            this.top.append(" ESCAPE ");
            this.top.append((Object)escape);
        }
    }

    public void visitNonJoinQuery(NonJoinQuery x) {
        StringBuffer rhs = this.pop();
        if (x.getRightOperand() instanceof TableReference) {
            rhs.insert(0, "TABLE ");
        } else if (x.getRightOperand() instanceof NonJoinQuery) {
            rhs.insert(0, '(');
            rhs.append(')');
        }
        String op = null;
        switch (x.getOperator()) {
            case 1: {
                op = " UNION ";
                break;
            }
            case 2: {
                op = " UNION ALL ";
                break;
            }
            case 3: {
                op = " INTERSECT ";
                break;
            }
            case 4: {
                op = " INTERSECT ALL ";
                break;
            }
            case 5: {
                op = " EXCEPT ";
                break;
            }
            case 6: {
                op = " EXCEPT ALL ";
            }
        }
        if (x.getLeftOperand() instanceof TableReference) {
            this.top.insert(0, "TABLE ");
        } else if (x.getLeftOperand() instanceof NonJoinQuery) {
            this.top.insert(0, '(');
            this.top.append(')');
        }
        this.top.append(op);
        this.top.append((Object)rhs);
    }

    public void visitNullPredicate(NullPredicate x) {
        if (x.isNotNull()) {
            this.top.append(" IS NOT NULL");
        } else {
            this.top.append(" IS NULL");
        }
    }

    public void visitNullValue(NullValue x) {
        this.push("NULL");
    }

    public void visitQuantifiedComparisonPredicate(QuantifiedComparisonPredicate x) {
        StringBuffer query = this.pop();
        this.top.append(' ');
        this.top.append(this.printComparisonOperator(x.getOperator()));
        this.top.append(' ');
        switch (x.getQuantifier()) {
            case 1: {
                this.top.append(" ALL ");
                break;
            }
            case 2: {
                this.top.append(" ANY ");
                break;
            }
            case 3: {
                this.top.append(" SOME ");
            }
        }
        this.top.append('(');
        this.top.append((Object)query);
        this.top.append(')');
    }

    public void visitQuerySpecification(QuerySpecification x) {
        StringBuffer buffer = new StringBuffer();
        StringBuffer having = x.getHavingClause() == null ? null : this.pop();
        StringBuffer group = this.listToString(x.getGroupByList(), ", ");
        StringBuffer where = x.getWhereClause() == null ? null : this.pop();
        StringBuffer from = this.listToString(x.getFromClause(), ", ");
        StringBuffer select = this.listToString(x.getSelectList(), ",");
        if (select == null) {
            select = new StringBuffer("*");
        }
        buffer.append("SELECT ");
        if (x.isDistinct()) {
            buffer.append("DISTINCT ");
        }
        buffer.append((Object)select);
        buffer.append(" FROM ");
        buffer.append((Object)from);
        if (where != null) {
            buffer.append(" WHERE ");
            buffer.append((Object)where);
        }
        if (group != null) {
            buffer.append(" GROUP BY ");
            buffer.append((Object)group);
        }
        if (having != null) {
            buffer.append(" HAVING ");
            buffer.append((Object)having);
        }
        this.push(buffer);
    }

    public void visitRowValueElementList(RowValueElementList x) {
        StringBuffer buffer = new StringBuffer();
        buffer.append('(');
        buffer.append((Object)this.listToString(x.getValueList(), ","));
        buffer.append(')');
        this.push(buffer);
    }

    public void visitSelectStatement(SelectStatement x) {
        StringBuffer query = this.pop();
        if (x.getOrderByList() != null && x.getOrderByList().length > 0) {
            query.append(" ORDER BY ");
            this.appendListToBuffer(x.getOrderByList(), ",", query);
        }
        this.push(query);
    }

    public void visitSelectSublist(SelectSublist x) {
        if (x.getTableRef() != null) {
            this.top.append(".*");
        } else {
            String aliasName = x.getAliasName();
            if (!(aliasName == null || x.getValue() instanceof ColumnReference && aliasName.equals(((ColumnReference)x.getValue()).getColumnName()))) {
                this.top.append(" ");
                NormalizeVisitor.toDelimitedIdentifier(aliasName, this.top);
            }
        }
    }

    public void visitSetClause(SetClause x) {
        StringBuffer value = this.pop();
        this.top.append(" = ");
        this.top.append((Object)value);
    }

    public void visitSetFunction(SetFunction x) {
        if (x.isDistinct()) {
            this.top.insert(0, "DISTINCT ");
        }
        switch (x.getSetFunctionType()) {
            case 1: {
                this.top.insert(0, "AVG(");
                break;
            }
            case 2: {
                this.top.insert(0, "MIN(");
                break;
            }
            case 3: {
                this.top.insert(0, "MAX(");
                break;
            }
            case 4: {
                this.top.insert(0, "SUM(");
                break;
            }
            case 5: {
                this.top.insert(0, "COUNT(");
            }
        }
        this.top.append(')');
    }

    public void visitSortSpecificationBefore(SortSpecification x) {
        StringBuffer buffer = new StringBuffer();
        if (x.getIndex() != 0) {
            buffer.append(Integer.toString(x.getIndex()));
        } else {
            NormalizeVisitor.toDelimitedIdentifier(x.getColumnName(), buffer);
        }
        if (x.isDescending()) {
            buffer.append(" DESC");
        }
        this.push(buffer);
    }

    public void visitStringLiteral(StringLiteral x) {
        this.push('\'' + x.getValue() + '\'');
    }

    public void visitTableReference(TableReference x) {
        this.push(x.toString());
    }

    public void visitTableValue(TableValue x) {
        int rowValueCnt = x.getRowValues().length;
        StringBuffer buffer = new StringBuffer("VALUES ");
        RowValue value = x.getRowValues()[0];
        if (value instanceof RowValueElement) {
            buffer.append("( ");
        }
        buffer.append((Object)this.pop());
        if (value instanceof RowValueElement) {
            buffer.append(") ");
        }
        this.push(buffer);
    }

    public void visitUpdateStatement(UpdateStatement x) {
        StringBuffer buffer = new StringBuffer("UPDATE ");
        StringBuffer where = x.getWhereClause() == null ? null : this.pop();
        StringBuffer set = this.listToString(x.getSetClauseList(), ",");
        buffer.append((Object)this.pop());
        buffer.append(" SET ");
        buffer.append((Object)set);
        if (where != null) {
            buffer.append(" WHERE ");
            buffer.append((Object)where);
        }
        this.push(buffer);
    }

    public void visitSelectForUpdate(SelectForUpdateStatement x) {
        StringBuffer updateFieldList = this.listToString(x.getUpdateFieldList(), ", ");
        this.top.append(" FOR UPDATE ");
        if (updateFieldList != null) {
            this.top.append(" OF ");
            this.top.append((Object)updateFieldList);
        }
    }

    public String getString() {
        if (this.stack.size() > 0) {
            return this.pop().toString();
        }
        return "";
    }
}

