/*
 * Decompiled with CFR 0.152.
 */
package com.sap.typeservices;

import com.sap.typeservices.ISimpleValueSet;
import com.sap.typeservices.SimpleValueSetException;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Vector;

public class SimpleValueSet
extends AbstractMap
implements ISimpleValueSet {
    protected Vector table = new Vector();
    protected Set entrySet = null;
    protected Locale defaultLocale;
    protected Locale locale;
    private static final Object NULL_KEY = new Object();

    private static final Object unmaskNull(Object key) {
        return key == NULL_KEY ? null : key;
    }

    private static final Object maskNull(Object key) {
        return key == null ? NULL_KEY : key;
    }

    private static final boolean eq(Object o1, Object o2) {
        return o1 == o2 || o1.equals(o2);
    }

    public SimpleValueSet() {
        this(Locale.getDefault());
    }

    public SimpleValueSet(Locale locale) {
        this.defaultLocale = this.locale = locale;
    }

    public Locale getLocale() {
        return this.defaultLocale;
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet(){

                public Iterator iterator() {
                    return new Iterator(this){
                        private int index;
                        private boolean isIllegalState;
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                            this.index = 0;
                            this.isIllegalState = true;
                        }

                        public boolean hasNext() {
                            return this.index < 1.access$100(this.this$1).table.size();
                        }

                        public Object next() {
                            if (this.hasNext()) {
                                this.isIllegalState = false;
                                return 1.access$100(this.this$1).table.get(this.index++);
                            }
                            throw new NoSuchElementException();
                        }

                        public void remove() {
                            if (this.isIllegalState) {
                                throw new IllegalStateException();
                            }
                            1.access$100(this.this$1).table.remove(--this.index);
                            this.isIllegalState = true;
                        }
                    };
                }

                public int size() {
                    return SimpleValueSet.this.table.size();
                }

                static /* synthetic */ SimpleValueSet access$100(1 x0) {
                    return x0.SimpleValueSet.this;
                }
            };
        }
        return this.entrySet;
    }

    public Object put(Object key, Object value) {
        Object k = SimpleValueSet.maskNull(key);
        int i = 0;
        while (i < this.table.size()) {
            Entry e = (Entry)this.table.get(i);
            if (SimpleValueSet.eq(e.key, k)) {
                return e.setValue(value);
            }
            ++i;
        }
        this.table.add(new Entry(k, value));
        return null;
    }

    public Collection texts() {
        return this.values();
    }

    public Collection texts(Locale locale) {
        final Locale l = locale;
        return new AbstractCollection(){

            public Iterator iterator() {
                return new Iterator(this){
                    private Iterator i;
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                        this.i = 3.access$200(this.this$1).entrySet().iterator();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    public Object next() {
                        return ((Entry)this.i.next()).map.get(3.access$300(this.this$1));
                    }

                    public void remove() {
                        this.i.remove();
                    }
                };
            }

            public int size() {
                return SimpleValueSet.this.table.size();
            }

            static /* synthetic */ SimpleValueSet access$200(3 x0) {
                return x0.SimpleValueSet.this;
            }

            static /* synthetic */ Locale access$300(3 x0) {
                return x0.l;
            }
        };
    }

    private String internalGetText(Object key, Locale loc) {
        String text;
        this.locale = loc;
        while (SimpleValueSet.isEmpty(text = (String)this.get(key))) {
            if (this.locale == null) break;
            if (!SimpleValueSet.isEmpty(this.locale.getVariant())) {
                this.locale = new Locale(this.locale.getLanguage(), this.locale.getCountry());
                continue;
            }
            if (!SimpleValueSet.isEmpty(this.locale.getCountry())) {
                this.locale = new Locale(this.locale.getLanguage(), "");
                continue;
            }
            if (SimpleValueSet.isEmpty(this.locale.getLanguage())) break;
            this.locale = new Locale("", "");
        }
        return text;
    }

    public boolean hasText(Object key, Locale loc) {
        return this.internalGetText(key, loc) != null;
    }

    public String getText(Object key) {
        return this.getText(key, this.locale);
    }

    public String getText(Object key, Locale loc) {
        String text = this.internalGetText(key, loc);
        if (text == null) {
            text = key != null ? key.toString() : null;
        }
        this.locale = this.defaultLocale;
        return text;
    }

    private static boolean isEmpty(String text) {
        return text == null || text.length() == 0;
    }

    public Object getKey(String text) {
        Iterator i = this.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            if (!SimpleValueSet.eq(SimpleValueSet.maskNull(this.getText(key)), text)) continue;
            return key;
        }
        return null;
    }

    public Object getKey(String text, Locale locale) {
        this.locale = locale;
        Object getKey = this.getKey(text);
        this.locale = this.defaultLocale;
        return getKey;
    }

    public String getText(int index) {
        return (String)((Entry)this.table.get(index)).getValue();
    }

    public String getText(int index, Locale locale) {
        String text;
        this.locale = locale;
        while (SimpleValueSet.isEmpty(text = this.getText(index))) {
            if (locale == null) break;
            if (!SimpleValueSet.isEmpty(locale.getVariant())) {
                locale = new Locale(locale.getLanguage(), locale.getCountry());
                continue;
            }
            if (!SimpleValueSet.isEmpty(locale.getCountry())) {
                locale = new Locale(locale.getLanguage(), "");
                continue;
            }
            if (SimpleValueSet.isEmpty(locale.getLanguage())) break;
            locale = new Locale("", "");
        }
        if (text == null) {
            text = this.getKey(index) != null ? this.getKey(index).toString() : null;
        }
        this.locale = this.defaultLocale;
        return text;
    }

    public Object getKey(int index) {
        return ((Entry)this.table.get(index)).getKey();
    }

    public boolean containsText(String text) {
        return this.containsValue(text);
    }

    public boolean containsText(String text, Locale locale) {
        this.locale = locale;
        boolean containsText = false;
        while (!this.containsValue(text)) {
            if (locale == null) break;
            if (!SimpleValueSet.isEmpty(locale.getVariant())) {
                locale = new Locale(locale.getLanguage(), locale.getCountry());
                continue;
            }
            if (!SimpleValueSet.isEmpty(locale.getCountry())) {
                locale = new Locale(locale.getLanguage(), "");
                continue;
            }
            if (SimpleValueSet.isEmpty(locale.getLanguage())) break;
            locale = new Locale("", "");
        }
        this.locale = this.defaultLocale;
        return containsText;
    }

    public void checkValue(Object value) throws SimpleValueSetException {
        if (!this.containsKey(value)) {
            throw new SimpleValueSetException("{0} is not one of the allowed values", value);
        }
    }

    protected class Entry
    implements Map.Entry {
        Object key;
        Map map = new HashMap();

        Entry(Object key, Object value) {
            this.key = key;
            this.map.put(SimpleValueSet.this.locale, value);
        }

        Entry(Object key, Map map) {
            this.key = key;
            this.map = map;
        }

        public Object getKey() {
            return SimpleValueSet.unmaskNull(this.key);
        }

        public Object getValue() {
            return this.map.get(SimpleValueSet.this.locale);
        }

        public Object setValue(Object value) {
            return this.map.put(SimpleValueSet.this.locale, value);
        }

        public String toString() {
            return this.getKey() + "=" + this.map;
        }
    }
}

