/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.https;

import com.sap.security.core.server.https.HostnameVerifier;
import com.sap.security.core.server.https.LoggingOutputStream;
import com.sap.security.core.server.https.V3ChainVerifier;
import com.sap.tc.logging.Location;
import iaik.pkcs.PKCS7CertList;
import iaik.pkcs.PKCSParsingException;
import iaik.pkcs.pkcs12.CertificateBag;
import iaik.pkcs.pkcs12.KeyBag;
import iaik.pkcs.pkcs12.PKCS12;
import iaik.protocol.https.HttpsURLConnection;
import iaik.security.ssl.SSLSocket;
import iaik.utils.Util;
import iaik.x509.X509Certificate;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URLConnection;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchProviderException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class Utils {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$security$core$server$https$Utils == null ? (class$com$sap$security$core$server$https$Utils = Utils.class$("com.sap.security.core.server.https.Utils")) : class$com$sap$security$core$server$https$Utils));
    static /* synthetic */ Class class$com$sap$security$core$server$https$Utils;

    public static Socket getProxySocket(String host, int port) throws IOException {
        int proxyPort;
        String me = "getProxySocket(String host, int port )";
        LOCATION.entering("getProxySocket(String host, int port )", new Object[]{host, "" + port});
        String proxyHost = System.getProperty("https.proxyHost");
        try {
            proxyPort = new Integer(System.getProperty("https.proxyPort"));
        }
        catch (NumberFormatException ex) {
            LOCATION.debugT("incorrect proxyPort: " + System.getProperty("https.proxyPort"));
            throw new IOException("undefined proxy port: " + System.getProperty("https.proxyPort"));
        }
        LOCATION.debugT("proxyHost/proxyPort detected: " + proxyHost + ":" + proxyPort);
        LOCATION.exiting();
        return Utils.getProxySocket(host, port, proxyHost, proxyPort);
    }

    public static Socket getProxySocket(String host, int port, String proxyusr, String proxypwd) throws IOException {
        int proxyPort;
        String me = "getProxySocket(String host, int port, String proxyusr, String proxypwd )";
        LOCATION.entering("getProxySocket(String host, int port, String proxyusr, String proxypwd )", new Object[]{host, "" + port, proxyusr, "---"});
        String proxyHost = System.getProperty("https.proxyHost");
        try {
            proxyPort = new Integer(System.getProperty("https.proxyPort"));
        }
        catch (NumberFormatException ex) {
            LOCATION.debugT("incorrect proxyPort: " + System.getProperty("https.proxyPort"));
            throw new IOException("undefined proxy port: " + System.getProperty("https.proxyPort"));
        }
        LOCATION.debugT("proxyHost/proxyPort detected: " + proxyHost + ":" + proxyPort);
        LOCATION.exiting();
        return Utils.getProxySocket(host, port, proxyHost, proxyPort, proxyusr, proxypwd);
    }

    public static Socket getProxySocket(String host, int port, String proxyServer, int proxyPort) throws IOException {
        return Utils.getProxySocket(host, port, null, proxyServer, proxyPort, null, null);
    }

    public static Socket getProxySocket(String host, int port, String proxyServer, int proxyPort, String proxyusr, String proxypwd) throws IOException {
        return Utils.getProxySocket(host, port, null, proxyServer, proxyPort, proxyusr, proxypwd);
    }

    protected static Socket getProxySocket(String host, int port, String authenticationMechanism, String proxyServer, int proxyPort, String proxyusr, String proxypwd) throws IOException {
        String headerLine;
        String _proxypwd = proxypwd == null || proxypwd.length() < 2 ? "---" : proxypwd.substring(0, 2) + "...";
        String me = "getProxySocket (..)";
        LOCATION.entering("getProxySocket (..)", new Object[]{host, new Integer(port), authenticationMechanism, proxyServer, new Integer(proxyPort), proxyusr, _proxypwd});
        LOCATION.debugT("opening socket to :" + proxyServer + ":" + proxyPort);
        Socket proxySocket = new Socket(proxyServer, proxyPort);
        proxySocket.setSoTimeout(30000);
        PrintWriter writer = iaik.security.ssl.Utils.getASCIIWriter((OutputStream)proxySocket.getOutputStream());
        String msg = "CONNECT " + host + ":" + port + " HTTP/1.0";
        writer.println(msg);
        if (authenticationMechanism != null) {
            String authMsg = null;
            if (authenticationMechanism.toUpperCase().startsWith("BASIC")) {
                String proxyPassword;
                String proxyUser = proxyusr == null ? System.getProperty("https.proxyUser") : proxyusr;
                String string = proxyPassword = proxypwd == null ? System.getProperty("https.proxyPassword") : proxypwd;
                if (proxyUser != null && proxyPassword != null) {
                    authMsg = "BASIC " + new String(Util.Base64Encode((byte[])(proxyUser + ":" + proxyPassword).getBytes()));
                }
            }
            if (authMsg != null) {
                msg = "Proxy-Authorization: " + authMsg;
                writer.println(msg);
            }
        }
        writer.println();
        writer.flush();
        BufferedReader reader = iaik.security.ssl.Utils.getASCIIReader((InputStream)proxySocket.getInputStream());
        String reqAuthMechanism = null;
        String requestLine = reader.readLine();
        while ((headerLine = reader.readLine()) != null && headerLine.length() != 0) {
            int index = headerLine.indexOf("Proxy-Authenticate:");
            if (!headerLine.startsWith("Proxy-Authenticate: ")) continue;
            reqAuthMechanism = headerLine.substring("Proxy-Authenticate:".length()).trim();
        }
        if (requestLine == null || !requestLine.startsWith("HTTP/1.")) {
            LOCATION.debugT("Invalid response from proxy: " + requestLine);
            throw new IOException("Invalid response from proxy: " + requestLine);
        }
        if (requestLine.substring("HTTP/1.x".length()).trim().startsWith("407") && reqAuthMechanism != null) {
            if (authenticationMechanism != null) {
                LOCATION.debugT("Proxy authentication failed. Wrong user or password.");
                throw new IOException("Proxy authentication failed. Wrong user or password.");
            }
            LOCATION.debugT("trying proxy connection again with authentication");
            return Utils.getProxySocket(host, port, reqAuthMechanism, proxyServer, proxyPort, proxyusr, proxypwd);
        }
        if (!requestLine.substring("HTTP/1.x ".length()).trim().startsWith("2")) {
            LOCATION.debugT("Proxy responded: " + requestLine);
            throw new IOException("Proxy responded: " + requestLine);
        }
        LOCATION.exiting();
        return proxySocket;
    }

    public static KeyStore getJavaDefaultKeystore() {
        String me = "getJavaDefaultKeystore ()";
        LOCATION.entering("getJavaDefaultKeystore ()", new Object[0]);
        String filename = System.getProperty("java.home") + File.separator + "jre" + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts";
        if (!new File(filename).exists()) {
            filename = System.getProperty("java.home") + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts";
        }
        LOCATION.infoT("Default keystore: " + filename);
        KeyStore keystore = null;
        try {
            keystore = KeyStore.getInstance("JKS");
            keystore.load(new FileInputStream(filename), "changeit".toCharArray());
        }
        catch (Exception ex) {
            LOCATION.errorT("Exception on loading default keystore from <" + filename + "> :" + ex.toString());
        }
        LOCATION.exiting();
        return keystore;
    }

    public static void setBasicAuthenticationHeader(HttpURLConnection con, String username, String pwd) {
        String basicAuth = new String(Util.Base64Encode((byte[])(username + ":" + pwd).getBytes()));
        basicAuth = "Basic " + basicAuth;
        con.setRequestProperty("Authorization", basicAuth);
    }

    public static void setProxyAuthentication(HttpURLConnection con, String proxyuser, String proxypwd) {
        String authMsg = "Basic " + new String(Util.Base64Encode((byte[])(proxyuser + ":" + proxypwd).getBytes()));
        con.setRequestProperty("Https-Proxy-Authorization", authMsg);
    }

    private static ByteArrayOutputStream loadIntoByteAOS(InputStream input) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int num = 0;
        while ((num = input.read(buf)) != -1) {
            bout.write(buf, 0, num);
        }
        return bout;
    }

    private static ByteArrayOutputStream loadIntoByteAOS(HttpURLConnection con) throws IOException {
        return Utils.loadIntoByteAOS(con.getInputStream());
    }

    public static byte[] loadAsBytes(HttpURLConnection con) throws IOException {
        return Utils.loadIntoByteAOS(con.getInputStream()).toByteArray();
    }

    public static byte[] loadAsBytes(InputStream input) throws IOException {
        return Utils.loadIntoByteAOS(input).toByteArray();
    }

    public static Hashtable getHttpHeaders(HttpURLConnection con) {
        Hashtable<String, String> headers = new Hashtable<String, String>();
        int n = 1;
        while (true) {
            String headerkey = ((URLConnection)con).getHeaderFieldKey(n);
            String header = ((URLConnection)con).getHeaderField(n);
            if (header == null) break;
            headers.put(headerkey, header);
            ++n;
        }
        return headers;
    }

    public static String headersToString(Hashtable headers) {
        StringBuffer sb = new StringBuffer();
        Enumeration enumeration = headers.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            sb.append(key + ": " + headers.get(key) + System.getProperty("line.separator"));
        }
        return sb.toString();
    }

    public static void setIgnoreServerCertificate(HttpURLConnection con) {
        String me = "setIgnoreServerCertificate ( HttpURLConnection con )";
        LOCATION.entering("setIgnoreServerCertificate ( HttpURLConnection con )", new Object[]{con});
        if (!(con instanceof HttpsURLConnection)) {
            LOCATION.debugT(con + " is not an instance of iaik.protocol.https.HttpsURLConnection");
            LOCATION.exiting();
            return;
        }
        HttpsURLConnection httpscon = (HttpsURLConnection)con;
        httpscon.getSSLContext().setChainVerifier(null);
        LOCATION.exiting();
    }

    public static void setIgnoreServerCertificate(Socket socket) {
        String me = "setIgnoreServerCertificate ( Socket socket )";
        LOCATION.entering("setIgnoreServerCertificate ( Socket socket )", new Object[]{socket});
        if (!(socket instanceof SSLSocket)) {
            LOCATION.debugT(socket + " is not an instance of iaik.security.ssl.Socket");
            LOCATION.exiting();
            return;
        }
        SSLSocket iaiksocket = (SSLSocket)socket;
        iaiksocket.getContext().setChainVerifier(null);
        LOCATION.exiting();
    }

    public static void setHostnameVerifier(HttpURLConnection con, HostnameVerifier verifier) {
        String me = "setHostnameVerifier ( HttpURLConnection con, HostnameVerifier verifier )";
        LOCATION.entering("setHostnameVerifier ( HttpURLConnection con, HostnameVerifier verifier )", new Object[]{con, verifier});
        if (!(con instanceof HttpsURLConnection)) {
            LOCATION.debugT(con + " is not an instance of iaik.protocol.https.HttpsURLConnection");
            LOCATION.exiting();
            return;
        }
        HttpsURLConnection httpscon = (HttpsURLConnection)con;
        ((V3ChainVerifier)httpscon.getSSLContext().getChainVerifier()).setHostnameVerifier(verifier);
        LOCATION.exiting();
    }

    public static void setSSLDebugStream(HttpURLConnection con, OutputStream os) {
        String me = "setDebugOutputStream  ( HttpURLConnection con, OutputStream os )";
        LOCATION.entering("setDebugOutputStream  ( HttpURLConnection con, OutputStream os )", new Object[]{con});
        if (!(con instanceof HttpsURLConnection)) {
            LOCATION.debugT(con + " is not an instance of iaik.protocol.https.HttpsURLConnection");
            LOCATION.exiting();
            return;
        }
        HttpsURLConnection httpscon = (HttpsURLConnection)con;
        httpscon.getSSLContext().setDebugStream((OutputStream)new LoggingOutputStream(os));
        LOCATION.exiting();
    }

    public static boolean isNonProxyHost(String host) {
        String me = "isNonProxyHost(String host) ";
        LOCATION.entering("isNonProxyHost(String host) ", new Object[]{host});
        String proxyhost = System.getProperty("https.proxyHost");
        if (proxyhost == null || "".equals(proxyhost)) {
            return true;
        }
        boolean isNonProxyHost = false;
        String nonProxyHosts = System.getProperty("https.nonProxyHosts");
        if (host != null && nonProxyHosts != null) {
            host = host.toLowerCase();
            nonProxyHosts = nonProxyHosts.toLowerCase();
            StringTokenizer tokenizer = new StringTokenizer(nonProxyHosts, " |", false);
            while (tokenizer.hasMoreTokens()) {
                String hostMatchString = tokenizer.nextToken();
                if (hostMatchString.startsWith("*")) {
                    String hostEndString = hostMatchString.substring(1);
                    if (!host.endsWith(hostEndString)) continue;
                    isNonProxyHost = true;
                } else {
                    if (!host.equals(hostMatchString)) continue;
                    isNonProxyHost = true;
                }
                break;
            }
        } else {
            isNonProxyHost = false;
        }
        LOCATION.infoT("isNonProxyHost returns: " + isNonProxyHost);
        LOCATION.exiting();
        return isNonProxyHost;
    }

    public KeyStore convertPKCS7ToKeyStore(InputStream is, char[] password) throws KeyStoreException, CertificateException {
        String me = "convertPKCS7toKeyStore (InputStream is, char[] password) ";
        LOCATION.entering("convertPKCS7toKeyStore (InputStream is, char[] password) ");
        PKCS7CertList pkcs7 = null;
        X509Certificate[] certs = null;
        try {
            pkcs7 = new PKCS7CertList(is);
            certs = pkcs7.getCertificateList();
        }
        catch (PKCSParsingException e) {
            LOCATION.debugT(e.toString());
            throw new KeyStoreException(e.getMessage());
        }
        catch (IOException e) {
            LOCATION.debugT(e.toString());
            throw new KeyStoreException(e.getMessage());
        }
        KeyStore ks = null;
        ks = KeyStore.getInstance("KeyStore");
        try {
            ks.load(null, null);
        }
        catch (Exception e1) {
            LOCATION.debugT(e1.toString());
            throw new KeyStoreException(e1.getMessage());
        }
        int i = 0;
        while (i < certs.length) {
            String principal = certs[i].getSubjectDN().getName();
            ks.setCertificateEntry(principal, (Certificate)certs[i]);
            ++i;
        }
        return ks;
    }

    public KeyStore convertCertificateToKeyStore(InputStream is, char[] password) throws KeyStoreException, CertificateException {
        String me = "convertCertificateToKeyStore (InputStream is, char[] password) ";
        LOCATION.entering("convertCertificateToKeyStore (InputStream is, char[] password) ");
        KeyStore ks = null;
        CertificateFactory cf = null;
        try {
            cf = CertificateFactory.getInstance("X.509");
            ks = KeyStore.getInstance("KeyStore");
        }
        catch (Exception e) {
            LOCATION.debugT(e.toString());
            throw new KeyStoreException(e.getMessage());
        }
        try {
            ks.load(null, null);
        }
        catch (Exception e) {
            LOCATION.debugT(e.toString());
            throw new KeyStoreException(e.getMessage());
        }
        X509Certificate cert = (X509Certificate)cf.generateCertificate(is);
        String principal = cert.getSubjectDN().getName();
        ks.setCertificateEntry(principal, (Certificate)cert);
        LOCATION.exiting();
        return ks;
    }

    public static KeyStore convertPKCS12ToKeyStore(InputStream certStream, char[] password) throws KeyStoreException, CertificateException {
        String me = "convertPKCS12ToKeyStore (InputStream is, char[] password) ";
        LOCATION.entering("convertPKCS12ToKeyStore (InputStream is, char[] password) ");
        HashMap<String, String> localKeyIDs = new HashMap<String, String>();
        PKCS12 pkcs12 = null;
        try {
            pkcs12 = new PKCS12(certStream);
            pkcs12.decrypt(password);
        }
        catch (Exception e) {
            LOCATION.debugT(e.toString());
            throw new CertificateException("Unable to import from PKCS12 stream: " + e.getMessage());
        }
        KeyStore ks = null;
        try {
            ks = KeyStore.getInstance("IAIKKeyStore", "IAIK");
        }
        catch (NoSuchProviderException e) {
            LOCATION.debugT(e.toString());
            throw new KeyStoreException("Unable to create keystore: " + e.getMessage());
        }
        try {
            ks.load(null, null);
        }
        catch (Exception e) {
            LOCATION.debugT(e.toString());
            throw new KeyStoreException("Unable to create keystore: " + e.getMessage());
        }
        CertificateBag[] certs = pkcs12.getCertificateBags();
        int i = 0;
        while (i < certs.length) {
            X509Certificate cert = certs[i].getCertificate();
            byte[] id = certs[i].getLocalKeyID();
            if (id != null) {
                localKeyIDs.put(new String(id), Utils.getPrincipal(cert));
            }
            ks.setCertificateEntry(Utils.getPrincipal(cert), (Certificate)cert);
            ++i;
        }
        KeyBag[] keys = pkcs12.getKeyBags();
        int i2 = 0;
        while (i2 < keys.length) {
            X509Certificate[] chain = Utils.getCertificateChain(ks, keys[i2], localKeyIDs);
            String principal = Utils.getPrincipal(chain[0]);
            ks.setKeyEntry(principal, keys[i2].getPrivateKey(), password, (Certificate[])chain);
            ++i2;
        }
        LOCATION.exiting();
        return ks;
    }

    private static String getPrincipal(X509Certificate cert) {
        return cert.getSubjectDN().getName();
    }

    private static X509Certificate[] getCertificateChain(KeyStore ks, KeyBag key, Map localKeyIDs) throws KeyStoreException {
        String me = "getCertificateChain (private) ";
        LOCATION.entering("getCertificateChain (private) ");
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        String subject = (String)localKeyIDs.get(new String(key.getLocalKeyID()));
        X509Certificate cert = (X509Certificate)ks.getCertificate(subject);
        if (cert == null) {
            String message = "Private key must have a certificate chain [missing certificate for " + subject + "]";
            LOCATION.debugT(message);
            throw new KeyStoreException(message);
        }
        String issuer = cert.getIssuerDN().getName();
        while (!subject.equals(issuer)) {
            certs.add(cert);
            subject = issuer;
            cert = (X509Certificate)ks.getCertificate(subject);
            if (cert == null) break;
            issuer = cert.getIssuerDN().getName();
        }
        if (cert != null) {
            certs.add(cert);
        }
        LOCATION.exiting();
        return certs.toArray(new X509Certificate[certs.size()]);
    }

    public static List getClientAliases(KeyStore keystore) throws KeyStoreException {
        ArrayList<String> list = new ArrayList<String>();
        Enumeration<String> aliases = keystore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (!keystore.isKeyEntry(alias)) continue;
            list.add(alias);
        }
        return list;
    }

    public boolean hasClientCertificates(KeyStore keystore) throws KeyStoreException {
        return Utils.getClientAliases(keystore).size() > 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

