/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.https;

import com.sap.security.core.server.https.DefaultHostnameVerifier;
import com.sap.security.core.server.https.HostnameVerifier;
import com.sap.security.core.server.https.LoggingOutputStream;
import com.sap.security.core.server.https.SocketFactory;
import com.sap.security.core.server.https.Utils;
import com.sap.security.core.server.https.V3ChainVerifier;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import iaik.protocol.https.Handler;
import iaik.protocol.https.HttpsURLConnection;
import iaik.security.ssl.ChainVerifier;
import iaik.security.ssl.DefaultSessionManager;
import iaik.security.ssl.KeyAndCert;
import iaik.security.ssl.SSLClientContext;
import iaik.security.ssl.SSLContext;
import iaik.security.ssl.SSLSocket;
import iaik.security.ssl.SessionManager;
import iaik.x509.X509Certificate;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.URLStreamHandler;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.naming.InitialContext;

public class SecureConnectionFactory
implements SocketFactory {
    private SSLClientContext defaultSSLContext;
    private SessionManager sessionManager;
    private KeyStore keystore;
    private KeyStore truststore;
    private Object keystoreCreds;
    private Object truststoreCreds;
    private String keystorepass;
    private OutputStream iaikDebugStream;
    private boolean ignoreServerCertifiate;
    private HostnameVerifier hnverifier;
    private boolean useProxyForSockets;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$security$core$server$https$SecureConnectionFactory == null ? (class$com$sap$security$core$server$https$SecureConnectionFactory = SecureConnectionFactory.class$("com.sap.security.core.server.https.SecureConnectionFactory")) : class$com$sap$security$core$server$https$SecureConnectionFactory));
    private static final Category CATEGORY = Category.getCategory((Category)Category.SYS_SECURITY, (String)"SecureConnectionFactory");
    private String myConnectionHeader;
    private X509Certificate[] _trustcerts;
    private KeyAndCert[] _keyandcerts;
    public boolean _isIAIKavailable;
    static /* synthetic */ Class class$com$sap$security$core$server$https$SecureConnectionFactory;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$iaik$security$ssl$SSLContext;

    public SecureConnectionFactory(KeyStore keystore) {
        this(keystore, null, keystore, null);
    }

    public SecureConnectionFactory(KeyStore truststore, KeyStore keystore) {
        this(truststore, null, keystore, null);
    }

    public SecureConnectionFactory(KeyStore truststore, Object truststoreCreds, KeyStore keystore, Object keystoreCreds) {
        this.defaultSSLContext = null;
        this.sessionManager = new DefaultSessionManager();
        this.keystore = null;
        this.truststore = null;
        this.keystorepass = null;
        this.iaikDebugStream = null;
        this.ignoreServerCertifiate = false;
        this.hnverifier = DefaultHostnameVerifier.getStrictInstance();
        this.useProxyForSockets = true;
        this.myConnectionHeader = "close";
        this._trustcerts = null;
        this._keyandcerts = null;
        this._isIAIKavailable = false;
        this.initFactory(truststore, truststoreCreds, keystore, keystoreCreds);
    }

    private SecureConnectionFactory() {
        this.defaultSSLContext = null;
        this.sessionManager = new DefaultSessionManager();
        this.keystore = null;
        this.truststore = null;
        this.keystorepass = null;
        this.iaikDebugStream = null;
        this.ignoreServerCertifiate = false;
        this.hnverifier = DefaultHostnameVerifier.getStrictInstance();
        this.useProxyForSockets = true;
        this.myConnectionHeader = "close";
        this._trustcerts = null;
        this._keyandcerts = null;
        this._isIAIKavailable = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SecureConnectionFactory(String trustview, String keyview) {
        KeyStore truststore;
        KeyStore keystore;
        block6: {
            this.defaultSSLContext = null;
            this.sessionManager = new DefaultSessionManager();
            this.keystore = null;
            this.truststore = null;
            this.keystorepass = null;
            this.iaikDebugStream = null;
            this.ignoreServerCertifiate = false;
            this.hnverifier = DefaultHostnameVerifier.getStrictInstance();
            this.useProxyForSockets = true;
            this.myConnectionHeader = "close";
            this._trustcerts = null;
            this._keyandcerts = null;
            this._isIAIKavailable = false;
            String me = "SecureConnectionFactory( String trustview, String keyview )";
            LOCATION.entering("SecureConnectionFactory( String trustview, String keyview )", new Object[]{trustview, keyview});
            final String _keyview = keyview;
            final String _trustview = trustview;
            keystore = null;
            truststore = null;
            InitialContext ctx = null;
            ClassLoader old_cl = Thread.currentThread().getContextClassLoader();
            LOCATION.infoT("Old ContextClassLoader stored (" + old_cl + ")");
            try {
                block5: {
                    try {
                        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                        LOCATION.infoT("New ClassLoader set for currentThread (" + this.getClass().getClassLoader() + ")");
                        ctx = new InitialContext();
                        final Object km_obj = ctx.lookup("keystore");
                        Class<?> cl = km_obj.getClass();
                        Class[] args = new Class[]{class$java$lang$String == null ? (class$java$lang$String = SecureConnectionFactory.class$("java.lang.String")) : class$java$lang$String};
                        final Method method = cl.getMethod("getKeystore", class$java$lang$String == null ? (class$java$lang$String = SecureConnectionFactory.class$("java.lang.String")) : class$java$lang$String);
                        if (keyview != null && !"".equals(keyview.trim())) {
                            keystore = (KeyStore)AccessController.doPrivileged(new PrivilegedAction(){

                                public Object run() {
                                    try {
                                        return method.invoke(km_obj, (Object[])new String[]{_keyview});
                                    }
                                    catch (InvocationTargetException e) {
                                        Throwable target_ex = e.getTargetException();
                                        CATEGORY.logThrowableT(500, LOCATION, "Access to the keystore view \"" + _keyview + "\" failed. Keystore doesn't exist or user not authorized !", target_ex);
                                    }
                                    catch (IllegalAccessException e) {
                                        CATEGORY.errorT(LOCATION, "Access to the keystore view \"" + _keyview + "\" failed with IllegalAccessException: " + e.toString() + "\n");
                                    }
                                    return null;
                                }
                            });
                        }
                        if (trustview == null || "".equals(trustview.trim())) break block5;
                        truststore = (KeyStore)AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                try {
                                    return method.invoke(km_obj, (Object[])new String[]{_trustview});
                                }
                                catch (InvocationTargetException e) {
                                    Throwable target_ex = e.getTargetException();
                                    CATEGORY.logThrowableT(500, LOCATION, "Access to the keystore view \"" + _trustview + "\" failed. Keystore doesn't exist or user not authorized !", target_ex);
                                }
                                catch (IllegalAccessException e) {
                                    CATEGORY.errorT(LOCATION, "Access to the keystore view \"" + _trustview + "\" failed with IllegalAccessException: " + e.toString() + "\n");
                                }
                                return null;
                            }
                        });
                    }
                    catch (Exception e) {
                        CATEGORY.errorT(LOCATION, "Unexpected exception during Keystore access: " + e.toString());
                        Object var15_16 = null;
                        Thread.currentThread().setContextClassLoader(old_cl);
                        LOCATION.infoT("Old ContextClassLoader restored");
                        break block6;
                    }
                }
                Object var15_15 = null;
                Thread.currentThread().setContextClassLoader(old_cl);
            }
            catch (Throwable throwable) {
                Object var15_17 = null;
                Thread.currentThread().setContextClassLoader(old_cl);
                LOCATION.infoT("Old ContextClassLoader restored");
                throw throwable;
            }
            LOCATION.infoT("Old ContextClassLoader restored");
        }
        this.initFactory(truststore, null, keystore, null);
        LOCATION.exiting();
    }

    public static SecureConnectionFactory getDefault() {
        return new SecureConnectionFactory("TrustedCAs", null);
    }

    protected void initFactory(KeyStore truststore, Object truststoreCreds, KeyStore keystore, Object keystoreCreds) {
        String me = "initFactory ( KeyStore truststore, Object truststoreCreds, KeyStore keystore, Object keystoreCreds)";
        LOCATION.entering("initFactory ( KeyStore truststore, Object truststoreCreds, KeyStore keystore, Object keystoreCreds)", new Object[]{truststore, truststoreCreds, keystore, keystoreCreds});
        this.keystore = keystore;
        this.truststore = truststore;
        this.truststoreCreds = truststoreCreds;
        this.keystoreCreds = keystoreCreds;
        LOCATION.exiting();
    }

    public SecureConnectionFactory(Certificate[] trustedcerts, Object[] keyandcerts) {
        this.defaultSSLContext = null;
        this.sessionManager = new DefaultSessionManager();
        this.keystore = null;
        this.truststore = null;
        this.keystorepass = null;
        this.iaikDebugStream = null;
        this.ignoreServerCertifiate = false;
        this.hnverifier = DefaultHostnameVerifier.getStrictInstance();
        this.useProxyForSockets = true;
        this.myConnectionHeader = "close";
        this._trustcerts = null;
        this._keyandcerts = null;
        this._isIAIKavailable = false;
        this.initFactory(trustedcerts, keyandcerts);
    }

    protected void initFactory(Certificate[] trustedcerts, Object[] keyandcerts) {
        int i;
        String me = "initFactory(Certificate[] trustedcerts,\tObject[] keyandcerts)";
        LOCATION.entering("initFactory(Certificate[] trustedcerts,\tObject[] keyandcerts)", new Object[]{trustedcerts, keyandcerts});
        if (trustedcerts != null) {
            this._trustcerts = new X509Certificate[trustedcerts.length];
            i = 0;
            while (i < trustedcerts.length) {
                try {
                    this._trustcerts[i] = new X509Certificate((InputStream)new ByteArrayInputStream(trustedcerts[i].getEncoded()));
                }
                catch (Exception e) {
                    LOCATION.debugT("incorrect certificate ignored " + trustedcerts[i] + "  " + e.toString());
                }
                ++i;
            }
        }
        if (keyandcerts != null) {
            this._keyandcerts = new KeyAndCert[keyandcerts.length];
            i = 0;
            while (i < keyandcerts.length) {
                if (keyandcerts[i] instanceof KeyAndCert) {
                    PrivateKey prKey = ((KeyAndCert)keyandcerts[i]).getPrivateKey();
                    java.security.cert.X509Certificate[] certs = ((KeyAndCert)keyandcerts[i]).getCertificateChain();
                    try {
                        int j = 0;
                        while (j < certs.length) {
                            certs[j] = new X509Certificate((InputStream)new ByteArrayInputStream(certs[j].getEncoded()));
                            ++j;
                        }
                        this._keyandcerts[i] = new KeyAndCert(certs, prKey);
                    }
                    catch (Exception e) {
                        LOCATION.debugT("certificate transformation failed " + e.toString());
                    }
                } else {
                    LOCATION.debugT(keyandcerts[i].getClass() + " instead of KeyAndCert at index " + i);
                }
                ++i;
            }
        }
    }

    public void setDefaultSSLContext(Object context) {
        if (context instanceof SSLClientContext) {
            this.defaultSSLContext = (SSLClientContext)context;
        }
    }

    public void setSSLDebugStream(OutputStream out) {
        this.iaikDebugStream = out;
    }

    public void setIgnoreServerCertificate(boolean arg) {
        this.ignoreServerCertifiate = arg;
    }

    public void setHostnameVerifier(HostnameVerifier ver) {
        this.hnverifier = ver;
    }

    public void setUseProxyForSocketConnection(boolean arg) {
        this.useProxyForSockets = arg;
    }

    private static void revertCertOrder(Object[] os) {
        int i = 0;
        int j = os.length;
        Object[] os2 = new Object[j];
        i = 0;
        while (i < j) {
            os2[j - i - 1] = os[i];
            ++i;
        }
        i = 0;
        while (i < j) {
            os[i] = os2[i];
            ++i;
        }
    }

    private SSLClientContext getSSLClientContext() throws KeyStoreException {
        return this.getSSLClientContext(null);
    }

    private SSLClientContext getSSLClientContext(String[] keyaliases) throws KeyStoreException {
        String me = "getSSLClientContext(String [] keyaliases)";
        LOCATION.entering("getSSLClientContext(String [] keyaliases)", (Object[])keyaliases);
        if (this.defaultSSLContext != null) {
            return this.defaultSSLContext;
        }
        if (this.truststore == null && this._trustcerts == null) {
            CATEGORY.warningT(LOCATION, "Attempting to create outgoing ssl connection without trusted certificates");
        }
        if (!this._isIAIKavailable) {
            this._isIAIKavailable = SecureConnectionFactory.isIAIKavailable();
            if (!this._isIAIKavailable) {
                CATEGORY.warningT(LOCATION, "SAP Java Crypto Toolkit NOT installed !");
            }
        }
        if (keyaliases != null) {
            Arrays.sort(keyaliases);
        }
        if (keyaliases != null) {
            this.sessionManager = new DefaultSessionManager();
        }
        final SSLClientContext clientContext = new SSLClientContext();
        clientContext.setSessionManager(this.sessionManager);
        final String[] _keyaliases = keyaliases;
        if (this.keystore != null) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws KeyStoreException {
                        Enumeration<String> allCerts = SecureConnectionFactory.this.keystore.aliases();
                        while (allCerts.hasMoreElements()) {
                            String alias = allCerts.nextElement();
                            if (!SecureConnectionFactory.this.keystore.isKeyEntry(alias)) continue;
                            if (_keyaliases != null && Arrays.binarySearch(_keyaliases, alias) < 0) {
                                LOCATION.infoT("Keyalias: " + alias + " rejected");
                                continue;
                            }
                            LOCATION.infoT("Keyalias: " + alias + " accepted");
                            Certificate[] certs = null;
                            PrivateKey key = null;
                            try {
                                Object[] x509Certs;
                                block9: {
                                    certs = SecureConnectionFactory.this.keystore.getCertificateChain(alias);
                                    Key _key = SecureConnectionFactory.this.keystore.getKey(alias, (char[])SecureConnectionFactory.this.keystoreCreds);
                                    if (!(_key instanceof PrivateKey)) {
                                        LOCATION.infoT("unsupported key (" + _key.getClass() + ")");
                                        LOCATION.infoT("Keyalias: " + alias + " ignored");
                                        continue;
                                    }
                                    key = (PrivateKey)_key;
                                    x509Certs = new X509Certificate[certs.length];
                                    int i = 0;
                                    while (i < certs.length) {
                                        x509Certs[i] = new X509Certificate((InputStream)new ByteArrayInputStream(certs[i].getEncoded()));
                                        ++i;
                                    }
                                    try {
                                        if (!x509Certs[0].getSubjectDN().toString().equals(x509Certs[0].getIssuerDN().toString())) break block9;
                                        SecureConnectionFactory.revertCertOrder(x509Certs);
                                    }
                                    catch (Exception e) {
                                        LOCATION.infoT("an error occured during reverting certificate chain order");
                                        LOCATION.infoT("Keyalias: " + alias + " ignored");
                                        continue;
                                    }
                                }
                                LOCATION.infoT("add creds: " + x509Certs[0].getSubjectDN());
                                clientContext.addClientCredentials((java.security.cert.X509Certificate[])x509Certs, key);
                            }
                            catch (GeneralSecurityException gkse) {
                                throw new KeyStoreException(gkse.toString());
                            }
                            catch (IOException ioex) {
                                throw new KeyStoreException(ioex.toString());
                            }
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException ex) {
                throw (KeyStoreException)ex.getException();
            }
        } else if (this._keyandcerts != null) {
            int i = 0;
            while (i < this._keyandcerts.length) {
                if (this._keyandcerts[i] != null) {
                    LOCATION.infoT("add creds: " + (this._keyandcerts[i].getCertificateChain().length > 0 ? this._keyandcerts[i].getCertificateChain()[0].getSubjectDN().toString() : "???"));
                    clientContext.addClientCredentials(this._keyandcerts[i]);
                }
                ++i;
            }
        }
        if (!this.ignoreServerCertifiate) {
            final V3ChainVerifier verifier = new V3ChainVerifier();
            if (this.truststore != null) {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws KeyStoreException {
                            Enumeration<String> allCerts = SecureConnectionFactory.this.truststore.aliases();
                            while (allCerts.hasMoreElements()) {
                                String alias = allCerts.nextElement();
                                if (!SecureConnectionFactory.this.truststore.isCertificateEntry(alias)) continue;
                                try {
                                    X509Certificate cert = new X509Certificate((InputStream)new ByteArrayInputStream(((java.security.cert.X509Certificate)SecureConnectionFactory.this.truststore.getCertificate(alias)).getEncoded()));
                                    LOCATION.infoT("add trusted: " + cert);
                                    verifier.addTrustedCertificate((java.security.cert.X509Certificate)cert);
                                }
                                catch (GeneralSecurityException gkse) {
                                    throw new KeyStoreException(gkse.toString());
                                }
                                catch (IOException ioex) {
                                    throw new KeyStoreException(ioex.toString());
                                }
                            }
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException ex) {
                    throw (KeyStoreException)ex.getException();
                }
            } else if (this._trustcerts != null) {
                int i = 0;
                while (i < this._trustcerts.length) {
                    if (this._trustcerts[i] != null) {
                        LOCATION.infoT("add trusted: " + this._trustcerts[i].getSubjectDN());
                        verifier.addTrustedCertificate((java.security.cert.X509Certificate)this._trustcerts[i]);
                    }
                    ++i;
                }
            }
            if (this.hnverifier != null) {
                verifier.setHostnameVerifier(this.hnverifier);
            }
            clientContext.setChainVerifier((ChainVerifier)verifier);
        } else {
            clientContext.setChainVerifier(null);
        }
        if (LoggingOutputStream.loggingAktiv() || this.iaikDebugStream != null) {
            clientContext.setDebugStream((OutputStream)new LoggingOutputStream(this.iaikDebugStream));
        }
        clientContext.setCacheTerminatedSessions(true);
        LOCATION.exiting();
        return clientContext;
    }

    public HttpURLConnection createURLConnection(String protocol, String host, int port, String file) throws MalformedURLException, IOException, KeyStoreException {
        String[] keyaliases = null;
        return this.createURLConnection(protocol, host, port, file, keyaliases);
    }

    public HttpURLConnection createURLConnection(String protocol, String host, int port, String file, String keyalias) throws MalformedURLException, IOException, KeyStoreException {
        String[] keyaliases = new String[]{keyalias};
        return this.createURLConnection(protocol, host, port, file, keyaliases);
    }

    public HttpURLConnection createURLConnection(String protocol, String host, int port, String file, String[] keyaliases) throws MalformedURLException, IOException, KeyStoreException {
        String me = "createURLConnection (String protocol, String host, int port, String file, String [] keyaliases)";
        LOCATION.entering("createURLConnection (String protocol, String host, int port, String file, String [] keyaliases)", new Object[]{protocol, host, new Integer(port), file, keyaliases});
        String myurl = "";
        myurl = myurl + protocol;
        if (protocol != null && !protocol.endsWith("://")) {
            myurl = myurl + "://";
        }
        myurl = myurl + host;
        if (port > 0) {
            myurl = myurl + ":" + port;
        }
        if (host != null && file != null && !host.endsWith("/") && !file.startsWith("/")) {
            myurl = myurl + "/";
        }
        if (file != null) {
            myurl = myurl + file;
        }
        LOCATION.exiting();
        return this.createURLConnection(myurl, keyaliases);
    }

    public HttpURLConnection createURLConnection(String url) throws MalformedURLException, IOException, KeyStoreException {
        String[] keyaliases = null;
        return this.createURLConnection(url, keyaliases);
    }

    public HttpURLConnection createURLConnection(String url, String keyalias) throws MalformedURLException, IOException, KeyStoreException {
        String[] keyaliases = new String[]{keyalias};
        return this.createURLConnection(url, keyaliases);
    }

    public HttpURLConnection createURLConnection(String url, String[] keyaliases) throws MalformedURLException, IOException, KeyStoreException {
        HttpURLConnection urlConnection;
        int iIdx;
        String me = "createURLConnection (String url, String [] keyaliases)";
        LOCATION.entering("createURLConnection (String url, String [] keyaliases)", new Object[]{url, keyaliases});
        if (url == null || (iIdx = url.indexOf("://")) == -1 || url.length() <= iIdx + 3) {
            throw new MalformedURLException("URL " + url + " is not valid");
        }
        String protocol = url.substring(0, iIdx);
        String _tmp = url.substring(iIdx + 3);
        if (_tmp.indexOf("/") < 0) {
            url = url + "/";
        }
        if ("https".equalsIgnoreCase(protocol)) {
            URL _url = new URL(null, url, (URLStreamHandler)new Handler());
            urlConnection = (HttpURLConnection)_url.openConnection();
            ((HttpsURLConnection)urlConnection).setSSLContext((SSLContext)this.getSSLClientContext(keyaliases));
        } else if ("http".equalsIgnoreCase(protocol)) {
            try {
                Class<?> clazz1 = Class.forName("org.w3c.www.protocol.http.Handler");
                URL _url = new URL(null, url, (URLStreamHandler)clazz1.newInstance());
                urlConnection = (HttpURLConnection)_url.openConnection();
            }
            catch (Exception e) {
                LOCATION.errorT(e.toString());
                throw new MalformedURLException("The protocol " + protocol + " is not supported");
            }
            try {
                Class<?> clazz2 = Class.forName("org.w3c.www.protocol.http.HttpURLConnection");
                Class[] args = new Class[]{class$iaik$security$ssl$SSLContext == null ? (class$iaik$security$ssl$SSLContext = SecureConnectionFactory.class$("iaik.security.ssl.SSLContext")) : class$iaik$security$ssl$SSLContext};
                Method method = clazz2.getMethod("setSSLContext", args);
                method.invoke((Object)urlConnection, this.getSSLClientContext(keyaliases));
                LOCATION.infoT("SSLContext added to http connection");
            }
            catch (Exception e) {
                LOCATION.infoT(e.toString());
                LOCATION.infoT("http->https redirects will be ignored");
            }
        } else {
            throw new MalformedURLException("The protocol " + protocol + " is not supported");
        }
        urlConnection.setRequestProperty("Connection", this.myConnectionHeader);
        LOCATION.exiting();
        return urlConnection;
    }

    public Socket createSocket(InetAddress inetAddr, int port) throws IOException {
        String[] aliases = null;
        return this.createSocket(inetAddr, port, aliases);
    }

    public Socket createSocket(InetAddress inetAddr, int port, String[] aliases) throws IOException {
        try {
            SSLClientContext cont = this.getSSLClientContext(aliases);
            SSLSocket iaikSocket = new SSLSocket(inetAddr, port, (SSLContext)cont);
            return iaikSocket;
        }
        catch (KeyStoreException ex) {
            throw new IOException("Unable to create SSLContext because of KeyStore Exception " + ex.getMessage());
        }
    }

    public Socket createSocket(String host, int port, InetAddress clientAddr, int cport) throws IOException {
        String[] aliases = null;
        return this.createSocket(host, port, clientAddr, cport, aliases);
    }

    public Socket createSocket(String host, int port, InetAddress clientAddr, int cport, String[] aliases) throws IOException {
        try {
            SSLClientContext cont = this.getSSLClientContext(aliases);
            SSLSocket iaikSocket = new SSLSocket(host, port, clientAddr, cport, (SSLContext)cont);
            return iaikSocket;
        }
        catch (KeyStoreException ex) {
            throw new IOException("Unable to create SSLContext because of KeyStore Exception " + ex.getMessage());
        }
    }

    public Socket createSocket(String host, int port) throws IOException {
        String[] aliases = null;
        return this.createSocket(host, port, aliases);
    }

    public Socket createSocket(String host, int port, String[] aliases) throws IOException {
        try {
            if (!this.useProxyForSockets || Utils.isNonProxyHost(host)) {
                SSLClientContext cont = this.getSSLClientContext(aliases);
                SSLSocket iaikSocket = new SSLSocket(host, port, (SSLContext)cont);
                return iaikSocket;
            }
            Socket psocket = Utils.getProxySocket(host, port);
            return this.createSocket(host, port, psocket);
        }
        catch (KeyStoreException ex) {
            throw new IOException("Unable to create SSLContext because of KeyStore Exception " + ex.getMessage());
        }
    }

    public Socket createSocket(InetAddress inetAddr, int port, InetAddress clientAddr, int cport) throws IOException {
        String[] aliases = null;
        return this.createSocket(inetAddr, port, clientAddr, cport, aliases);
    }

    public Socket createSocket(InetAddress inetAddr, int port, InetAddress clientAddr, int cport, String[] aliases) throws IOException {
        try {
            SSLClientContext cont = this.getSSLClientContext(aliases);
            SSLSocket iaikSocket = new SSLSocket(inetAddr, port, clientAddr, cport, (SSLContext)cont);
            return iaikSocket;
        }
        catch (KeyStoreException ex) {
            throw new IOException("Unable to create SSLContext because of KeyStore Exception " + ex.getMessage());
        }
    }

    public Socket createSocket(String host, int port, Socket socket) throws IOException {
        String[] aliases = null;
        return this.createSocket(host, port, socket, aliases);
    }

    public Socket createSocket(String host, int port, Socket socket, String[] aliases) throws IOException {
        try {
            SSLClientContext cont = this.getSSLClientContext(aliases);
            SSLSocket iaikSocket = new SSLSocket(socket, (SSLContext)cont, host, port);
            iaikSocket.setAutoHandshake(true);
            return iaikSocket;
        }
        catch (KeyStoreException ex) {
            throw new IOException("Unable to create SSLContext because of KeyStore Exception " + ex.getMessage());
        }
    }

    public void setConnectionHeader(String arg) {
        this.myConnectionHeader = arg;
    }

    public String getConnectionHeader() {
        return this.myConnectionHeader;
    }

    private static boolean isIAIKavailable() {
        try {
            Cipher.getInstance("RSA", "IAIK");
            return true;
        }
        catch (NoSuchPaddingException e) {
        }
        catch (NoSuchProviderException e) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        if (System.getProperty("org.w3c.www.protocol.http.userAgent") == null) {
            System.setProperty("org.w3c.www.protocol.http.userAgent", "SAP J2EE Engine/6.30");
        }
    }
}

