/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.qualified;

import iaik.utils.Util;
import iaik.x509.CertificateFactory;
import iaik.x509.X509Certificate;
import iaik.x509.qualified.QualifiedCertificate;
import iaik.x509.qualified.QualifiedCertificateException;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Collection;
import java.util.HashSet;

public class QualifiedCertificateFactory
extends CertificateFactory {
    private static boolean a;

    public Collection engineGenerateCertificates(InputStream inputStream) throws CertificateException {
        Collection collection = super.engineGenerateCertificates(inputStream);
        Object[] objectArray = collection.toArray();
        HashSet<X509Certificate> hashSet = new HashSet<X509Certificate>();
        int n = 0;
        while (n < objectArray.length) {
            X509Certificate x509Certificate = (X509Certificate)objectArray[n];
            QualifiedCertificate qualifiedCertificate = null;
            try {
                qualifiedCertificate = QualifiedCertificate.isQualifedCertificate(x509Certificate);
                hashSet.add(qualifiedCertificate);
            }
            catch (QualifiedCertificateException qualifiedCertificateException) {
                hashSet.add(x509Certificate);
            }
            ++n;
        }
        return hashSet;
    }

    public Certificate engineGenerateCertificate(InputStream inputStream) throws CertificateException {
        byte[] byArray = null;
        try {
            byArray = Util.readStream(inputStream);
        }
        catch (IOException iOException) {
            throw new CertificateException("Error reading certificate: " + iOException.getMessage());
        }
        try {
            return new QualifiedCertificate(byArray);
        }
        catch (Exception exception) {
            if (a) {
                System.out.println("engineGenerateCertificate: no qualified cert");
            }
            return new X509Certificate(byArray);
        }
    }
}

