/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.extensions.qualified.structures;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.GeneralName;
import iaik.x509.extensions.qualified.structures.QCStatementInfo;

public class SemanticsInformation
extends QCStatementInfo {
    GeneralName[] b;
    ObjectID a;
    public static final ObjectID statementID = new ObjectID("1.3.6.1.5.5.7.11.1", "SemanticsInformation");

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.a != null) {
            stringBuffer.append("SemanticsIdentifier: " + this.a.getName() + "\n");
        }
        if (this.b != null) {
            stringBuffer.append("NameRegsitrationAuthorities:\n");
            int n = 0;
            while (n < this.b.length) {
                stringBuffer.append(String.valueOf(this.b[n]) + "\n");
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object() throws CodingException {
        if (this.a == null && (this.b == null || this.b.length == 0)) {
            throw new CodingException("Cannot create ASN.1 object. Both semanticIdentifier and nameRegistrationAuthorities are not allowed to be null!");
        }
        SEQUENCE sEQUENCE = new SEQUENCE();
        if (this.a != null) {
            sEQUENCE.addComponent(this.a);
        }
        if (this.b != null) {
            SEQUENCE sEQUENCE2 = new SEQUENCE();
            int n = 0;
            while (n < this.b.length) {
                sEQUENCE2.addComponent(this.b[n].toASN1Object());
                ++n;
            }
            sEQUENCE.addComponent(sEQUENCE2);
        }
        return sEQUENCE;
    }

    public ObjectID getStatementID() {
        return statementID;
    }

    public ObjectID getSemanticsIdentifier() {
        return this.a;
    }

    public GeneralName[] getNameRegistrationAuthorities() {
        return this.b;
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        int n = aSN1Object.countComponents();
        if (n < 1 || n > 2) {
            throw new CodingException("Invalid number of components (" + n + ") in this SemanticsInformation!");
        }
        int n2 = 0;
        ASN1Object aSN1Object2 = aSN1Object.getComponentAt(n2);
        if (aSN1Object2.isA(ASN.ObjectID)) {
            this.a = (ObjectID)aSN1Object2;
            if (n == 2) {
                ++n2;
            } else {
                return;
            }
        }
        aSN1Object2 = aSN1Object.getComponentAt(n2);
        n = aSN1Object2.countComponents();
        if (n2 == 0 && n == 0) {
            throw new CodingException("Invalid empty SemanticsInformation object.");
        }
        this.b = new GeneralName[n];
        int n3 = 0;
        while (n3 < n) {
            this.b[n3] = new GeneralName(aSN1Object2.getComponentAt(n3));
            ++n3;
        }
    }

    public SemanticsInformation(ObjectID objectID, GeneralName[] generalNameArray) throws IllegalArgumentException {
        if (objectID == null && (generalNameArray == null || generalNameArray.length == 0)) {
            throw new IllegalArgumentException("Both semanticIdentifier and nameRegistrationAuthorities are not allowed to be null!");
        }
        this.a = objectID;
        this.b = generalNameArray;
    }

    public SemanticsInformation() {
    }
}

