/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejbjar.ddp;

import com.tssap.j2ee.core.ejbjar.context.EjbContext;
import com.tssap.j2ee.core.ejbjar.context.EntityBeanContext;
import com.tssap.j2ee.core.ejbjar.context.MessageDrivenBeanContext;
import com.tssap.j2ee.core.ejbjar.context.SessionBeanContext;
import com.tssap.j2ee.core.utils.StringArrayList;
import com.tssap.j2ee.core.utils.ddp.DdpDescriptor;
import com.tssap.j2ee.internal.core.ejbjar.EjbJarChildOrder;
import com.tssap.j2ee.internal.core.util.DomUtils;
import java.util.List;
import org.w3c.dom.Element;

public class SrrDdpExecutive
implements DdpDescriptor.Executive {
    public void apply(Object entity, Object value, DdpDescriptor descriptor) {
        String[] childOrder;
        if (entity instanceof EntityBeanContext) {
            childOrder = EjbJarChildOrder.ENTITY;
        } else if (entity instanceof SessionBeanContext) {
            childOrder = EjbJarChildOrder.SESSION;
        } else if (entity instanceof MessageDrivenBeanContext) {
            childOrder = EjbJarChildOrder.MESSAGE_DRIVEN;
        } else {
            return;
        }
        EjbContext context = (EjbContext)entity;
        Object source = context.getSource();
        if (!(source instanceof Element)) {
            return;
        }
        DomUtils.removeChildNodes((Element)((Element)source), (String)"security-role-ref");
        if (!(value instanceof List)) {
            return;
        }
        List refs = (List)value;
        int i = refs.size() - 1;
        while (i >= 0) {
            StringArrayList ref;
            Object refObj = refs.get(i);
            if (refObj instanceof StringArrayList && !(ref = (StringArrayList)refObj).isEmpty()) {
                String roleName = ref.getString(0);
                String description = null;
                if (ref.size() > 1) {
                    description = ref.getString(1);
                }
                this.getSrr((Element)source, childOrder, roleName, description);
            }
            --i;
        }
    }

    protected Element getSrr(Element ejb, String[] childOrder, String roleName, String description) {
        Element[] srrs = DomUtils.getChildElements((Element)ejb, (String)"security-role-ref");
        if (srrs == null || srrs.length == 0) {
            return this.createSrr(ejb, childOrder, roleName, description);
        }
        int i = 0;
        while (i < srrs.length) {
            Element srr = srrs[i];
            if (roleName.equals(DomUtils.getChildTextNodeValue((Element)srr, (String)"role-name"))) {
                return srr;
            }
            ++i;
        }
        return this.createSrr(ejb, childOrder, roleName, description);
    }

    private Element createSrr(Element ejb, String[] childOrder, String roleName, String description) {
        Element srr = DomUtils.createChildElement((Element)ejb, (String[])childOrder, (String)"security-role-ref");
        DomUtils.setChildTextNodeValue((Element)srr, (String[])EjbJarChildOrder.SECURITY_ROLE_REF, (String)"role-name", (String)roleName);
        if (description != null) {
            DomUtils.setChildTextNodeValue((Element)srr, (String[])EjbJarChildOrder.SECURITY_ROLE_REF, (String)"description", (String)description);
        }
        return srr;
    }
}

