/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejbjar.ddp;

import com.tssap.j2ee.core.ejbjar.AssemblyDescriptor;
import com.tssap.j2ee.core.ejbjar.context.EjbContext;
import com.tssap.j2ee.core.ejbjar.context.EntityBeanContext;
import com.tssap.j2ee.core.ejbjar.context.MessageDrivenBeanContext;
import com.tssap.j2ee.core.ejbjar.context.SessionBeanContext;
import com.tssap.j2ee.core.utils.StringArrayList;
import com.tssap.j2ee.core.utils.ddp.DdpDescriptor;
import com.tssap.j2ee.internal.core.ejbjar.EjbJarChildOrder;
import com.tssap.j2ee.internal.core.util.DomUtils;
import org.w3c.dom.Element;

public class SiraDdpExecutive
implements DdpDescriptor.Executive {
    public void apply(Object entity, Object value, DdpDescriptor descriptor) {
        AssemblyDescriptor ad;
        Object source;
        String[] childOrder;
        if (entity instanceof EntityBeanContext) {
            childOrder = EjbJarChildOrder.ENTITY;
        } else if (entity instanceof SessionBeanContext) {
            childOrder = EjbJarChildOrder.SESSION;
        } else if (entity instanceof MessageDrivenBeanContext) {
            childOrder = EjbJarChildOrder.MESSAGE_DRIVEN;
        } else {
            return;
        }
        EjbContext context = (EjbContext)entity;
        if (!(value instanceof StringArrayList)) {
            return;
        }
        StringArrayList sira = (StringArrayList)value;
        if (sira.isEmpty()) {
            return;
        }
        String roleName = sira.getString(0);
        if (roleName == null || roleName.trim().length() == 0) {
            return;
        }
        String description = null;
        if (sira.size() > 1) {
            description = sira.getString(1);
        }
        if (!((source = context.getSource()) instanceof Element)) {
            return;
        }
        Element runAs = this.getRunAs((Element)source, childOrder);
        DomUtils.setChildTextNodeValue((Element)runAs, (String[])EjbJarChildOrder.RUN_AS, (String)"role-name", (String)roleName);
        if (description != null) {
            DomUtils.setChildTextNodeValue((Element)runAs, (String[])EjbJarChildOrder.RUN_AS, (String)"description", (String)description);
        }
        if ((ad = context.getEjbJar().getAssemblyDescriptor()).canCreateSecurityRole(roleName, null)) {
            ad.createSecurityRole(roleName, null);
        }
    }

    protected Element getRunAs(Element ejb, String[] childOrder) {
        Element si = DomUtils.getChildElement((Element)ejb, (String)"security-identity");
        Element ra = null;
        if (si == null) {
            si = DomUtils.createChildElement((Element)ejb, (String[])childOrder, (String)"security-identity");
            ra = DomUtils.createChildElement((Element)si, (String[])EjbJarChildOrder.SECURITY_IDENTITY, (String)"run-as");
        } else {
            ra = DomUtils.getChildElement((Element)si, (String)"run-as");
            if (ra == null) {
                ra = DomUtils.createChildElement((Element)si, (String[])EjbJarChildOrder.SECURITY_IDENTITY, (String)"run-as");
            }
        }
        return ra;
    }
}

