/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejbjar;

import com.tssap.j2ee.core.descriptor.AccessibleBean;
import com.tssap.j2ee.core.descriptor.DescriptorEntity;
import com.tssap.j2ee.core.descriptor.EnterpriseBean;
import com.tssap.j2ee.core.descriptor.SecurityRole;
import com.tssap.j2ee.core.descriptor.SecurityRoleRef;
import com.tssap.j2ee.core.ejbjar.EjbJar;
import com.tssap.j2ee.core.ejbjar.MethodPermission;
import com.tssap.j2ee.core.utils.UtilsPlugin;
import com.tssap.j2ee.internal.core.descriptor.DescribedDescriptorEntityImpl;
import com.tssap.j2ee.internal.core.descriptor.DescriptorEntityImpl;
import com.tssap.j2ee.internal.core.ejbjar.AssemblyDescriptorImpl;
import com.tssap.j2ee.internal.core.ejbjar.EjbJarChildOrder;
import com.tssap.j2ee.internal.core.util.DomUtils;
import org.w3c.dom.Element;

final class SecurityRoleImpl
extends DescribedDescriptorEntityImpl
implements SecurityRole {
    public SecurityRoleImpl(AssemblyDescriptorImpl parent, Element element) {
        super((DescriptorEntityImpl)parent, element);
    }

    public String toString() {
        return "SecurityRole \"" + this.getName() + "\"";
    }

    public void delete() {
        if (!this.edit(null)) {
            return;
        }
        final String oldName = this.getName();
        this.modify(new Runnable(){

            public void run() {
                SecurityRoleImpl.super.delete();
                SecurityRoleImpl.this.getAssemblyDescriptorImpl().updateSecurityRole(oldName);
                SecurityRoleImpl.this.sync(oldName, null);
            }
        });
    }

    public String getName() {
        return DomUtils.getChildTextNodeValue((Element)this.getElement(), (String)"role-name");
    }

    public boolean canSetName(String name) {
        if (DescriptorEntityImpl.isNull((String)name)) {
            return false;
        }
        return DescriptorEntityImpl.equals((Object)name, (Object)this.getName()) || this.getAssemblyDescriptorImpl().getSecurityRole(name) == null;
    }

    public void setName(final String name) {
        if (!this.canSetName(name)) {
            throw new IllegalArgumentException(name);
        }
        if (name.equals(this.getName())) {
            return;
        }
        if (!this.edit(null)) {
            return;
        }
        final String oldName = this.getName();
        this.modify(new Runnable(){

            public void run() {
                DomUtils.setChildTextNodeValue((Element)SecurityRoleImpl.this.getElement(), (String[])EjbJarChildOrder.SECURITY_ROLE, (String)"role-name", (String)name);
                SecurityRoleImpl.this.getAssemblyDescriptorImpl().updateSecurityRole(oldName);
                SecurityRoleImpl.super.changed((DescriptorEntity)SecurityRoleImpl.this);
                SecurityRoleImpl.this.sync(oldName, name);
            }
        });
    }

    private void sync(String oldName, String newName) {
        this.syncEnterpriseBeans(oldName, newName);
        this.syncMethodPermissions(oldName, newName);
    }

    private void syncMethodPermissions(String oldName, String newName) {
        AssemblyDescriptorImpl ad = this.getAssemblyDescriptorImpl();
        if (ad == null) {
            return;
        }
        MethodPermission[] ps = ad.getMethodPermissions();
        if (ps == null || ps.length == 0) {
            return;
        }
        int i = 0;
        while (i < ps.length) {
            String[] rs;
            MethodPermission p = ps[i];
            if (p != null && (rs = p.getSecurityRoleNames()) != null) {
                int j = 0;
                while (j < rs.length) {
                    if (oldName.equals(rs[j])) {
                        rs[j] = newName;
                        try {
                            if (p.canSetSecurityRoleNames(rs)) {
                                p.setSecurityRoleNames(rs);
                                break;
                            }
                            UtilsPlugin.logWarning((String)"Unable to synchronize method permission security roles");
                        }
                        catch (Exception e) {
                            UtilsPlugin.logError((String)"Unable to synchronize method permission security roles");
                        }
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void syncEnterpriseBeans(String oldName, String newName) {
        AssemblyDescriptorImpl ad = this.getAssemblyDescriptorImpl();
        EjbJar ejbJar = (EjbJar)ad.getParent();
        EnterpriseBean[] beans = ejbJar.getEnterpriseBeans();
        if (beans == null || beans.length == 0) {
            return;
        }
        int i = 0;
        while (i < beans.length) {
            String roleName;
            EnterpriseBean bean = beans[i];
            if (bean instanceof AccessibleBean) {
                this.syncSecurityRoleRefs((AccessibleBean)bean, oldName, newName);
            }
            if (oldName.equals(roleName = bean.getSecurityIdentityRunAsRoleName())) {
                try {
                    if (bean.canSetSecurityIdentityRunAsRoleName(newName)) {
                        bean.setSecurityIdentityRunAsRoleName(newName);
                    } else {
                        UtilsPlugin.logWarning((String)("Unable to synchronize security identity run as security role name of ejb " + bean.getName()));
                    }
                }
                catch (Exception e) {
                    UtilsPlugin.logError((String)("Unable to synchronize security identity run as security role name of ejb " + bean.getName()), (Throwable)e);
                }
            }
            ++i;
        }
    }

    private void syncSecurityRoleRefs(AccessibleBean bean, String oldName, String newName) {
        SecurityRoleRef[] refs = bean.getSecurityRoleReferences();
        if (refs == null || refs.length == 0) {
            return;
        }
        int i = 0;
        while (i < refs.length) {
            SecurityRoleRef ref = refs[i];
            if (oldName.equals(ref.getLink())) {
                try {
                    if (ref.canSetLink(newName)) {
                        ref.setLink(newName);
                    } else {
                        UtilsPlugin.logWarning((String)("Unable to synchronize security role reference name of ejb " + bean.getName()));
                    }
                }
                catch (Exception e) {
                    UtilsPlugin.logError((String)("Unable to synchronize security role reference name of ejb " + bean.getName()), (Throwable)e);
                }
            }
            ++i;
        }
    }

    protected String[] getChildOrder() {
        return EjbJarChildOrder.SECURITY_ROLE;
    }

    private AssemblyDescriptorImpl getAssemblyDescriptorImpl() {
        return (AssemblyDescriptorImpl)this.getParent();
    }
}

