/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejbjar;

import com.tssap.j2ee.core.descriptor.DescriptorDocument;
import com.tssap.j2ee.core.descriptor.DescriptorEntity;
import com.tssap.j2ee.core.descriptor.EnterpriseBean;
import com.tssap.j2ee.core.ejb.EJBDeltaEvent;
import com.tssap.j2ee.core.ejb.EJBModelException;
import com.tssap.j2ee.core.ejb.IAccessibleBean;
import com.tssap.j2ee.core.ejb.IEJBDelta;
import com.tssap.j2ee.core.ejb.IEJBDeltaListener;
import com.tssap.j2ee.core.ejb.IEJBElement;
import com.tssap.j2ee.core.ejb.IEJBMethod;
import com.tssap.j2ee.core.ejb.IEJBSynchronizeListener;
import com.tssap.j2ee.core.ejb.IEnterpriseBean;
import com.tssap.j2ee.core.ejb.IEntityBean;
import com.tssap.j2ee.core.ejb.IPersistentField;
import com.tssap.j2ee.core.ejb.IQueryMethod;
import com.tssap.j2ee.core.ejb.IRelationshipEnd;
import com.tssap.j2ee.core.ejbjar.AssembledInfoFinder;
import com.tssap.j2ee.core.ejbjar.CmpField;
import com.tssap.j2ee.core.ejbjar.EjbJar;
import com.tssap.j2ee.core.ejbjar.EjbJarMetaInfo;
import com.tssap.j2ee.core.ejbjar.EjbRelation;
import com.tssap.j2ee.core.ejbjar.EjbRelationshipRole;
import com.tssap.j2ee.core.ejbjar.EjbRelationshipRoleTemplate;
import com.tssap.j2ee.core.ejbjar.EntityBean;
import com.tssap.j2ee.core.ejbjar.Method;
import com.tssap.j2ee.core.ejbjar.Query;
import com.tssap.j2ee.core.ejbjar.namegen.EjbRelationNameGen;
import com.tssap.j2ee.core.utils.ReadOnlinessValidator;
import com.tssap.j2ee.core.utils.StringArrayList;
import com.tssap.j2ee.internal.core.ejbjar.AccessibleBeanImpl;
import com.tssap.j2ee.internal.core.ejbjar.EjbJarImpl;
import com.tssap.j2ee.internal.core.ejbjar.EjbJarImplPlugin;
import com.tssap.j2ee.internal.core.ejbjar.EnterpriseBeanImpl;
import com.tssap.j2ee.internal.core.ejbjar.EntityBeanImpl;
import com.tssap.j2ee.internal.core.ejbjar.MethodDNDHelper;
import com.tssap.j2ee.internal.core.ejbjar.MethodImpl;
import com.tssap.j2ee.internal.core.ejbjar.QueryImpl;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.util.UndoTransparableCommand;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;

public class ParticipantSynchronizer
extends IEJBSynchronizeListener.Stub
implements IEJBDeltaListener {
    private HashSet myDeferredDeltas = new HashSet();
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$Set;

    public void homeInterfaceRemoved(IEnterpriseBean bean, IType oldType) {
        this.removedRemoteStructure(bean);
    }

    public void homeInterfaceRenamed(IEnterpriseBean bean, IType oldType) {
        EnterpriseBean[] deployables = this.findDeployedBeans(bean);
        int i = 0;
        while (i < deployables.length) {
            AccessibleBeanImpl aBean;
            String oldHome;
            if (deployables[i] instanceof AccessibleBeanImpl && (oldHome = (aBean = (AccessibleBeanImpl)deployables[i]).getHomeInterface()) != null && oldType.getFullyQualifiedName().equals(oldHome)) {
                try {
                    String fqn;
                    IType newType = ((IAccessibleBean)bean).getParticipant(2);
                    if (newType != null && aBean.canSetHomeInterface(fqn = newType.getFullyQualifiedName())) {
                        aBean.setHomeInterface(fqn);
                    }
                }
                catch (EJBModelException e) {
                    EjbJarImplPlugin.logError("Could not update home interface", e);
                }
            }
            ++i;
        }
    }

    public void localhomeInterfaceRemoved(IEnterpriseBean bean, IType oldType) {
        this.removedLocalStructure(bean);
    }

    public void localhomeInterfaceRenamed(IEnterpriseBean bean, IType oldType) {
        EnterpriseBean[] deployables = this.findDeployedBeans(bean);
        int i = 0;
        while (i < deployables.length) {
            AccessibleBeanImpl aBean;
            String oldHome;
            if (deployables[i] instanceof AccessibleBeanImpl && (oldHome = (aBean = (AccessibleBeanImpl)deployables[i]).getLocalHomeInterface()) != null && oldType.getFullyQualifiedName().equals(oldHome)) {
                try {
                    String fqn;
                    IType newType = ((IAccessibleBean)bean).getParticipant(8);
                    if (newType != null && aBean.canSetLocalHomeInterface(fqn = newType.getFullyQualifiedName())) {
                        aBean.setLocalHomeInterface(fqn);
                    }
                }
                catch (EJBModelException e) {
                    EjbJarImplPlugin.logError("Could not update localhome interface", e);
                }
            }
            ++i;
        }
    }

    public void localInterfaceRemoved(IEnterpriseBean bean, IType oldType) {
        this.removedLocalStructure(bean);
    }

    public void localInterfaceRenamed(IEnterpriseBean bean, IType oldType) {
        EnterpriseBean[] deployables = this.findDeployedBeans(bean);
        int i = 0;
        while (i < deployables.length) {
            AccessibleBeanImpl aBean;
            String oldLocal;
            if (deployables[i] instanceof AccessibleBeanImpl && (oldLocal = (aBean = (AccessibleBeanImpl)deployables[i]).getLocalInterface()) != null && oldType.getFullyQualifiedName().equals(oldLocal)) {
                try {
                    String fqn;
                    IType newType = ((IAccessibleBean)bean).getParticipant(16);
                    if (newType != null && aBean.canSetLocalInterface(fqn = newType.getFullyQualifiedName())) {
                        aBean.setLocalInterface(fqn);
                    }
                }
                catch (EJBModelException e) {
                    EjbJarImplPlugin.logError("Could not update local interface", e);
                }
            }
            ++i;
        }
    }

    public void primKeyClassAdded(IEntityBean bean) {
        try {
            IType newType = bean.getParticipant(32);
            this.primKeyClassChanged((IEnterpriseBean)bean, null, newType);
        }
        catch (EJBModelException e) {
            EjbJarImplPlugin.logError("Could not update primary key class", e);
        }
    }

    public void primKeyClassRemoved(IEnterpriseBean bean, IType oldType) {
        this.primKeyClassChanged(bean, oldType, null);
    }

    public void primKeyClassRenamed(IEnterpriseBean bean, IType oldType) {
        try {
            IType newType = ((IAccessibleBean)bean).getParticipant(32);
            this.primKeyClassChanged(bean, oldType, newType);
        }
        catch (EJBModelException e) {
            EjbJarImplPlugin.logError("Could not update primary key class", e);
        }
    }

    private void primKeyClassChanged(IEnterpriseBean bean, IType oldType, IType newType) {
        String oldExpectedPK = oldType == null ? (class$java$lang$Object == null ? (class$java$lang$Object = ParticipantSynchronizer.class$("java.lang.Object")) : class$java$lang$Object).getName() : oldType.getFullyQualifiedName();
        EnterpriseBean[] deployables = this.findDeployedBeans(bean);
        int i = 0;
        while (i < deployables.length) {
            if (deployables[i] instanceof EntityBeanImpl) {
                String fqn;
                EntityBeanImpl aBean = (EntityBeanImpl)deployables[i];
                String oldPK = aBean.getPrimaryKeyClass();
                if (oldPK == null || oldExpectedPK.equals(oldPK)) {
                    // empty if block
                }
                if (aBean.canSetPrimaryKeyClass(fqn = newType != null ? newType.getFullyQualifiedName() : (class$java$lang$Object == null ? ParticipantSynchronizer.class$("java.lang.Object") : class$java$lang$Object).getName())) {
                    aBean.setPrimaryKeyClass(fqn);
                }
            }
            ++i;
        }
    }

    public void remoteInterfaceRemoved(IEnterpriseBean bean, IType oldType) {
        this.removedRemoteStructure(bean);
    }

    public void remoteInterfaceRenamed(IEnterpriseBean bean, IType oldType) {
        EnterpriseBean[] deployables = this.findDeployedBeans(bean);
        int i = 0;
        while (i < deployables.length) {
            AccessibleBeanImpl aBean;
            String oldRemote;
            if (deployables[i] instanceof AccessibleBeanImpl && (oldRemote = (aBean = (AccessibleBeanImpl)deployables[i]).getRemoteInterface()) != null && oldType.getFullyQualifiedName().equals(oldRemote)) {
                try {
                    String fqn;
                    IType newType = ((IAccessibleBean)bean).getParticipant(4);
                    if (newType != null && aBean.canSetRemoteInterface(fqn = newType.getFullyQualifiedName())) {
                        aBean.setRemoteInterface(fqn);
                    }
                }
                catch (EJBModelException e) {
                    EjbJarImplPlugin.logError("Could not update remote interface", e);
                }
            }
            ++i;
        }
    }

    public void primKeyClassStatusChanged(final IEntityBean bean) {
        try {
            if (!bean.isCMP()) {
                return;
            }
        }
        catch (EJBModelException e) {
            EjbJarImplPlugin.logError("Could not update primkey-field, bean doesn't seem to exist", e);
            return;
        }
        ModelAccess.runCommandLater((Runnable)new UndoTransparableCommand(){

            public void run() {
                EnterpriseBean[] deployedBeans = ParticipantSynchronizer.this.findDeployedBeans((IEnterpriseBean)bean);
                if (!ParticipantSynchronizer.ensureAllSaved((DescriptorEntity[])deployedBeans)) {
                    return;
                }
                deployedBeans = ParticipantSynchronizer.this.findDeployedBeans((IEnterpriseBean)bean);
                boolean isSimplePK = bean.isSimplePK();
                if (isSimplePK) {
                    IPersistentField[] fields;
                    String pkFieldName = null;
                    try {
                        fields = bean.getFields();
                    }
                    catch (EJBModelException e) {
                        EjbJarImplPlugin.logError("Could not update primkey-field, bean doesn't seem to exist", e);
                        return;
                    }
                    int i = 0;
                    while (i < fields.length) {
                        if (!fields[i].isRelationship() && fields[i].isInPrimaryKey()) {
                            pkFieldName = fields[i].getName();
                            break;
                        }
                        ++i;
                    }
                    int i2 = 0;
                    while (i2 < deployedBeans.length) {
                        if (deployedBeans[i2] instanceof EntityBeanImpl) {
                            EntityBeanImpl deployed = (EntityBeanImpl)deployedBeans[i2];
                            if (deployed.canSetPrimaryKeyField(pkFieldName)) {
                                deployed.setPrimaryKeyField(pkFieldName);
                            } else {
                                EjbJarImplPlugin.logError("Could not update primkey-field");
                            }
                        }
                        ++i2;
                    }
                } else {
                    int i = 0;
                    while (i < deployedBeans.length) {
                        if (deployedBeans[i] instanceof EntityBeanImpl) {
                            EntityBeanImpl deployed = (EntityBeanImpl)deployedBeans[i];
                            if (deployed.canSetPrimaryKeyField(null)) {
                                deployed.setPrimaryKeyField(null);
                            } else {
                                EjbJarImplPlugin.logError("Could not update primkey-field");
                            }
                        }
                        ++i;
                    }
                }
            }
        });
    }

    public void fieldPKStatusChanged(final IPersistentField field) {
        ModelAccess.runCommandLater((Runnable)new UndoTransparableCommand(){

            public void run() {
                IEntityBean bean = (IEntityBean)field.getParent();
                try {
                    if (!bean.isCMP() || !bean.isSimplePK()) {
                        return;
                    }
                }
                catch (EJBModelException e) {
                    EjbJarImplPlugin.logError("Could not update primkey-field, bean doesn't seem to exist", e);
                    return;
                }
                boolean fieldNowInPK = field.isInPrimaryKey();
                String fieldName = field.getName();
                EnterpriseBean[] deployedBeans = ParticipantSynchronizer.this.findDeployedBeans((IEnterpriseBean)bean);
                if (!ParticipantSynchronizer.ensureAllSaved((DescriptorEntity[])deployedBeans)) {
                    return;
                }
                deployedBeans = ParticipantSynchronizer.this.findDeployedBeans((IEnterpriseBean)bean);
                int i = 0;
                while (i < deployedBeans.length) {
                    if (deployedBeans[i] instanceof EntityBeanImpl) {
                        EntityBeanImpl deployed = (EntityBeanImpl)deployedBeans[i];
                        if (fieldNowInPK) {
                            if (deployed.canSetPrimaryKeyField(fieldName)) {
                                deployed.setPrimaryKeyField(fieldName);
                            } else {
                                EjbJarImplPlugin.logError("Could not update primkey-field");
                            }
                        } else if (fieldName.equals(deployed.getPrimaryKeyField())) {
                            if (deployed.canSetPrimaryKeyField(null)) {
                                deployed.setPrimaryKeyField(null);
                            }
                        } else {
                            EjbJarImplPlugin.logError("Prior synchronizations seem to have failed");
                        }
                    }
                    ++i;
                }
            }
        });
    }

    private void removedRemoteStructure(IEnterpriseBean bean) {
        if (!EjbJarImplPlugin.isRemovingInterfaceDeclarationsOnClassRemove()) {
            return;
        }
        EnterpriseBean[] deployed = this.findDeployedBeans(bean);
        int i = 0;
        while (i < deployed.length) {
            AccessibleBeanImpl next;
            if (deployed[i] instanceof AccessibleBeanImpl && (next = (AccessibleBeanImpl)deployed[i]).hasRemoteStructure()) {
                if (next.hasLocalStructure()) {
                    if (next.canSetRemoteInterface(null) && next.canSetHomeInterface(null)) {
                        next.setRemoteInterface(null);
                        next.setHomeInterface(null);
                    } else {
                        EjbJarImplPlugin.logError("Could not remove remote component interfaces");
                    }
                } else {
                    next.delete();
                }
            }
            ++i;
        }
    }

    private void removedLocalStructure(IEnterpriseBean bean) {
        if (!EjbJarImplPlugin.isRemovingInterfaceDeclarationsOnClassRemove()) {
            return;
        }
        EnterpriseBean[] deployed = this.findDeployedBeans(bean);
        int i = 0;
        while (i < deployed.length) {
            AccessibleBeanImpl next;
            if (deployed[i] instanceof AccessibleBeanImpl && (next = (AccessibleBeanImpl)deployed[i]).hasLocalStructure()) {
                if (next.hasRemoteStructure()) {
                    if (next.canSetLocalInterface(null) && next.canSetLocalHomeInterface(null)) {
                        next.setLocalInterface(null);
                        next.setLocalHomeInterface(null);
                    } else {
                        EjbJarImplPlugin.logError("Could not remove local component interfaces");
                    }
                } else {
                    next.delete();
                }
            }
            ++i;
        }
    }

    private EnterpriseBean[] findDeployedBeans(IEnterpriseBean bean) {
        EnterpriseBean[] rawResult = AssembledInfoFinder.findAssembledBeans((IEnterpriseBean)bean);
        if (rawResult == null) {
            return rawResult;
        }
        if (this.validateEdit((DescriptorEntity[])rawResult)) {
            return rawResult;
        }
        ArrayList<EnterpriseBean> result = new ArrayList<EnterpriseBean>();
        int i = 0;
        while (i < rawResult.length) {
            if (!rawResult[i].getDocument().getFile().isReadOnly()) {
                result.add(rawResult[i]);
            }
            ++i;
        }
        return result.toArray(new EnterpriseBean[result.size()]);
    }

    private static boolean ensureAllSaved(DescriptorEntity[] entities) {
        HashSet<DescriptorDocument> allDescriptors = new HashSet<DescriptorDocument>();
        int i = 0;
        while (i < entities.length) {
            allDescriptors.add(entities[i].getDocument());
            ++i;
        }
        Iterator it = allDescriptors.iterator();
        while (it.hasNext()) {
            DescriptorDocument element = (DescriptorDocument)it.next();
            if (element.ensureSaved(false)) continue;
            return false;
        }
        return true;
    }

    public void ejbModelChanged(EJBDeltaEvent evt) {
        final IEJBDelta delta = evt.getDelta();
        if (!delta.getProject().isAutomaticSynchronizationEnabled()) {
            return;
        }
        if (!delta.isEmpty()) {
            HashSet hashSet = this.myDeferredDeltas;
            synchronized (hashSet) {
                if (this.myDeferredDeltas.contains(delta)) {
                    return;
                }
                this.myDeferredDeltas.add(delta);
            }
            ModelAccess.runCommandLater((Runnable)new UndoTransparableCommand(){

                public void run() {
                    ParticipantSynchronizer.this.processRenamedElements(delta.getRenamedElements());
                    ParticipantSynchronizer.this.processRemovedElements(delta.getRemovedElements());
                    ParticipantSynchronizer.this.processAddedElements(delta.getAddedElements());
                    ParticipantSynchronizer.this.processTotallyChangedElements(delta.getTotallyChangedElements());
                    ParticipantSynchronizer.this.processCMPCMRConversions(delta.getFieldsMadeCMR());
                    ParticipantSynchronizer.this.processCMRCMPConversions(delta.getFieldsCeasedCMR());
                    HashSet hashSet = ParticipantSynchronizer.this.myDeferredDeltas;
                    synchronized (hashSet) {
                        ParticipantSynchronizer.this.myDeferredDeltas.remove(delta);
                    }
                }
            });
        }
    }

    private void processAddedElements(IEJBElement[] added) {
        int i = 0;
        while (i < added.length) {
            IEJBElement element = added[i];
            try {
                if (element instanceof IPersistentField && ((IEntityBean)element.getParent()).isCMP()) {
                    this.addedPersistentField((IPersistentField)element);
                } else if (element instanceof IQueryMethod && ((IEntityBean)element.getParent()).isCMP()) {
                    this.addedQueryMethod((IQueryMethod)element);
                }
            }
            catch (EJBModelException e) {
                EjbJarImplPlugin.logWarning("Exception while processing added elements", e);
            }
            ++i;
        }
    }

    private void addedQueryMethod(IQueryMethod query) {
        IEntityBean bean = (IEntityBean)query.getParent();
        String methodName = query.getNameForDD();
        String[] parameters = query.getParameterTypesForDD();
        if (methodName.equals("findByPrimaryKey") && parameters.length == 1) {
            return;
        }
        EnterpriseBean[] deployedBeans = this.findDeployedBeans((IEnterpriseBean)bean);
        if (!ParticipantSynchronizer.ensureAllSaved((DescriptorEntity[])deployedBeans)) {
            return;
        }
        deployedBeans = this.findDeployedBeans((IEnterpriseBean)bean);
        int i = 0;
        while (i < deployedBeans.length) {
            EntityBeanImpl deployed;
            if (deployedBeans[i] instanceof EntityBeanImpl && (deployed = (EntityBeanImpl)deployedBeans[i]).canCreateQuery(methodName, parameters, null, "", null)) {
                deployed.createQuery(methodName, parameters, null, "", null);
            }
            ++i;
        }
    }

    private void addedPersistentField(IPersistentField added) {
        if (added.isRelationship()) {
            this.addedRelation((IRelationshipEnd)added);
            return;
        }
        this.addedCMPField(added);
    }

    private void addedCMPField(IPersistentField added) {
        IEntityBean bean = (IEntityBean)added.getParent();
        EnterpriseBean[] deployedBeans = this.findDeployedBeans((IEnterpriseBean)bean);
        if (!ParticipantSynchronizer.ensureAllSaved((DescriptorEntity[])deployedBeans)) {
            return;
        }
        deployedBeans = this.findDeployedBeans((IEnterpriseBean)bean);
        int i = 0;
        while (i < deployedBeans.length) {
            EntityBeanImpl deployed;
            if (deployedBeans[i] instanceof EntityBeanImpl && (deployed = (EntityBeanImpl)deployedBeans[i]).canCreateCmpField(added.getName(), null)) {
                deployed.createCmpField(added.getName(), null);
            }
            ++i;
        }
    }

    private void addedRelation(IRelationshipEnd relation) {
        IEntityBean bean = (IEntityBean)relation.getParent();
        EnterpriseBean[] deployedBeans = this.findDeployedBeans((IEnterpriseBean)bean);
        if (!ParticipantSynchronizer.ensureAllSaved((DescriptorEntity[])deployedBeans)) {
            return;
        }
        deployedBeans = this.findDeployedBeans((IEnterpriseBean)bean);
        int i = 0;
        while (i < deployedBeans.length) {
            if (deployedBeans[i] instanceof EntityBeanImpl) {
                EntityBeanImpl deployed = (EntityBeanImpl)deployedBeans[i];
                this.createRelation(deployed, relation);
            }
            ++i;
        }
    }

    private void createRelation(EntityBeanImpl entityBean, IRelationshipEnd relation) {
        String multiplicity;
        String ejbName = entityBean.getName();
        String persistenceType = entityBean.getPersistenceType();
        if (!"Container".equals(persistenceType)) {
            return;
        }
        String target = this.getTargetEjbName(relation, relation.getRelationshipTarget(), ejbName);
        if (target == null) {
            return;
        }
        EjbJarImpl ejbJar = entityBean.getEjbJarImpl();
        StringArrayList ejbRelation = this.getSalDdp(relation, "defaultEjbRelation");
        String ejbRelationName = ParticipantSynchronizer.getName(ejbRelation);
        if (ejbRelationName != null) {
            EjbRelationNameGen erng = new EjbRelationNameGen((EjbJar)ejbJar);
            ejbRelationName = erng.getUniqueName(ejbRelationName);
        }
        String ejbRelationDescription = ParticipantSynchronizer.getDescription(ejbRelation);
        EjbRelationshipRoleTemplate role1Template = new EjbRelationshipRoleTemplate();
        StringArrayList ejbRelationshipRole = this.getSalDdp(relation, "defaultEjbRelationshipRole");
        String ejbRelationshipRoleName = ParticipantSynchronizer.getName(ejbRelationshipRole);
        role1Template.setName(ejbRelationshipRoleName);
        role1Template.setDescription(ParticipantSynchronizer.getDescription(ejbRelationshipRole));
        role1Template.setSourceEjbName(ejbName);
        role1Template.setCmrFieldName(relation.getName());
        String cmrFieldType = relation.getCMRField().getType();
        if ((class$java$util$Collection == null ? (class$java$util$Collection = ParticipantSynchronizer.class$("java.util.Collection")) : class$java$util$Collection).getName().equals(cmrFieldType) || (class$java$util$Set == null ? (class$java$util$Set = ParticipantSynchronizer.class$("java.util.Set")) : class$java$util$Set).getName().equals(cmrFieldType)) {
            role1Template.setCmrFieldType(cmrFieldType);
            multiplicity = "Many";
        } else {
            multiplicity = "One";
        }
        boolean cascadeDelete = ParticipantSynchronizer.getBoolean(relation, "defaultCascadeDelete");
        EjbRelationshipRoleTemplate role2Template = new EjbRelationshipRoleTemplate();
        StringArrayList externalEjbRelationshipRole = this.getSalDdp(relation, "defaultExternalEjbRelationshipRole");
        String externalEjbRelationshipRoleName = ParticipantSynchronizer.getName(externalEjbRelationshipRole);
        if (ejbRelationshipRoleName != null && ejbRelationshipRoleName.equals(externalEjbRelationshipRoleName)) {
            ejbRelationshipRoleName = ejbRelationshipRoleName + "1";
            role1Template.setName(ejbRelationshipRoleName);
            externalEjbRelationshipRoleName = externalEjbRelationshipRoleName + "2";
        }
        role2Template.setName(externalEjbRelationshipRoleName);
        role2Template.setDescription(ParticipantSynchronizer.getDescription(externalEjbRelationshipRole));
        role2Template.setSourceEjbName(target);
        String externalMultiplicity = relation.getDdpAsString("defaultExternalMultiplicity");
        if (!EjbJarMetaInfo.isValidMultiplicity((String)externalMultiplicity)) {
            externalMultiplicity = "One";
        }
        boolean externalCascadeDelete = ParticipantSynchronizer.getBoolean(relation, "defaultExternalCascadeDelete");
        String tmp = multiplicity;
        multiplicity = externalMultiplicity;
        externalMultiplicity = tmp;
        if ("Many".equals(externalMultiplicity)) {
            cascadeDelete = false;
        }
        if ("Many".equals(multiplicity)) {
            externalCascadeDelete = false;
        }
        role1Template.setMultiplicity(multiplicity);
        role1Template.setCascadeDelete(cascadeDelete);
        role2Template.setMultiplicity(externalMultiplicity);
        role2Template.setCascadeDelete(externalCascadeDelete);
        if (ejbJar.canCreateEjbRelation(ejbRelationName, ejbRelationDescription, (EjbRelationshipRole)role1Template, (EjbRelationshipRole)role2Template)) {
            ejbJar.createEjbRelation(ejbRelationName, ejbRelationDescription, (EjbRelationshipRole)role1Template, (EjbRelationshipRole)role2Template);
        } else {
            EjbJarImplPlugin.logWarning("Unable to create ejb relation based on persistent field defaults");
        }
    }

    private static String getName(StringArrayList sal) {
        return sal == null || sal.isEmpty() ? null : sal.getString(0);
    }

    private static String getDescription(StringArrayList sal) {
        return sal == null || sal.size() < 2 ? null : sal.getString(1);
    }

    private static boolean getBoolean(IRelationshipEnd relation, String ddpName) {
        Object result = relation.getDdp(ddpName);
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        return false;
    }

    private StringArrayList getSalDdp(IRelationshipEnd relation, String ddpName) {
        Object result = relation.getDdp(ddpName);
        if (result instanceof StringArrayList) {
            return (StringArrayList)result;
        }
        return null;
    }

    private void processRemovedElements(IEJBElement[] removed) {
        int i = 0;
        while (i < removed.length) {
            IEJBElement old = removed[i];
            try {
                if (old instanceof IPersistentField && ((IEntityBean)old.getParent()).isCMP()) {
                    this.removedPersistentField((IPersistentField)old);
                } else if (old instanceof IEnterpriseBean) {
                    this.removedBean((IEnterpriseBean)old);
                } else if (old instanceof IEJBMethod) {
                    this.ejbMethodRemoved((IEJBMethod)old);
                }
            }
            catch (EJBModelException e) {
                EjbJarImplPlugin.logWarning("Exception while processing removed elements", e);
            }
            ++i;
        }
    }

    private void ejbMethodRemoved(IEJBMethod removed) {
        String[] expectedParameters;
        String expectedMethodName;
        IEnterpriseBean expectedBean = (IEnterpriseBean)removed.getParent();
        String expectedBeanClassName = expectedBean.getBeanClassName();
        Method[] methods = this.findDeployedMethods(removed, this.getFindAllMethodsCondition(expectedBeanClassName, expectedMethodName = removed.getNameForDD(), expectedParameters = removed.getParameterTypesForDD()));
        if (!ParticipantSynchronizer.ensureAllSaved((DescriptorEntity[])methods)) {
            return;
        }
        methods = this.findDeployedMethods(removed, this.getFindAllMethodsCondition(expectedBeanClassName, expectedMethodName, expectedParameters));
        int i = 0;
        while (i < methods.length) {
            MethodImpl next = (MethodImpl)methods[i];
            next.delete();
            ++i;
        }
        if (removed.getKind() == 4 || removed.getKind() == 16) {
            Query[] queries = this.findDeployedQueries(removed);
            if (!ParticipantSynchronizer.ensureAllSaved((DescriptorEntity[])queries)) {
                return;
            }
            queries = this.findDeployedQueries(removed);
            int i2 = 0;
            while (i2 < queries.length) {
                QueryImpl q = (QueryImpl)queries[i2];
                q.delete();
                ++i2;
            }
        }
    }

    private AssembledInfoFinder.UnaryConditionEx getFindAllMethodsCondition(final String expectedBeanClassName, final String expectedMethodName, final String[] expectedParameters) {
        return new AssembledInfoFinder.UnaryConditionEx(){
            private EjbJar myEjbJar;

            public boolean execute(Object object) {
                Method ejbjarMethod = (Method)object;
                EnterpriseBean bean = this.myEjbJar.getEnterpriseBean(ejbjarMethod.getEjbName());
                if (bean == null) {
                    return false;
                }
                String beanClassName = bean.getEjbClass();
                if (!expectedBeanClassName.equals(beanClassName)) {
                    return false;
                }
                String methodName = ejbjarMethod.getMethodName();
                if (methodName == null) {
                    return false;
                }
                if (!methodName.equals(expectedMethodName)) {
                    return false;
                }
                String[] parameterTypes = ejbjarMethod.getMethodParameters();
                return ParticipantSynchronizer.equalParameterTypes(parameterTypes, expectedParameters);
            }

            public void setEjbJar(EjbJar ejbJar) {
                this.myEjbJar = ejbJar;
            }
        };
    }

    private void removedBean(IEnterpriseBean bean) {
        if (bean.getEJBProject() == null || !bean.getEJBProject().getProject().isAccessible()) {
            return;
        }
        EnterpriseBean[] deployedBeans = this.findDeployedBeans(bean);
        if (!ParticipantSynchronizer.ensureAllSaved((DescriptorEntity[])deployedBeans)) {
            return;
        }
        deployedBeans = this.findDeployedBeans(bean);
        int i = 0;
        while (i < deployedBeans.length) {
            deployedBeans[i].delete();
            ++i;
        }
    }

    private void removedPersistentField(IPersistentField removed) {
        if (removed.isRelationship()) {
            this.removedRelation((IRelationshipEnd)removed);
            return;
        }
        this.removedCMPField(removed);
    }

    private void removedCMPField(IPersistentField removed) {
        IEntityBean bean = (IEntityBean)removed.getParent();
        EnterpriseBean[] deployedBeans = this.findDeployedBeans((IEnterpriseBean)bean);
        if (!ParticipantSynchronizer.ensureAllSaved((DescriptorEntity[])deployedBeans)) {
            return;
        }
        deployedBeans = this.findDeployedBeans((IEnterpriseBean)bean);
        int i = 0;
        while (i < deployedBeans.length) {
            if (deployedBeans[i] instanceof EntityBeanImpl) {
                EntityBeanImpl deployed = (EntityBeanImpl)deployedBeans[i];
                CmpField cmpField = deployed.getCmpField(removed.getName());
                if (cmpField != null) {
                    cmpField.delete();
                } else {
                    EjbJarImplPlugin.logWarning("Did not find CMP field to delete");
                }
            }
            ++i;
        }
    }

    private void removedRelation(IRelationshipEnd relation) {
        EjbRelationshipRole[] relations = AssembledInfoFinder.findAssembledRelations((IRelationshipEnd)relation);
        if (relations == null || !ParticipantSynchronizer.ensureAllSaved((DescriptorEntity[])relations)) {
            return;
        }
        relations = AssembledInfoFinder.findAssembledRelations((IRelationshipEnd)relation);
        int i = 0;
        while (i < relations.length) {
            if (relations[i].getParent().canDelete()) {
                relations[i].getParent().delete();
            } else {
                EjbJarImplPlugin.logWarning("Could not remove relation");
            }
            ++i;
        }
    }

    private void processRenamedElements(IEJBElement[][] renamed) {
        int i = 0;
        while (i < renamed[0].length) {
            IEJBElement removed = renamed[0][i];
            IEJBElement added = renamed[1][i];
            try {
                if (added instanceof IPersistentField && ((IEntityBean)added.getParent()).isCMP()) {
                    this.renamedPersistentField((IPersistentField)removed, (IPersistentField)added);
                } else if (added instanceof IEnterpriseBean) {
                    this.beanRenamed((IEnterpriseBean)removed, (IEnterpriseBean)added);
                } else if (added instanceof IEJBMethod) {
                    IEJBMethod removedMethod = (IEJBMethod)removed;
                    IEJBMethod addedMethod = (IEJBMethod)added;
                    if (removedMethod.getParent().equals(addedMethod.getParent())) {
                        this.ejbMethodRenamed(removedMethod, addedMethod);
                    } else {
                        this.ejbMethodDragNDropped(removedMethod, addedMethod);
                    }
                }
            }
            catch (EJBModelException e) {
                EjbJarImplPlugin.logWarning("Exception while processing renamed elements", e);
            }
            ++i;
        }
    }

    private void processCMPCMRConversions(IRelationshipEnd[] newCMRs) {
        int i = 0;
        while (i < newCMRs.length) {
            this.addedRelation(newCMRs[i]);
            this.removedCMPField(newCMRs[i].getCMRField());
            ++i;
        }
    }

    private void processCMRCMPConversions(IRelationshipEnd[] deletedCMRs) {
        int i = 0;
        while (i < deletedCMRs.length) {
            this.removedRelation(deletedCMRs[i]);
            this.addedCMPField(deletedCMRs[i].getCMRField());
            ++i;
        }
    }

    private void renamedPersistentField(IPersistentField removed, IPersistentField added) {
        if (removed.isRelationship()) {
            if (added.isRelationship()) {
                this.renamedRelation((IRelationshipEnd)removed, (IRelationshipEnd)added);
                return;
            }
            this.removedRelation((IRelationshipEnd)removed);
            this.addedPersistentField(added);
            return;
        }
        if (added.isRelationship()) {
            this.addedRelation((IRelationshipEnd)added);
            this.removedPersistentField(removed);
            return;
        }
        this.renamedCMPField(removed, added);
    }

    private void renamedCMPField(IPersistentField removed, IPersistentField added) {
        String oldName = removed.getName();
        String newName = added.getName();
        IEntityBean bean = (IEntityBean)added.getParent();
        IEntityBean originalBean = (IEntityBean)removed.getParent();
        if (originalBean != bean) {
            this.removedPersistentField(removed);
            this.addedPersistentField(added);
            return;
        }
        EnterpriseBean[] deployedBeans = this.findDeployedBeans((IEnterpriseBean)bean);
        if (!ParticipantSynchronizer.ensureAllSaved((DescriptorEntity[])deployedBeans)) {
            return;
        }
        deployedBeans = this.findDeployedBeans((IEnterpriseBean)bean);
        int i = 0;
        while (i < deployedBeans.length) {
            if (deployedBeans[i] instanceof EntityBeanImpl) {
                String primKeyField;
                EntityBeanImpl deployed = (EntityBeanImpl)deployedBeans[i];
                CmpField cmpField = deployed.getCmpField(oldName);
                if (cmpField != null) {
                    if (cmpField.canSetName(newName)) {
                        cmpField.setName(newName);
                    } else {
                        EjbJarImplPlugin.logWarning("Synchronization failed while renaming persistent field " + removed);
                    }
                } else {
                    EjbJarImplPlugin.logWarning("Synchronization failed while renaming persistent field " + removed + ": no such field");
                }
                if (bean.isSimplePK() && oldName.equals(primKeyField = deployed.getPrimaryKeyField())) {
                    if (deployed.canSetPrimaryKeyField(newName)) {
                        deployed.setPrimaryKeyField(newName);
                    } else {
                        EjbJarImplPlugin.logWarning("Synchronization failed while renaming primKeyField " + removed);
                    }
                }
            }
            ++i;
        }
    }

    private void renamedRelation(IRelationshipEnd removed, IRelationshipEnd added) {
        IEntityBean bean = (IEntityBean)added.getParent();
        IEntityBean originalBean = (IEntityBean)removed.getParent();
        if (originalBean != bean) {
            this.removedRelation(removed);
            this.addedRelation(added);
            return;
        }
        EjbRelationshipRole[] relations = AssembledInfoFinder.findAssembledRelations((IRelationshipEnd)removed);
        if (relations == null || !ParticipantSynchronizer.ensureAllSaved((DescriptorEntity[])relations)) {
            return;
        }
        relations = AssembledInfoFinder.findAssembledRelations((IRelationshipEnd)removed);
        String newName = added.getName();
        int i = 0;
        while (i < relations.length) {
            if (relations[i].canSetCmrFieldName(newName)) {
                relations[i].setCmrFieldName(newName);
            } else {
                EjbJarImplPlugin.logWarning("Could not rename relation");
            }
            ++i;
        }
    }

    private void beanRenamed(IEnterpriseBean removed, IEnterpriseBean added) {
        try {
            added = added.getEJBProject().getEnterpriseBean(added.getBeanClassName());
        }
        catch (EJBModelException e) {
            EjbJarImplPlugin.logError("Could not find new state for the added bean", e);
            return;
        }
        if (added == null) {
            return;
        }
        EnterpriseBean[] deployedBeans = this.findDeployedBeans(removed);
        if (!ParticipantSynchronizer.ensureAllSaved((DescriptorEntity[])deployedBeans)) {
            return;
        }
        deployedBeans = this.findDeployedBeans(removed);
        int i = 0;
        while (i < deployedBeans.length) {
            ((EnterpriseBeanImpl)deployedBeans[i]).referencedBeanRenamed(removed, added);
            ++i;
        }
    }

    private void ejbMethodRenamed(IEJBMethod removed, IEJBMethod added) {
        IEnterpriseBean expectedBean = (IEnterpriseBean)removed.getParent();
        String expectedBeanClassName = expectedBean.getBeanClassName();
        String expectedMethodName = removed.getNameForDD();
        String newMethodName = added.getNameForDD();
        String[] expectedParameters = removed.getParameterTypesForDD();
        String[] newParameters = added.getParameterTypesForDD();
        Method[] methods = this.findDeployedMethods(removed, this.getFindAllMethodsCondition(expectedBeanClassName, expectedMethodName, expectedParameters));
        if (!ParticipantSynchronizer.ensureAllSaved((DescriptorEntity[])methods)) {
            return;
        }
        methods = this.findDeployedMethods(removed, this.getFindAllMethodsCondition(expectedBeanClassName, expectedMethodName, expectedParameters));
        int i = 0;
        while (i < methods.length) {
            Method next = methods[i];
            if (next.canSetMethodSignature(next.getEjbName(), next.getInterfaceType(), newMethodName, newParameters)) {
                next.setMethodSignature(next.getEjbName(), next.getInterfaceType(), newMethodName, newParameters);
            }
            ++i;
        }
        if (removed.getKind() == 4 || removed.getKind() == 16) {
            Query[] queries = this.findDeployedQueries(removed);
            if (!ParticipantSynchronizer.ensureAllSaved((DescriptorEntity[])queries)) {
                return;
            }
            queries = this.findDeployedQueries(removed);
            int i2 = 0;
            while (i2 < queries.length) {
                Query q = queries[i2];
                if (q.canSetMethodSignature(newMethodName, newParameters)) {
                    q.setMethodSignature(newMethodName, newParameters);
                }
                ++i2;
            }
        }
    }

    private void ejbMethodDragNDropped(IEJBMethod removed, IEJBMethod added) {
        IEnterpriseBean oldBean = (IEnterpriseBean)removed.getParent();
        IEnterpriseBean newBean = (IEnterpriseBean)added.getParent();
        String oldBeanClassName = oldBean.getBeanClassName();
        String oldMethodName = removed.getNameForDD();
        String newMethodName = added.getNameForDD();
        String[] oldParameters = removed.getParameterTypesForDD();
        String[] newParameters = added.getParameterTypesForDD();
        MethodDNDHelper helper = new MethodDNDHelper(removed, added);
        HashMap ejbJars2NewDeployedBeans = helper.getEjbJars2NewDeployedBeansMap();
        Method[] methodsToProcess = this.findDeployedMethods(removed, this.getFindAllMethodsCondition(oldBeanClassName, oldMethodName, oldParameters));
        if (!ParticipantSynchronizer.ensureAllSaved((DescriptorEntity[])methodsToProcess)) {
            return;
        }
        methodsToProcess = this.findDeployedMethods(removed, this.getFindAllMethodsCondition(oldBeanClassName, oldMethodName, oldParameters));
        int i = 0;
        while (i < methodsToProcess.length) {
            Method next = methodsToProcess[i];
            String newBeanName = (String)ejbJars2NewDeployedBeans.get(next.getDocument());
            if (newBeanName != null) {
                if (next.canSetMethodSignature(newBeanName, next.getInterfaceType(), newMethodName, newParameters)) {
                    next.setMethodSignature(newBeanName, next.getInterfaceType(), newMethodName, newParameters);
                } else {
                    EjbJarImplPlugin.logWarning("Could not refactor method occurrence after DnD");
                }
            } else if (next.canDelete()) {
                next.delete();
            } else {
                EjbJarImplPlugin.logWarning("Could not remove method occurrence after DnD");
            }
            ++i;
        }
        try {
            if (removed instanceof IQueryMethod && ((IEntityBean)removed.getParent()).isCMP()) {
                Query[] queriesToProcess = this.findDeployedQueries(removed);
                if (!ParticipantSynchronizer.ensureAllSaved((DescriptorEntity[])queriesToProcess)) {
                    return;
                }
                queriesToProcess = this.findDeployedQueries(removed);
                int i2 = 0;
                while (i2 < queriesToProcess.length) {
                    EntityBean newEntityBean;
                    Query nextQuery = queriesToProcess[i2];
                    EjbJar ejbJar = (EjbJar)nextQuery.getDocument();
                    String newBeanName = (String)ejbJars2NewDeployedBeans.get(ejbJar);
                    if (newBeanName != null && (newEntityBean = ejbJar.getEntityBean(newBeanName)) != null) {
                        if (newEntityBean.canCreateQuery(newMethodName, newParameters, nextQuery.getResultTypeMapping(), nextQuery.getEjbQl(), nextQuery.getDescription())) {
                            newEntityBean.createQuery(newMethodName, newParameters, nextQuery.getResultTypeMapping(), nextQuery.getEjbQl(), nextQuery.getDescription());
                        } else {
                            EjbJarImplPlugin.logWarning("Could not refactor query occurrence after DnD");
                        }
                    }
                    if (nextQuery.canDelete()) {
                        nextQuery.delete();
                    } else {
                        EjbJarImplPlugin.logWarning("Could not remove query occurrence after DnD");
                    }
                    ++i2;
                }
                EnterpriseBean[] newAssembledBeans = this.findDeployedBeans(newBean);
                if (!ParticipantSynchronizer.ensureAllSaved((DescriptorEntity[])newAssembledBeans)) {
                    return;
                }
                newAssembledBeans = this.findDeployedBeans(newBean);
                int i3 = 0;
                while (i3 < newAssembledBeans.length) {
                    EntityBean deployed;
                    EnterpriseBean next = newAssembledBeans[i3];
                    if (next instanceof EntityBean && (deployed = (EntityBean)next).canCreateQuery(newMethodName, newParameters, null, "", null)) {
                        deployed.createQuery(newMethodName, newParameters, null, "", null);
                    }
                    ++i3;
                }
            }
        }
        catch (EJBModelException e) {
            EjbJarImplPlugin.logWarning("Could not synchronize method DnD", e);
        }
    }

    private void processTotallyChangedElements(IEJBElement[] elements) {
        int i = 0;
        while (i < elements.length) {
            try {
                if (elements[i] instanceof IEntityBean && ((IEntityBean)elements[i]).isCMP()) {
                    this.processTotallyChangedCMPBeans((IEntityBean)elements[i]);
                }
            }
            catch (EJBModelException e) {
                // empty catch block
            }
            ++i;
        }
    }

    private void processTotallyChangedCMPBeans(IEntityBean bean) {
        IPersistentField[] fields;
        try {
            fields = bean.getFields();
        }
        catch (EJBModelException e) {
            return;
        }
        EnterpriseBean[] deployedBeans = this.findDeployedBeans((IEnterpriseBean)bean);
        if (deployedBeans == null) {
            return;
        }
        if (!ParticipantSynchronizer.ensureAllSaved((DescriptorEntity[])deployedBeans)) {
            return;
        }
        deployedBeans = this.findDeployedBeans((IEnterpriseBean)bean);
        if (deployedBeans == null) {
            return;
        }
        int i = 0;
        while (i < deployedBeans.length) {
            if (deployedBeans[i] instanceof EntityBean) {
                EntityBean entity = (EntityBean)deployedBeans[i];
                this.synchronizeFields(entity, bean, fields);
            }
            ++i;
        }
    }

    private void synchronizeFields(EntityBean deployedBean, IEntityBean cmpBean, IPersistentField[] fields) {
        boolean isSimplePK = cmpBean.isSimplePK();
        String pkFieldName = null;
        CmpField[] cmpFields = deployedBean.getCmpFields();
        ArrayList<String> cmpFieldNames = new ArrayList<String>();
        if (cmpFields != null) {
            int i = 0;
            while (i < cmpFields.length) {
                cmpFieldNames.add(cmpFields[i].getName());
                ++i;
            }
        }
        ArrayList<String> persistentFieldNames = new ArrayList<String>();
        int i = 0;
        while (i < fields.length) {
            if (!fields[i].isRelationship()) {
                if (isSimplePK && fields[i].isInPrimaryKey()) {
                    pkFieldName = fields[i].getName();
                }
                persistentFieldNames.add(fields[i].getName());
            }
            ++i;
        }
        HashSet common = new HashSet(cmpFieldNames);
        common.retainAll(persistentFieldNames);
        HashSet added = new HashSet(persistentFieldNames);
        added.removeAll(common);
        HashSet removed = new HashSet(cmpFieldNames);
        removed.removeAll(common);
        Iterator it = added.iterator();
        while (it.hasNext()) {
            String next = (String)it.next();
            if (deployedBean.canCreateCmpField(next, null)) {
                deployedBean.createCmpField(next, null);
                continue;
            }
            EjbJarImplPlugin.logError("Could not create entry for new CMP field");
        }
        Iterator it2 = removed.iterator();
        while (it2.hasNext()) {
            String next = (String)it2.next();
            CmpField field = deployedBean.getCmpField(next);
            if (field.canDelete()) {
                field.delete();
                continue;
            }
            EjbJarImplPlugin.logWarning("Did not find CMP field to delete");
        }
        if (!ParticipantSynchronizer.equals(deployedBean.getPrimaryKeyField(), pkFieldName) && deployedBean.canSetPrimaryKeyField(pkFieldName)) {
            deployedBean.setPrimaryKeyField(pkFieldName);
        }
    }

    private static boolean equals(String one, String another) {
        if (one == another) {
            return true;
        }
        if (one == null || another == null) {
            return false;
        }
        return one.equals(another);
    }

    public void methodParticipantsChanged(final IEJBMethod method, int oldFlags, int newFlags) {
        final int uncheckedFlags = oldFlags - (oldFlags & newFlags);
        if (uncheckedFlags != 0) {
            ModelAccess.runCommandLater((Runnable)new UndoTransparableCommand(){

                public void run() {
                    ParticipantSynchronizer.this.internalMethodParticipantsChanged(method, uncheckedFlags);
                }
            });
        }
    }

    private void internalMethodParticipantsChanged(IEJBMethod ejbMethod, final int uncheckedFlags) {
        if (!ejbMethod.exists()) {
            return;
        }
        IEnterpriseBean expectedBean = (IEnterpriseBean)ejbMethod.getParent();
        final String expectedBeanClassName = expectedBean.getBeanClassName();
        final String expectedMethodName = ejbMethod.getNameForDD();
        if (expectedMethodName == null) {
            return;
        }
        final String[] expectedParameters = ejbMethod.getParameterTypesForDD();
        AssembledInfoFinder.UnaryConditionEx condition = new AssembledInfoFinder.UnaryConditionEx(){
            private EjbJar myEjbJar;

            public boolean execute(Object object) {
                Method ejbjarMethod = (Method)object;
                if (!ParticipantSynchronizer.this.isApplicableInterfaceType(ejbjarMethod.getInterfaceType(), uncheckedFlags, false)) {
                    return false;
                }
                EnterpriseBean bean = this.myEjbJar.getEnterpriseBean(ejbjarMethod.getEjbName());
                if (bean == null) {
                    return false;
                }
                String beanClassName = bean.getEjbClass();
                if (!expectedBeanClassName.equals(beanClassName)) {
                    return false;
                }
                String methodName = ejbjarMethod.getMethodName();
                if (methodName == null) {
                    return false;
                }
                if (!methodName.equals(expectedMethodName)) {
                    return false;
                }
                String[] parameterTypes = ejbjarMethod.getMethodParameters();
                return ParticipantSynchronizer.equalParameterTypes(parameterTypes, expectedParameters);
            }

            public void setEjbJar(EjbJar ejbJar) {
                this.myEjbJar = ejbJar;
            }
        };
        Method[] methods = this.findDeployedMethods(ejbMethod, condition);
        if (!ParticipantSynchronizer.ensureAllSaved((DescriptorEntity[])methods)) {
            return;
        }
        methods = this.findDeployedMethods(ejbMethod, condition);
        int i = 0;
        while (i < methods.length) {
            methods[i].delete();
            ++i;
        }
    }

    public void relationCardinalityChanged(final IRelationshipEnd relation, final int oldCardinality, final int newCardinality) {
        ModelAccess.runCommandLater((Runnable)new UndoTransparableCommand(){

            public void run() {
                ParticipantSynchronizer.this.internalRelationCardinalityChanged(relation, oldCardinality, newCardinality);
            }
        });
    }

    private void internalRelationCardinalityChanged(IRelationshipEnd relation, int oldCardinality, int newCardinality) {
        String cmrFieldType;
        String multiplicity;
        EjbRelationshipRole[] relations = AssembledInfoFinder.findAssembledRelations((IRelationshipEnd)relation);
        if (relations == null || !ParticipantSynchronizer.ensureAllSaved((DescriptorEntity[])relations)) {
            return;
        }
        relations = AssembledInfoFinder.findAssembledRelations((IRelationshipEnd)relation);
        if (relations == null) {
            return;
        }
        switch (newCardinality) {
            case 0: {
                multiplicity = "One";
                cmrFieldType = null;
                break;
            }
            case 1: {
                multiplicity = "Many";
                cmrFieldType = "java.util.Collection";
                break;
            }
            case 2: {
                multiplicity = "Many";
                cmrFieldType = "java.util.Set";
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        int i = 0;
        while (i < relations.length) {
            final EjbRelationshipRole nextRole = relations[i];
            if (relations[i].canSetMultiplicity(multiplicity) && relations[i].canSetCmrFieldType(cmrFieldType)) {
                relations[i].modify(new Runnable(){

                    public void run() {
                        nextRole.setMultiplicity(multiplicity);
                        nextRole.setCmrFieldType(cmrFieldType);
                    }
                });
            } else {
                EjbJarImplPlugin.logWarning("Could not modify relation");
            }
            ++i;
        }
    }

    public void relationTargetChanged(final IRelationshipEnd relation, final IEntityBean oldTarget, final IEntityBean newTarget) {
        ModelAccess.runCommandLater((Runnable)new UndoTransparableCommand(){

            public void run() {
                ParticipantSynchronizer.this.internalRelationTargetChanged(relation, oldTarget, newTarget);
            }
        });
    }

    private void internalRelationTargetChanged(IRelationshipEnd relation, IEntityBean oldTarget, IEntityBean newTarget) {
        EjbRelationshipRole[] relations = AssembledInfoFinder.findAssembledRelations((IRelationshipEnd)relation);
        if (relations == null || !ParticipantSynchronizer.ensureAllSaved((DescriptorEntity[])relations)) {
            return;
        }
        relations = AssembledInfoFinder.findAssembledRelations((IRelationshipEnd)relation);
        if (relations == null) {
            return;
        }
        int i = 0;
        while (i < relations.length) {
            EjbRelationshipRole nextRole = relations[i];
            String newTargetEjbName = this.getTargetEjbName(relation, newTarget, nextRole.getSourceEjbName());
            EjbRelationshipRole theOtherRole = this.getTheOtherRole(nextRole);
            if (theOtherRole.canSetSourceEjbName(newTargetEjbName)) {
                theOtherRole.setSourceEjbName(newTargetEjbName);
            } else {
                EjbJarImplPlugin.logWarning("Could not modify relation");
            }
            ++i;
        }
    }

    private EjbRelationshipRole getTheOtherRole(EjbRelationshipRole role) {
        EjbRelation parent = (EjbRelation)role.getParent();
        EjbRelationshipRole one = parent.getRole1();
        if (one != role) {
            return one;
        }
        return parent.getRole2();
    }

    private String getTargetEjbName(IRelationshipEnd relation, IEntityBean targetBean, String sourceEjbName) {
        IEntityBean parentEJB;
        String target = relation.getDdpAsString("defaultEjbRelationTargetEjbName");
        if (target != null && (target = target.trim()).length() > 0) {
            return target;
        }
        target = relation.getDdpAsString("defaultEjbRelationTargetBeanClass");
        if (target != null) {
            parentEJB = relation.getRoleSource();
            if (target.equals(parentEJB.getBeanClassName())) {
                return sourceEjbName;
            }
            if ((target = Signature.getSimpleName((String)target.trim()).trim()) != null) {
                return target;
            }
        }
        if ((target = relation.getDdpAsString("defaultEjbRelationTargetLocalInterface")) == null) {
            return null;
        }
        try {
            parentEJB = relation.getRoleSource();
            IType parentLocal = parentEJB.getParticipant(16);
            if (parentLocal != null && target.equals(parentLocal.getFullyQualifiedName())) {
                return sourceEjbName;
            }
        }
        catch (EJBModelException e) {
            // empty catch block
        }
        target = Signature.getSimpleName((String)target.trim()).trim();
        if (target == null) {
            return null;
        }
        if (!target.endsWith("Local")) {
            return null;
        }
        return target.substring(0, target.length() - "Local".length()) + "Bean";
    }

    private static boolean equalParameterTypes(String[] one, String[] another) {
        if (one == null) {
            return false;
        }
        if (one.length != another.length) {
            return false;
        }
        int i = 0;
        while (i < one.length) {
            if (!Signature.getSimpleName((String)one[i]).equals(Signature.getSimpleName((String)another[i]))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isApplicableInterfaceType(String interfaceType, int flags, boolean allowNull) {
        if (interfaceType == null) {
            return allowNull;
        }
        if ("Home".equals(interfaceType)) {
            return (flags & 2) > 0;
        }
        if ("Local".equals(interfaceType)) {
            return (flags & 0x10) > 0;
        }
        if ("LocalHome".equals(interfaceType)) {
            return (flags & 8) > 0;
        }
        if ("Remote".equals(interfaceType)) {
            return (flags & 4) > 0;
        }
        return false;
    }

    public Method[] findDeployedMethods(IEJBMethod method, AssembledInfoFinder.UnaryConditionEx filter) {
        Method[] rawResult = AssembledInfoFinder.findDeployedMethods((IEJBMethod)method, (AssembledInfoFinder.UnaryConditionEx)filter);
        if (rawResult == null) {
            return rawResult;
        }
        if (this.validateEdit((DescriptorEntity[])rawResult)) {
            return rawResult;
        }
        ArrayList<Method> result = new ArrayList<Method>();
        int i = 0;
        while (i < rawResult.length) {
            if (!rawResult[i].getDocument().getFile().isReadOnly()) {
                result.add(rawResult[i]);
            }
            ++i;
        }
        return result.toArray(new Method[result.size()]);
    }

    public Query[] findDeployedQueries(IEJBMethod method) {
        Query[] rawResult = AssembledInfoFinder.findAssembledQueries((IEJBMethod)method);
        if (rawResult == null) {
            return rawResult;
        }
        if (this.validateEdit((DescriptorEntity[])rawResult)) {
            return rawResult;
        }
        ArrayList<Query> result = new ArrayList<Query>();
        int i = 0;
        while (i < rawResult.length) {
            if (!rawResult[i].getDocument().getFile().isReadOnly()) {
                result.add(rawResult[i]);
            }
            ++i;
        }
        return result.toArray(new Query[result.size()]);
    }

    private boolean validateEdit(DescriptorEntity[] entities) {
        HashSet<IFile> files = new HashSet<IFile>();
        int i = 0;
        while (i < entities.length) {
            files.add(entities[i].getDocument().getFile());
            ++i;
        }
        if (files.isEmpty()) {
            return true;
        }
        return new ReadOnlinessValidator(files.toArray(new IFile[files.size()])).canModify();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

