/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejbjar;

import com.tssap.j2ee.core.descriptor.DescriptorEntity;
import com.tssap.j2ee.core.descriptor.EnterpriseBean;
import com.tssap.j2ee.core.ejb.EJBModelException;
import com.tssap.j2ee.core.ejb.IEJBMethod;
import com.tssap.j2ee.core.ejb.IEnterpriseBean;
import com.tssap.j2ee.core.ejbjar.EjbJar;
import com.tssap.j2ee.core.ejbjar.EjbJarMetaInfo;
import com.tssap.j2ee.core.ejbjar.Method;
import com.tssap.j2ee.internal.core.descriptor.DescriptorEntityImpl;
import com.tssap.j2ee.internal.core.ejbjar.AbstractMethodImpl;
import com.tssap.j2ee.internal.core.ejbjar.EjbJarChildOrder;
import com.tssap.j2ee.internal.core.ejbjar.MethodContainerImpl;
import com.tssap.j2ee.internal.core.util.DomUtils;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.Signature;
import org.w3c.dom.Element;

final class MethodImpl
extends AbstractMethodImpl
implements Method {
    private String myCachedSignature;
    private static final IEJBMethod[] NO_EJB_METHODS = new IEJBMethod[0];
    private static final IMethod[] NO_JDT_METHODS = new IMethod[0];

    public MethodImpl(MethodContainerImpl parent, Element element) {
        super((DescriptorEntityImpl)parent, element);
    }

    public String toString() {
        return "Method \"" + this.getMethodSignature() + "\" of (" + this.getParent() + ")";
    }

    public void delete() {
        if (!this.edit(null)) {
            return;
        }
        final String oldSignature = this.getMethodSignature();
        this.myCachedSignature = null;
        this.modify(new Runnable(){

            public void run() {
                MethodImpl.super.delete();
                MethodImpl.this.getMethodContainerImpl().updateMethod(oldSignature);
            }
        });
    }

    public String getMethodSignature() {
        if (this.myCachedSignature == null) {
            this.myCachedSignature = EjbJarMetaInfo.getMethodSignature((String)this.getEjbName(), (String)this.getInterfaceType(), (String)this.getMethodName(), (String[])this.getMethodParameters());
        }
        return this.myCachedSignature;
    }

    public boolean canSetMethodSignature(String signature) {
        if (signature == null) {
            return false;
        }
        if (signature.equals(this.getMethodSignature())) {
            return true;
        }
        return this.getMethodContainerImpl().getMethod(signature) == null;
    }

    public boolean canSetMethodSignature(String ejbName, String interfaceType, String name, String[] parameters) {
        return this.canSetMethodSignature(EjbJarMetaInfo.getMethodSignature((String)ejbName, (String)interfaceType, (String)name, (String[])parameters));
    }

    public void setMethodSignature(String ejbName, String interfaceType, String name, String[] parameters) {
        String signature = EjbJarMetaInfo.getMethodSignature((String)ejbName, (String)interfaceType, (String)name, (String[])parameters);
        if (!this.canSetMethodSignature(signature)) {
            throw new IllegalArgumentException(signature);
        }
        String oldSignature = this.getMethodSignature();
        if (signature.equals(oldSignature)) {
            return;
        }
        if (!this.edit(null)) {
            return;
        }
        if (!DescriptorEntityImpl.equals((Object)ejbName, (Object)this.getEjbName())) {
            this.doSetEjbName(ejbName);
        }
        if (!DescriptorEntityImpl.equals((Object)interfaceType, (Object)this.getInterfaceType())) {
            this.doSetInterfaceType(interfaceType);
        }
        if (!DescriptorEntityImpl.equals((Object)name, (Object)this.getMethodName())) {
            this.doSetMethodName(name);
        }
        if (!Arrays.equals(parameters, this.getMethodParameters())) {
            this.doSetMethodParameters(parameters);
        }
        this.signatureChanged();
    }

    public String getEjbName() {
        return DomUtils.getChildTextNodeValue((Element)this.getElement(), (String)"ejb-name");
    }

    public boolean canSetEjbName(String name) {
        return this.canSetMethodSignature(EjbJarMetaInfo.getMethodSignature((String)name, (String)this.getInterfaceType(), (String)this.getMethodName(), (String[])this.getMethodParameters()));
    }

    public void setEjbName(String name) {
        if (!this.canSetEjbName(name)) {
            throw new IllegalArgumentException(name);
        }
        if (DescriptorEntityImpl.equals((Object)name, (Object)this.getEjbName())) {
            return;
        }
        if (!this.edit(null)) {
            return;
        }
        this.doSetEjbName(name);
        this.signatureChanged();
    }

    private void doSetEjbName(String name) {
        DomUtils.setChildTextNodeValue((Element)this.getElement(), (String[])EjbJarChildOrder.METHOD, (String)"ejb-name", (String)name);
    }

    public String getInterfaceType() {
        return DomUtils.getChildTextNodeValue((Element)this.getElement(), (String)"method-intf");
    }

    public boolean canSetInterfaceType(String type) {
        return this.canSetMethodSignature(EjbJarMetaInfo.getMethodSignature((String)this.getEjbName(), (String)type, (String)this.getMethodName(), (String[])this.getMethodParameters()));
    }

    public void setInterfaceType(String type) {
        if (!this.canSetInterfaceType(type)) {
            throw new IllegalArgumentException(type);
        }
        if (DescriptorEntityImpl.equals((Object)type, (Object)this.getInterfaceType())) {
            return;
        }
        if (!this.edit(null)) {
            return;
        }
        this.doSetInterfaceType(type);
        this.signatureChanged();
    }

    private void doSetInterfaceType(String type) {
        DomUtils.setChildTextNodeValue((Element)this.getElement(), (String[])EjbJarChildOrder.METHOD, (String)"method-intf", (String)type);
    }

    public boolean canSetMethodName(String name) {
        return this.canSetMethodSignature(EjbJarMetaInfo.getMethodSignature((String)this.getEjbName(), (String)this.getInterfaceType(), (String)name, (String[])this.getMethodParameters()));
    }

    public boolean canSetMethodParameters(String[] parameters) {
        return this.canSetMethodSignature(EjbJarMetaInfo.getMethodSignature((String)this.getEjbName(), (String)this.getInterfaceType(), (String)this.getMethodName(), (String[])parameters));
    }

    private IEnterpriseBean getEjb() {
        EjbJar ejbJar = (EjbJar)this.getDocument();
        if (ejbJar == null) {
            return null;
        }
        EnterpriseBean ejb = ejbJar.getEnterpriseBean(this.getEjbName());
        if (ejb == null) {
            return null;
        }
        return ejbJar.getReferencedBean(ejb.getEjbClass());
    }

    protected IEJBMethod[] getReferencedEjbMethods() {
        IEJBMethod[] methods;
        IEnterpriseBean ejb = this.getEjb();
        if (ejb == null) {
            return NO_EJB_METHODS;
        }
        try {
            methods = ejb.getEJBMethods();
        }
        catch (EJBModelException eme) {
            return NO_EJB_METHODS;
        }
        if (methods == null || methods.length == 0) {
            return NO_EJB_METHODS;
        }
        String methodName = this.getMethodName();
        if ("*".equals(methodName)) {
            return methods;
        }
        String[] parameters = this.getMethodParameters();
        ArrayList<IEJBMethod> filteredMethods = new ArrayList<IEJBMethod>(methods.length);
        int i = 0;
        while (i < methods.length) {
            String[] parameterTypes;
            IEJBMethod method = methods[i];
            if (method.getName().equals(methodName) && MethodImpl.isParameterTypesEqual(parameters, parameterTypes = method.getParameterTypesForDD())) {
                filteredMethods.add(method);
            }
            ++i;
        }
        methods = filteredMethods.toArray(new IEJBMethod[filteredMethods.size()]);
        return methods;
    }

    private static boolean isParameterTypesEqual(String[] spa, String[] tpa) {
        if (spa == null || tpa == null || spa.length != tpa.length) {
            return false;
        }
        int j = 0;
        while (j < spa.length) {
            String sp = spa[j];
            String tp = tpa[j];
            if (!sp.equals(tp) && !(sp = Signature.getSimpleName((String)sp)).equals(tp = Signature.getSimpleName((String)tp))) {
                return false;
            }
            ++j;
        }
        return true;
    }

    public IEJBMethod[] getEjbMethods() {
        if (this.getInterfaceType() != null) {
            return NO_EJB_METHODS;
        }
        return this.getReferencedEjbMethods();
    }

    public IMethod[] getJavaMethods() {
        String interfaceType = this.getInterfaceType();
        if (interfaceType == null) {
            return NO_JDT_METHODS;
        }
        ArrayList<IMethod> jdtMethods = new ArrayList<IMethod>();
        IEJBMethod[] methods = this.getReferencedEjbMethods();
        int i = 0;
        while (i < methods.length) {
            block10: {
                IMethod jdtMethod;
                block9: {
                    IEJBMethod method = methods[i];
                    try {
                        if ("Home".equals(interfaceType)) {
                            jdtMethod = method.getMethod(2);
                            break block9;
                        }
                        if ("Local".equals(interfaceType)) {
                            jdtMethod = method.getMethod(16);
                            break block9;
                        }
                        if ("LocalHome".equals(interfaceType)) {
                            jdtMethod = method.getMethod(8);
                            break block9;
                        }
                        if ("Remote".equals(interfaceType)) {
                            jdtMethod = method.getMethod(4);
                            break block9;
                        }
                        throw new IllegalStateException(interfaceType);
                    }
                    catch (EJBModelException eme) {
                        break block10;
                    }
                }
                if (jdtMethod != null && jdtMethod.exists()) {
                    jdtMethods.add(jdtMethod);
                }
            }
            ++i;
        }
        return jdtMethods.toArray(new IMethod[jdtMethods.size()]);
    }

    protected Element getMethodElement() {
        return this.getElement();
    }

    protected String[] getMethodChildOrder() {
        return this.getChildOrder();
    }

    protected String[] getChildOrder() {
        return EjbJarChildOrder.METHOD;
    }

    private MethodContainerImpl getMethodContainerImpl() {
        return (MethodContainerImpl)this.getParent();
    }

    protected void signatureChanged() {
        String oldSignature = this.getMethodSignature();
        this.myCachedSignature = null;
        this.getMethodContainerImpl().updateMethod(oldSignature);
        this.changed((DescriptorEntity)this);
    }
}

