/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejbjar;

import com.tssap.j2ee.core.descriptor.EnterpriseBean;
import com.tssap.j2ee.core.ejb.EjbProject;
import com.tssap.j2ee.core.ejb.IEJBMethod;
import com.tssap.j2ee.core.ejb.IEnterpriseBean;
import com.tssap.j2ee.core.ejbjar.AssembledInfoFinder;
import com.tssap.j2ee.core.ejbjar.EjbJar;
import com.tssap.j2ee.core.ejbjar.EjbJarProject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

public class MethodDNDHelper {
    private IEJBMethod myRemoved;
    private IEJBMethod myAdded;
    private IEnterpriseBean myOldBean;
    private IEnterpriseBean myNewBean;
    private EjbJarProject[] myNewPossibleReferencers;
    private EjbJarProject[] myOldPossibleReferencers;
    private EjbJarProject[] myCommonPossibleReferencers;
    private Collection myEjbJarsWhereDNDPossible;
    private HashMap myEjbJars2NewDeployedBeansMap;

    public MethodDNDHelper(IEJBMethod removed, IEJBMethod added) {
        this.myRemoved = removed;
        this.myAdded = added;
        this.myOldBean = (IEnterpriseBean)this.myRemoved.getParent();
        this.myNewBean = (IEnterpriseBean)this.myAdded.getParent();
        EjbJarProject[] oldPossibleReferencers = AssembledInfoFinder.findDependentAssemblyProjects((EjbProject)this.myOldBean.getEJBProject());
        EjbJarProject[] newPossibleReferencers = AssembledInfoFinder.findDependentAssemblyProjects((EjbProject)this.myNewBean.getEJBProject());
        HashSet<EjbJarProject> oldReferencers = new HashSet<EjbJarProject>(Arrays.asList(oldPossibleReferencers));
        HashSet<EjbJarProject> newReferencers = new HashSet<EjbJarProject>(Arrays.asList(newPossibleReferencers));
        HashSet<EjbJarProject> commonReferencers = new HashSet<EjbJarProject>(oldReferencers);
        commonReferencers.retainAll(newReferencers);
        oldReferencers.removeAll(commonReferencers);
        newReferencers.removeAll(commonReferencers);
        this.myCommonPossibleReferencers = commonReferencers.toArray(new EjbJarProject[commonReferencers.size()]);
        this.myOldPossibleReferencers = oldReferencers.toArray(new EjbJarProject[oldReferencers.size()]);
        this.myNewPossibleReferencers = newReferencers.toArray(new EjbJarProject[newReferencers.size()]);
    }

    public Collection getEjbJarsWhereDNDPossible() {
        if (this.myEjbJarsWhereDNDPossible != null) {
            return this.myEjbJarsWhereDNDPossible;
        }
        this.myEjbJarsWhereDNDPossible = new ArrayList();
        this.myEjbJars2NewDeployedBeansMap = new HashMap();
        int i = 0;
        while (i < this.myCommonPossibleReferencers.length) {
            EjbJarProject next = this.myCommonPossibleReferencers[i];
            EjbJar[] ejbJars = next.getEjbJars();
            if (ejbJars != null) {
                int j = 0;
                while (j < ejbJars.length) {
                    EjbJar nextEjbJar = ejbJars[j];
                    String newBeanName = this.getNewBeanNameIfBothBeansDeployedExactlyOnce(nextEjbJar);
                    if (newBeanName != null) {
                        this.myEjbJarsWhereDNDPossible.add(nextEjbJar);
                        this.myEjbJars2NewDeployedBeansMap.put(nextEjbJar, newBeanName);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return this.myEjbJarsWhereDNDPossible;
    }

    private String getNewBeanNameIfBothBeansDeployedExactlyOnce(EjbJar ejbJar) {
        boolean haveRemoved = false;
        String addedName = null;
        EnterpriseBean[] beans = ejbJar.getEnterpriseBeans();
        if (beans == null) {
            return null;
        }
        int i = 0;
        while (i < beans.length) {
            String beanClass = beans[i].getEjbClass();
            if (beanClass != null) {
                if (beanClass.equals(this.myOldBean.getBeanClassName())) {
                    if (haveRemoved) {
                        return null;
                    }
                    haveRemoved = true;
                }
                if (beanClass.equals(this.myNewBean.getBeanClassName())) {
                    if (addedName != null) {
                        return null;
                    }
                    addedName = beans[i].getName();
                }
            }
            ++i;
        }
        if (!haveRemoved) {
            return null;
        }
        return addedName;
    }

    public HashMap getEjbJars2NewDeployedBeansMap() {
        if (this.myEjbJars2NewDeployedBeansMap == null) {
            this.getEjbJarsWhereDNDPossible();
        }
        return this.myEjbJars2NewDeployedBeansMap;
    }
}

