/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejbjar;

import com.tssap.j2ee.core.descriptor.DescriptorEntity;
import com.tssap.j2ee.core.ejbjar.EjbJarMetaInfo;
import com.tssap.j2ee.core.ejbjar.Method;
import com.tssap.j2ee.core.ejbjar.MethodContainer;
import com.tssap.j2ee.internal.core.descriptor.DescribedDescriptorEntityImpl;
import com.tssap.j2ee.internal.core.descriptor.DescriptorEntityImpl;
import com.tssap.j2ee.internal.core.ejbjar.AssemblyDescriptorImpl;
import com.tssap.j2ee.internal.core.ejbjar.EjbJarChildOrder;
import com.tssap.j2ee.internal.core.ejbjar.MethodImpl;
import com.tssap.j2ee.internal.core.util.DomUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;

abstract class MethodContainerImpl
extends DescribedDescriptorEntityImpl
implements MethodContainer {
    private Map myMethods;

    public MethodContainerImpl(AssemblyDescriptorImpl parent, Element element) {
        super((DescriptorEntityImpl)parent, element);
    }

    protected void readMethods() {
        if (this.myMethods == null) {
            this.myMethods = new HashMap();
            Element[] methods = DomUtils.getChildElements((Element)this.getElement(), (String)"method");
            int i = 0;
            while (i < methods.length) {
                MethodImpl method = new MethodImpl(this, methods[i]);
                if (method.getMethodSignature() != null) {
                    this.myMethods.put(method.getMethodSignature(), method);
                }
                ++i;
            }
        }
    }

    public void updateMethod(String name) {
        Method method;
        if (this.myMethods != null && name != null && (method = (Method)this.myMethods.remove(name)) != null && method.isValid()) {
            this.myMethods.put(method.getMethodSignature(), method);
        }
    }

    public Method[] getMethods() {
        this.readMethods();
        if (this.myMethods.isEmpty()) {
            return null;
        }
        Collection methods = this.myMethods.values();
        return methods.toArray(new Method[methods.size()]);
    }

    public Method getMethod(String name) {
        this.readMethods();
        return (Method)this.myMethods.get(name);
    }

    public boolean canCreateMethod(String ejbName, String interfaceType, String name, String[] parameters, String description) {
        this.readMethods();
        String signature = EjbJarMetaInfo.getMethodSignature((String)ejbName, (String)interfaceType, (String)name, (String[])parameters);
        return signature != null && !this.myMethods.containsKey(signature);
    }

    public Method createMethod(String ejbName, String interfaceType, String name, String[] parameters, String description) {
        if (!this.canCreateMethod(ejbName, interfaceType, name, parameters, description)) {
            throw new IllegalArgumentException();
        }
        if (!this.edit(null)) {
            return null;
        }
        Element methodElement = DomUtils.createChildElement((Element)this.getElement(), (String[])this.getChildOrder(), (String)"method");
        DomUtils.setChildTextNodeValue((Element)methodElement, (String[])EjbJarChildOrder.METHOD, (String)"ejb-name", (String)ejbName);
        if (interfaceType != null) {
            DomUtils.setChildTextNodeValue((Element)methodElement, (String[])EjbJarChildOrder.METHOD, (String)"method-intf", (String)interfaceType);
        }
        DomUtils.setChildTextNodeValue((Element)methodElement, (String[])EjbJarChildOrder.METHOD, (String)"method-name", (String)name);
        if (parameters != null) {
            Element parametersElement = DomUtils.createChildElement((Element)methodElement, (String[])EjbJarChildOrder.METHOD, (String)"method-params");
            int i = 0;
            while (i < parameters.length) {
                String parameter = parameters[i];
                if (parameter == null) {
                    parameter = "";
                }
                Element parameterElement = DomUtils.createChildElement((Element)parametersElement, (String)"method-param", null);
                DomUtils.setElementText((Element)parameterElement, (String)parameter);
                ++i;
            }
        }
        if (description != null) {
            DomUtils.setChildTextNodeValue((Element)this.getElement(), (String[])EjbJarChildOrder.METHOD, (String)"description", (String)description);
        }
        MethodImpl method = new MethodImpl(this, methodElement);
        this.myMethods.put(method.getMethodSignature(), method);
        this.added((DescriptorEntity)method);
        return method;
    }

    protected abstract String[] getChildOrder();
}

