/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejbjar;

import com.tssap.j2ee.core.descriptor.EnterpriseBean;
import com.tssap.j2ee.core.ejb.EJBModelException;
import com.tssap.j2ee.core.ejb.EjbProject;
import com.tssap.j2ee.core.ejb.IAccessibleBean;
import com.tssap.j2ee.core.ejb.IEnterpriseBean;
import com.tssap.j2ee.core.ejb.IEntityBean;
import com.tssap.j2ee.internal.core.ejb.EjbPlugin;
import com.tssap.j2ee.internal.core.ejbjar.AccessibleBeanImpl;
import com.tssap.j2ee.internal.core.ejbjar.EjbJarImpl;
import com.tssap.j2ee.internal.core.ejbjar.EjbJarImplPlugin;
import com.tssap.j2ee.internal.core.ejbjar.EnterpriseBeanImpl;
import com.tssap.j2ee.internal.core.ejbjar.EntityBeanImpl;
import com.tssap.j2ee.internal.core.ejbjar.MessageDrivenBeanImpl;
import com.tssap.j2ee.internal.core.ejbjar.SessionBeanImpl;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class ForwardEngineering {
    private EjbJarImpl myEjbJar;
    private EjbProject[] myAllEJBProjects;

    public ForwardEngineering(EjbJarImpl ejbJar) {
        this.myEjbJar = ejbJar;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor monitor) {
        block8: {
            block9: {
                block7: {
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    EjbPlugin.getDefault().setGlobalAutomaticSynchronizationEnabled(false);
                    try {
                        EnterpriseBean[] beans = this.myEjbJar.getEnterpriseBeans();
                        if (beans == null) {
                            Object var5_3 = null;
                            break block7;
                        }
                        monitor.beginTask("Setting design comments to enable recognition", beans.length);
                        int i = 0;
                        while (true) {
                            if (i >= beans.length) {
                                break block8;
                            }
                            this.workBean((EnterpriseBeanImpl)beans[i], monitor);
                            if (monitor.isCanceled()) {
                                break block9;
                            }
                            ++i;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_6 = null;
                        EjbPlugin.getDefault().setGlobalAutomaticSynchronizationEnabled(true);
                        monitor.done();
                        throw throwable;
                    }
                }
                EjbPlugin.getDefault().setGlobalAutomaticSynchronizationEnabled(true);
                monitor.done();
                return;
            }
            Object var5_4 = null;
            EjbPlugin.getDefault().setGlobalAutomaticSynchronizationEnabled(true);
            monitor.done();
            return;
        }
        Object var5_5 = null;
        EjbPlugin.getDefault().setGlobalAutomaticSynchronizationEnabled(true);
        monitor.done();
    }

    private void workBean(EnterpriseBeanImpl bean, IProgressMonitor m) {
        IEnterpriseBean ejbProjectBean = this.findReferencedBean(bean);
        if (ejbProjectBean == null) {
            return;
        }
        ejbProjectBean.rewriteWithEjbJarContents((Object)bean, m);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void workBean(EntityBeanImpl bean, IProgressMonitor m) {
        block13: {
            block12: {
                block10: {
                    block9: {
                        block8: {
                            System.out.println("Working Entity bean " + bean.getEjbClass());
                            m.beginTask("Setting design comments to bean " + bean.getEjbClass(), 10);
                            try {
                                block11: {
                                    IEntityBean ejbProjectBean = (IEntityBean)this.findReferencedBean(bean);
                                    m.worked(1);
                                    if (ejbProjectBean == null) {
                                        Object var6_4 = null;
                                        break block8;
                                    }
                                    this.workAccessibleBean(bean, (IAccessibleBean)ejbProjectBean, m);
                                    this.setParticipant(32, bean.getPrimaryKeyClass(), (IAccessibleBean)ejbProjectBean, m);
                                    if (!"Container".equals(bean.getPersistenceType())) {
                                        break block9;
                                    }
                                    if (!"2.x".equals(bean.getCmpVersion())) {
                                        EjbJarImplPlugin.logWarning("CMP version 1.x not currently supported, bean ignored");
                                        break block10;
                                    }
                                    try {
                                        if (ejbProjectBean.isCMP()) break block11;
                                        EjbJarImplPlugin.logWarning("The bean is declared to be CMP, but is fount to be BMP");
                                        break block12;
                                    }
                                    catch (EJBModelException e) {
                                        Object var6_8 = null;
                                        m.done();
                                        return;
                                    }
                                }
                                String pkField = bean.getPrimaryKeyField();
                                if (pkField == null) {
                                }
                                break block13;
                            }
                            catch (Throwable throwable) {
                                Object var6_10 = null;
                                m.done();
                                throw throwable;
                            }
                        }
                        m.done();
                        return;
                    }
                    Object var6_5 = null;
                    m.done();
                    return;
                }
                Object var6_6 = null;
                m.done();
                return;
            }
            Object var6_7 = null;
            m.done();
            return;
        }
        Object var6_9 = null;
        m.done();
    }

    private void workAccessibleBean(AccessibleBeanImpl asmbean, IAccessibleBean ejbBean, IProgressMonitor m) {
        this.setParticipant(2, asmbean.getHomeInterface(), ejbBean, m);
        this.setParticipant(8, asmbean.getLocalHomeInterface(), ejbBean, m);
        this.setParticipant(4, asmbean.getRemoteInterface(), ejbBean, m);
        this.setParticipant(16, asmbean.getLocalInterface(), ejbBean, m);
    }

    private void setParticipant(int role, String participantFQN, IAccessibleBean bean, IProgressMonitor m) {
        IType type;
        if (participantFQN == null) {
            m.worked(1);
            return;
        }
        try {
            type = bean.getBeanClass().getJavaProject().findType(participantFQN);
        }
        catch (JavaModelException e) {
            type = null;
        }
        if (type == null) {
            EjbJarImplPlugin.logError("Could not find participant " + participantFQN + " for bean " + bean.getBeanClassName());
            m.worked(1);
            return;
        }
        try {
            IType recognizedParticipant = bean.getParticipant(role);
            if (recognizedParticipant == null || !participantFQN.equals(recognizedParticipant.getFullyQualifiedName())) {
                bean.addParticipant(role, participantFQN, true, false, null, (IProgressMonitor)new SubProgressMonitor(m, 1));
            }
        }
        catch (EJBModelException e1) {
            EjbJarImplPlugin.logWarning("Unable to set participant " + participantFQN + " for bean " + bean.getBeanClassName());
        }
    }

    private IEnterpriseBean findReferencedBean(EnterpriseBeanImpl bean) {
        IEnterpriseBean result = bean.getReferencedBean();
        if (this.isValidReferencedBean(bean, result)) {
            return result;
        }
        EjbProject[] ejbProjects = this.getAllEJBProjects();
        int i = 0;
        while (i < ejbProjects.length) {
            try {
                result = ejbProjects[i].getEnterpriseBean(bean.getEjbClass());
                if (this.isValidReferencedBean(bean, result)) {
                    return result;
                }
            }
            catch (EJBModelException e) {
                // empty catch block
            }
            ++i;
        }
        return null;
    }

    private boolean isValidReferencedBean(EnterpriseBeanImpl bean, IEnterpriseBean result) {
        if (result == null) {
            return false;
        }
        if (result.isImported()) {
            return false;
        }
        int kind = result.getKind();
        switch (kind) {
            case 1: {
                return bean instanceof EntityBeanImpl;
            }
            case 2: {
                return bean instanceof SessionBeanImpl;
            }
            case 4: {
                return bean instanceof MessageDrivenBeanImpl;
            }
        }
        return false;
    }

    private EjbProject[] getAllEJBProjects() {
        if (this.myAllEJBProjects == null) {
            ArrayList<EjbProject> result = new ArrayList<EjbProject>();
            IProject[] allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int i = 0;
            while (i < allProjects.length) {
                EjbProject next = EjbProject.getInstance((IProject)allProjects[i]);
                if (next != null) {
                    result.add(next);
                }
                ++i;
            }
            this.myAllEJBProjects = result.toArray(new EjbProject[result.size()]);
        }
        return this.myAllEJBProjects;
    }
}

