/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejbjar;

import com.tssap.j2ee.core.descriptor.AbstractJ2eeDescriptorProject;
import com.tssap.j2ee.core.descriptor.DescriptorDeltaListener;
import com.tssap.j2ee.core.descriptor.DescriptorEntity;
import com.tssap.j2ee.core.ejb.EjbProject;
import com.tssap.j2ee.core.ejbjar.EjbJar;
import com.tssap.j2ee.core.ejbjar.EjbJarProject;
import com.tssap.j2ee.core.utils.FileUtils;
import com.tssap.j2ee.internal.core.ejbjar.EjbJarImpl;
import com.tssap.j2ee.internal.core.ejbjar.EjbJarImplPlugin;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.util.UpdateCommand;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.IJavaProject;

public final class EjbJarProjectImpl
extends EjbJarProject {
    private Map myEjbJars = new HashMap();
    private IResourceChangeListener myResourceChangeListener;
    private IResourceDeltaVisitor myResourceDeltaVisitor;
    private static final String TEMPLATE_PATH = "templates/ejb-jar.xml";
    private static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final String EJB_JAR_DTD = "<!DOCTYPE ejb-jar PUBLIC \"-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN\" \"http://java.sun.com/dtd/ejb-jar_2_0.dtd\">";
    private static final String DEFAULT_TEMPLATE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE ejb-jar PUBLIC \"-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN\" \"http://java.sun.com/dtd/ejb-jar_2_0.dtd\"><ejb-jar></ejb-jar>";
    private static String ourTemplate;

    public void setProject(IProject project) {
        super.setProject(project);
        this.myEjbJars.clear();
        String fixedLocation = EjbJarProjectImpl.getFixedLocation();
        EjbJarImplPlugin.logInfo("Fixed location [" + fixedLocation + "]");
        if (fixedLocation != null) {
            IFile file = project.getFile(fixedLocation);
            if (file.exists()) {
                EjbJarImplPlugin.logInfo("Fixed descriptor file found [" + file.getFullPath() + "]");
                this.addEjbJar(file);
            }
        } else {
            try {
                IJavaProject javaProject = this.getJavaProject();
                final IPath output = javaProject == null ? null : javaProject.getOutputLocation();
                project.accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) {
                        IFolder folder;
                        if (!resource.isAccessible()) {
                            return false;
                        }
                        if (resource instanceof IFolder && output != null && output.equals((Object)(folder = (IFolder)resource).getFullPath())) {
                            return false;
                        }
                        if (resource instanceof IFile && "ejb-jar.xml".equals(resource.getName())) {
                            EjbJarImplPlugin.logInfo("Descriptor file found [" + resource.getFullPath() + "]");
                            EjbJarProjectImpl.this.addEjbJar((IFile)resource);
                        }
                        return true;
                    }
                });
            }
            catch (CoreException ce) {
                EjbJarImplPlugin.logError("Exception while reading descriptor files in the project [" + project + "]", ce);
            }
        }
    }

    protected EjbJar addEjbJar(IFile file) {
        EjbJarImpl ejbJar = (EjbJarImpl)((Object)this.myEjbJars.remove(EjbJarProjectImpl.getLocation(file)));
        if (!file.isAccessible()) {
            return null;
        }
        if (ejbJar == null) {
            ejbJar = new EjbJarImpl(file, this);
        } else {
            ejbJar.reload();
        }
        this.myEjbJars.put(EjbJarProjectImpl.getLocation(file), ejbJar);
        return ejbJar;
    }

    public EjbJar getEjbJar(IFile file) {
        EjbJarImpl ejbJar = (EjbJarImpl)((Object)this.myEjbJars.get(EjbJarProjectImpl.getLocation(file)));
        if (ejbJar == null) {
            return null;
        }
        if (ejbJar.isFileModified()) {
            ejbJar = (EjbJarImpl)this.addEjbJar(file);
        }
        return ejbJar;
    }

    public EjbJar[] getEjbJars() {
        if (this.myEjbJars.isEmpty()) {
            return null;
        }
        ArrayList ejbJars = new ArrayList(this.myEjbJars.values());
        int i = ejbJars.size() - 1;
        while (i >= 0) {
            EjbJarImpl ejbJar = (EjbJarImpl)((Object)ejbJars.get(i));
            if (ejbJar.isFileModified()) {
                this.addEjbJar(ejbJar.getFile());
            }
            --i;
        }
        ejbJars = new ArrayList(this.myEjbJars.values());
        return ejbJars.toArray(new EjbJar[ejbJars.size()]);
    }

    public boolean canCreateEjbJar(IFile file) {
        if (file.exists()) {
            return false;
        }
        IContainer folder = file.getParent();
        if (!folder.isAccessible() || folder.isReadOnly()) {
            return false;
        }
        EjbJar ejbJar = this.getEjbJar(file);
        return ejbJar == null;
    }

    public EjbJar createEjbJar(IFile file) {
        if (!this.canCreateEjbJar(file)) {
            throw new IllegalArgumentException();
        }
        ByteArrayInputStream source = new ByteArrayInputStream(this.getTemplate().getBytes());
        try {
            file.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException ce) {
            EjbJarImplPlugin.logError("Unable to create file [" + file + "]", ce);
            return null;
        }
        return this.addEjbJar(file);
    }

    public EjbProject[] getReferencedEjbProjects() {
        ArrayList ejbProjects = new ArrayList();
        this.addEjbProject(this.getProject(), ejbProjects);
        try {
            IProject[] projects = this.getProject().getReferencedProjects();
            if (projects != null && projects.length > 0) {
                int i = 0;
                while (i < projects.length) {
                    this.addEjbProject(projects[i], ejbProjects);
                    ++i;
                }
            }
        }
        catch (CoreException ce) {
            EjbJarImplPlugin.logError("Unable to retrieve referenced projects", ce);
        }
        return ejbProjects.toArray(new EjbProject[ejbProjects.size()]);
    }

    protected void addEjbProject(IProject project, Collection ejbProjects) {
        if (project == null || !project.isAccessible()) {
            return;
        }
        try {
            EjbProject ejbProject;
            if (project.hasNature("com.tssap.j2ee.core.ejb.ejbNature") && (ejbProject = EjbProject.getInstance((IProject)project)) != null) {
                ejbProjects.add(ejbProject);
            }
        }
        catch (CoreException ce) {
            EjbJarImplPlugin.logError("Unable to retrieve referenced ejb project for the [" + project + "]", ce);
        }
    }

    public void addDescriptorDeltaListener(DescriptorDeltaListener listener) {
        super.addDescriptorDeltaListener(listener);
        this.registerResourceChangeListener();
    }

    public void removeDescriptorDeltaListener(DescriptorDeltaListener listener) {
        super.removeDescriptorDeltaListener(listener);
        if (!this.hasDescriptorDeltaListeners()) {
            this.unregisterResourceChangeListener();
            this.myResourceChangeListener = null;
        }
    }

    private void fileAdded(IFile file) {
        EjbJar ejbJar = this.addEjbJar(file);
        if (ejbJar != null) {
            EjbJarImplPlugin.logInfo("Descriptor added [" + file + "]");
            this.descriptorEntityAdded((DescriptorEntity)ejbJar);
            this.clearDescriptorDeltaFired();
        }
    }

    private void fileRemoved(IFile file) {
        EjbJar cachedEjbJar = (EjbJar)this.myEjbJars.remove(EjbJarProjectImpl.getLocation(file));
        if (cachedEjbJar != null) {
            EjbJarImplPlugin.logInfo("Descriptor removed [" + file + "]");
            this.descriptorEntityRemoved((DescriptorEntity)cachedEjbJar);
            this.clearDescriptorDeltaFired();
        }
    }

    private void fileChanged(IFile file) {
        EjbJar cachedEjbJar = this.getEjbJar(file);
        EjbJar ejbJar = this.addEjbJar(file);
        if (cachedEjbJar != null) {
            if (ejbJar != null) {
                EjbJarImplPlugin.logInfo("Descriptor changed [" + file + "]");
                this.descriptorEntityTotallyChanged((DescriptorEntity)ejbJar);
                this.clearDescriptorDeltaFired();
            } else {
                EjbJarImplPlugin.logInfo("Descriptor removed [" + file + "], it became invalid");
                this.descriptorEntityRemoved((DescriptorEntity)cachedEjbJar);
                this.clearDescriptorDeltaFired();
            }
        } else if (ejbJar != null) {
            EjbJarImplPlugin.logInfo("Descriptor added [" + file + "], it was invalid before");
            this.descriptorEntityAdded((DescriptorEntity)ejbJar);
            this.clearDescriptorDeltaFired();
        }
    }

    private void registerResourceChangeListener() {
        this.myResourceChangeListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                IProject project = EjbJarProjectImpl.this.getProject();
                if (project == null || !project.isAccessible()) {
                    return;
                }
                if (1 == event.getType()) {
                    try {
                        if (EjbJarProjectImpl.this.myResourceDeltaVisitor == null) {
                            EjbJarProjectImpl.this.myResourceDeltaVisitor = new EjbJarResourceDeltaVisitor();
                            EjbJarImplPlugin.logInfo("Resource delta visitor instantiated");
                        }
                        event.getDelta().accept(EjbJarProjectImpl.this.myResourceDeltaVisitor);
                    }
                    catch (CoreException ce) {
                        EjbJarImplPlugin.logError("Exception while processing resource delta", ce);
                    }
                }
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.myResourceChangeListener);
        EjbJarImplPlugin.logInfo("Resource delta listener registered");
    }

    private void unregisterResourceChangeListener() {
        if (this.myResourceChangeListener == null) {
            return;
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.myResourceChangeListener);
        EjbJarImplPlugin.logInfo("Resource delta listener unregistered");
    }

    private static String getLocation(IFile file) {
        return file.getProjectRelativePath().toString();
    }

    protected String getTemplate() {
        if (ourTemplate == null) {
            ourTemplate = FileUtils.getFileContents((String)TEMPLATE_PATH, (String)DEFAULT_TEMPLATE, (Plugin)EjbJarImplPlugin.getDefault());
        }
        return ourTemplate;
    }

    protected String[] getRequiredLibraries() {
        return new String[0];
    }

    public static String getFixedLocation() {
        return AbstractJ2eeDescriptorProject.getFixedLocation((Plugin)EjbJarImplPlugin.getDefault());
    }

    static /* synthetic */ void access$500(EjbJarProjectImpl x0, IFile x1) {
        x0.fileAdded(x1);
    }

    static /* synthetic */ void access$600(EjbJarProjectImpl x0, IFile x1) {
        x0.fileChanged(x1);
    }

    static /* synthetic */ void access$700(EjbJarProjectImpl x0, IFile x1) {
        x0.fileRemoved(x1);
    }

    private class EjbJarResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        private final String myFixedLocation = EjbJarProjectImpl.getFixedLocation();

        private EjbJarResourceDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) {
            IResource resource = delta.getResource();
            if (resource instanceof IWorkspaceRoot) {
                return true;
            }
            if (!EjbJarProjectImpl.this.getProject().equals((Object)resource.getProject())) {
                return false;
            }
            if (this.myFixedLocation != null) {
                if (!(resource instanceof IFile)) {
                    return true;
                }
                IFile file = (IFile)resource;
                if (this.myFixedLocation.equals(file.getProjectRelativePath().toString())) {
                    this.process(delta);
                }
            } else {
                try {
                    IFolder folder;
                    IPath output;
                    IJavaProject javaProject = EjbJarProjectImpl.this.getJavaProject();
                    IPath iPath = output = javaProject == null ? null : javaProject.getOutputLocation();
                    if (resource instanceof IFolder && output != null && output.equals((Object)(folder = (IFolder)resource).getFullPath())) {
                        return false;
                    }
                }
                catch (CoreException ce) {
                    return false;
                }
                if (!(resource instanceof IFile)) {
                    return true;
                }
                IFile file = (IFile)resource;
                if (!"ejb-jar.xml".equals(file.getName())) {
                    return true;
                }
                this.process(delta);
            }
            return true;
        }

        private void process(IResourceDelta delta) {
            if (EjbJarProjectImpl.super.isDescriptorDeltaFired()) {
                EjbJarProjectImpl.super.clearDescriptorDeltaFired();
                return;
            }
            int kind = delta.getKind();
            IFile file = (IFile)delta.getResource();
            ModelAccess.runCommandLater((Runnable)new UpdateCommand(this, kind, file){
                private final /* synthetic */ int val$kind;
                private final /* synthetic */ IFile val$file;
                private final /* synthetic */ EjbJarResourceDeltaVisitor this$1;
                {
                    this.this$1 = this$1;
                    this.val$kind = val$kind;
                    this.val$file = val$file;
                }

                public void run() {
                    if ((this.val$kind & 1) > 0) {
                        EjbJarProjectImpl.access$500(EjbJarResourceDeltaVisitor.access$400(this.this$1), this.val$file);
                    } else if ((this.val$kind & 4) > 0) {
                        EjbJarProjectImpl.access$600(EjbJarResourceDeltaVisitor.access$400(this.this$1), this.val$file);
                    } else if ((this.val$kind & 2) > 0) {
                        EjbJarProjectImpl.access$700(EjbJarResourceDeltaVisitor.access$400(this.this$1), this.val$file);
                    }
                }
            });
        }

        static /* synthetic */ EjbJarProjectImpl access$400(EjbJarResourceDeltaVisitor x0) {
            return x0.EjbJarProjectImpl.this;
        }
    }
}

