/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejbjar;

import com.tssap.j2ee.core.descriptor.AccessibleBean;
import com.tssap.j2ee.core.descriptor.DescriptorDeltaListener;
import com.tssap.j2ee.core.descriptor.DescriptorEntity;
import com.tssap.j2ee.core.descriptor.EnterpriseBean;
import com.tssap.j2ee.core.ejb.EJBModelException;
import com.tssap.j2ee.core.ejb.EjbProject;
import com.tssap.j2ee.core.ejb.IEnterpriseBean;
import com.tssap.j2ee.core.ejbjar.AssemblyDescriptor;
import com.tssap.j2ee.core.ejbjar.EjbJar;
import com.tssap.j2ee.core.ejbjar.EjbJarMetaInfo;
import com.tssap.j2ee.core.ejbjar.EjbJarProject;
import com.tssap.j2ee.core.ejbjar.EjbRelation;
import com.tssap.j2ee.core.ejbjar.EjbRelationshipRole;
import com.tssap.j2ee.core.ejbjar.EntityBean;
import com.tssap.j2ee.core.ejbjar.MessageDrivenBean;
import com.tssap.j2ee.core.ejbjar.SessionBean;
import com.tssap.j2ee.core.ejbjar.context.AccessibleBeanContext;
import com.tssap.j2ee.core.ejbjar.context.EntityBeanContext;
import com.tssap.j2ee.core.ejbjar.context.MessageDrivenBeanContext;
import com.tssap.j2ee.core.ejbjar.context.PersistentFieldContext;
import com.tssap.j2ee.core.ejbjar.context.SessionBeanContext;
import com.tssap.j2ee.core.ejbjar.namegen.EjbRelationNameGen;
import com.tssap.j2ee.core.utils.FileUtils;
import com.tssap.j2ee.core.utils.NumericComparator;
import com.tssap.j2ee.internal.core.descriptor.DescriptorDocumentImpl;
import com.tssap.j2ee.internal.core.descriptor.DescriptorEntityImpl;
import com.tssap.j2ee.internal.core.ejbjar.AssemblyDescriptorImpl;
import com.tssap.j2ee.internal.core.ejbjar.EjbJarChildOrder;
import com.tssap.j2ee.internal.core.ejbjar.EjbJarImplPlugin;
import com.tssap.j2ee.internal.core.ejbjar.EjbJarProjectImpl;
import com.tssap.j2ee.internal.core.ejbjar.EjbRelationImpl;
import com.tssap.j2ee.internal.core.ejbjar.EntityBeanImpl;
import com.tssap.j2ee.internal.core.ejbjar.ForwardEngineering;
import com.tssap.j2ee.internal.core.ejbjar.MessageDrivenBeanImpl;
import com.tssap.j2ee.internal.core.ejbjar.SessionBeanImpl;
import com.tssap.j2ee.internal.core.util.DomUtils;
import com.tssap.selena.model.elements.ModelAccess;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.w3c.dom.Element;

public final class EjbJarImpl
extends DescriptorDocumentImpl
implements EjbJar {
    public static final String PUBLIC_ID = "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN";
    public static final String SYSTEM_ID = "http://java.sun.com/dtd/ejb-jar_2_0.dtd";
    private static final String DTD_PATH = "templates/ejb-jar_2_0.dtd";
    private static String ourDtd;
    private AssemblyDescriptor myAssemblyDescriptor;
    private Map myEjbRelations;
    private EjbRelationNameGen myEjbRelationNameGen = new EjbRelationNameGen((EjbJar)this);
    private Map myEntityBeans;
    private Map mySessionBeans;
    private Map myMessageDrivenBeans;
    private EjbJarProjectImpl myProject;

    public EjbJarImpl(IFile file, EjbJarProjectImpl project) {
        super(file, (DescriptorDeltaListener)project);
        this.myProject = project;
        if (this.isRecognized()) {
            this.myAssemblyDescriptor = new AssemblyDescriptorImpl(this, this.getElement());
        }
    }

    public String toString() {
        return "EjbJar \"" + this.getDisplayName() + "\"";
    }

    public void delete() {
        try {
            this.getFile().delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException ce) {
            EjbJarImplPlugin.logError("Unable to delete file [" + this.getFile() + "]", ce);
        }
    }

    public String getSpecVersion() {
        return "2.0";
    }

    public String getDescription() {
        if (!this.isRecognized()) {
            return null;
        }
        return DomUtils.getChildTextNodeValue((Element)this.getElement(), (String)"description");
    }

    public boolean canSetDescription(String description) {
        return this.isRecognized();
    }

    public void setDescription(String description) {
        if (!this.canSetDescription(description)) {
            throw new IllegalArgumentException(description);
        }
        if (DescriptorEntityImpl.equals((Object)this.getDescription(), (Object)description)) {
            return;
        }
        if (!this.edit(null)) {
            return;
        }
        DomUtils.setChildTextNodeValue((Element)this.getElement(), (String[])EjbJarChildOrder.EJB_JAR, (String)"description", (String)description);
        this.changed((DescriptorEntity)this);
    }

    public String getClientJar() {
        if (!this.isRecognized()) {
            return null;
        }
        return DomUtils.getChildTextNodeValue((Element)this.getElement(), (String)"ejb-client-jar");
    }

    public boolean canSetClientJar(String clientJar) {
        return this.isRecognized();
    }

    public void setClientJar(String clientJar) {
        if (!this.canSetClientJar(clientJar)) {
            throw new IllegalArgumentException(clientJar);
        }
        if (DescriptorEntityImpl.equals((Object)this.getClientJar(), (Object)clientJar)) {
            return;
        }
        if (!this.edit(null)) {
            return;
        }
        DomUtils.setChildTextNodeValue((Element)this.getElement(), (String[])EjbJarChildOrder.EJB_JAR, (String)"ejb-client-jar", (String)clientJar);
        this.changed((DescriptorEntity)this);
    }

    public String getDisplayName() {
        if (!this.isRecognized()) {
            return null;
        }
        return DomUtils.getChildTextNodeValue((Element)this.getElement(), (String)"display-name");
    }

    public boolean canSetDisplayName(String name) {
        return this.isRecognized();
    }

    public void setDisplayName(String displayName) {
        if (!this.canSetDisplayName(displayName)) {
            throw new IllegalArgumentException(displayName);
        }
        if (DescriptorEntityImpl.equals((Object)this.getDisplayName(), (Object)displayName)) {
            return;
        }
        if (!this.edit(null)) {
            return;
        }
        DomUtils.setChildTextNodeValue((Element)this.getElement(), (String[])EjbJarChildOrder.EJB_JAR, (String)"display-name", (String)displayName);
        this.changed((DescriptorEntity)this);
    }

    public String getSmallIcon() {
        if (!this.isRecognized()) {
            return null;
        }
        return DomUtils.getChildTextNodeValue((Element)this.getElement(), (String)"small-icon");
    }

    public boolean canSetSmallIcon(String name) {
        return this.isRecognized();
    }

    public void setSmallIcon(String iconName) {
        if (!this.canSetSmallIcon(iconName)) {
            throw new IllegalArgumentException(iconName);
        }
        if (DescriptorEntityImpl.equals((Object)this.getSmallIcon(), (Object)iconName)) {
            return;
        }
        if (!this.edit(null)) {
            return;
        }
        DomUtils.setChildTextNodeValue((Element)this.getElement(), (String[])EjbJarChildOrder.EJB_JAR, (String)"small-icon", (String)iconName);
        this.changed((DescriptorEntity)this);
    }

    public String getLargeIcon() {
        if (!this.isRecognized()) {
            return null;
        }
        return DomUtils.getChildTextNodeValue((Element)this.getElement(), (String)"large-icon");
    }

    public boolean canSetLargeIcon(String name) {
        return this.isRecognized();
    }

    public void setLargeIcon(String iconName) {
        if (!this.canSetLargeIcon(iconName)) {
            throw new IllegalArgumentException(iconName);
        }
        if (DescriptorEntityImpl.equals((Object)this.getLargeIcon(), (Object)iconName)) {
            return;
        }
        if (!this.edit(null)) {
            return;
        }
        DomUtils.setChildTextNodeValue((Element)this.getElement(), (String[])EjbJarChildOrder.EJB_JAR, (String)"large-icon", (String)iconName);
        this.changed((DescriptorEntity)this);
    }

    public AssemblyDescriptor getAssemblyDescriptor() {
        return this.myAssemblyDescriptor;
    }

    protected Element getRelationsElement(boolean create) {
        Element relationships = DomUtils.getChildElement((Element)this.getElement(), (String)"relationships");
        if (relationships == null && create) {
            relationships = DomUtils.createChildElement((Element)this.getElement(), (String[])EjbJarChildOrder.EJB_JAR, (String)"relationships");
        }
        return relationships;
    }

    public String getRelationsDescription() {
        if (!this.isRecognized()) {
            return null;
        }
        Element relationships = this.getRelationsElement(false);
        if (relationships == null) {
            return null;
        }
        return DomUtils.getChildTextNodeValue((Element)relationships, (String)"description");
    }

    public boolean canSetRelationsDescription(String description) {
        return this.isRecognized();
    }

    public void setRelationsDescription(String description) {
        if (!this.canSetRelationsDescription(description)) {
            throw new IllegalArgumentException(description);
        }
        if (DescriptorEntityImpl.equals((Object)description, (Object)this.getDescription())) {
            return;
        }
        if (!this.edit(null)) {
            return;
        }
        Element relationships = this.getRelationsElement(true);
        DomUtils.setChildTextNodeValue((Element)relationships, (String[])EjbJarChildOrder.RELATIONSHIPS, (String)"description", (String)description);
        DomUtils.removeIfEmpty((Element)relationships);
        this.changed((DescriptorEntity)this);
    }

    private boolean isValidEjbRelationshipRole(EjbRelationshipRole role) {
        String multiplicity = role.getMultiplicity();
        if (!EjbJarMetaInfo.isValidMultiplicity((String)multiplicity)) {
            return false;
        }
        String sourceEjbName = role.getSourceEjbName();
        if (sourceEjbName == null || sourceEjbName.trim().length() == 0) {
            return false;
        }
        String cmrFieldName = role.getCmrFieldName();
        String cmrFieldType = role.getCmrFieldType();
        if (cmrFieldName != null) {
            if (cmrFieldName.trim().length() == 0) {
                return false;
            }
            if (!EjbJarMetaInfo.isValidCmrFieldType((String)cmrFieldType)) {
                return false;
            }
        }
        return true;
    }

    private boolean isCascadeDeleteValid(EjbRelationshipRole role1, EjbRelationshipRole role2) {
        if (!role1.isCascadeDelete()) {
            return true;
        }
        return "One".equals(role2.getMultiplicity());
    }

    boolean isEjbRelationExists(String name) {
        return this.myEjbRelationNameGen.exists(name);
    }

    protected void readEjbRelations() {
        if (this.myEjbRelations == null) {
            this.myEjbRelations = new HashMap();
            Element relationships = this.getRelationsElement(false);
            if (relationships != null) {
                Element[] relations = DomUtils.getChildElements((Element)relationships, (String)"ejb-relation");
                int i = 0;
                while (i < relations.length) {
                    EjbRelationshipRole role2;
                    EjbRelationshipRole role1;
                    EjbRelationImpl relation = new EjbRelationImpl(this, relations[i], String.valueOf(i));
                    String name = relation.getRelationName();
                    if (!this.isEjbRelationExists(name) && (role1 = relation.getRole1()) != null && this.isValidEjbRelationshipRole(role1) && (role2 = relation.getRole2()) != null && this.isValidEjbRelationshipRole(role2)) {
                        String role1Name = role1.getName();
                        String role2Name = role2.getName();
                        if ((role1Name == null || role2Name == null || !role1Name.equals(role2Name)) && this.isCascadeDeleteValid(role1, role2) && this.isCascadeDeleteValid(role2, role1)) {
                            this.myEjbRelations.put(relation.getSyntheticName(), relation);
                        }
                    }
                    ++i;
                }
            }
        }
    }

    protected void updateEjbRelation(String syntheticName) {
        if (this.myEjbRelations == null) {
            return;
        }
        EjbRelation relation = (EjbRelation)this.myEjbRelations.remove(syntheticName);
        if (relation != null && relation.isValid()) {
            this.myEjbRelations.put(relation.getSyntheticName(), relation);
        } else {
            try {
                this.updateEjbRelationsSyntheticNames(syntheticName);
            }
            catch (NumberFormatException nfe) {
                EjbJarImplPlugin.logError("Unable to update ejb relations synthetic names", nfe);
            }
        }
        if (!this.myEjbRelations.isEmpty()) {
            return;
        }
        Element relations = this.getRelationsElement(false);
        if (relations == null) {
            return;
        }
        Element[] children = DomUtils.getChildElements((Element)relations, (String)"ejb-relation");
        if (children == null || children.length == 0) {
            DomUtils.removeElement((Element)relations);
        }
    }

    private void updateEjbRelationsSyntheticNames(String syntheticName) throws NumberFormatException {
        int stale = Integer.parseInt(syntheticName);
        ArrayList names = new ArrayList(this.myEjbRelations.keySet());
        Collections.sort(names, NumericComparator.getInstance());
        int i = 0;
        while (i < names.size()) {
            syntheticName = String.valueOf(names.get(i));
            int current = Integer.parseInt(syntheticName);
            if (current > stale) {
                EjbRelationImpl currentRelation = (EjbRelationImpl)((Object)this.myEjbRelations.remove(syntheticName));
                if (currentRelation == null) {
                    EjbJarImplPlugin.logWarning("No ejb relation is associated with the synthetic name " + syntheticName);
                }
                syntheticName = String.valueOf(--current);
                this.myEjbRelations.put(syntheticName, currentRelation);
                currentRelation.setSyntheticName(syntheticName);
            }
            ++i;
        }
    }

    public EjbRelation[] getEjbRelations() {
        if (!this.isRecognized()) {
            return null;
        }
        this.readEjbRelations();
        if (this.myEjbRelations.isEmpty()) {
            return null;
        }
        Collection relations = this.myEjbRelations.values();
        return relations.toArray(new EjbRelation[relations.size()]);
    }

    public EjbRelation getEjbRelation(String name) {
        if (!this.isRecognized()) {
            return null;
        }
        this.readEjbRelations();
        return (EjbRelation)this.myEjbRelations.get(name);
    }

    private boolean canCreateEjbRelationshipRole(EjbRelationshipRole roleTemplate, boolean source) {
        if (!EjbJarMetaInfo.isValidMultiplicity((String)roleTemplate.getMultiplicity())) {
            return false;
        }
        String sourceEjbName = roleTemplate.getSourceEjbName();
        if (sourceEjbName == null || sourceEjbName.trim().length() == 0) {
            return false;
        }
        String cmrFieldName = roleTemplate.getCmrFieldName();
        String cmrFieldType = roleTemplate.getCmrFieldType();
        String cmrFieldDescription = roleTemplate.getCmrFieldDescription();
        if (cmrFieldName != null) {
            if (this.isCmrFieldExists(sourceEjbName, cmrFieldName)) {
                return false;
            }
            if (cmrFieldName.trim().length() == 0) {
                return false;
            }
            if (!EjbJarMetaInfo.isValidCmrFieldType((String)cmrFieldType)) {
                return false;
            }
        } else {
            if (cmrFieldType != null) {
                return false;
            }
            if (cmrFieldDescription != null) {
                return false;
            }
        }
        return true;
    }

    public boolean canCreateEjbRelation(String name, String description, EjbRelationshipRole role1Template, EjbRelationshipRole role2Template) {
        if (!this.isRecognized()) {
            return false;
        }
        this.readEjbRelations();
        if (name != null && this.isEjbRelationExists(name)) {
            return false;
        }
        if (role1Template == null || !this.canCreateEjbRelationshipRole(role1Template, true)) {
            return false;
        }
        if (role2Template == null || !this.canCreateEjbRelationshipRole(role2Template, false)) {
            return false;
        }
        String role1Name = role1Template.getName();
        String role2Name = role2Template.getName();
        if (role1Name != null && role2Name != null && role1Name.equals(role2Name)) {
            return false;
        }
        return this.isCascadeDeleteValid(role1Template, role2Template) && this.isCascadeDeleteValid(role2Template, role1Template);
    }

    private void createEjbRelationshipRole(Element relationElement, EjbRelationshipRole roleTemplate) {
        String cmrFieldName;
        String description;
        Element roleElement = DomUtils.createChildElement((Element)relationElement, (String[])EjbJarChildOrder.EJB_RELATION, (String)"ejb-relationship-role");
        String name = roleTemplate.getName();
        if (name != null) {
            DomUtils.setChildTextNodeValue((Element)roleElement, (String[])EjbJarChildOrder.EJB_RELATIONSHIP_ROLE, (String)"ejb-relationship-role-name", (String)name);
        }
        if ((description = roleTemplate.getDescription()) != null) {
            DomUtils.setChildTextNodeValue((Element)roleElement, (String[])EjbJarChildOrder.EJB_RELATIONSHIP_ROLE, (String)"description", (String)description);
        }
        DomUtils.setChildTextNodeValue((Element)roleElement, (String[])EjbJarChildOrder.EJB_RELATIONSHIP_ROLE, (String)"multiplicity", (String)roleTemplate.getMultiplicity());
        if (roleTemplate.isCascadeDelete()) {
            DomUtils.createChildElement((Element)roleElement, (String[])EjbJarChildOrder.EJB_RELATIONSHIP_ROLE, (String)"cascade-delete");
        }
        Element sourceElement = DomUtils.createChildElement((Element)roleElement, (String[])EjbJarChildOrder.EJB_RELATIONSHIP_ROLE, (String)"relationship-role-source");
        DomUtils.setChildTextNodeValue((Element)sourceElement, (String[])EjbJarChildOrder.RELATIONSHIP_ROLE_SOURCE, (String)"ejb-name", (String)roleTemplate.getSourceEjbName());
        String sourceDescription = roleTemplate.getSourceDescription();
        if (sourceDescription != null) {
            DomUtils.setChildTextNodeValue((Element)sourceElement, (String[])EjbJarChildOrder.RELATIONSHIP_ROLE_SOURCE, (String)"description", (String)sourceDescription);
        }
        if ((cmrFieldName = roleTemplate.getCmrFieldName()) != null) {
            String cmrFieldDescription;
            Element cmrFieldElement = DomUtils.createChildElement((Element)roleElement, (String[])EjbJarChildOrder.EJB_RELATIONSHIP_ROLE, (String)"cmr-field");
            DomUtils.setChildTextNodeValue((Element)cmrFieldElement, (String[])EjbJarChildOrder.CMR_FIELD, (String)"cmr-field-name", (String)cmrFieldName);
            String cmrFieldType = roleTemplate.getCmrFieldType();
            if (cmrFieldType != null) {
                DomUtils.setChildTextNodeValue((Element)cmrFieldElement, (String[])EjbJarChildOrder.CMR_FIELD, (String)"cmr-field-type", (String)cmrFieldType);
            }
            if ((cmrFieldDescription = roleTemplate.getCmrFieldDescription()) != null) {
                DomUtils.setChildTextNodeValue((Element)cmrFieldElement, (String[])EjbJarChildOrder.CMR_FIELD, (String)"description", (String)cmrFieldDescription);
            }
        }
    }

    public EjbRelation createEjbRelation(String name, String description, EjbRelationshipRole role1Template, EjbRelationshipRole role2Template) {
        if (!this.canCreateEjbRelation(name, description, role1Template, role2Template)) {
            throw new IllegalArgumentException();
        }
        if (!this.edit(null)) {
            return null;
        }
        Element relations = this.getRelationsElement(true);
        Element relationElement = DomUtils.createChildElement((Element)relations, (String[])EjbJarChildOrder.RELATIONSHIPS, (String)"ejb-relation");
        if (name != null) {
            DomUtils.setChildTextNodeValue((Element)relationElement, (String[])EjbJarChildOrder.EJB_RELATION, (String)"ejb-relation-name", (String)name);
        }
        if (description != null) {
            DomUtils.setChildTextNodeValue((Element)relationElement, (String[])EjbJarChildOrder.EJB_RELATION, (String)"description", (String)description);
        }
        this.createEjbRelationshipRole(relationElement, role1Template);
        this.createEjbRelationshipRole(relationElement, role2Template);
        EjbRelationImpl relation = new EjbRelationImpl(this, relationElement, String.valueOf(this.myEjbRelations.size()));
        this.myEjbRelations.put(relation.getSyntheticName(), relation);
        this.added((DescriptorEntity)relation);
        return relation;
    }

    public boolean isCmrFieldExists(String ejbName, String cmrFieldName) {
        EjbRelation[] relations = this.getEjbRelations();
        if (relations == null) {
            return false;
        }
        int i = 0;
        while (i < relations.length) {
            EjbRelation relation = relations[i];
            if (DescriptorEntityImpl.equals((Object)ejbName, (Object)relation.getRole1().getSourceEjbName()) && DescriptorEntityImpl.equals((Object)cmrFieldName, (Object)relation.getRole1().getCmrFieldName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Element getEjbs(boolean create) {
        Element descriptor = DomUtils.getChildElement((Element)this.getElement(), (String)"enterprise-beans");
        if (descriptor == null && create) {
            descriptor = DomUtils.createChildElement((Element)this.getElement(), (String[])EjbJarChildOrder.EJB_JAR, (String)"enterprise-beans");
        }
        return descriptor;
    }

    protected void readEntityBeans() {
        if (this.myEntityBeans == null) {
            this.myEntityBeans = new HashMap();
            Element ejbs = this.getEjbs(false);
            if (ejbs != null) {
                Element[] beans = DomUtils.getChildElements((Element)ejbs, (String)"entity");
                int i = 0;
                while (i < beans.length) {
                    EntityBeanImpl bean = new EntityBeanImpl(this, beans[i]);
                    this.myEntityBeans.put(bean.getName(), bean);
                    ++i;
                }
            }
        }
    }

    protected void updateEntityBean(String name) {
        EntityBean bean;
        if (this.myEntityBeans != null && (bean = (EntityBean)this.myEntityBeans.remove(name)) != null && bean.isValid()) {
            this.myEntityBeans.put(bean.getName(), bean);
        }
    }

    public EntityBean[] getEntityBeans() {
        if (!this.isRecognized()) {
            return null;
        }
        this.readEntityBeans();
        if (this.myEntityBeans.isEmpty()) {
            return null;
        }
        Collection beans = this.myEntityBeans.values();
        return beans.toArray(new EntityBean[beans.size()]);
    }

    public EntityBean getEntityBean(String name) {
        if (!this.isRecognized()) {
            return null;
        }
        this.readEntityBeans();
        return (EntityBean)this.myEntityBeans.get(name);
    }

    public boolean canCreateEntityBean(EntityBeanContext context, Boolean local) {
        if (!this.isRecognized()) {
            return false;
        }
        this.readEntityBeans();
        String name = context.getName();
        return !DescriptorEntityImpl.isNull((String)name) && this.getEnterpriseBean(name) == null;
    }

    public EntityBean createEntityBean(final EntityBeanContext context, final Boolean local) {
        if (!this.canCreateEntityBean(context, local)) {
            throw new IllegalArgumentException();
        }
        if (!this.edit(null)) {
            return null;
        }
        final EntityBean[] entityHolder = new EntityBean[1];
        this.modify(new Runnable(){
            static /* synthetic */ Class class$java$lang$Object;

            public void run() {
                Element ejbs = EjbJarImpl.this.getEjbs(true);
                Element ejb = DomUtils.createChildElement((Element)ejbs, (String[])EjbJarChildOrder.ENTERPRISE_BEANS, (String)"entity");
                String name = context.getName();
                EjbJarImpl.this.writeEjbNameAndClass(ejb, EjbJarChildOrder.ENTITY, name, context.getEjbClass());
                EjbJarImpl.this.writeParticipants(ejb, EjbJarChildOrder.ENTITY, (AccessibleBeanContext)context, local);
                String primaryKeyClass = context.getPrimaryKeyClass();
                if (DescriptorEntityImpl.isNull((String)primaryKeyClass)) {
                    primaryKeyClass = (class$java$lang$Object == null ? (class$java$lang$Object = 1.class$("java.lang.Object")) : class$java$lang$Object).getName();
                }
                DomUtils.setChildTextNodeValue((Element)ejb, (String[])EjbJarChildOrder.ENTITY, (String)"prim-key-class", (String)primaryKeyClass);
                String persistenceType = context.getPersistenceType();
                if (!"Bean".equals(persistenceType)) {
                    persistenceType = "Container";
                    boolean isSimplePK = context.isPrimaryKeySimple();
                    PersistentFieldContext[] fields = context.getFields();
                    if (fields != null && fields.length > 0) {
                        int i = 0;
                        while (i < fields.length) {
                            PersistentFieldContext field = fields[i];
                            if (!field.isRelation()) {
                                if (isSimplePK && field.isInPrimaryKey()) {
                                    DomUtils.setChildTextNodeValue((Element)ejb, (String[])EjbJarChildOrder.ENTITY, (String)"primkey-field", (String)field.getName());
                                }
                                Element fieldElement = DomUtils.createChildElement((Element)ejb, (String[])EjbJarChildOrder.ENTITY, (String)"cmp-field");
                                DomUtils.createChildTextNode((Element)fieldElement, (String[])EjbJarChildOrder.CMP_FIELD, (String)"field-name").setNodeValue(field.getName());
                            }
                            ++i;
                        }
                    }
                }
                DomUtils.setChildTextNodeValue((Element)ejb, (String[])EjbJarChildOrder.ENTITY, (String)"persistence-type", (String)persistenceType);
                DomUtils.setChildTextNodeValue((Element)ejb, (String[])EjbJarChildOrder.ENTITY, (String)"reentrant", (String)EjbJarMetaInfo.toString1((boolean)context.isReentrant()));
                EntityBeanImpl entity = new EntityBeanImpl(EjbJarImpl.this, ejb);
                EjbJarImpl.this.myEntityBeans.put(name, entity);
                EjbJarImpl.this.added((DescriptorEntity)entity);
                context.applyDdps((EjbJar)EjbJarImpl.this, (DescriptorEntity)entity, (Object)ejb);
                entityHolder[0] = entity;
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        });
        return entityHolder[0];
    }

    protected void readSessionBeans() {
        if (this.mySessionBeans == null) {
            this.mySessionBeans = new HashMap();
            Element ejbs = this.getEjbs(false);
            if (ejbs != null) {
                Element[] beans = DomUtils.getChildElements((Element)ejbs, (String)"session");
                int i = 0;
                while (i < beans.length) {
                    SessionBeanImpl bean = new SessionBeanImpl(this, beans[i]);
                    this.mySessionBeans.put(bean.getName(), bean);
                    ++i;
                }
            }
        }
    }

    protected void updateSessionBean(String name) {
        SessionBean bean;
        if (this.mySessionBeans != null && (bean = (SessionBean)this.mySessionBeans.remove(name)) != null && bean.isValid()) {
            this.mySessionBeans.put(bean.getName(), bean);
        }
    }

    public SessionBean[] getSessionBeans() {
        if (!this.isRecognized()) {
            return null;
        }
        this.readSessionBeans();
        if (this.mySessionBeans.isEmpty()) {
            return null;
        }
        Collection beans = this.mySessionBeans.values();
        return beans.toArray(new SessionBean[beans.size()]);
    }

    public SessionBean getSessionBean(String name) {
        if (!this.isRecognized()) {
            return null;
        }
        this.readSessionBeans();
        return (SessionBean)this.mySessionBeans.get(name);
    }

    public boolean canCreateSessionBean(SessionBeanContext context, Boolean local) {
        if (!this.isRecognized()) {
            return false;
        }
        this.readSessionBeans();
        String name = context.getName();
        return context != null && !DescriptorEntityImpl.isNull((String)name) && this.getEnterpriseBean(name) == null;
    }

    public SessionBean createSessionBean(final SessionBeanContext context, final Boolean local) {
        if (!this.canCreateSessionBean(context, local)) {
            throw new IllegalArgumentException();
        }
        if (!this.edit(null)) {
            return null;
        }
        final SessionBean[] sessionHolder = new SessionBean[1];
        this.modify(new Runnable(){

            public void run() {
                Element ejbs = EjbJarImpl.this.getEjbs(true);
                Element ejb = DomUtils.createChildElement((Element)ejbs, (String[])EjbJarChildOrder.ENTERPRISE_BEANS, (String)"session");
                String name = context.getName();
                EjbJarImpl.this.writeEjbNameAndClass(ejb, EjbJarChildOrder.SESSION, name, context.getEjbClass());
                EjbJarImpl.this.writeParticipants(ejb, EjbJarChildOrder.SESSION, (AccessibleBeanContext)context, local);
                String sessionType = context.getSessionType();
                if (!"Stateful".equals(sessionType)) {
                    sessionType = "Stateless";
                }
                DomUtils.setChildTextNodeValue((Element)ejb, (String[])EjbJarChildOrder.SESSION, (String)"session-type", (String)sessionType);
                String transactionType = context.getTransactionType();
                if (!"Bean".equals(transactionType)) {
                    transactionType = "Container";
                }
                DomUtils.setChildTextNodeValue((Element)ejb, (String[])EjbJarChildOrder.SESSION, (String)"transaction-type", (String)transactionType);
                SessionBeanImpl session = new SessionBeanImpl(EjbJarImpl.this, ejb);
                EjbJarImpl.this.mySessionBeans.put(name, session);
                EjbJarImpl.this.added((DescriptorEntity)session);
                context.applyDdps((EjbJar)EjbJarImpl.this, (DescriptorEntity)session, (Object)ejb);
                sessionHolder[0] = session;
            }
        });
        return sessionHolder[0];
    }

    protected void readMessageDrivenBeans() {
        if (this.myMessageDrivenBeans == null) {
            this.myMessageDrivenBeans = new HashMap();
            Element ejbs = this.getEjbs(false);
            if (ejbs != null) {
                Element[] beans = DomUtils.getChildElements((Element)ejbs, (String)"message-driven");
                int i = 0;
                while (i < beans.length) {
                    MessageDrivenBeanImpl bean = new MessageDrivenBeanImpl(this, beans[i]);
                    this.myMessageDrivenBeans.put(bean.getName(), bean);
                    ++i;
                }
            }
        }
    }

    protected void updateMessageDrivenBean(String name) {
        MessageDrivenBean bean;
        if (this.myMessageDrivenBeans != null && (bean = (MessageDrivenBean)this.myMessageDrivenBeans.remove(name)) != null && bean.isValid()) {
            this.myMessageDrivenBeans.put(bean.getName(), bean);
        }
    }

    public MessageDrivenBean[] getMessageDrivenBeans() {
        if (!this.isRecognized()) {
            return null;
        }
        this.readMessageDrivenBeans();
        if (this.myMessageDrivenBeans.isEmpty()) {
            return null;
        }
        Collection beans = this.myMessageDrivenBeans.values();
        return beans.toArray(new MessageDrivenBean[beans.size()]);
    }

    public MessageDrivenBean getMessageDrivenBean(String name) {
        if (!this.isRecognized()) {
            return null;
        }
        this.readMessageDrivenBeans();
        return (MessageDrivenBean)this.myMessageDrivenBeans.get(name);
    }

    public boolean canCreateMessageDrivenBean(MessageDrivenBeanContext context) {
        if (!this.isRecognized()) {
            return false;
        }
        this.readMessageDrivenBeans();
        String name = context.getName();
        return context != null && !DescriptorEntityImpl.isNull((String)name) && this.getEnterpriseBean(name) == null;
    }

    public MessageDrivenBean createMessageDrivenBean(final MessageDrivenBeanContext context) {
        if (!this.canCreateMessageDrivenBean(context)) {
            throw new IllegalArgumentException();
        }
        if (!this.edit(null)) {
            return null;
        }
        final MessageDrivenBean[] mdbHolder = new MessageDrivenBean[1];
        this.modify(new Runnable(){

            public void run() {
                Element ejbs = EjbJarImpl.this.getEjbs(true);
                Element ejb = DomUtils.createChildElement((Element)ejbs, (String[])EjbJarChildOrder.ENTERPRISE_BEANS, (String)"message-driven");
                String name = context.getName();
                EjbJarImpl.this.writeEjbNameAndClass(ejb, EjbJarChildOrder.MESSAGE_DRIVEN, name, context.getEjbClass());
                String transactionType = context.getTransactionType();
                if (!"Bean".equals(transactionType)) {
                    transactionType = "Container";
                }
                DomUtils.setChildTextNodeValue((Element)ejb, (String[])EjbJarChildOrder.MESSAGE_DRIVEN, (String)"transaction-type", (String)transactionType);
                MessageDrivenBeanImpl mdb = new MessageDrivenBeanImpl(EjbJarImpl.this, ejb);
                EjbJarImpl.this.myMessageDrivenBeans.put(name, mdb);
                EjbJarImpl.this.added((DescriptorEntity)mdb);
                context.applyDdps((EjbJar)EjbJarImpl.this, (DescriptorEntity)mdb, (Object)ejb);
                mdbHolder[0] = mdb;
            }
        });
        return mdbHolder[0];
    }

    protected void readEnterpriseBeans() {
        this.readEntityBeans();
        this.readSessionBeans();
        this.readMessageDrivenBeans();
    }

    public EnterpriseBean[] getEnterpriseBeans() {
        if (!this.isRecognized()) {
            return null;
        }
        this.readEnterpriseBeans();
        int size = this.myEntityBeans.size() + this.mySessionBeans.size() + this.myMessageDrivenBeans.size();
        if (size == 0) {
            return null;
        }
        ArrayList beans = new ArrayList(size);
        beans.addAll(this.myEntityBeans.values());
        beans.addAll(this.mySessionBeans.values());
        beans.addAll(this.myMessageDrivenBeans.values());
        return beans.toArray(new EnterpriseBean[beans.size()]);
    }

    public EnterpriseBean getEnterpriseBean(String name) {
        if (!this.isRecognized()) {
            return null;
        }
        this.readEnterpriseBeans();
        EnterpriseBean bean = (EnterpriseBean)this.myEntityBeans.get(name);
        if (bean != null) {
            return bean;
        }
        bean = (EnterpriseBean)this.mySessionBeans.get(name);
        if (bean != null) {
            return bean;
        }
        return (EnterpriseBean)this.myMessageDrivenBeans.get(name);
    }

    public AccessibleBean[] getAccessibleBeans() {
        if (!this.isRecognized()) {
            return null;
        }
        this.readEnterpriseBeans();
        int size = this.myEntityBeans.size() + this.mySessionBeans.size();
        if (size == 0) {
            return null;
        }
        ArrayList beans = new ArrayList(size);
        beans.addAll(this.myEntityBeans.values());
        beans.addAll(this.mySessionBeans.values());
        return beans.toArray(new AccessibleBean[beans.size()]);
    }

    public AccessibleBean getAccessibleBean(String name) {
        if (!this.isRecognized()) {
            return null;
        }
        this.readEnterpriseBeans();
        AccessibleBean bean = (AccessibleBean)this.myEntityBeans.get(name);
        if (bean != null) {
            return bean;
        }
        return (AccessibleBean)this.mySessionBeans.get(name);
    }

    public IEnterpriseBean[] getReferencedBeans() {
        if (!this.isRecognized()) {
            return null;
        }
        EnterpriseBean[] beans = this.getEnterpriseBeans();
        if (beans == null) {
            return null;
        }
        ArrayList<IEnterpriseBean> beanRefs = new ArrayList<IEnterpriseBean>(beans.length);
        int i = 0;
        while (i < beans.length) {
            IEnterpriseBean beanRef = this.getReferencedBean(beans[i].getEjbClass());
            if (beanRef != null) {
                beanRefs.add(beanRef);
            }
            ++i;
        }
        return beanRefs.toArray(new IEnterpriseBean[beanRefs.size()]);
    }

    public IEnterpriseBean getReferencedBean(String beanClassName) {
        if (!this.isRecognized()) {
            return null;
        }
        EjbProject[] ejbProjects = this.getEjbJarProject().getReferencedEjbProjects();
        int i = 0;
        while (i < ejbProjects.length) {
            EjbProject ejbProject = ejbProjects[i];
            IEnterpriseBean ejb = null;
            try {
                ejb = ejbProject.getEnterpriseBean(beanClassName);
            }
            catch (EJBModelException ejbme) {
                ejbme.printStackTrace();
            }
            if (ejb != null) {
                return ejb;
            }
            ++i;
        }
        return null;
    }

    private void writeEjbNameAndClass(Element ejb, String[] childOrder, String name, String beanClass) {
        DomUtils.createChildTextNode((Element)ejb, (String[])childOrder, (String)"ejb-name").setNodeValue(name);
        DomUtils.createChildTextNode((Element)ejb, (String[])childOrder, (String)"ejb-class").setNodeValue(beanClass);
    }

    private void writeParticipants(Element ejb, String[] childOrder, AccessibleBeanContext context, Boolean local) {
        if (local == null || local.booleanValue()) {
            String localInterface;
            String localHomeInterface = context.getLocalHomeInterface();
            if (localHomeInterface != null) {
                DomUtils.createChildTextNode((Element)ejb, (String[])childOrder, (String)"local-home").setNodeValue(localHomeInterface);
            }
            if ((localInterface = context.getLocalInterface()) != null) {
                DomUtils.createChildTextNode((Element)ejb, (String[])childOrder, (String)"local").setNodeValue(localInterface);
            }
        }
        if (local == null || !local.booleanValue()) {
            String remoteInterface;
            String homeInterface = context.getHomeInterface();
            if (homeInterface != null) {
                DomUtils.createChildTextNode((Element)ejb, (String[])childOrder, (String)"home").setNodeValue(homeInterface);
            }
            if ((remoteInterface = context.getRemoteInterface()) != null) {
                DomUtils.createChildTextNode((Element)ejb, (String[])childOrder, (String)"remote").setNodeValue(remoteInterface);
            }
        }
    }

    private EjbJarProject getEjbJarProject() {
        return this.myProject;
    }

    public void reload() {
        this.myAssemblyDescriptor = null;
        this.myEjbRelations = null;
        this.myEntityBeans = null;
        this.mySessionBeans = null;
        this.myMessageDrivenBeans = null;
        super.reload();
        if (this.isRecognized()) {
            this.myAssemblyDescriptor = new AssemblyDescriptorImpl(this, this.getElement());
        }
    }

    protected String getPublicId() {
        return PUBLIC_ID;
    }

    protected String getSystemId() {
        return SYSTEM_ID;
    }

    protected String getDtd() {
        if (ourDtd == null) {
            ourDtd = FileUtils.getFileContents((String)DTD_PATH, (String)"", (Plugin)EjbJarImplPlugin.getDefault());
        }
        return ourDtd;
    }

    public void forwardEngineerToEJBProjects(final IProgressMonitor monitor) {
        ModelAccess.runCommand((Runnable)new Runnable(){

            public void run() {
                new ForwardEngineering(EjbJarImpl.this).run(monitor);
            }
        });
    }
}

