/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejbjar;

import com.tssap.j2ee.core.descriptor.DescriptorEntity;
import com.tssap.j2ee.core.descriptor.SecurityRole;
import com.tssap.j2ee.core.ejbjar.AssemblyDescriptor;
import com.tssap.j2ee.core.ejbjar.ContainerTransaction;
import com.tssap.j2ee.core.ejbjar.EjbJarMetaInfo;
import com.tssap.j2ee.core.ejbjar.ExcludeList;
import com.tssap.j2ee.core.ejbjar.MethodPermission;
import com.tssap.j2ee.internal.core.descriptor.DescriptorEntityImpl;
import com.tssap.j2ee.internal.core.ejbjar.ContainerTransactionImpl;
import com.tssap.j2ee.internal.core.ejbjar.EjbJarChildOrder;
import com.tssap.j2ee.internal.core.ejbjar.EjbJarImpl;
import com.tssap.j2ee.internal.core.ejbjar.ExcludeListImpl;
import com.tssap.j2ee.internal.core.ejbjar.MethodPermissionImpl;
import com.tssap.j2ee.internal.core.ejbjar.SecurityRoleImpl;
import com.tssap.j2ee.internal.core.util.DomUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;

final class AssemblyDescriptorImpl
extends DescriptorEntityImpl
implements AssemblyDescriptor {
    private Map mySecurityRoles;
    private Map myMethodPermissions;
    private Map myContainerTransactions;
    private ExcludeList myExcludeList;

    public AssemblyDescriptorImpl(EjbJarImpl parent, Element element) {
        super((DescriptorEntityImpl)parent, element);
    }

    public String toString() {
        return "AssemblyDescriptor";
    }

    public boolean canDelete() {
        return false;
    }

    public void delete() {
        throw new UnsupportedOperationException();
    }

    protected void readSecurityRoles() {
        if (this.mySecurityRoles != null) {
            return;
        }
        this.mySecurityRoles = new HashMap();
        Element adElement = this.getAdElement(false);
        if (adElement == null) {
            return;
        }
        Element[] roles = DomUtils.getChildElements((Element)adElement, (String)"security-role");
        if (roles == null || roles.length == 0) {
            return;
        }
        int i = 0;
        while (i < roles.length) {
            SecurityRoleImpl role = new SecurityRoleImpl(this, roles[i]);
            String name = role.getName();
            if (!DescriptorEntityImpl.isNull((String)name) && !this.mySecurityRoles.containsKey(name)) {
                this.mySecurityRoles.put(name, role);
            }
            ++i;
        }
    }

    protected void updateSecurityRole(String name) {
        if (this.mySecurityRoles == null) {
            return;
        }
        SecurityRole role = (SecurityRole)this.mySecurityRoles.remove(name);
        if (role != null && role.isValid()) {
            this.mySecurityRoles.put(role.getName(), role);
        }
        this.deleteIfEmpty();
    }

    public SecurityRole[] getSecurityRoles() {
        this.readSecurityRoles();
        if (this.mySecurityRoles.isEmpty()) {
            return null;
        }
        Collection roles = this.mySecurityRoles.values();
        return roles.toArray(new SecurityRole[roles.size()]);
    }

    public SecurityRole getSecurityRole(String name) {
        this.readSecurityRoles();
        return (SecurityRole)this.mySecurityRoles.get(name);
    }

    public boolean canCreateSecurityRole(String name, String description) {
        this.readSecurityRoles();
        if (DescriptorEntityImpl.isNull((String)name)) {
            return false;
        }
        return !this.mySecurityRoles.containsKey(name);
    }

    public SecurityRole createSecurityRole(String name, String description) {
        if (!this.canCreateSecurityRole(name, description)) {
            throw new IllegalArgumentException();
        }
        if (!this.edit(null)) {
            return null;
        }
        Element roleElement = DomUtils.createChildElement((Element)this.getAdElement(true), (String[])EjbJarChildOrder.ASSEMBLY_DESCRIPTOR, (String)"security-role");
        DomUtils.setChildTextNodeValue((Element)roleElement, (String[])EjbJarChildOrder.SECURITY_ROLE, (String)"role-name", (String)name);
        if (description != null) {
            DomUtils.setChildTextNodeValue((Element)roleElement, (String[])EjbJarChildOrder.SECURITY_ROLE, (String)"description", (String)description);
        }
        SecurityRoleImpl role = new SecurityRoleImpl(this, roleElement);
        this.mySecurityRoles.put(role.getName(), role);
        this.added((DescriptorEntity)role);
        return role;
    }

    protected void readMethodPermissions() {
        if (this.myMethodPermissions != null) {
            return;
        }
        this.myMethodPermissions = new HashMap();
        Element adElement = this.getAdElement(false);
        if (adElement == null) {
            return;
        }
        Element[] permissions = DomUtils.getChildElements((Element)adElement, (String)"method-permission");
        if (permissions == null || permissions.length == 0) {
            return;
        }
        int i = 0;
        while (i < permissions.length) {
            MethodPermissionImpl permission = new MethodPermissionImpl(this, permissions[i], String.valueOf(i));
            this.myMethodPermissions.put(permission.getSyntheticName(), permission);
            ++i;
        }
    }

    protected void updateMethodPermission(String name) {
        if (this.myMethodPermissions == null) {
            return;
        }
        MethodPermission permission = (MethodPermission)this.myMethodPermissions.remove(name);
        if (permission != null && permission.isValid()) {
            this.myMethodPermissions.put(permission.getSyntheticName(), permission);
        }
        this.deleteIfEmpty();
    }

    public MethodPermission[] getMethodPermissions() {
        this.readMethodPermissions();
        if (this.myMethodPermissions.isEmpty()) {
            return null;
        }
        Collection permissions = this.myMethodPermissions.values();
        return permissions.toArray(new MethodPermission[permissions.size()]);
    }

    public MethodPermission getMethodPermission(String name) {
        this.readMethodPermissions();
        return (MethodPermission)this.myMethodPermissions.get(name);
    }

    public boolean canCreateMethodPermission(String[] roles, String description) {
        this.readMethodPermissions();
        return true;
    }

    public MethodPermission createMethodPermission(String[] roles, String description) {
        if (!this.canCreateMethodPermission(roles, description)) {
            throw new IllegalArgumentException();
        }
        if (!this.edit(null)) {
            return null;
        }
        Element permissionElement = DomUtils.createChildElement((Element)this.getAdElement(true), (String[])EjbJarChildOrder.ASSEMBLY_DESCRIPTOR, (String)"method-permission");
        boolean unchecked = true;
        if (roles != null && roles.length > 0) {
            int i = 0;
            while (i < roles.length) {
                String role = DescriptorEntityImpl.nullify((String)roles[i]);
                if (role != null) {
                    DomUtils.createChildTextNode((Element)permissionElement, (String[])EjbJarChildOrder.METHOD_PERMISSION, (String)"role-name").setNodeValue(role);
                    unchecked = false;
                }
                ++i;
            }
        }
        if (unchecked) {
            DomUtils.createChildElement((Element)permissionElement, (String[])EjbJarChildOrder.METHOD_PERMISSION, (String)"unchecked");
        }
        if (description != null) {
            DomUtils.setChildTextNodeValue((Element)permissionElement, (String[])EjbJarChildOrder.METHOD_PERMISSION, (String)"description", (String)description);
        }
        MethodPermissionImpl permission = new MethodPermissionImpl(this, permissionElement, String.valueOf(this.myMethodPermissions.size()));
        this.myMethodPermissions.put(permission.getSyntheticName(), permission);
        this.added((DescriptorEntity)permission);
        return permission;
    }

    protected void readContainerTransactions() {
        if (this.myContainerTransactions != null) {
            return;
        }
        this.myContainerTransactions = new HashMap();
        Element adElement = this.getAdElement(false);
        if (adElement == null) {
            return;
        }
        Element[] transactions = DomUtils.getChildElements((Element)adElement, (String)"container-transaction");
        if (transactions == null || transactions.length == 0) {
            return;
        }
        int i = 0;
        while (i < transactions.length) {
            ContainerTransactionImpl transaction = new ContainerTransactionImpl(this, transactions[i], String.valueOf(i));
            this.myContainerTransactions.put(transaction.getSyntheticName(), transaction);
            ++i;
        }
    }

    protected void updateContainerTransaction(String name) {
        if (this.myContainerTransactions == null) {
            return;
        }
        ContainerTransaction transaction = (ContainerTransaction)this.myContainerTransactions.remove(name);
        if (transaction != null && transaction.isValid()) {
            this.myContainerTransactions.put(transaction.getSyntheticName(), transaction);
        }
        this.deleteIfEmpty();
    }

    public ContainerTransaction[] getContainerTransactions() {
        this.readContainerTransactions();
        if (this.myContainerTransactions.isEmpty()) {
            return null;
        }
        Collection transactions = this.myContainerTransactions.values();
        return transactions.toArray(new ContainerTransaction[transactions.size()]);
    }

    public ContainerTransaction getContainerTransaction(String name) {
        this.readContainerTransactions();
        return (ContainerTransaction)this.myContainerTransactions.get(name);
    }

    public boolean canCreateContainerTransaction(String attribute, String description) {
        this.readContainerTransactions();
        return EjbJarMetaInfo.isValidTransactionAttribute((String)attribute);
    }

    public ContainerTransaction createContainerTransaction(String attribute, String description) {
        if (!this.canCreateContainerTransaction(attribute, description)) {
            throw new IllegalArgumentException();
        }
        if (!this.edit(null)) {
            return null;
        }
        Element transactionElement = DomUtils.createChildElement((Element)this.getAdElement(true), (String[])EjbJarChildOrder.ASSEMBLY_DESCRIPTOR, (String)"container-transaction");
        DomUtils.setChildTextNodeValue((Element)transactionElement, (String[])EjbJarChildOrder.CONTAINER_TRANSACTION, (String)"trans-attribute", (String)attribute);
        if (description != null) {
            DomUtils.setChildTextNodeValue((Element)transactionElement, (String[])EjbJarChildOrder.CONTAINER_TRANSACTION, (String)"description", (String)description);
        }
        ContainerTransactionImpl transaction = new ContainerTransactionImpl(this, transactionElement, String.valueOf(this.myContainerTransactions.size()));
        this.myContainerTransactions.put(transaction.getSyntheticName(), transaction);
        this.added((DescriptorEntity)transaction);
        return transaction;
    }

    public ExcludeList getExcludeList(boolean create) {
        if (this.myExcludeList != null) {
            return this.myExcludeList;
        }
        Element adElement = this.getAdElement(create);
        if (adElement == null) {
            return null;
        }
        Element list = DomUtils.getChildElement((Element)adElement, (String)"exclude-list");
        if (list != null) {
            this.myExcludeList = new ExcludeListImpl(this, list);
            return this.myExcludeList;
        }
        if (!create) {
            return null;
        }
        if (!this.edit(null)) {
            return null;
        }
        list = DomUtils.createChildElement((Element)adElement, (String[])EjbJarChildOrder.ASSEMBLY_DESCRIPTOR, (String)"exclude-list");
        this.myExcludeList = new ExcludeListImpl(this, list);
        this.added((DescriptorEntity)this.myExcludeList);
        return this.myExcludeList;
    }

    public void updateExcludeList() {
        if (this.myExcludeList == null) {
            return;
        }
        if (this.myExcludeList.isValid()) {
            return;
        }
        this.myExcludeList = null;
        this.deleteIfEmpty();
    }

    private Element getAdElement(boolean create) {
        Element adElement = DomUtils.getChildElement((Element)this.getElement(), (String)"assembly-descriptor");
        if (adElement == null && create) {
            if (!this.edit(null)) {
                return null;
            }
            adElement = DomUtils.createChildElement((Element)this.getElement(), (String[])EjbJarChildOrder.EJB_JAR, (String)"assembly-descriptor");
        }
        return adElement;
    }

    private void deleteIfEmpty() {
        Element adElement = this.getAdElement(false);
        if (adElement == null) {
            return;
        }
        if (DomUtils.hasChildElements((Element)adElement)) {
            return;
        }
        if (!this.edit(null)) {
            return;
        }
        DomUtils.removeElement((Element)adElement);
    }

    private EjbJarImpl getEjbJarImpl() {
        return (EjbJarImpl)this.getParent();
    }
}

