/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejbjar;

import com.tssap.j2ee.core.descriptor.AccessibleBean;
import com.tssap.j2ee.core.descriptor.DescriptorEntity;
import com.tssap.j2ee.core.descriptor.EjbLocalRef;
import com.tssap.j2ee.core.descriptor.EjbRef;
import com.tssap.j2ee.core.descriptor.EjbRefBase;
import com.tssap.j2ee.core.descriptor.SecurityRoleRef;
import com.tssap.j2ee.core.ejb.EJBModelException;
import com.tssap.j2ee.core.ejb.IAccessibleBean;
import com.tssap.j2ee.core.ejb.IEnterpriseBean;
import com.tssap.j2ee.core.utils.UtilsPlugin;
import com.tssap.j2ee.internal.core.descriptor.DescriptorEntityImpl;
import com.tssap.j2ee.internal.core.ejbjar.EjbJarChildOrder;
import com.tssap.j2ee.internal.core.ejbjar.EjbJarImpl;
import com.tssap.j2ee.internal.core.ejbjar.EjbJarImplPlugin;
import com.tssap.j2ee.internal.core.ejbjar.EnterpriseBeanImpl;
import com.tssap.j2ee.internal.core.ejbjar.SecurityRoleRefImpl;
import com.tssap.j2ee.internal.core.util.DomUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.IType;
import org.w3c.dom.Element;

abstract class AccessibleBeanImpl
extends EnterpriseBeanImpl
implements AccessibleBean {
    private Map mySecurityRoleRefs;

    protected AccessibleBeanImpl(EjbJarImpl parent, Element element) {
        super(parent, element);
    }

    public String getHomeInterface() {
        return DomUtils.getChildTextNodeValue((Element)this.getElement(), (String)"home");
    }

    public boolean canSetHomeInterface(String name) {
        return true;
    }

    public void setHomeInterface(final String name) {
        if (!this.canSetHomeInterface(name)) {
            throw new IllegalArgumentException(name);
        }
        final String oldName = this.getHomeInterface();
        if (DescriptorEntityImpl.equals((Object)oldName, (Object)name)) {
            return;
        }
        if (!this.edit(null)) {
            return;
        }
        this.modify(new Runnable(){

            public void run() {
                DomUtils.setChildTextNodeValue((Element)AccessibleBeanImpl.this.getElement(), (String[])AccessibleBeanImpl.this.getChildOrder(), (String)"home", (String)name);
                AccessibleBeanImpl.super.changed((DescriptorEntity)AccessibleBeanImpl.this);
                AccessibleBeanImpl.this.syncHomeInterface(oldName, name);
            }
        });
    }

    public String getRemoteInterface() {
        return DomUtils.getChildTextNodeValue((Element)this.getElement(), (String)"remote");
    }

    public boolean canSetRemoteInterface(String name) {
        return true;
    }

    public void setRemoteInterface(final String name) {
        if (!this.canSetRemoteInterface(name)) {
            throw new IllegalArgumentException(name);
        }
        final String oldName = this.getRemoteInterface();
        if (DescriptorEntityImpl.equals((Object)oldName, (Object)name)) {
            return;
        }
        if (!this.edit(null)) {
            return;
        }
        this.modify(new Runnable(){

            public void run() {
                DomUtils.setChildTextNodeValue((Element)AccessibleBeanImpl.this.getElement(), (String[])AccessibleBeanImpl.this.getChildOrder(), (String)"remote", (String)name);
                AccessibleBeanImpl.super.changed((DescriptorEntity)AccessibleBeanImpl.this);
                AccessibleBeanImpl.this.syncRemoteInterface(oldName, name);
            }
        });
    }

    public String getLocalHomeInterface() {
        return DomUtils.getChildTextNodeValue((Element)this.getElement(), (String)"local-home");
    }

    public boolean canSetLocalHomeInterface(String name) {
        return true;
    }

    public void setLocalHomeInterface(final String name) {
        if (!this.canSetLocalHomeInterface(name)) {
            throw new IllegalArgumentException(name);
        }
        final String oldName = this.getLocalHomeInterface();
        if (DescriptorEntityImpl.equals((Object)oldName, (Object)name)) {
            return;
        }
        if (!this.edit(null)) {
            return;
        }
        this.modify(new Runnable(){

            public void run() {
                DomUtils.setChildTextNodeValue((Element)AccessibleBeanImpl.this.getElement(), (String[])AccessibleBeanImpl.this.getChildOrder(), (String)"local-home", (String)name);
                AccessibleBeanImpl.super.changed((DescriptorEntity)AccessibleBeanImpl.this);
                AccessibleBeanImpl.this.syncLocalHomeInterface(oldName, name);
            }
        });
    }

    public String getLocalInterface() {
        return DomUtils.getChildTextNodeValue((Element)this.getElement(), (String)"local");
    }

    public boolean canSetLocalInterface(String name) {
        return true;
    }

    public void setLocalInterface(final String name) {
        if (!this.canSetLocalInterface(name)) {
            throw new IllegalArgumentException(name);
        }
        final String oldName = this.getLocalInterface();
        if (DescriptorEntityImpl.equals((Object)oldName, (Object)name)) {
            return;
        }
        if (!this.edit(null)) {
            return;
        }
        this.modify(new Runnable(){

            public void run() {
                DomUtils.setChildTextNodeValue((Element)AccessibleBeanImpl.this.getElement(), (String[])AccessibleBeanImpl.this.getChildOrder(), (String)"local", (String)name);
                AccessibleBeanImpl.super.changed((DescriptorEntity)AccessibleBeanImpl.this);
                AccessibleBeanImpl.this.syncLocalInterface(oldName, name);
            }
        });
    }

    protected void referencedBeanRenamed(IEnterpriseBean removed, IEnterpriseBean added) {
        String remote;
        String home;
        String local;
        String localHome;
        super.referencedBeanRenamed(removed, added);
        if (!(added instanceof IAccessibleBean)) {
            EjbJarImplPlugin.logError("Referenced bean is not an accessible bean, cannot update");
            return;
        }
        IAccessibleBean bean = (IAccessibleBean)added;
        try {
            IType localHomeType = bean.getParticipant(8);
            localHome = localHomeType != null && localHomeType.exists() ? localHomeType.getFullyQualifiedName() : null;
            IType localType = bean.getParticipant(16);
            local = localType != null && localType.exists() ? localType.getFullyQualifiedName() : null;
            IType homeType = bean.getParticipant(2);
            home = homeType != null && homeType.exists() ? homeType.getFullyQualifiedName() : null;
            IType remoteType = bean.getParticipant(4);
            remote = remoteType != null && remoteType.exists() ? remoteType.getFullyQualifiedName() : null;
        }
        catch (EJBModelException e) {
            EjbJarImplPlugin.logError("Could not update renamed bean: added bean does not seem to exist", e);
            return;
        }
        this.modify(new Runnable(){

            public void run() {
                if (AccessibleBeanImpl.this.hasLocalStructure()) {
                    if (AccessibleBeanImpl.this.canSetLocalHomeInterface(localHome) && AccessibleBeanImpl.this.canSetLocalInterface(local)) {
                        AccessibleBeanImpl.this.setLocalHomeInterface(localHome);
                        AccessibleBeanImpl.this.setLocalInterface(local);
                    } else {
                        EjbJarImplPlugin.logError("Could not update local structure after bean rename");
                    }
                }
                if (AccessibleBeanImpl.this.hasRemoteStructure()) {
                    if (AccessibleBeanImpl.this.canSetHomeInterface(home) && AccessibleBeanImpl.this.canSetRemoteInterface(remote)) {
                        AccessibleBeanImpl.this.setHomeInterface(home);
                        AccessibleBeanImpl.this.setRemoteInterface(remote);
                    } else {
                        EjbJarImplPlugin.logError("Could not update remote structure after bean rename");
                    }
                }
            }
        });
    }

    public boolean hasLocalStructure() {
        return this.getLocalHomeInterface() != null && this.getLocalInterface() != null;
    }

    public boolean hasRemoteStructure() {
        return this.getHomeInterface() != null && this.getRemoteInterface() != null;
    }

    protected void readSecurityRoleRefs() {
        if (this.mySecurityRoleRefs == null) {
            this.mySecurityRoleRefs = new HashMap();
            Element[] refs = DomUtils.getChildElements((Element)this.getElement(), (String)"security-role-ref");
            int i = 0;
            while (i < refs.length) {
                SecurityRoleRefImpl ref = new SecurityRoleRefImpl(this, refs[i]);
                String name = ref.getName();
                if (!DescriptorEntityImpl.isNull((String)name) && !this.mySecurityRoleRefs.containsKey(name)) {
                    this.mySecurityRoleRefs.put(name, ref);
                }
                ++i;
            }
        }
    }

    protected void updateSecurityRoleRef(String name) {
        SecurityRoleRef ref;
        if (this.mySecurityRoleRefs != null && (ref = (SecurityRoleRef)this.mySecurityRoleRefs.remove(name)) != null && ref.isValid()) {
            this.mySecurityRoleRefs.put(ref.getName(), ref);
        }
    }

    public SecurityRoleRef[] getSecurityRoleReferences() {
        this.readSecurityRoleRefs();
        if (this.mySecurityRoleRefs.isEmpty()) {
            return null;
        }
        Collection refs = this.mySecurityRoleRefs.values();
        return refs.toArray(new SecurityRoleRef[refs.size()]);
    }

    public SecurityRoleRef getSecurityRoleReference(String name) {
        this.readSecurityRoleRefs();
        return (SecurityRoleRef)this.mySecurityRoleRefs.get(name);
    }

    public boolean canCreateSecurityRoleReference(String name, String link, String description) {
        this.readSecurityRoleRefs();
        return !DescriptorEntityImpl.isNull((String)name) && !this.mySecurityRoleRefs.containsKey(name);
    }

    public SecurityRoleRef createSecurityRoleReference(String name, String link, String description) {
        if (!this.canCreateSecurityRoleReference(name, link, description)) {
            throw new IllegalArgumentException();
        }
        if (!this.edit(null)) {
            return null;
        }
        Element refElement = DomUtils.createChildElement((Element)this.getElement(), (String[])this.getChildOrder(), (String)"security-role-ref");
        DomUtils.setChildTextNodeValue((Element)refElement, (String[])EjbJarChildOrder.SECURITY_ROLE_REF, (String)"role-name", (String)name);
        if (link != null) {
            DomUtils.setChildTextNodeValue((Element)refElement, (String[])EjbJarChildOrder.SECURITY_ROLE_REF, (String)"role-link", (String)link);
        }
        if (description != null) {
            DomUtils.setChildTextNodeValue((Element)refElement, (String[])EjbJarChildOrder.SECURITY_ROLE_REF, (String)"description", (String)description);
        }
        SecurityRoleRefImpl ref = new SecurityRoleRefImpl(this, refElement);
        this.mySecurityRoleRefs.put(name, ref);
        this.added((DescriptorEntity)ref);
        return ref;
    }

    private void syncHomeInterface(final String oldName, final String newName) {
        this.syncRefs(new EnterpriseBeanImpl.PuppetMaster(){

            public void accept(EjbRefBase ref) {
                if (ref instanceof EjbRef) {
                    this.accept((EjbRef)ref);
                }
            }

            public void accept(EjbRef ref) {
                if (!DescriptorEntityImpl.equals((Object)oldName, (Object)ref.getHomeInterface())) {
                    return;
                }
                try {
                    if (ref.canSetHomeInterface(newName)) {
                        ref.setHomeInterface(newName);
                    } else {
                        UtilsPlugin.logWarning((String)("Unable to synchronize ejb reference home interface " + oldName));
                    }
                }
                catch (Exception e) {
                    UtilsPlugin.logError((String)("Unable to synchronize ejb reference home interface " + oldName), (Throwable)e);
                }
            }
        }, null, this.getName(), true, false);
    }

    private void syncRemoteInterface(final String oldName, final String newName) {
        this.syncRefs(new EnterpriseBeanImpl.PuppetMaster(){

            public void accept(EjbRefBase ref) {
                if (ref instanceof EjbRef) {
                    this.accept((EjbRef)ref);
                }
            }

            public void accept(EjbRef ref) {
                if (!DescriptorEntityImpl.equals((Object)oldName, (Object)ref.getRemoteInterface())) {
                    return;
                }
                try {
                    if (ref.canSetRemoteInterface(newName)) {
                        ref.setRemoteInterface(newName);
                    } else {
                        UtilsPlugin.logWarning((String)("Unable to synchronize ejb reference remote interface " + oldName));
                    }
                }
                catch (Exception e) {
                    UtilsPlugin.logError((String)("Unable to synchronize ejb reference remote interface " + oldName), (Throwable)e);
                }
            }
        }, null, this.getName(), true, false);
    }

    private void syncLocalHomeInterface(final String oldName, final String newName) {
        this.syncRefs(new EnterpriseBeanImpl.PuppetMaster(){

            public void accept(EjbRefBase ref) {
                if (ref instanceof EjbLocalRef) {
                    this.accept((EjbLocalRef)ref);
                }
            }

            public void accept(EjbLocalRef ref) {
                if (!DescriptorEntityImpl.equals((Object)oldName, (Object)ref.getLocalHomeInterface())) {
                    return;
                }
                try {
                    if (ref.canSetLocalHomeInterface(newName)) {
                        ref.setLocalHomeInterface(newName);
                    } else {
                        UtilsPlugin.logWarning((String)("Unable to synchronize ejb local reference local home interface " + oldName));
                    }
                }
                catch (Exception e) {
                    UtilsPlugin.logError((String)("Unable to synchronize ejb local reference local home interface " + oldName), (Throwable)e);
                }
            }
        }, null, this.getName(), false, true);
    }

    private void syncLocalInterface(final String oldName, final String newName) {
        this.syncRefs(new EnterpriseBeanImpl.PuppetMaster(){

            public void accept(EjbRefBase ref) {
                if (ref instanceof EjbLocalRef) {
                    this.accept((EjbLocalRef)ref);
                }
            }

            public void accept(EjbLocalRef ref) {
                if (!DescriptorEntityImpl.equals((Object)oldName, (Object)ref.getLocalInterface())) {
                    return;
                }
                try {
                    if (ref.canSetLocalInterface(newName)) {
                        ref.setLocalInterface(newName);
                    } else {
                        UtilsPlugin.logWarning((String)("Unable to synchronize ejb local reference local interface " + oldName));
                    }
                }
                catch (Exception e) {
                    UtilsPlugin.logError((String)("Unable to synchronize ejb local reference local interface " + oldName), (Throwable)e);
                }
            }
        }, null, this.getName(), false, true);
    }
}

