/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.generation.eclipse;

import com.sap.ide.generationfwk.eclipse.GenerationFwkPlugin;
import com.sap.ide.generationfwk.eclipse.marker.GenerationMarker;
import com.sap.ide.generationfwk.naming.NamingServiceBase;
import com.sap.ide.metamodel.core.generation.GenerationObjectChangedCache;
import com.sap.ide.metamodel.webdynpro.WebDynproMDOEnum;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceDefinition;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.webdynpro.generation.eclipse.GenerationEclipse;
import com.sap.ide.webdynpro.generation.eclipse.GenerationPlugin;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import com.sap.tc.logging.Location;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;

public class GenerationVisitor
implements IResourceVisitor {
    private static final Location TRACE_LOCATION = Location.getLocation((String)(class$com$sap$ide$webdynpro$generation$eclipse$GenerationVisitor == null ? (class$com$sap$ide$webdynpro$generation$eclipse$GenerationVisitor = GenerationVisitor.class$("com.sap.ide.webdynpro.generation.eclipse.GenerationVisitor")) : class$com$sap$ide$webdynpro$generation$eclipse$GenerationVisitor).getName());
    GenerationEclipse mGeneration = null;
    IProgressMonitor mProgessMonitor = null;
    static /* synthetic */ Class class$com$sap$ide$webdynpro$generation$eclipse$GenerationVisitor;

    public GenerationVisitor(IProgressMonitor monitor, boolean incremental) {
        this.setProgressMonitor(monitor);
        this.setGeneration(new GenerationEclipse(monitor));
        this.getGeneration().setIncremental(incremental);
        this.getGeneration().refreshConfiguration();
    }

    public boolean visit(IResource resource) throws CoreException {
        GenerationObjectChangedCache lObjectChangedCache = GenerationEclipse.getObjectChangedCacheForProject(resource.getProject().getName());
        if (this.getProgressMonitor().isCanceled()) {
            lObjectChangedCache.setValid(true);
            this.getProgressMonitor().done();
            throw new OperationCanceledException();
        }
        if (resource.getType() == 4) {
            lObjectChangedCache.evaluateConsumers();
            if (this.getGeneration().isIncremental()) {
                if (lObjectChangedCache.isValid()) {
                    this.getGeneration().setObjectChangedCache(lObjectChangedCache);
                    lObjectChangedCache.setValid(false, "com.sap.ide.webdynpro.generation.GenerationBuilder");
                } else {
                    this.getGeneration().getObjectChangedCache().clear();
                }
            } else {
                this.getGeneration().setTargetPath(resource.getProject().getLocation().toFile().getAbsolutePath());
                this.getGeneration().deleteOutputFolderContent();
                lObjectChangedCache.setValid(false, "com.sap.ide.webdynpro.generation.GenerationBuilder");
                this.getGeneration().getObjectChangedCache().clear();
            }
            return true;
        }
        if (resource.getType() != 1) {
            return true;
        }
        if (resource.getFileExtension() == null) {
            return true;
        }
        if (resource.getFileExtension().equalsIgnoreCase(WebDynproMDOEnum.COMPONENT.getFileExtension())) {
            if (!GenerationEclipse.isResourceInSourceFolder(resource)) {
                return false;
            }
            return this.visitComponent(resource);
        }
        if (resource.getFileExtension().equalsIgnoreCase(WebDynproMDOEnum.COMPONENTINTERFACEDEFINITION.getFileExtension())) {
            if (!GenerationEclipse.isResourceInSourceFolder(resource)) {
                return false;
            }
            return this.visitComponentInterfaceDefinition(resource);
        }
        if (resource.getFileExtension().equalsIgnoreCase(WebDynproMDOEnum.MODEL.getFileExtension())) {
            if (!GenerationEclipse.isResourceInSourceFolder(resource)) {
                return false;
            }
            return this.visitModel(resource);
        }
        return true;
    }

    private boolean visitComponent(IResource resource) throws CoreException {
        this.getGeneration().setResource(resource);
        GenerationMarker.deleteProblemMarkers((String)GenerationPlugin.getPluginId(), (IResource)resource);
        Component lComponent = null;
        IProject lProject = resource.getProject();
        try {
            WebDynproRoot lWebDynproRoot = MetamodelServices.getWebDynproRoot((String)resource.getProject().getName());
            lComponent = lWebDynproRoot.getComponent(this.getPackageName(resource, GenerationFwkPlugin.getJavaProject((IProject)lProject)), NamingServiceBase.getFileNameWithoutExtension((String)resource.getName()));
        }
        catch (Exception ex) {
            this.getGeneration().printMessage(2, "Metadata could not be read!");
            this.getGeneration().setResource(null);
            return false;
        }
        this.getGeneration().setTargetPath(resource.getProject().getLocation().toFile().getAbsolutePath());
        this.getGeneration().generatePersistentComponent(lComponent, false, true, true, false);
        this.getGeneration().setResource(null);
        return false;
    }

    private boolean visitComponentInterfaceDefinition(IResource resource) throws CoreException {
        this.getGeneration().setResource(resource);
        GenerationMarker.deleteProblemMarkers((String)GenerationPlugin.getPluginId(), (IResource)resource);
        ComponentInterfaceDefinition lComponentInterfaceDefinition = null;
        IProject lProject = resource.getProject();
        try {
            WebDynproRoot lWebDynproRoot = MetamodelServices.getWebDynproRoot((String)resource.getProject().getName());
            lComponentInterfaceDefinition = lWebDynproRoot.getComponentInterfaceDefinition(this.getPackageName(resource, GenerationFwkPlugin.getJavaProject((IProject)lProject)), NamingServiceBase.getFileNameWithoutExtension((String)resource.getName()));
        }
        catch (Exception ex) {
            this.getGeneration().printMessage(2, "Metadata could not be read!");
            this.getGeneration().setResource(null);
            return false;
        }
        this.getGeneration().setTargetPath(resource.getProject().getLocation().toFile().getAbsolutePath());
        this.getGeneration().generatePersistentComponentInterfaceDefinition(lComponentInterfaceDefinition, false, true, true, false);
        this.getGeneration().setResource(null);
        return false;
    }

    private boolean visitModel(IResource resource) throws CoreException {
        this.getGeneration().setResource(resource);
        GenerationMarker.deleteProblemMarkers((String)GenerationPlugin.getPluginId(), (IResource)resource);
        Model lModel = null;
        IProject lProject = resource.getProject();
        try {
            WebDynproRoot lWebDynproRoot = MetamodelServices.getWebDynproRoot((String)resource.getProject().getName());
            lModel = lWebDynproRoot.getModel(this.getPackageName(resource, GenerationFwkPlugin.getJavaProject((IProject)lProject)), NamingServiceBase.getFileNameWithoutExtension((String)resource.getName()));
        }
        catch (Exception ex) {
            this.getGeneration().printMessage(2, "Metadata could not be read!");
            this.getGeneration().setResource(null);
            return false;
        }
        this.getGeneration().setTargetPath(resource.getProject().getLocation().toFile().getAbsolutePath());
        this.getGeneration().generatePersistentModel(lModel, false, true, true, false);
        this.getGeneration().setResource(null);
        return false;
    }

    private String getPackageName(IResource resource, IJavaProject lJavaProject) throws JavaModelException {
        IPackageFragment lPackageFragment = lJavaProject.findPackageFragment(resource.getParent().getFullPath());
        if (lPackageFragment == null) {
            return "";
        }
        String lPackage = lPackageFragment.getElementName();
        if (lPackage == null) {
            return "";
        }
        return lPackage;
    }

    private void setGeneration(GenerationEclipse generation) {
        this.mGeneration = generation;
    }

    private GenerationEclipse getGeneration() {
        return this.mGeneration;
    }

    private void setProgressMonitor(IProgressMonitor monitor) {
        this.mProgessMonitor = monitor;
    }

    private IProgressMonitor getProgressMonitor() {
        return this.mProgessMonitor;
    }

    public final void refreshGenerationPath() {
        if (this.getGeneration() != null) {
            this.getGeneration().refreshTargetPath();
        }
    }

    public final void cleanup() {
        this.getGeneration().cleanup();
        this.setGeneration(null);
        this.setProgressMonitor(null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

