/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.generation.eclipse;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.generation.GenerationObjectChangedCache;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.webdynpro.generation.eclipse.GenerationVisitor;
import com.sap.tc.logging.Location;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class GenerationBuilder
extends IncrementalProjectBuilder {
    private static final Location TRACE_LOCATION = Location.getLocation((String)(class$com$sap$ide$webdynpro$generation$eclipse$GenerationBuilder == null ? (class$com$sap$ide$webdynpro$generation$eclipse$GenerationBuilder = GenerationBuilder.class$("com.sap.ide.webdynpro.generation.eclipse.GenerationBuilder")) : class$com$sap$ide$webdynpro$generation$eclipse$GenerationBuilder).getName());
    private static final String TEXT_WEB_DYNPRO_GENERATION = "Web Dynpro Generation ...";
    private static final String TEXT_JAVA_COMPILATION = "Building project ...";
    private IProgressMonitor mProgressMonitor = new NullProgressMonitor();
    static /* synthetic */ Class class$com$sap$ide$webdynpro$generation$eclipse$GenerationBuilder;

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (!this.getProject().isAccessible()) {
            return new IProject[0];
        }
        if (this.isMetamodelChanged(this.getProject())) {
            return new IProject[0];
        }
        this.initializeProgressMonitor();
        this.setProgressMonitor(monitor);
        if (this.getDelta(this.getProject()) == null) {
            kind = 6;
        }
        switch (kind) {
            case 6: {
                long lStartingTime = System.currentTimeMillis();
                this.getProgressMonitor().beginTask("", 50);
                this.getProgressMonitor().setTaskName(TEXT_WEB_DYNPRO_GENERATION);
                GenerationVisitor lGenerationVisitor = new GenerationVisitor(this.getProgressMonitor(), false);
                this.getProject().accept((IResourceVisitor)lGenerationVisitor);
                lGenerationVisitor.refreshGenerationPath();
                lGenerationVisitor.cleanup();
                this.getProgressMonitor().setTaskName(TEXT_JAVA_COMPILATION);
                long lEndingTime = System.currentTimeMillis();
                TRACE_LOCATION.infoT("Building project " + this.getProject().getName() + ": " + (lEndingTime - lStartingTime) + " ms)");
                break;
            }
            case 9: {
                if (this.isObjectChangedCacheEmpty(this.getProject())) break;
                this.getProgressMonitor().beginTask("", 25);
                this.getProgressMonitor().subTask(TEXT_WEB_DYNPRO_GENERATION);
                GenerationVisitor lGenerationVisitor = new GenerationVisitor(this.getProgressMonitor(), true);
                this.getProject().accept((IResourceVisitor)lGenerationVisitor);
                lGenerationVisitor.cleanup();
                break;
            }
            case 10: {
                this.getProgressMonitor().beginTask("", 25);
                this.getProgressMonitor().setTaskName(TEXT_WEB_DYNPRO_GENERATION);
                GenerationVisitor lGenerationVisitor = new GenerationVisitor(this.getProgressMonitor(), true);
                this.getProject().accept((IResourceVisitor)lGenerationVisitor);
                lGenerationVisitor.cleanup();
                this.getProgressMonitor().setTaskName(TEXT_JAVA_COMPILATION);
                break;
            }
        }
        this.initializeProgressMonitor();
        return new IProject[0];
    }

    protected void startupOnInitialize() {
        super.startupOnInitialize();
    }

    private boolean isMetamodelChanged(IProject project) {
        Metamodel lMetamodel = null;
        try {
            lMetamodel = MetamodelManager.getMetamodel((String)project.getName());
            if (lMetamodel == null) {
                this.getProgressMonitor().done();
                throw new OperationCanceledException();
            }
        }
        catch (Exception e) {
            this.getProgressMonitor().done();
            throw new OperationCanceledException();
        }
        return lMetamodel.isModified();
    }

    private boolean isObjectChangedCacheEmpty(IProject project) {
        MetamodelManager lMetamodelManager = MetamodelManager.getMetamodelManager((String)project.getName());
        if (lMetamodelManager == null) {
            this.getProgressMonitor().done();
            throw new OperationCanceledException();
        }
        GenerationObjectChangedCache lObjectChangedCache = lMetamodelManager.getGenerationObjectChangedCache();
        return !lObjectChangedCache.isValid() || lObjectChangedCache.isEmpty();
    }

    private IProgressMonitor getProgressMonitor() {
        return this.mProgressMonitor;
    }

    private void setProgressMonitor(IProgressMonitor progressMonitor) {
        if (progressMonitor != null) {
            this.mProgressMonitor = progressMonitor;
        }
    }

    private void initializeProgressMonitor() {
        if (!(this.mProgressMonitor instanceof NullProgressMonitor)) {
            this.mProgressMonitor = new NullProgressMonitor();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

