/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.user;

import com.sap.caf.mp.base.caching.MemoryCache;
import com.sap.caf.mp.base.db.ICNConnectionPool;
import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.base.exception.SynchronizationException;
import com.sap.caf.mp.base.logging.BaseLogManager;
import com.sap.caf.mp.base.util.MD4Hash;
import com.sap.caf.mp.core.ICoreFactory;
import com.sap.caf.mp.core.IUserFactory;
import com.sap.caf.mp.core.svc.CoreServiceUser;
import com.sap.caf.mp.core.svc.persist.ILockArgument;
import com.sap.caf.mp.core.svc.persist.ILockManager;
import com.sap.caf.mp.core.svc.persist.INumberRange;
import com.sap.caf.mp.core.svc.persist.PersistenceManagers;
import com.sap.caf.mp.core.user.IUserContext;
import com.sap.caf.mp.core.user.UserContext;
import com.sap.security.api.IGroup;
import com.sap.security.api.IUser;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;

public class UserFactory
implements IUserFactory {
    private static final String USER_EVERYONE = "GRUP.SUPER_GROUPS_DATASOURCE.EVERYONE";
    private static final int CACHE_INVALIDATION_CYCLE = 3600000;
    private static final String NUMBERRANGE_ARG_USERFACTORY = "range.users";
    private static final String TABLE_USERHASH = "CAF_RT_USRHSH";
    private static final String COL_USERHASH_INSTNR = "INSTNR";
    private static final String COL_USERHASH_ID = "ID";
    private static final String COL_USERHASH_HASHVALUE = "HASHVALUE";
    private static final String COL_USERHASH_HASHINDEX = "HASHINDEX";
    private static final String COL_USERHASH_UNIQUEID = "UNIQUEID";
    private static String m_stmtInsert;
    private static String m_stmtDelete;
    private static String m_stmtSelect;
    private static String m_stmtSelectHash;
    private MemoryCache m_userCache = new MemoryCache(3600000, Locale.getDefault());
    private INumberRange m_numberRange;
    private ILockManager m_lockManager;
    private ICNConnectionPool m_connectionPool;
    private int m_installationNumber;
    private IGroup m_everyone;
    private ICoreFactory m_coreFactory;

    public UserFactory(ICoreFactory coreFactory, int sysInstnr) throws InvocationException, EngineException {
        this.m_lockManager = coreFactory.getPersistenceManagers().getLockManager();
        this.m_numberRange = coreFactory.getPersistenceManagers().getNumberRange();
        this.m_connectionPool = coreFactory.getPersistenceManagers().getConnectionPool();
        this.m_installationNumber = sysInstnr;
        this.m_coreFactory = coreFactory;
    }

    public IUserContext getUserContext(Locale locale, IUser user) throws InvocationException, EngineException, SynchronizationException {
        return this.getUserContext(locale, user.getUniqueID());
    }

    public IUserContext getUserContext(Locale locale, String uniqueid) throws InvocationException, EngineException, SynchronizationException {
        IUserContext context;
        if (locale == null) {
            locale = this.m_coreFactory.getCoreContext().getFallbackLocale();
        }
        if ((context = (IUserContext)this.m_userCache.getEntry(uniqueid)) != null) {
            return context;
        }
        context = this.readUserContext(locale, uniqueid);
        if (context != null) {
            return context;
        }
        context = this.createUserContext(locale, uniqueid);
        this.m_userCache.addEntry(uniqueid, (Object)context);
        return context;
    }

    public IUser getCoreServiceUser() {
        return CoreServiceUser.getCoreServiceUser();
    }

    private synchronized IUserContext createUserContext(Locale locale, String uniqueId) throws InvocationException, EngineException, SynchronizationException {
        ILockArgument lockArgument = null;
        MD4Hash hash = new MD4Hash();
        String hashValue = hash.computeHash(uniqueId);
        Connection conn = null;
        long id = this.m_numberRange.getNextNumber(NUMBERRANGE_ARG_USERFACTORY);
        try {
            lockArgument = this.m_lockManager.lock(1, hashValue, 0, uniqueId);
            conn = this.m_connectionPool.getConnection();
            if (conn.getAutoCommit()) {
                conn.setAutoCommit(false);
            }
            int maxPrevious = -1;
            PreparedStatement stmt = conn.prepareStatement(m_stmtSelectHash);
            stmt.setString(1, hashValue);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                maxPrevious = rs.getInt(1);
            }
            PreparedStatement insertStmt = conn.prepareStatement(m_stmtInsert);
            insertStmt.setInt(1, this.m_installationNumber);
            insertStmt.setLong(2, id);
            insertStmt.setString(3, hashValue);
            insertStmt.setInt(4, ++maxPrevious);
            insertStmt.setString(5, uniqueId);
            insertStmt.execute();
            rs.close();
            stmt.close();
            insertStmt.close();
            conn.commit();
            conn.close();
            this.m_lockManager.unlock(lockArgument);
            return new UserContext(this.m_connectionPool, locale, this.m_installationNumber, id, uniqueId);
        }
        catch (Exception ex) {
            BaseLogManager.error(this.getClass(), (Exception)ex);
            PersistenceManagers.recover(conn);
            if (lockArgument != null) {
                try {
                    this.m_lockManager.unlock(lockArgument);
                }
                catch (EngineException e) {
                    // empty catch block
                }
            }
            throw new EngineException(ex);
        }
    }

    private IUserContext readUserContext(Locale locale, String uniqueId) throws InvocationException, EngineException, SynchronizationException {
        MD4Hash hash = new MD4Hash();
        String hashValue = hash.computeHash(uniqueId);
        Connection conn = null;
        try {
            conn = this.m_connectionPool.getConnection();
            PreparedStatement stmt = conn.prepareStatement(m_stmtSelect);
            stmt.setString(1, hashValue);
            UserContext context = null;
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                String id = rs.getString(COL_USERHASH_UNIQUEID);
                if (!id.equals(uniqueId)) continue;
                int instnr = rs.getInt(COL_USERHASH_INSTNR);
                long usrid = rs.getLong(COL_USERHASH_ID);
                context = new UserContext(this.m_connectionPool, locale, instnr, usrid, uniqueId);
                break;
            }
            rs.close();
            stmt.close();
            conn.close();
            return context;
        }
        catch (SQLException e) {
            PersistenceManagers.recover(conn);
            throw new EngineException((Exception)e);
        }
    }

    private synchronized IGroup resolveEveryone() {
        try {
            if (this.m_everyone != null) {
                return this.m_everyone;
            }
            this.m_everyone = UMFactory.getGroupFactory().getGroup(USER_EVERYONE);
            return this.m_everyone;
        }
        catch (UMException ex) {
            return null;
        }
    }

    public IGroup getEveryone() {
        return this.resolveEveryone();
    }

    static {
        m_stmtSelect = "SELECT * FROM CAF_RT_USRHSH WHERE HASHVALUE=?;";
        m_stmtSelectHash = "SELECT MAX(HASHINDEX) AS HASHINDEX FROM CAF_RT_USRHSH WHERE  HASHVALUE=?;";
        m_stmtInsert = "INSERT INTO CAF_RT_USRHSH(INSTNR,ID,HASHVALUE,HASHINDEX,UNIQUEID) VALUES(?,?,?,?,?);";
    }
}

