/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.user;

import com.sap.caf.mp.base.db.ICNConnectionPool;
import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.base.logging.BaseLogManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class UserConfigDbImpl {
    public static final String TABLE_USERCONFIG = "CAF_RT_USRCFG";
    public static final String COLUMN_INSTNR = "INSTNR";
    public static final String COLUMN_USERID = "USERID";
    public static final String COLUMN_APPLICATION = "APPLICATION";
    public static final String COLUMN_PARAMNAME = "PARAMNAME";
    public static final String COLUMN_PARAMVALUE = "PARAMVALUE";
    private ICNConnectionPool m_pool;

    protected UserConfigDbImpl(ICNConnectionPool pool) {
        this.m_pool = pool;
    }

    public void set(int instNr, long userId, String application, String paramName, String paramValue) throws InvocationException, EngineException {
        Connection conn = null;
        try {
            conn = this.m_pool.getConnection();
            if (conn.getAutoCommit()) {
                conn.setAutoCommit(false);
            }
            this.set(conn, instNr, userId, application, paramName, paramValue);
            conn.commit();
            conn.close();
        }
        catch (SQLException ex) {
            BaseLogManager.error(this.getClass(), (Exception)ex);
            if (conn != null) {
                try {
                    conn.rollback();
                }
                catch (SQLException ex2) {
                    // empty catch block
                }
                try {
                    conn.close();
                }
                catch (SQLException ex2) {
                    // empty catch block
                }
            }
            throw new EngineException(ex.getMessage(), (Exception)ex);
        }
    }

    public String get(int instNr, long userId, String application, String paramName) throws InvocationException, EngineException {
        Connection conn = null;
        try {
            String paramValue = null;
            conn = this.m_pool.getConnection();
            if (conn.getAutoCommit()) {
                conn.setAutoCommit(false);
            }
            paramValue = this.get(conn, instNr, userId, application, paramName);
            conn.commit();
            conn.close();
            return paramValue;
        }
        catch (SQLException ex) {
            BaseLogManager.error(this.getClass(), (Exception)ex);
            if (conn != null) {
                try {
                    conn.rollback();
                }
                catch (SQLException ex2) {
                    // empty catch block
                }
                try {
                    conn.close();
                }
                catch (SQLException ex2) {
                    // empty catch block
                }
            }
            throw new EngineException(ex.getMessage(), (Exception)ex);
        }
    }

    public String remove(int instNr, long userId, String application, String paramName) throws InvocationException, EngineException {
        Connection conn = null;
        try {
            String paramValue = null;
            conn = this.m_pool.getConnection();
            if (conn.getAutoCommit()) {
                conn.setAutoCommit(false);
            }
            paramValue = this.remove(conn, instNr, userId, application, paramName);
            conn.commit();
            conn.close();
            return paramValue;
        }
        catch (SQLException ex) {
            BaseLogManager.error(this.getClass(), (Exception)ex);
            if (conn != null) {
                try {
                    conn.rollback();
                }
                catch (SQLException ex2) {
                    // empty catch block
                }
                try {
                    conn.close();
                }
                catch (SQLException ex2) {
                    // empty catch block
                }
            }
            throw new EngineException(ex.getMessage(), (Exception)ex);
        }
    }

    /*
     * Loose catch block
     */
    private void set(Connection conn, int instNr, long userId, String application, String paramName, String paramValue) throws InvocationException, EngineException {
        block24: {
            Statement ps1 = null;
            PreparedStatement ps = null;
            ResultSet rs = null;
            boolean exists = false;
            ps = conn.prepareStatement("SELECT * FROM CAF_RT_USRCFG WHERE INSTNR = ? AND USERID = ? AND APPLICATION = ? AND PARAMNAME = ? FOR UPDATE;");
            ps.setInt(1, instNr);
            ps.setLong(2, userId);
            ps.setString(3, application);
            ps.setString(4, paramName);
            rs = ps.executeQuery();
            if (rs.next()) {
                exists = true;
            }
            if (exists) {
                ps1 = conn.prepareStatement("UPDATE CAF_RT_USRCFG SET PARAMVALUE = ?  WHERE INSTNR = ? AND USERID = ? AND APPLICATION = ? AND PARAMNAME = ? ;");
                ps1.setString(1, paramValue);
                ps1.setInt(2, instNr);
                ps1.setLong(3, userId);
                ps1.setString(4, application);
                ps1.setString(5, paramName);
            } else {
                ps1 = conn.prepareStatement("INSERT INTO CAF_RT_USRCFG (INSTNR,USERID,APPLICATION,PARAMNAME,PARAMVALUE) VALUES (?,?,?,?,?)");
                ps1.setInt(1, instNr);
                ps1.setLong(2, userId);
                ps1.setString(3, application);
                ps1.setString(4, paramName);
                ps1.setString(5, paramValue);
            }
            ps1.executeUpdate();
            Object var14_11 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                // empty catch block
            }
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException ex) {
                // empty catch block
            }
            try {
                if (ps1 != null) {
                    ps1.close();
                }
                break block24;
            }
            catch (SQLException ex) {}
            break block24;
            {
                catch (SQLException ex) {
                    throw new EngineException(ex.getMessage(), (Exception)ex);
                }
            }
            catch (Throwable throwable) {
                Object var14_12 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex) {
                    // empty catch block
                }
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (SQLException ex) {
                    // empty catch block
                }
                try {
                    if (ps1 != null) {
                        ps1.close();
                    }
                }
                catch (SQLException ex) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    private String get(Connection conn, int instNr, long userId, String application, String paramName) throws InvocationException, EngineException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        String paramValue = null;
        ps = conn.prepareStatement("SELECT * FROM CAF_RT_USRCFG WHERE INSTNR = ? AND USERID = ? AND APPLICATION = ? AND PARAMNAME = ? FOR UPDATE;");
        ps.setInt(1, instNr);
        ps.setLong(2, userId);
        ps.setString(3, application);
        ps.setString(4, paramName);
        rs = ps.executeQuery();
        if (rs.next()) {
            paramValue = rs.getString(COLUMN_PARAMVALUE);
        }
        String string = paramValue;
        Object var12_11 = null;
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException ex2) {
            // empty catch block
        }
        try {
            if (ps != null) {
                ps.close();
            }
        }
        catch (SQLException ex2) {
            // empty catch block
        }
        return string;
        catch (SQLException ex) {
            try {
                throw new EngineException(ex.getMessage(), (Exception)ex);
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex2) {
                    // empty catch block
                }
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (SQLException ex2) {}
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    private String remove(Connection conn, int instNr, long userId, String application, String paramName) throws InvocationException, EngineException {
        Statement ps1 = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        boolean exists = false;
        String paramValue = null;
        ps = conn.prepareStatement("SELECT * FROM CAF_RT_USRCFG WHERE INSTNR = ? AND USERID = ? AND APPLICATION = ? AND PARAMNAME = ? FOR UPDATE;");
        ps.setInt(1, instNr);
        ps.setLong(2, userId);
        ps.setString(3, application);
        ps.setString(4, paramName);
        rs = ps.executeQuery();
        if (rs.next()) {
            exists = true;
            paramValue = rs.getString(COLUMN_PARAMVALUE);
        }
        if (exists) {
            ps1 = conn.prepareStatement("DELETE FROM CAF_RT_USRCFG WHERE INSTNR = ? AND USERID = ? AND APPLICATION = ? AND PARAMNAME = ?");
            ps1.setInt(1, instNr);
            ps1.setLong(2, userId);
            ps1.setString(3, application);
            ps1.setString(4, paramName);
            ps1.executeUpdate();
        }
        String string = paramValue;
        Object var14_13 = null;
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException ex2) {
            // empty catch block
        }
        try {
            if (ps != null) {
                ps.close();
            }
        }
        catch (SQLException ex2) {
            // empty catch block
        }
        try {
            if (ps1 != null) {
                ps1.close();
            }
        }
        catch (SQLException ex2) {
            // empty catch block
        }
        return string;
        catch (SQLException ex) {
            try {
                throw new EngineException(ex.getMessage(), (Exception)ex);
            }
            catch (Throwable throwable) {
                Object var14_14 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex2) {
                    // empty catch block
                }
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (SQLException ex2) {
                    // empty catch block
                }
                try {
                    if (ps1 != null) {
                        ps1.close();
                    }
                }
                catch (SQLException ex2) {}
                throw throwable;
            }
        }
    }
}

