/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.user;

import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.base.logging.BaseLogManager;
import java.lang.ref.SoftReference;
import java.util.Enumeration;
import java.util.Properties;

public class UserConfigCache
extends Properties {
    private static final long serialVersionUID = 1L;
    public static final String ERROR_INVALID_INSTALLATION_NUMBER = "Invalid installation number: ";
    public static final String ERROR_CACHE_SHUT_DOWN = "The user configuration cache has been shut down.";
    public static final String ERROR_INVALID_INVALIDATION_CYCLES = "Negative values are not allowed as invalidation cycle periods.";
    private static final long THREAD_SLEEP_TIME = 100L;
    private static UserConfigCache m_instance;
    private transient Object m_lock = new Object();
    private int m_instNr;
    private int m_invalidationCycle;
    private boolean m_shutdownRequested;
    private transient ValidationThread m_validationThread;

    private UserConfigCache(int instNr, int invalidationCycle) throws InvocationException {
        this.m_instNr = instNr;
        this.m_invalidationCycle = invalidationCycle;
        this.m_shutdownRequested = false;
        this.m_invalidationCycle = invalidationCycle;
        if (this.m_invalidationCycle < 0) {
            throw new InvocationException(ERROR_INVALID_INVALIDATION_CYCLES);
        }
        if (this.m_invalidationCycle != 0) {
            this.m_validationThread = new ValidationThread(this);
            this.m_validationThread.start();
        }
    }

    protected static final UserConfigCache getInstance(int instNr, int invalidationCycle) throws InvocationException {
        if (m_instance == null) {
            m_instance = new UserConfigCache(instNr, invalidationCycle);
            return m_instance;
        }
        if (instNr == m_instance.getInstallationNumber()) {
            return m_instance;
        }
        throw new InvocationException(ERROR_INVALID_INSTALLATION_NUMBER + instNr);
    }

    public int getInstallationNumber() {
        return this.m_instNr;
    }

    public int getInvalidationCycle() {
        return this.m_invalidationCycle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getParameterValue(int instNr, long userId, String application, String parameterName) throws InvocationException {
        Object object = this.m_lock;
        synchronized (object) {
            if (this.m_instNr != instNr) {
                throw new InvocationException(ERROR_INVALID_INSTALLATION_NUMBER + instNr);
            }
            CacheEntry entry = (CacheEntry)super.get(Long.toString(userId) + application + parameterName);
            if (entry != null) {
                return (String)entry.getEntry();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameterValue(int instNr, long userId, String application, String parameterName, String parameterValue) throws InvocationException {
        Object object = this.m_lock;
        synchronized (object) {
            if (this.m_instNr != instNr) {
                throw new InvocationException(ERROR_INVALID_INSTALLATION_NUMBER + instNr);
            }
            String key = Long.toString(userId) + application + parameterName;
            super.put(key, new CacheEntry(key, parameterValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String removeParameterValue(int instNr, long userId, String application, String parameterName) throws InvocationException {
        Object object = this.m_lock;
        synchronized (object) {
            if (this.m_instNr != instNr) {
                throw new InvocationException(ERROR_INVALID_INSTALLATION_NUMBER + instNr);
            }
            CacheEntry entry = (CacheEntry)super.remove(Long.toString(userId) + application + parameterName);
            if (entry != null) {
                return (String)entry.getEntry();
            }
            return null;
        }
    }

    private void checkActive() throws InvocationException {
        if (this.m_shutdownRequested) {
            throw new InvocationException(ERROR_CACHE_SHUT_DOWN);
        }
    }

    public void shutdown() {
        this.m_shutdownRequested = true;
        this.clear();
    }

    public boolean isShutdown() {
        return this.m_shutdownRequested;
    }

    public void clear() {
        super.clear();
    }

    public static void main(String[] args) {
    }

    private class ValidationThread
    extends Thread {
        UserConfigCache m_parent;

        public ValidationThread(UserConfigCache parent) {
            this.m_parent = parent;
        }

        public void run() {
            BaseLogManager.info(this.getClass(), (String)"UserConfigCache validator was started.");
            while (!UserConfigCache.this.isShutdown()) {
                try {
                    Enumeration<Object> enumeration = this.m_parent.elements();
                    while (enumeration.hasMoreElements()) {
                        CacheEntry cacheEntry = (CacheEntry)enumeration.nextElement();
                        long lastTime = cacheEntry.getLastCheckTime();
                        if (lastTime + (long)this.m_parent.getInvalidationCycle() >= System.currentTimeMillis()) continue;
                        this.m_parent.remove(cacheEntry.getEntryId());
                    }
                    Thread.sleep(100L);
                }
                catch (Exception ex) {
                    BaseLogManager.error(this.getClass(), (String)ex.getMessage());
                }
            }
            BaseLogManager.info(this.getClass(), (String)"Cache validator was stopped.");
        }
    }

    private class CacheEntry {
        private String m_entryId;
        private SoftReference m_entry;
        private long m_lastcheckTime;

        public CacheEntry(String entryid, Object entry) {
            this.m_entryId = entryid;
            this.m_entry = new SoftReference<Object>(entry);
            this.m_lastcheckTime = System.currentTimeMillis();
        }

        public String getEntryId() {
            return this.m_entryId;
        }

        public Object getEntry() {
            return this.m_entry.get();
        }

        public long getLastCheckTime() {
            return this.m_lastcheckTime;
        }
    }
}

