/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.svc.persist;

import com.sap.caf.mp.base.db.ICNConnectionPool;
import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.logging.BaseLogManager;
import com.sap.caf.mp.core.svc.persist.INumberRange;
import com.sap.caf.mp.core.svc.persist.PersistenceManagers;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class NumberRange
implements INumberRange {
    private static final String TABLE_NUMRANGE = "CAF_RT_NUMRNG";
    private static final String COL_NUMRANGE_INSTNR = "INSTNR";
    private static final String COL_NUMRANGE_NAME = "NAME";
    private static final String COL_NUMRANGE_NUMSTATE = "NUMSTATE";
    private static String m_stmtSelectRange = "SELECT * FROM CAF_RT_NUMRNG WHERE INSTNR = ? AND NAME = ? FOR UPDATE;";
    private static String m_stmtInsert = "INSERT INTO CAF_RT_NUMRNG(INSTNR,NAME,NUMSTATE) VALUES(?,?,?);";
    private static String m_stmtUpdate = "UPDATE CAF_RT_NUMRNG SET NUMSTATE=? WHERE INSTNR=? AND NAME=?;";
    private ICNConnectionPool m_pool;
    private int m_installationNumber;

    public NumberRange(ICNConnectionPool pool, int installationNumber) {
        this.m_pool = pool;
        this.m_installationNumber = installationNumber;
    }

    public int getNextNumber(String arg) throws EngineException {
        Connection conn = null;
        try {
            conn = this.m_pool.getConnection();
            if (conn.getAutoCommit()) {
                conn.setAutoCommit(false);
            }
            int currValue = 0;
            boolean doupdate = false;
            PreparedStatement stmt = conn.prepareStatement(m_stmtSelectRange);
            stmt.setInt(1, this.m_installationNumber);
            stmt.setString(2, arg);
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                currValue = result.getInt(COL_NUMRANGE_NUMSTATE);
                doupdate = true;
            }
            ++currValue;
            if (doupdate) {
                stmt = conn.prepareStatement(m_stmtUpdate);
                stmt.setInt(1, currValue);
                stmt.setInt(2, this.m_installationNumber);
                stmt.setString(3, arg);
            } else {
                stmt = conn.prepareStatement(m_stmtInsert);
                stmt.setInt(1, this.m_installationNumber);
                stmt.setString(2, arg);
                stmt.setInt(3, currValue);
            }
            stmt.execute();
            PersistenceManagers.commit(conn);
            conn.close();
            return currValue;
        }
        catch (Exception ex) {
            BaseLogManager.error(this.getClass(), null, (Exception)ex);
            PersistenceManagers.recover(conn);
            throw new EngineException(ex);
        }
    }
}

