/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.svc;

import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.logging.BaseLogManager;
import com.sap.caf.mp.base.logging.ILogManager;
import com.sap.caf.mp.base.thread.BaseThreadController;
import com.sap.caf.mp.base.thread.IThreadSystemController;
import com.sap.caf.mp.base.util.StringUtilities;
import com.sap.caf.mp.base.uuid.BaseUUIDManager;
import com.sap.caf.mp.base.uuid.IUUIDGenerator;
import com.sap.caf.mp.core.svc.CoreFactory;
import com.sap.caf.mp.core.svc.CoreLogManager;
import com.sap.caf.mp.core.svc.CoreServiceConstants;
import com.sap.caf.mp.core.svc.CoreServiceUser;
import com.sap.caf.mp.core.svc.CoreThreadController;
import com.sap.caf.mp.core.svc.J2EEGuidGenerator;
import com.sap.caf.mp.core.svc.perm.PermissionUtils;
import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.ApplicationServiceFrame;
import com.sap.engine.frame.ServiceException;
import com.sap.engine.frame.core.CoreContext;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.ConfigurationHandlerFactory;
import com.sap.engine.frame.core.thread.ThreadContext;
import com.sap.engine.frame.core.thread.ThreadSystem;
import com.sap.engine.interfaces.security.SecurityContextObject;
import com.sap.security.api.IUser;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.naming.NameAlreadyBoundException;

public class CAFMPCoreServiceFrame
implements ApplicationServiceFrame {
    public static final String DEFAULT_SEARCHMGR_CLASSNAME = "SearchManagerClassNameDefault";
    public static final String DEFAULT_INDEXMGR_CLASSNAME = "IndexManagerClassNameDefault";
    public static final String DEFAULT_CACHEMGR_CLASSNAME = "CacheManagerClassNameDefault";
    protected static final String INTERFACE_NAME_CONTAINER = "container";
    private static final String SECURITY_SERVICE_NAME = "security";
    private static final String JDBC = "jdbc/notx/";
    private ApplicationServiceContext m_serviceCtxt;
    private int m_securityContextObjectId = -1;
    private Properties m_globalConfig;
    private CoreFactory m_coreFactory;
    private CoreLogManager m_coreLogManager;
    private J2EEGuidGenerator m_coreUUIDGenerator;
    private String m_dbPool;
    private String m_fallbackLanguage;
    private int m_adminMembersMode;
    private String m_adminMembersGroup;
    private String m_adminMembersRole;
    private Vector m_persistentFiles;
    private String m_httpServerPrefix;

    public Principal getCallerPrincipal() {
        SecurityContextObject securityContext = this.getSecurityContext();
        return securityContext.getSession().getPrincipal();
    }

    public SecurityContextObject getSecurityContext() {
        CoreContext ctxt = this.m_serviceCtxt.getCoreContext();
        ThreadContext currentThread = ctxt.getThreadSystem().getThreadContext();
        return (SecurityContextObject)currentThread.getContextObject(this.m_securityContextObjectId);
    }

    public String getDatabasepoolName() {
        return this.m_dbPool;
    }

    public String getFallbackLanguage() {
        return this.m_fallbackLanguage;
    }

    public String getHttpServerPrefix() {
        return this.m_httpServerPrefix;
    }

    protected void initializeService() {
        BaseLogManager.info(this.getClass(), (String)"Initializing core service ...");
        int counter = 0;
        boolean done = false;
        CoreContext coreContext = this.m_serviceCtxt.getCoreContext();
        while (!done) {
            this.m_securityContextObjectId = coreContext.getThreadSystem().getContextObjectId(SECURITY_SERVICE_NAME);
            boolean bl = done = this.m_securityContextObjectId != -1;
            if (done || ++counter > 600) break;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {}
        }
        if (this.m_securityContextObjectId == -1) {
            ServiceException toThrow = new ServiceException((Throwable)new Exception("Unable to retrieve security context object id"));
            BaseLogManager.error(this.getClass(), (Exception)((Object)toThrow));
        }
        BaseLogManager.info(this.getClass(), (String)"Intialization: security context succeeded.");
        try {
            this.initializePermissions();
        }
        catch (Exception ex) {
            BaseLogManager.error(this.getClass(), (String)"Initialization of permissions failed", (Exception)ex);
            return;
        }
        BaseLogManager.info(this.getClass(), (String)"Intialization: permission succeeded.");
        IUser svcUser = CoreServiceUser.getCoreServiceUser();
        BaseLogManager.info(this.getClass(), (String)("Core service user: " + svcUser.getUniqueID()));
        BaseLogManager.info(this.getClass(), (String)"Initialization: initializing core service persistent store.");
        try {
            this.initializePersistentFiles();
        }
        catch (ServiceException ex) {
            BaseLogManager.error(this.getClass(), (String)"Unable to initialize core service persistent store.", (Exception)((Object)ex));
        }
        try {
            this.m_coreFactory = new CoreFactory(this);
        }
        catch (Exception ex) {
            BaseLogManager.error(this.getClass(), (String)"Initialization: Unable to instantiate the core factories.", (Exception)ex);
            return;
        }
        BaseLogManager.info(this.getClass(), (String)"Intialization: core factory instantiated.");
        try {
            Properties ctxProp = new Properties();
            ctxProp.put("java.naming.factory.initial", "com.sap.engine.services.jndi.InitialContextFactoryImpl");
            ctxProp.put("domain", "true");
            InitialContext ctx = new InitialContext(ctxProp);
            try {
                ctx.createSubcontext("sap.com");
            }
            catch (NameAlreadyBoundException nabe) {
                // empty catch block
            }
            try {
                ctx.createSubcontext("sap.com/com.sap.caf");
            }
            catch (NameAlreadyBoundException nabe) {
                // empty catch block
            }
            try {
                ctx.rebind("/sap.com/com.sap.caf/CoreFactory", (Object)this.m_coreFactory);
            }
            catch (NameAlreadyBoundException nabe) {}
        }
        catch (Exception ex) {
            BaseLogManager.error(this.getClass(), (String)"Unable to register core factory in the naming.");
            return;
        }
        BaseLogManager.info(this.getClass(), (String)"Intialization: core factory registered.");
        InputStream stream = this.m_coreFactory.getCoreContext().getPersistenFile("caf_mp_metamodel_v1.xsd");
        BaseLogManager.info(this.getClass(), (String)"Intialization: core model xsd file retrieved.");
    }

    private void addExtendedProperties(Properties globalconfig) {
        try {
            Properties props = new Properties();
            InputStream additionStream = this.getPersistentFile("extended.properties");
            props.load(additionStream);
            globalconfig.putAll((Map<?, ?>)props);
        }
        catch (Exception ex) {
            BaseLogManager.error(this.getClass(), (Exception)ex);
        }
    }

    public void start(ApplicationServiceContext serviceContext) throws ServiceException {
        BaseLogManager.info(this.getClass(), (String)"Service started.");
        this.m_persistentFiles = new Vector();
        this.m_coreLogManager = new CoreLogManager();
        BaseLogManager.setLogManager((ILogManager)this.m_coreLogManager);
        CoreThreadController controller = new CoreThreadController(this);
        BaseThreadController.setThreadSystemController((IThreadSystemController)controller);
        this.m_coreUUIDGenerator = new J2EEGuidGenerator();
        BaseUUIDManager.setUUIDGenerator((IUUIDGenerator)this.m_coreUUIDGenerator);
        this.m_serviceCtxt = serviceContext;
        this.m_globalConfig = this.m_serviceCtxt.getServiceState().getProperties();
        this.addExtendedProperties(this.m_globalConfig);
        BaseLogManager.info(this.getClass(), (String)("Configuration properties: " + this.m_globalConfig.toString()));
        this.parseProperties(this.m_globalConfig);
        Enumeration<Object> enumeration = this.m_globalConfig.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String value = (String)this.m_globalConfig.get(key);
        }
        this.initializeService();
    }

    public void stop() {
        this.m_serviceCtxt.getContainerContext().getObjectRegistry().unregisterInterfaceProvider("/sap.com/com.sap.caf/CoreFactory");
        BaseLogManager.info(this.getClass(), (String)"Service Stopped.");
    }

    public boolean changeProperties(Properties arg0) throws IllegalArgumentException {
        return true;
    }

    public Properties getServiceConfig() {
        return this.m_globalConfig;
    }

    public ApplicationServiceContext getServiceContext() {
        return this.m_serviceCtxt;
    }

    protected ThreadSystem getThreadSystem() {
        return this.m_serviceCtxt.getCoreContext().getThreadSystem();
    }

    protected int getAdminMembersMode() {
        return this.m_adminMembersMode;
    }

    protected String getAdminMembersGroup() {
        return this.m_adminMembersGroup;
    }

    protected String getAdminMembersRole() {
        return this.m_adminMembersRole;
    }

    protected InputStream getPersistentFile(String filename) {
        try {
            ConfigurationHandlerFactory factory = this.m_serviceCtxt.getCoreContext().getConfigurationHandlerFactory();
            ConfigurationHandler handler = factory.getConfigurationHandler();
            String[] names = CoreServiceConstants.PATH_TO_PERSISTENT_STORAGE;
            Configuration[] configs = new Configuration[names.length];
            for (int i = 0; i < names.length; ++i) {
                configs[i] = i == 0 ? handler.openConfiguration(names[i], 0) : configs[i - 1].getSubConfiguration(names[i]);
            }
            Configuration persistent = configs[configs.length - 1];
            return persistent.getFile(filename);
        }
        catch (Exception ex) {
            BaseLogManager.error(this.getClass(), (String)("Unable to retrieve persistent file: " + filename + ": " + ex.getMessage()), (Exception)ex);
            return null;
        }
    }

    protected Vector getPersistentFileNames() {
        return this.m_persistentFiles;
    }

    /*
     * Loose catch block
     */
    protected void updatePersistentFile(String fileName, InputStream newFile) throws EngineException {
        block12: {
            ConfigurationHandler handler = null;
            ConfigurationHandlerFactory factory = this.m_serviceCtxt.getCoreContext().getConfigurationHandlerFactory();
            handler = factory.getConfigurationHandler();
            Configuration persistent = handler.openConfiguration("cluster_data/server/persistent/caf~runtime~connectivity~impl", 1);
            persistent.updateFileAsStream(fileName, newFile, false);
            handler.commit();
            Object var7_8 = null;
            try {
                if (handler != null) {
                    handler.closeAllConfigurations();
                }
                break block12;
            }
            catch (Exception ex) {
                BaseLogManager.error(this.getClass(), (Exception)ex);
            }
            break block12;
            {
                catch (Exception ex) {
                    BaseLogManager.error(this.getClass(), (Exception)ex);
                    try {
                        if (handler != null) {
                            handler.rollback();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    throw new EngineException(ex);
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    if (handler != null) {
                        handler.closeAllConfigurations();
                    }
                }
                catch (Exception ex) {
                    BaseLogManager.error(this.getClass(), (Exception)ex);
                }
                throw throwable;
            }
        }
    }

    private void initializePersistentFiles() throws ServiceException {
        ConfigurationHandlerFactory factory = this.m_serviceCtxt.getCoreContext().getConfigurationHandlerFactory();
        ConfigurationHandler handler = factory.getConfigurationHandler();
        BaseLogManager.info(this.getClass(), (String)"Application configuration handler successfully accessed.");
        String[] names = CoreServiceConstants.PATH_TO_PERSISTENT_STORAGE;
        Configuration[] configs = new Configuration[names.length];
        for (int i = 0; i < names.length; ++i) {
            configs[i] = i == 0 ? handler.openConfiguration(names[i], 0) : configs[i - 1].getSubConfiguration(names[i]);
        }
        Configuration persistent = configs[configs.length - 1];
        String[] filenames = persistent.getAllFileEntryNames();
        for (int i = 0; i < filenames.length; ++i) {
            String filename = filenames[i];
            this.m_persistentFiles.add(filename);
        }
    }

    private void initializePermissions() throws ServiceException {
        try {
            int counter = 0;
            boolean done = false;
            while (!done) {
                try {
                    PermissionUtils.adaptPermissionsHierarchically();
                    done = true;
                }
                catch (Exception ex) {
                    ++counter;
                    Thread.sleep(1000L);
                }
            }
            BaseLogManager.info(this.getClass(), (String)"Successfully initialized hierarchical permissions.");
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    private void parseProperties(Properties props) throws ServiceException {
        String msg;
        String propvalue;
        String propkey;
        Hashtable<String, String> replacements = new Hashtable<String, String>();
        try {
            String hostname = InetAddress.getLocalHost().getHostName();
            replacements.put("%hostname%", hostname);
        }
        catch (UnknownHostException ex) {
            // empty catch block
        }
        Enumeration<Object> enumeration = props.keys();
        while (enumeration.hasMoreElements()) {
            propkey = (String)enumeration.nextElement();
            propvalue = props.getProperty(propkey);
            replacements.put("%" + propkey + "%", propvalue);
        }
        enumeration = props.keys();
        while (enumeration.hasMoreElements()) {
            propkey = (String)enumeration.nextElement();
            propvalue = props.getProperty(propkey);
            Enumeration inner = replacements.keys();
            while (inner.hasMoreElements()) {
                String repkey = (String)inner.nextElement();
                String repvalue = (String)replacements.get(repkey);
                propvalue = StringUtilities.replaceString((String)propvalue, (String)repkey, (String)repvalue);
            }
            props.put(propkey, propvalue);
        }
        String dbPool = props.getProperty("dbpool.name", "SAP/CAF_RT");
        if (dbPool == null) {
            String msg2 = "Configuration error: unable to find configuration parameter dbpool.name";
            BaseLogManager.error(this.getClass(), (String)msg2);
            throw new ServiceException((Throwable)new EngineException(msg2));
        }
        if (!dbPool.startsWith(JDBC)) {
            dbPool = JDBC + dbPool;
        }
        this.m_dbPool = dbPool;
        String adminMembersMode = props.getProperty("admin.members.mode", "internal");
        if (adminMembersMode == null) {
            msg = "Configuration error: unable to find configuration parameter admin.members.mode";
            BaseLogManager.error(this.getClass(), (String)msg);
            throw new ServiceException((Throwable)new EngineException(msg));
        }
        if (adminMembersMode.equals("group")) {
            this.m_adminMembersMode = 1;
        } else if (adminMembersMode.equals("internal")) {
            this.m_adminMembersMode = 0;
        } else if (adminMembersMode.equals("role")) {
            this.m_adminMembersMode = 2;
        } else {
            msg = "Configuration error: invalid value for configuration parameter admin.members.mode";
            BaseLogManager.error(this.getClass(), (String)msg);
            throw new ServiceException((Throwable)new EngineException(msg));
        }
        this.m_adminMembersGroup = null;
        if (this.m_adminMembersMode == 1) {
            this.m_adminMembersGroup = (String)props.get("admin.members.group");
            if (this.m_adminMembersGroup == null) {
                msg = "Configuration error: unable to find configuration parameter admin.members.group";
                BaseLogManager.error(this.getClass(), (String)msg);
                throw new ServiceException((Throwable)new EngineException(msg));
            }
        }
        this.m_adminMembersRole = null;
        if (this.m_adminMembersMode == 2) {
            this.m_adminMembersRole = (String)props.get("admin.members.role");
            if (this.m_adminMembersRole == null) {
                msg = "Configuration error: unable to find configuration parameter admin.members.role";
                BaseLogManager.error(this.getClass(), (String)msg);
                throw new ServiceException((Throwable)new EngineException(msg));
            }
        }
        this.m_fallbackLanguage = (String)props.get("system.fallbacklang");
        if (this.m_fallbackLanguage == null) {
            msg = "Configuration error: unable to find configuration parameter system.fallbacklang";
            BaseLogManager.error(this.getClass(), (String)msg);
            throw new ServiceException((Throwable)new EngineException(msg));
        }
        this.m_httpServerPrefix = (String)props.get("http.server.prefix");
        if (this.m_httpServerPrefix == null) {
            msg = "Configuration error: unable to find configuration parameter http.server.prefix";
            BaseLogManager.error(this.getClass(), (String)msg);
            throw new ServiceException((Throwable)new EngineException(msg));
        }
    }

    public String getParticipantName() {
        String serverName = this.m_serviceCtxt.getClusterContext().getClusterMonitor().getCurrentParticipant().getName();
        return serverName;
    }

    public int getParticipantId() {
        return this.m_serviceCtxt.getClusterContext().getClusterMonitor().getCurrentParticipant().getClusterId();
    }
}

