/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.data.service.registry.types;

import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.text.TitleTextList;
import com.sap.caf.mp.core.data.service.registry.types.IParameterDef;
import com.sap.caf.mp.core.data.service.registry.types.IParameterValueDefEnumeration;
import com.sap.caf.mp.core.data.service.registry.types.ParameterValueDefEnumeration;
import com.sap.caf.mp.core.data.service.registry.types.TitleListHelper;
import com.sap.caf.mp.core.data.service.registry.types.UsageConstraintDef;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ParameterDef
implements IParameterDef {
    private static final String ATTRIBUTE_NAME_NAME = "name";
    private static final String ATTRIBUTE_NAME_TYPE = "type";
    private static final String ATTRIBUTE_NAME_SIZE = "size";
    private static final String ATTRIBUTE_NAME_OBLIGATE = "obligate";
    private static final String ELEMENT_NAME_TITLELIST = "TitleList";
    private static final String ELEMENT_NAME_PARAMETERVALUEENUMERATION = "ParameterValueEnumeration";
    private static final String ELEMENT_NAME_USAGECONSTRAINTS = "UsageConstraints";
    private static final String ELEMENT_NAME_USAGECONSTRAINT = "UsageConstraint";
    private static final String VALUETYPE_STRING = "string";
    private static final String VALUETYPE_ENUMERATION = "enumeration";
    private static final String VALUETYPE_PASSWORD = "password";
    private static final String VALUETYPE_LANGUAGE = "language";
    private static final String VALUETYPE_NUMSTRING = "numstring";
    private static final String VALUETYPE_BOOLEAN = "boolean";
    private String m_name = null;
    private int m_type = 0;
    private int m_size = 0;
    private boolean m_isObligate;
    private TitleTextList m_textList = null;
    private ParameterValueDefEnumeration m_valueDefs = null;
    private Vector m_constraints = new Vector();

    protected ParameterDef(Element element, String fallbackLanguage) throws EngineException {
        NamedNodeMap map = element.getAttributes();
        int count = map.getLength();
        for (int i = 0; i < count; ++i) {
            Attr child = (Attr)map.item(i);
            if (child.getLocalName().equals(ATTRIBUTE_NAME_NAME)) {
                this.m_name = child.getValue();
                continue;
            }
            if (child.getLocalName().equals(ATTRIBUTE_NAME_OBLIGATE)) {
                this.m_isObligate = child.getValue().equals("true");
                continue;
            }
            if (child.getLocalName().equals(ATTRIBUTE_NAME_SIZE)) {
                this.m_size = Integer.parseInt(child.getValue());
                continue;
            }
            if (!child.getLocalName().equals(ATTRIBUTE_NAME_TYPE)) continue;
            String typeValue = child.getValue();
            if (typeValue.equals(VALUETYPE_ENUMERATION)) {
                this.m_type = 2;
                continue;
            }
            if (typeValue.equals(VALUETYPE_LANGUAGE)) {
                this.m_type = 4;
                continue;
            }
            if (typeValue.equals(VALUETYPE_NUMSTRING)) {
                this.m_type = 3;
                continue;
            }
            if (typeValue.equals(VALUETYPE_PASSWORD)) {
                this.m_type = 5;
                continue;
            }
            if (typeValue.equals(VALUETYPE_STRING)) {
                this.m_type = 1;
                continue;
            }
            if (typeValue.equals(VALUETYPE_BOOLEAN)) {
                this.m_type = 6;
                continue;
            }
            throw new EngineException("Invalid input file: Invalid type specified in parameter element: " + typeValue);
        }
        if (this.m_name == null) {
            throw new EngineException("Invalid input file: name attribute missing on parameter definition.");
        }
        if (this.m_type == 0) {
            throw new EngineException("Invalid input file: type attribute missing or invalid on parameter definition.");
        }
        NodeList children = element.getChildNodes();
        count = children.getLength();
        for (int i = 0; i < count; ++i) {
            Node child = children.item(i);
            String localName = child.getLocalName();
            if (localName == null) continue;
            if (localName.equalsIgnoreCase(ELEMENT_NAME_TITLELIST)) {
                this.m_textList = TitleListHelper.parseTitleTextList((Element)child, fallbackLanguage);
                continue;
            }
            if (localName.equalsIgnoreCase(ELEMENT_NAME_USAGECONSTRAINTS)) {
                NodeList constNodes = child.getChildNodes();
                int constCount = constNodes.getLength();
                for (int j = 0; j < constCount; ++j) {
                    Node constNode = constNodes.item(j);
                    String constLocalName = constNode.getLocalName();
                    if (constLocalName == null || !constLocalName.equals(ELEMENT_NAME_USAGECONSTRAINT)) continue;
                    UsageConstraintDef constraint = new UsageConstraintDef((Element)constNode);
                    this.m_constraints.add(constraint);
                }
                continue;
            }
            if (!localName.equalsIgnoreCase(ELEMENT_NAME_PARAMETERVALUEENUMERATION)) continue;
            this.m_valueDefs = new ParameterValueDefEnumeration((Element)child, fallbackLanguage);
        }
        if (this.m_textList == null) {
            throw new EngineException("Invalid input file: TitleList element missing on parameter definition.");
        }
    }

    public String getName() {
        return this.m_name;
    }

    public int getType() {
        return this.m_type;
    }

    public int getSize() {
        return this.m_size;
    }

    public boolean isObligate() {
        return this.m_isObligate;
    }

    public TitleTextList getTitleList() {
        return this.m_textList;
    }

    public IParameterValueDefEnumeration getParameterValueDefEnumeration() {
        return this.m_valueDefs;
    }

    public Vector getUsageConstraints() {
        return this.m_constraints;
    }
}

